/*
 * Decompiled with CFR 0.152.
 */
package io.sundr.codegen.model;

import io.sundr.codegen.model.AnnotationRef;
import io.sundr.codegen.model.AttributeKey;
import io.sundr.codegen.model.ClassRef;
import io.sundr.codegen.model.ModifierSupport;
import io.sundr.codegen.model.TypeRef;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class Property
extends ModifierSupport {
    private final List<AnnotationRef> annotations;
    private final TypeRef typeRef;
    private final String name;

    public Property(List<AnnotationRef> annotations, TypeRef typeRef, String name, int modifiers, Map<AttributeKey, Object> attributes) {
        super(modifiers, attributes);
        this.annotations = annotations;
        this.typeRef = typeRef;
        this.name = name;
    }

    public List<AnnotationRef> getAnnotations() {
        return this.annotations;
    }

    public TypeRef getTypeRef() {
        return this.typeRef;
    }

    public String getName() {
        return this.name;
    }

    public String getNameCapitalized() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.name.replaceAll("_", "").substring(0, 1).toUpperCase());
        sb.append(this.name.replaceAll("_", "").substring(1));
        return sb.toString();
    }

    public Set<ClassRef> getReferences() {
        LinkedHashSet<ClassRef> refs = new LinkedHashSet<ClassRef>();
        if (this.typeRef instanceof ClassRef) {
            ClassRef classRef = (ClassRef)this.typeRef;
            refs.addAll(classRef.getReferences());
        }
        for (AnnotationRef a : this.getAnnotations()) {
            refs.addAll(a.getClassRef().getReferences());
        }
        if (this.getAttributes().containsKey(ALSO_IMPORT)) {
            Object obj = this.getAttributes().get(ALSO_IMPORT);
            if (obj instanceof ClassRef) {
                refs.add((ClassRef)obj);
            } else if (obj instanceof Collection) {
                refs.addAll((Collection)obj);
            }
        }
        return refs;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Property property = (Property)o;
        if (this.typeRef != null ? !this.typeRef.equals(property.typeRef) : property.typeRef != null) {
            return false;
        }
        return this.name != null ? this.name.equals(property.name) : property.name == null;
    }

    public int hashCode() {
        int result = this.typeRef != null ? this.typeRef.hashCode() : 0;
        result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
        return result;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.isPublic()) {
            sb.append("public").append(" ");
        } else if (this.isProtected()) {
            sb.append("protected").append(" ");
        } else if (this.isPrivate()) {
            sb.append("private").append(" ");
        }
        if (this.isStatic()) {
            sb.append("static").append(" ");
        }
        if (this.isFinal()) {
            sb.append("final").append(" ");
        }
        sb.append(this.typeRef).append(" ");
        sb.append(this.name);
        return sb.toString();
    }
}

