/*
 * Decompiled with CFR 0.152.
 */
package io.sundr.codegen.utils;

import io.sundr.Function;
import io.sundr.codegen.model.ClassRef;
import io.sundr.codegen.model.PrimitiveRef;
import io.sundr.codegen.model.TypeDef;
import io.sundr.codegen.model.TypeDefBuilder;
import io.sundr.codegen.model.TypeParamDef;
import io.sundr.codegen.model.TypeParamDefBuilder;
import io.sundr.codegen.model.TypeParamRef;
import io.sundr.codegen.model.TypeParamRefBuilder;
import io.sundr.codegen.model.TypeRef;
import java.util.Arrays;
import java.util.Collection;
import javax.lang.model.element.Modifier;

public final class TypeUtils {
    private TypeUtils() {
    }

    public static boolean isInstanceOf(TypeRef type, TypeDef targetType, Function<TypeRef, Boolean> function) {
        if (type instanceof ClassRef) {
            ClassRef classRef = (ClassRef)type;
            TypeDef definition = classRef.getDefinition();
            if (definition.getFullyQualifiedName().equals(targetType.getFullyQualifiedName())) {
                return true;
            }
            for (TypeRef typeRef : definition.getImplementsList()) {
                if (!((Boolean)function.apply((Object)typeRef)).booleanValue()) continue;
                return true;
            }
            for (TypeRef typeRef : definition.getExtendsList()) {
                if (!((Boolean)function.apply((Object)typeRef)).booleanValue()) continue;
                return true;
            }
        }
        return false;
    }

    public static TypeParamDef getParamterDefinition(TypeRef typeRef, Collection<TypeParamDef> parameters) {
        String name = typeRef instanceof ClassRef ? ((ClassRef)typeRef).getName() : (typeRef instanceof TypeParamRef ? ((TypeParamRef)typeRef).getName() : (typeRef instanceof PrimitiveRef ? ((PrimitiveRef)typeRef).getName() : typeRef.toString()));
        for (TypeParamDef parameter : parameters) {
            if (!parameter.getName().equals(name)) continue;
            return parameter;
        }
        return null;
    }

    public static TypeParamRef newTypeParamRef(String letter) {
        return ((TypeParamRefBuilder)new TypeParamRefBuilder().withName(letter)).build();
    }

    public static TypeParamDef newTypeParamDef(String letter) {
        return ((TypeParamDefBuilder)new TypeParamDefBuilder().withName(letter)).build();
    }

    public static TypeDef unwrapGeneric(TypeDef base) {
        return ((TypeDefBuilder)new TypeDefBuilder(base).withParameters(new TypeParamDef[0])).build();
    }

    public static TypeDef typeGenericOf(TypeDef base, TypeParamDef ... parameters) {
        return ((TypeDefBuilder)new TypeDefBuilder(base).withParameters(parameters)).build();
    }

    public static TypeDef typeExtends(TypeDef base, ClassRef superClass) {
        return ((TypeDefBuilder)new TypeDefBuilder(base).withExtendsList(superClass)).build();
    }

    public static TypeDef typeImplements(TypeDef base, ClassRef ... superClass) {
        return ((TypeDefBuilder)new TypeDefBuilder(base).withImplementsList(superClass)).build();
    }

    public static int modifiersToInt(Modifier ... modifiers) {
        return TypeUtils.modifiersToInt(Arrays.asList(modifiers));
    }

    public static int modifiersToInt(Collection<Modifier> modifiers) {
        int result = 0;
        for (Modifier m : modifiers) {
            switch (m) {
                case ABSTRACT: {
                    result |= 0x400;
                    break;
                }
                case FINAL: {
                    result |= 0x10;
                    break;
                }
                case NATIVE: {
                    result |= 0x100;
                    break;
                }
                case PRIVATE: {
                    result |= 2;
                    break;
                }
                case PROTECTED: {
                    result |= 4;
                    break;
                }
                case PUBLIC: {
                    result |= 1;
                    break;
                }
                case STATIC: {
                    result |= 8;
                    break;
                }
                case SYNCHRONIZED: {
                    result |= 0x20;
                    break;
                }
                case TRANSIENT: {
                    result |= 0x80;
                }
            }
        }
        return result;
    }

    public static String fullyQualifiedNameDiff(String left, String right) {
        String[] lparts = left.split("\\.");
        String[] rparts = right.split("\\.");
        int l = lparts.length - 1;
        for (int r = rparts.length - 1; l >= 0 && r >= 0; --r, --l) {
            if (lparts[l].equals(rparts[r])) continue;
            return rparts[r];
        }
        return "other";
    }
}

