/*
 * Decompiled with CFR 0.152.
 */
package io.sundr.codegen.functions;

import io.sundr.Function;
import io.sundr.codegen.functions.StringReplace;
import java.util.Arrays;
import java.util.List;

public enum Singularize implements Function<String, String>
{
    FUNCTION;

    private static final List<String> UNCOUNTABLE;
    private static final List<Function<String, String>> SINGULARS;

    public String apply(String word) {
        if (word == null) {
            return null;
        }
        if (word.isEmpty()) {
            return word;
        }
        if (UNCOUNTABLE.contains(word)) {
            return word;
        }
        for (Function<String, String> function : SINGULARS) {
            String result = (String)function.apply((Object)word);
            if (result == null) continue;
            return result;
        }
        return word;
    }

    static {
        UNCOUNTABLE = Arrays.asList("equipment", "fish", "information", "money", "rice", "series", "sheep", "species");
        SINGULARS = Arrays.asList(new StringReplace("(p)erson$", "$1eople"), new StringReplace("(m)an$", "$1en"), new StringReplace("(c)hild$", "$1hildren"), new StringReplace("(s)ex$", "$1exes"), new StringReplace("(m)ove$", "$1oves"), new StringReplace("(s)tadium$", "$1tadiums"), new StringReplace("(quiz)zes$", "$1"), new StringReplace("(matr)ices$", "$1ix"), new StringReplace("(vert|ind)ices$", "$1ex"), new StringReplace("^(ox)en", "$1"), new StringReplace("(alias|status)$", "$1"), new StringReplace("(alias|status)es$", "$1"), new StringReplace("(octop|vir)us$", "$1us"), new StringReplace("(octop|vir)i$", "$1us"), new StringReplace("(cris|ax|test)es$", "$1is"), new StringReplace("(cris|ax|test)is$", "$1is"), new StringReplace("(shoe)s$", "$1"), new StringReplace("(o)es$", "$1"), new StringReplace("(bus)es$", "$1"), new StringReplace("([m|l])ice$", "$1ouse"), new StringReplace("(x|ch|ss|sh)es$", "$1"), new StringReplace("(m)ovies$", "$1ovie"), new StringReplace("(s)eries$", "$1eries"), new StringReplace("([^aeiouy]|qu)ies$", "$1y"), new StringReplace("([lr])ves$", "$1f"), new StringReplace("(tive)s$", "$1"), new StringReplace("(hive)s$", "$1"), new StringReplace("([^f])ves$", "$1fe"), new StringReplace("(^analy)sis$", "$1sis"), new StringReplace("(^analy)ses$", "$1sis"), new StringReplace("((a)naly|(b)a|(d)iagno|(p)arenthe|(p)rogno|(s)ynop|(t)he)ses$", "$1$2sis"), new StringReplace("([ti])a$", "$1um"), new StringReplace("(n)ews$", "$1ews"), new StringReplace("(s|si|u)s$", "$1s"), new StringReplace("s$", ""));
    }
}

