/*
 * Decompiled with CFR 0.152.
 */
package io.sundr.codegen.model;

import io.sundr.codegen.model.AnnotationRef;
import io.sundr.codegen.model.AttributeKey;
import io.sundr.codegen.model.AttributeSupport;
import io.sundr.codegen.model.Block;
import io.sundr.codegen.model.ClassRef;
import io.sundr.codegen.model.ModifierSupport;
import io.sundr.codegen.model.Property;
import io.sundr.codegen.model.TypeParamDef;
import io.sundr.codegen.model.TypeRef;
import io.sundr.codegen.utils.StringUtils;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class Method
extends ModifierSupport {
    private final List<String> comments;
    private final List<AnnotationRef> annotations;
    private final List<TypeParamDef> parameters;
    private final String name;
    private final TypeRef returnType;
    private final List<Property> arguments;
    private final boolean varArgPreferred;
    private final List<ClassRef> exceptions;
    private final Block block;

    public Method(List<String> comments, List<AnnotationRef> annotations, List<TypeParamDef> parameters, String name, TypeRef returnType, List<Property> arguments, boolean varArgPreferred, List<ClassRef> exceptions, Block block, int modifiers, Map<AttributeKey, Object> attributes) {
        super(modifiers, attributes);
        this.comments = comments != null ? comments : Collections.emptyList();
        this.annotations = annotations;
        this.parameters = parameters;
        this.name = name;
        this.returnType = returnType;
        this.arguments = arguments;
        this.varArgPreferred = varArgPreferred;
        this.exceptions = exceptions;
        this.block = block;
    }

    public List<String> getComments() {
        return this.comments;
    }

    public List<AnnotationRef> getAnnotations() {
        return this.annotations;
    }

    public boolean isVarArgPreferred() {
        return this.varArgPreferred;
    }

    public List<TypeParamDef> getParameters() {
        return this.parameters;
    }

    public String getName() {
        return this.name;
    }

    public TypeRef getReturnType() {
        return this.returnType;
    }

    public List<Property> getArguments() {
        return this.arguments;
    }

    public List<ClassRef> getExceptions() {
        return this.exceptions;
    }

    public Block getBlock() {
        return this.block;
    }

    public Set<ClassRef> getReferences() {
        LinkedHashSet<ClassRef> refs = new LinkedHashSet<ClassRef>();
        if (this.returnType instanceof ClassRef) {
            Iterator<AttributeSupport> classRef = (ClassRef)this.returnType;
            refs.addAll(((ClassRef)((Object)classRef)).getReferences());
        }
        for (Property argument : this.arguments) {
            refs.addAll(argument.getReferences());
        }
        for (ClassRef e : this.exceptions) {
            refs.addAll(e.getReferences());
        }
        for (AnnotationRef a : this.getAnnotations()) {
            refs.addAll(a.getClassRef().getReferences());
        }
        for (TypeParamDef typeParamDef : this.parameters) {
            for (ClassRef bound : typeParamDef.getBounds()) {
                refs.addAll(bound.getReferences());
            }
        }
        if (this.getAttributes().containsKey(ALSO_IMPORT)) {
            Object obj = this.getAttributes().get(ALSO_IMPORT);
            if (obj instanceof ClassRef) {
                refs.add((ClassRef)obj);
            } else if (obj instanceof Collection) {
                refs.addAll((Collection)obj);
            }
        }
        return refs;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Method method = (Method)o;
        if (this.parameters != null ? !this.parameters.equals(method.parameters) : method.parameters != null) {
            return false;
        }
        if (this.name != null ? !this.name.equals(method.name) : method.name != null) {
            return false;
        }
        return this.arguments != null ? this.arguments.equals(method.arguments) : method.arguments == null;
    }

    public int hashCode() {
        int result = this.parameters != null ? this.parameters.hashCode() : 0;
        result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
        result = 31 * result + (this.arguments != null ? this.arguments.hashCode() : 0);
        return result;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (!this.comments.isEmpty()) {
            sb.append("\n").append("/**").append("\n");
            for (String c : this.comments) {
                sb.append(" ").append("*").append(" ").append(c).append("\n");
            }
            sb.append(" ").append("*/").append("\n");
        }
        for (AnnotationRef annotationRef : this.annotations) {
            sb.append(annotationRef.toString()).append(" ");
        }
        if (this.isPublic()) {
            sb.append("public").append(" ");
        } else if (this.isProtected()) {
            sb.append("protected").append(" ");
        } else if (this.isPrivate()) {
            sb.append("private").append(" ");
        }
        if (this.isSynchronized()) {
            sb.append("synchronized").append(" ");
        }
        if (this.isStatic()) {
            sb.append("static").append(" ");
        }
        if (this.isAbstract()) {
            sb.append("abstract").append(" ");
        }
        if (this.isFinal()) {
            sb.append("final").append(" ");
        }
        if (this.parameters != null && !this.parameters.isEmpty()) {
            sb.append("<");
            sb.append(StringUtils.join(this.parameters, ","));
            sb.append(">");
        }
        if (this.name != null) {
            sb.append(this.returnType);
            sb.append(" ").append(this.name);
        } else {
            sb.append(((ClassRef)this.returnType).getDefinition().getName());
        }
        sb.append("(");
        if (!this.varArgPreferred) {
            sb.append(StringUtils.join(this.arguments, ","));
        } else if (!this.arguments.isEmpty()) {
            List<Property> args = this.arguments.subList(0, this.arguments.size() - 1);
            Property varArg = this.arguments.get(this.arguments.size() - 1);
            sb.append(StringUtils.join(args, ","));
            if (!args.isEmpty()) {
                sb.append(",");
            }
            if (varArg.getTypeRef().getDimensions() == 1) {
                sb.append(varArg.getTypeRef().withDimensions(0)).append("...").append(" ");
            } else {
                sb.append(varArg.getTypeRef()).append(" ");
            }
            sb.append(varArg.getName());
        }
        sb.append(")");
        if (this.exceptions != null && !this.exceptions.isEmpty()) {
            sb.append(" ").append("throws").append(" ").append(StringUtils.join(this.exceptions, ","));
        }
        return sb.toString();
    }
}

