/*
 * Decompiled with CFR 0.152.
 */
package io.sundr.codegen.utils;

import io.sundr.Function;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;

public final class StringUtils {
    private StringUtils() {
    }

    public static boolean isNullOrEmpty(String str) {
        return str == null || str.isEmpty();
    }

    public static String captializeFirst(String str) {
        return str.substring(0, 1).toUpperCase() + str.substring(1);
    }

    public static String deCaptializeFirst(String str) {
        return str.substring(0, 1).toLowerCase() + str.substring(1);
    }

    public static <T> String join(Iterable<T> items, String delimiter) {
        return StringUtils.join(items, new ToString(), delimiter);
    }

    public static <T> String join(Iterable<T> items, Function<T, String> function, String delimiter) {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (T item : items) {
            if (!first) {
                sb.append(delimiter);
            }
            sb.append((String)function.apply(item));
            first = false;
        }
        return sb.toString();
    }

    public static <T> String join(T[] items, String delimiter) {
        return StringUtils.join(items, new ToString(), delimiter);
    }

    public static <T> String join(T[] items, Function<T, String> function, String delimiter) {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (T item : items) {
            if (!first) {
                sb.append(delimiter);
            }
            sb.append((String)function.apply(item));
            first = false;
        }
        return sb.toString();
    }

    public static <T> String getPrefix(Iterable<T> items, Function<T, String> function) {
        int length = 0;
        String prefix = "";
        String current = "";
        while (true) {
            boolean first = true;
            for (T item : items) {
                String currnetItem = (String)function.apply(item);
                if (first) {
                    first = false;
                    if (currnetItem.length() > length) {
                        current = currnetItem.substring(0, length);
                        continue;
                    }
                    return prefix;
                }
                if (currnetItem.startsWith(current)) continue;
                return prefix;
            }
            ++length;
            prefix = current;
        }
    }

    public static String getPrefix(Iterable<String> items) {
        return StringUtils.getPrefix(items, new Function<String, String>(){

            public String apply(String item) {
                return item;
            }
        });
    }

    public static final String loadResourceQuietly(String resourceName) {
        try {
            return StringUtils.loadResource(resourceName);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String loadResource(String resourceName) throws IOException {
        InputStream is = null;
        BufferedReader in = null;
        try {
            is = StringUtils.class.getClassLoader().getResourceAsStream(resourceName);
            in = new BufferedReader(new InputStreamReader(is));
            String line = null;
            StringBuffer sb = new StringBuffer();
            while ((line = in.readLine()) != null) {
                sb.append(line).append("\n");
            }
            String string = sb.toString();
            return string;
        }
        finally {
            if (in != null) {
                in.close();
            }
            if (is != null) {
                is.close();
            }
        }
    }

    public static final String loadResourceQuietly(URL resourceUrl) {
        try {
            return StringUtils.loadResource(resourceUrl);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String loadResource(URL resourceUrl) throws IOException {
        InputStream is = null;
        BufferedReader in = null;
        try {
            is = resourceUrl.openStream();
            in = new BufferedReader(new InputStreamReader(is));
            String line = null;
            StringBuffer sb = new StringBuffer();
            while ((line = in.readLine()) != null) {
                sb.append(line).append("\n");
            }
            String string = sb.toString();
            return string;
        }
        finally {
            if (in != null) {
                in.close();
            }
            if (is != null) {
                is.close();
            }
        }
    }

    public static final class ToString<X>
    implements Function<X, String> {
        public String apply(X item) {
            return String.valueOf(item);
        }
    }
}

