/*
 * Decompiled with CFR 0.152.
 */
package io.sundr.codegen.utils;

import io.sundr.Function;
import io.sundr.codegen.DefinitionRepository;
import io.sundr.codegen.functions.Collections;
import io.sundr.codegen.model.ClassRef;
import io.sundr.codegen.model.PrimitiveRef;
import io.sundr.codegen.model.TypeDef;
import io.sundr.codegen.model.TypeDefBuilder;
import io.sundr.codegen.model.TypeParamDef;
import io.sundr.codegen.model.TypeParamDefBuilder;
import io.sundr.codegen.model.TypeParamRef;
import io.sundr.codegen.model.TypeParamRefBuilder;
import io.sundr.codegen.model.TypeRef;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.lang.model.element.Modifier;

public final class TypeUtils {
    private static final String BOOLEAN = "boolean";
    private static final String JAVA_LANG_OBJECT = "java.lang.Object";
    private static final String JAVA_LANG_BOOLEAN = "java.lang.Boolean";
    private static final String JAVA_UTIL_OPTIONAL = "java.util.Optional";
    private static final String JAVA_UTIL_OPTIONAL_INT = "java.util.OptionalInt";
    private static final String JAVA_UTIL_OPTIONAL_DOUBLE = "java.util.OptionalDouble";
    private static final String JAVA_UTIL_OPTIONAL_LONG = "java.util.OptionalLong";
    private static final String OTHER = "other";
    private static final String DOT_REGEX = "\\.";

    private TypeUtils() {
    }

    public static boolean isInstanceOf(TypeRef type, TypeDef targetType, Function<TypeRef, Boolean> function) {
        if (type instanceof ClassRef) {
            ClassRef classRef = (ClassRef)type;
            TypeDef definition = classRef.getDefinition();
            if (definition.getFullyQualifiedName().equals(targetType.getFullyQualifiedName())) {
                return true;
            }
            for (TypeRef typeRef : definition.getImplementsList()) {
                if (!((Boolean)function.apply((Object)typeRef)).booleanValue()) continue;
                return true;
            }
            for (TypeRef typeRef : definition.getExtendsList()) {
                if (!((Boolean)function.apply((Object)typeRef)).booleanValue()) continue;
                return true;
            }
        }
        return false;
    }

    public static TypeParamDef getParameterDefinition(TypeRef typeRef, Collection<TypeParamDef> parameters) {
        String name = typeRef instanceof ClassRef ? ((ClassRef)typeRef).getName() : (typeRef instanceof TypeParamRef ? ((TypeParamRef)typeRef).getName() : (typeRef instanceof PrimitiveRef ? ((PrimitiveRef)typeRef).getName() : typeRef.toString()));
        for (TypeParamDef parameter : parameters) {
            if (!parameter.getName().equals(name)) continue;
            return parameter;
        }
        return null;
    }

    public static TypeParamRef newTypeParamRef(String letter) {
        return ((TypeParamRefBuilder)new TypeParamRefBuilder().withName(letter)).build();
    }

    public static TypeParamDef newTypeParamDef(String letter) {
        return ((TypeParamDefBuilder)new TypeParamDefBuilder().withName(letter)).build();
    }

    public static TypeDef unwrapGeneric(TypeDef base) {
        return ((TypeDefBuilder)new TypeDefBuilder(base).withParameters(new TypeParamDef[0])).build();
    }

    public static TypeDef typeGenericOf(TypeDef base, TypeParamDef ... parameters) {
        return ((TypeDefBuilder)new TypeDefBuilder(base).withParameters(parameters)).build();
    }

    public static TypeDef typeExtends(TypeDef base, ClassRef superClass) {
        return ((TypeDefBuilder)new TypeDefBuilder(base).withExtendsList(superClass)).build();
    }

    public static TypeDef typeImplements(TypeDef base, ClassRef ... superClass) {
        return ((TypeDefBuilder)new TypeDefBuilder(base).withImplementsList(superClass)).build();
    }

    public static int modifiersToInt(Modifier ... modifiers) {
        return TypeUtils.modifiersToInt(Arrays.asList(modifiers));
    }

    public static int modifiersToInt(Collection<Modifier> modifiers) {
        int result = 0;
        for (Modifier m : modifiers) {
            switch (m) {
                case ABSTRACT: {
                    result |= 0x400;
                    break;
                }
                case FINAL: {
                    result |= 0x10;
                    break;
                }
                case NATIVE: {
                    result |= 0x100;
                    break;
                }
                case PRIVATE: {
                    result |= 2;
                    break;
                }
                case PROTECTED: {
                    result |= 4;
                    break;
                }
                case PUBLIC: {
                    result |= 1;
                    break;
                }
                case STATIC: {
                    result |= 8;
                    break;
                }
                case SYNCHRONIZED: {
                    result |= 0x20;
                    break;
                }
                case TRANSIENT: {
                    result |= 0x80;
                }
            }
        }
        return result;
    }

    public static String fullyQualifiedNameDiff(String left, String right) {
        String[] lparts = left.split(DOT_REGEX);
        String[] rparts = right.split(DOT_REGEX);
        int l = lparts.length - 1;
        for (int r = rparts.length - 1; l >= 0 && r >= 0; --r, --l) {
            if (lparts[l].equals(rparts[r])) continue;
            return rparts[r];
        }
        return OTHER;
    }

    public static boolean isAbstract(TypeRef typeRef) {
        DefinitionRepository repository = DefinitionRepository.getRepository();
        TypeDef def = repository.getDefinition(typeRef);
        if (def == null && typeRef instanceof ClassRef) {
            def = ((ClassRef)typeRef).getDefinition();
        }
        return def != null ? def.isAbstract() : false;
    }

    public static boolean isPrimitive(TypeRef type) {
        return type instanceof PrimitiveRef;
    }

    public static boolean isMap(TypeRef type) {
        return (Boolean)Collections.IS_MAP.apply((Object)type);
    }

    public static boolean isList(TypeRef type) {
        return (Boolean)Collections.IS_LIST.apply((Object)type);
    }

    public static boolean isSet(TypeRef type) {
        return (Boolean)Collections.IS_SET.apply((Object)type);
    }

    public static boolean isCollection(TypeRef type) {
        return (Boolean)Collections.IS_COLLECTION.apply((Object)type);
    }

    public static boolean isBoolean(TypeRef type) {
        if (type instanceof PrimitiveRef) {
            return BOOLEAN.equals(((PrimitiveRef)type).getName());
        }
        if (!(type instanceof ClassRef)) {
            return false;
        }
        return JAVA_LANG_BOOLEAN.equals(((ClassRef)type).getDefinition().getFullyQualifiedName());
    }

    public static boolean isArray(TypeRef type) {
        if (type instanceof ClassRef) {
            return ((ClassRef)type).getDimensions() > 0;
        }
        if (type instanceof PrimitiveRef) {
            return ((PrimitiveRef)type).getDimensions() > 0;
        }
        if (type instanceof TypeParamRef) {
            return ((TypeParamRef)type).getDimensions() > 0;
        }
        return false;
    }

    public static boolean isOptional(TypeRef type) {
        if (!(type instanceof ClassRef)) {
            return false;
        }
        return JAVA_UTIL_OPTIONAL.equals(((ClassRef)type).getDefinition().getFullyQualifiedName());
    }

    public static boolean isOptionalInt(TypeRef type) {
        if (!(type instanceof ClassRef)) {
            return false;
        }
        return JAVA_UTIL_OPTIONAL_INT.equals(((ClassRef)type).getDefinition().getFullyQualifiedName());
    }

    public static boolean isOptionalDouble(TypeRef type) {
        if (!(type instanceof ClassRef)) {
            return false;
        }
        return JAVA_UTIL_OPTIONAL_DOUBLE.equals(((ClassRef)type).getDefinition().getFullyQualifiedName());
    }

    public static boolean isOptionalLong(TypeRef type) {
        if (!(type instanceof ClassRef)) {
            return false;
        }
        return JAVA_UTIL_OPTIONAL_LONG.equals(((ClassRef)type).getDefinition().getFullyQualifiedName());
    }

    public static void visitParents(TypeDef type, List<TypeDef> types) {
        TypeUtils.visitParents(type, types, new ArrayList<TypeDef>());
    }

    public static void visitParents(TypeDef type, List<TypeDef> types, List<TypeDef> visited) {
        if (JAVA_LANG_OBJECT.equals(type.getFullyQualifiedName())) {
            return;
        }
        if (visited.contains(type)) {
            return;
        }
        visited.add(type);
        ArrayList<ClassRef> allRefs = new ArrayList<ClassRef>();
        allRefs.addAll(type.getImplementsList());
        allRefs.addAll(type.getExtendsList());
        for (TypeRef typeRef : allRefs) {
            TypeDef parent = DefinitionRepository.getRepository().getDefinition(typeRef);
            TypeUtils.visitParents(parent, types, visited);
        }
        types.add(type);
    }
}

