/*
 * Decompiled with CFR 0.152.
 */
package io.sundr;

import io.sundr.Function;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CachingFunction<X, Y>
implements Function<X, Y> {
    private final Map<X, Y> cache = new HashMap<X, Y>();
    private final Function<X, Y> function;

    public CachingFunction(Function<X, Y> function) {
        this.function = function;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Y apply(X item) {
        Y result;
        Map<X, Y> map = this.cache;
        synchronized (map) {
            result = this.cache.get(item);
            if (result == null) {
                result = this.function.apply(item);
                this.cache.put(item, result);
            }
        }
        return result;
    }

    public static <X, Y> CachingFunction<X, Y> wrap(Function<X, Y> function) {
        return new CachingFunction<X, Y>(function);
    }
}

