/*
 * Decompiled with CFR 0.152.
 */
package io.sundr.maven;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MavenVersion
implements Comparable<MavenVersion> {
    private static final Pattern VERSION_PATTERN = Pattern.compile("(?<major>\\d+).(?<minor>\\d+).(?<micro>\\d+)");
    private final int major;
    private final int minor;
    private final int micro;

    public MavenVersion(String version) {
        this(MavenVersion.versionGroup(version, "major"), MavenVersion.versionGroup(version, "minor"), MavenVersion.versionGroup(version, "micro"));
    }

    public MavenVersion(int major, int minor, int micro) {
        this.major = major;
        this.minor = minor;
        this.micro = micro;
    }

    @Override
    public int compareTo(MavenVersion o) {
        if (o == null) {
            return 0;
        }
        if (this.major > o.major) {
            return -1;
        }
        if (this.major < o.major) {
            return 1;
        }
        if (this.minor > o.minor) {
            return -1;
        }
        if (this.minor < o.minor) {
            return 1;
        }
        if (this.micro > o.micro) {
            return -1;
        }
        if (this.micro < o.micro) {
            return 1;
        }
        return 0;
    }

    public String toString() {
        return this.major + "." + this.minor + "." + this.micro;
    }

    private static int versionGroup(String version, String group) {
        if (version == null || version.isEmpty()) {
            return 0;
        }
        String cleanVersion = version.replaceAll("[^\\d\\.]", "");
        Matcher matcher = VERSION_PATTERN.matcher(cleanVersion);
        if (matcher.matches()) {
            String str = matcher.group(group);
            return Integer.parseInt(str);
        }
        return 0;
    }
}

