/*
 * Decompiled with CFR 0.152.
 */
package io.sundr.maven.filter;

import io.sundr.maven.filter.ArtifactFilter;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.maven.artifact.Artifact;
import org.codehaus.plexus.util.SelectorUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ArtifactRuleFilter
implements ArtifactFilter {
    private static final String ARTIFACT_FORMAT = "%s:%s:%s:%s:%s";
    private static final Pattern ARTIFACT_PATTERN = Pattern.compile("(?<groupId>[^:]+):(?<artifactId>[^:]+)(:(?<version>[^:]+))?(:(?<type>[^:]+))?(:(?<classifier>[^:]+))?");

    static boolean matches(Artifact artifact, Set<String> set) {
        Set<String> expanded = ArtifactRuleFilter.expand(set);
        String coords = String.format(ARTIFACT_FORMAT, artifact.getGroupId(), artifact.getArtifactId(), artifact.getVersion(), artifact.getType(), artifact.getClassifier());
        for (String e : expanded) {
            if (!SelectorUtils.match((String)e, (String)coords)) continue;
            return true;
        }
        return false;
    }

    static Set<String> expand(Set<String> set) {
        HashSet<String> result = new HashSet<String>();
        if (set != null) {
            for (String exclusion : set) {
                Matcher m = ARTIFACT_PATTERN.matcher(exclusion);
                if (!m.matches()) {
                    throw new IllegalArgumentException("Pattern: " + exclusion + " doesn't the required format.");
                }
                String groupId = m.group("groupId");
                String artifactId = m.group("artifactId");
                String version = m.group("version");
                String type = m.group("type");
                String classifier = m.group("classifier");
                version = version != null ? version : "*";
                type = type != null ? type : "*";
                classifier = classifier != null ? classifier : "*";
                result.add(String.format(ARTIFACT_FORMAT, groupId, artifactId, version, type, classifier));
            }
        }
        return result;
    }
}

