/*
 * Decompiled with CFR 0.152.
 */
package io.sundr.maven.filter;

import io.sundr.maven.filter.ArtifactFilter;
import java.util.Collection;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.project.MavenProject;

public class SessionArtifactFilter
implements ArtifactFilter {
    private final Collection<MavenProject> projects;
    private final boolean include;

    public SessionArtifactFilter(MavenSession session, boolean include) {
        this.projects = session.getProjectDependencyGraph().getSortedProjects();
        this.include = include;
    }

    public Artifact apply(Artifact artifact) {
        if (artifact == null) {
            return null;
        }
        if (this.include) {
            return SessionArtifactFilter.inSessionOrNull(artifact);
        }
        return SessionArtifactFilter.nullIfInSession(artifact);
    }

    private static Artifact inSessionOrNull(Artifact artifact) {
        return SessionArtifactFilter.isBom(artifact) ? artifact : null;
    }

    private static Artifact nullIfInSession(Artifact artifact) {
        return !SessionArtifactFilter.isBom(artifact) ? artifact : null;
    }

    private static boolean isBom(Artifact artifact) {
        return "import".equals(artifact.getScope()) && "pom".equals(artifact.getType());
    }
}

