/*
 * Decompiled with CFR 0.152.
 */
package io.sundr.maven;

import io.sundr.maven.Reflections;
import java.lang.reflect.Constructor;
import java.util.Objects;
import org.apache.maven.artifact.versioning.ComparableVersion;
import org.apache.maven.execution.MavenExecutionResult;
import org.apache.maven.lifecycle.internal.LifecycleModuleBuilder;
import org.apache.maven.lifecycle.internal.ProjectIndex;
import org.apache.maven.lifecycle.internal.ReactorBuildStatus;
import org.apache.maven.lifecycle.internal.ReactorContext;

public class ReactorContextFactory {
    private static ComparableVersion VERSION_3_0_0 = new ComparableVersion("3.0.0");
    private static ComparableVersion VERSION_3_3_0 = new ComparableVersion("3.3.0");
    private static ComparableVersion VERSION_3_8_5 = new ComparableVersion("3.8.5");
    private static ComparableVersion VERSION_3_9_0 = new ComparableVersion("3.9.0");
    private static ComparableVersion VERSION_4_0_0 = new ComparableVersion("4.0.0-alpha-3");
    private final ComparableVersion version;

    public ReactorContextFactory(String version) {
        this.version = new ComparableVersion(Objects.requireNonNull(version, "Maven version must not be null"));
    }

    public ReactorContext create(MavenExecutionResult result, ProjectIndex index, ClassLoader classLoader, ReactorBuildStatus status, LifecycleModuleBuilder builder) {
        if (this.version.compareTo(VERSION_3_0_0) < 0) {
            throw new UnsupportedOperationException("ReactorContext is not supported in maven version: " + this.version);
        }
        ReactorContext context = this.version.compareTo(VERSION_3_3_0) < 0 || this.version.compareTo(VERSION_3_8_5) == 0 ? ReactorContextFactory.create_3_2_x(result, index, classLoader, status) : (this.version.compareTo(VERSION_3_9_0) < 0 ? ReactorContextFactory.create_3_3_x(result, index, classLoader, status, builder) : (this.version.compareTo(VERSION_4_0_0) < 0 ? ReactorContextFactory.create_3_9_x(result, index, classLoader, status, builder) : ReactorContextFactory.create_4_0_x(result, classLoader, status)));
        if (context == null) {
            throw new IllegalStateException("Unable to create ReactorContext");
        }
        return context;
    }

    private static ReactorContext create_3_2_x(MavenExecutionResult result, ProjectIndex index, ClassLoader classLoader, ReactorBuildStatus status) {
        try {
            Constructor constructor = ReactorContext.class.getDeclaredConstructor(MavenExecutionResult.class, ProjectIndex.class, ClassLoader.class, ReactorBuildStatus.class);
            return (ReactorContext)constructor.newInstance(result, index, classLoader, status);
        }
        catch (NoSuchMethodException e) {
            return null;
        }
        catch (Throwable t) {
            throw new RuntimeException("Could not create ReactorContext.", t);
        }
    }

    private static ReactorContext create_3_3_x(MavenExecutionResult result, ProjectIndex index, ClassLoader classLoader, ReactorBuildStatus status, LifecycleModuleBuilder builder) {
        try {
            Constructor<?> constructor = ReactorContext.class.getDeclaredConstructors()[0];
            return (ReactorContext)constructor.newInstance(result, index, classLoader, status, Reflections.getMemento(builder));
        }
        catch (Throwable t) {
            throw new RuntimeException("Could not create ReactorContext.", t);
        }
    }

    private static ReactorContext create_3_9_x(MavenExecutionResult result, ProjectIndex index, ClassLoader classLoader, ReactorBuildStatus status, LifecycleModuleBuilder builder) {
        try {
            Constructor<?> constructor = ReactorContext.class.getDeclaredConstructors()[0];
            return (ReactorContext)constructor.newInstance(result, index, classLoader, status);
        }
        catch (Throwable t) {
            throw new RuntimeException("Could not create ReactorContext.", t);
        }
    }

    private static ReactorContext create_4_0_x(MavenExecutionResult result, ClassLoader classLoader, ReactorBuildStatus status) {
        try {
            Constructor<?> constructor = ReactorContext.class.getDeclaredConstructors()[0];
            return (ReactorContext)constructor.newInstance(result, classLoader, status);
        }
        catch (Throwable t) {
            throw new RuntimeException("Could not create ReactorContext.", t);
        }
    }
}

