/*
 * Decompiled with CFR 0.152.
 */
package io.sundr.maven;

import io.sundr.codegen.generator.CodeGeneratorBuilder;
import io.sundr.maven.AbstractSundrioMojo;
import io.sundr.maven.BomConfig;
import io.sundr.maven.BomDependencyGraph;
import io.sundr.maven.ExternalBomResolver;
import io.sundr.maven.GoalSet;
import io.sundr.maven.MavenVersion;
import io.sundr.maven.ReactorContextFactory;
import io.sundr.maven.Reflections;
import io.sundr.maven.VersionOverride;
import io.sundr.maven.filter.ArtifactFilter;
import io.sundr.maven.filter.CompositeFilter;
import io.sundr.maven.filter.ExcludesFilter;
import io.sundr.maven.filter.Filters;
import io.sundr.maven.filter.IncludesFilter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.DefaultArtifact;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactResolutionRequest;
import org.apache.maven.artifact.resolver.ArtifactResolutionResult;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.execution.ProjectDependencyGraph;
import org.apache.maven.lifecycle.internal.LifecycleModuleBuilder;
import org.apache.maven.lifecycle.internal.LifecycleTaskSegmentCalculator;
import org.apache.maven.lifecycle.internal.ProjectIndex;
import org.apache.maven.lifecycle.internal.ReactorBuildStatus;
import org.apache.maven.lifecycle.internal.ReactorContext;
import org.apache.maven.lifecycle.internal.TaskSegment;
import org.apache.maven.model.Build;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.DependencyManagement;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.PluginManagement;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.repository.RemoteRepository;

@Mojo(name="generate-bom", inheritByDefault=false, defaultPhase=LifecyclePhase.VALIDATE)
public class GenerateBomMojo
extends AbstractSundrioMojo {
    private static final Set<String> GENERATED_ARTIFACT_IDS = Collections.synchronizedSet(new HashSet());
    @Component
    private ArtifactResolver artifactResolver;
    @Component
    private LifecycleModuleBuilder builder;
    @Component
    private LifecycleTaskSegmentCalculator segmentCalculator;
    @Component
    private RepositorySystem aetherSystem;
    @Parameter(defaultValue="${repositorySystemSession}", readonly=true, required=true)
    private RepositorySystemSession aetherSession;
    @Parameter(defaultValue="${project.remoteProjectRepositories}", readonly=true, required=true)
    private List<RemoteRepository> aetherRemoteRepositories;
    @Parameter(defaultValue="${localRepository}", readonly=true, required=true)
    private ArtifactRepository localRepository;
    @Parameter(defaultValue="${project.remoteArtifactRepositories}", readonly=true, required=true)
    protected List<ArtifactRepository> remoteRepositories;
    @Parameter
    private BomConfig[] boms;
    @Parameter(defaultValue="${reactorProjects}", required=true, readonly=false)
    private List<MavenProject> reactorProjects;
    @Parameter(defaultValue="${maven.version}")
    private String mavenVersion;
    @Parameter(defaultValue="${bom.template.resource}")
    private String bomTemplateResource = "templates/bom.xml.vm";
    @Parameter(defaultValue="${bom.template.url}")
    private URL bomTemplateUrl;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.getProject().isExecutionRoot() && !this.getProject().getModules().isEmpty()) {
            LinkedList<MavenProject> updated = new LinkedList<MavenProject>();
            HashMap<BomConfig, MavenProject> generated = new HashMap<BomConfig, MavenProject>();
            updated.add(this.getProject());
            if (this.boms == null || this.boms.length == 0) {
                String artifactId = this.getProject().getArtifactId() + "-bom";
                if (GENERATED_ARTIFACT_IDS.add(artifactId)) {
                    BomConfig bomConfig = new BomConfig(artifactId, this.getProject().getName() + " Bom", " Generated bom");
                    MavenProject bomProject = this.generateBom(bomConfig);
                    generated.put(bomConfig, bomProject);
                    updated.add(bomProject);
                }
            } else {
                for (BomConfig cfg : this.boms) {
                    if (!GENERATED_ARTIFACT_IDS.add(cfg.getArtifactId())) continue;
                    MavenProject bomProject = this.generateBom(cfg);
                    generated.put(cfg, bomProject);
                    updated.add(bomProject);
                }
            }
            updated.addAll(this.getAllButCurrent());
            for (Map.Entry entry : generated.entrySet()) {
                this.build(this.getSession().clone(), (MavenProject)entry.getValue(), updated, ((BomConfig)entry.getKey()).getGoals());
            }
        }
    }

    private MavenProject generateBom(BomConfig config) throws MojoFailureException, MojoExecutionException {
        File outputDir = new File(this.getProject().getBuild().getOutputDirectory());
        File bomDir = new File(outputDir, config.getArtifactId());
        File generatedBom = new File(bomDir, "pom.xml");
        if (!bomDir.exists() && !bomDir.mkdirs()) {
            throw new MojoFailureException("Failed to create output dir for bom:" + bomDir.getAbsolutePath());
        }
        GenerateBomMojo.preProccessConfig(config);
        FileWriter writer = null;
        try {
            writer = new FileWriter(generatedBom);
            LinkedHashMap<Artifact, Dependency> dependencies = new LinkedHashMap<Artifact, Dependency>();
            LinkedHashSet<Artifact> plugins = new LinkedHashSet<Artifact>();
            Set<Artifact> ownModules = Filters.filter(this.getReactorArtifacts(), Filters.createModulesFilter(config));
            LinkedHashSet dependencyManagementArtifacts = config.isInheritDependencyManagement() ? this.getProjectDependencyManagement() : new LinkedHashSet();
            LinkedHashSet<Artifact> pluginManagementArtifacts = config.isInheritPluginManagement() ? this.getProjectPluginManagement() : new LinkedHashSet<Artifact>();
            LinkedHashSet<Artifact> allDependencies = new LinkedHashSet<Artifact>(dependencyManagementArtifacts);
            allDependencies.addAll(this.getDependencies(this.getProjectDependencies()));
            dependencies.putAll(GenerateBomMojo.toDependencyMap(ownModules));
            dependencies.putAll(GenerateBomMojo.toDependencyMap(Filters.filter(allDependencies, Filters.createDependencyFilter(this.getSession(), config))));
            ExternalBomResolver bomResolver = new ExternalBomResolver(this.getSession(), this.getArtifactHandler(), this.aetherSystem, this.aetherSession, this.aetherRemoteRepositories, this.getLog());
            Map<Artifact, Dependency> externalDependencies = bomResolver.resolve(config);
            dependencies.putAll(externalDependencies);
            plugins.addAll(Filters.filter(ownModules, Filters.MAVEN_PLUGIN_FILTER));
            plugins.addAll(Filters.filter(pluginManagementArtifacts, Filters.createPluginFilter(this.getSession(), config)));
            this.applyOverrides(config, dependencies);
            MavenProject projectToGenerate = GenerateBomMojo.toGenerate(this.getProject(), config, dependencies.values(), plugins);
            this.verifyBomDependencies(config, projectToGenerate);
            this.getLog().info((CharSequence)("Generating BOM: " + config.getArtifactId()));
            ((CodeGeneratorBuilder)((CodeGeneratorBuilder)((CodeGeneratorBuilder)((CodeGeneratorBuilder)new CodeGeneratorBuilder().withWriter((Writer)writer)).withModel((Object)projectToGenerate.getModel())).withTemplateResource(this.bomTemplateResource)).withTemplateUrl(this.bomTemplateUrl)).build().generate();
            MavenProject mavenProject = GenerateBomMojo.toBuild(this.getProject(), config);
            return mavenProject;
        }
        catch (Exception e) {
            throw new MojoFailureException("Failed to generate bom.", (Throwable)e);
        }
        finally {
            try {
                if (writer != null) {
                    writer.close();
                }
            }
            catch (IOException e) {
                throw new MojoExecutionException("Failed to close the generated bom writer", (Exception)e);
            }
        }
    }

    private void verifyBomDependencies(BomConfig config, MavenProject project) throws MojoFailureException {
        if (!config.isCheckMismatches()) {
            return;
        }
        TreeMap versions = new TreeMap();
        TreeSet<String> mismatches = new TreeSet<String>();
        if (project.getDependencyManagement() != null && project.getDependencyManagement().getDependencies() != null) {
            for (Dependency dependency : project.getDependencyManagement().getDependencies()) {
                String key = GenerateBomMojo.dependencyKey(dependency);
                String version = dependency.getVersion();
                if (!versions.containsKey(key)) {
                    versions.put(key, new TreeSet());
                }
                for (String otherVersion : (Set)versions.get(key)) {
                    if (version.equals(otherVersion)) continue;
                    mismatches.add(key);
                    break;
                }
                ((Set)versions.get(key)).add(version);
            }
        }
        if (mismatches.size() > 0) {
            StringBuilder message = new StringBuilder();
            message.append("The BOM " + config.getArtifactId() + " contains multiple versions of the following dependencies:\n");
            for (String key : mismatches) {
                message.append(" - " + key + " versions " + versions.get(key) + "\n");
            }
            if (config.isFailOnMismatch()) {
                throw new MojoFailureException(message.toString());
            }
            this.getLog().warn((CharSequence)message.toString());
        }
    }

    private void applyOverrides(BomConfig config, Map<Artifact, Dependency> dependencies) {
        if (config.getOverrides() != null) {
            for (VersionOverride override : config.getOverrides()) {
                LinkedList<ArtifactFilter> filters = new LinkedList<ArtifactFilter>();
                filters.add(new IncludesFilter(override.getDependencies().getIncludes()));
                filters.add(new ExcludesFilter(override.getDependencies().getExcludes()));
                CompositeFilter filter = new CompositeFilter(filters);
                for (Map.Entry<Artifact, Dependency> entry : dependencies.entrySet()) {
                    if (filter.apply(entry.getKey()) == null) continue;
                    this.getLog().debug((CharSequence)("Changing version of dependency " + GenerateBomMojo.dependencyKey(entry.getValue()) + " to " + override.getVersion()));
                    entry.getKey().setVersion(override.getVersion());
                    entry.getValue().setVersion(override.getVersion());
                }
            }
        }
    }

    private Set<Artifact> getReactorArtifacts() {
        LinkedHashSet<Artifact> reactorArtifacts = new LinkedHashSet<Artifact>();
        for (MavenProject project : this.reactorProjects) {
            reactorArtifacts.add(project.getArtifact());
        }
        return reactorArtifacts;
    }

    private static MavenProject toGenerate(MavenProject project, BomConfig config, Collection<Dependency> dependencies, Set<Artifact> plugins) {
        MavenProject toGenerate = project.clone();
        toGenerate.setGroupId(project.getGroupId());
        toGenerate.setArtifactId(config.getArtifactId());
        toGenerate.setVersion(project.getVersion());
        toGenerate.setPackaging("pom");
        toGenerate.setName(config.getName());
        toGenerate.setDescription(config.getDescription());
        toGenerate.setUrl(project.getUrl());
        toGenerate.setLicenses(project.getLicenses());
        toGenerate.setScm(project.getScm());
        toGenerate.setDevelopers(project.getDevelopers());
        toGenerate.getModel().setDependencyManagement(new DependencyManagement());
        for (Dependency dependency : dependencies) {
            toGenerate.getDependencyManagement().addDependency(dependency);
        }
        for (Dependency dependency : config.getExtraDependencies()) {
            toGenerate.getDependencyManagement().addDependency(dependency);
        }
        toGenerate.getModel().setBuild(new Build());
        if (!plugins.isEmpty()) {
            toGenerate.getModel().setBuild(new Build());
            toGenerate.getModel().getBuild().setPluginManagement(new PluginManagement());
            for (Artifact artifact : plugins) {
                toGenerate.getPluginManagement().addPlugin(GenerateBomMojo.toPlugin(artifact));
            }
        }
        return toGenerate;
    }

    private static MavenProject toBuild(MavenProject project, BomConfig config) {
        File outputDir = new File(project.getBuild().getOutputDirectory());
        File bomDir = new File(outputDir, config.getArtifactId());
        File generatedBom = new File(bomDir, "pom.xml");
        MavenProject toBuild = project.clone();
        toBuild.setExecutionRoot(false);
        toBuild.setFile(generatedBom);
        toBuild.getModel().setPomFile(generatedBom);
        toBuild.setModelVersion(project.getModelVersion());
        toBuild.setArtifact((Artifact)new DefaultArtifact(project.getGroupId(), config.getArtifactId(), project.getVersion(), project.getArtifact().getScope(), project.getArtifact().getType(), project.getArtifact().getClassifier(), project.getArtifact().getArtifactHandler()));
        toBuild.setParent(project.getParent());
        toBuild.getModel().setParent(project.getModel().getParent());
        toBuild.setGroupId(project.getGroupId());
        toBuild.setArtifactId(config.getArtifactId());
        toBuild.setVersion(project.getVersion());
        toBuild.setPackaging("pom");
        toBuild.setName(config.getName());
        toBuild.setDescription(config.getDescription());
        toBuild.setUrl(project.getUrl());
        toBuild.setLicenses(project.getLicenses());
        toBuild.setScm(project.getScm());
        toBuild.setDevelopers(project.getDevelopers());
        toBuild.setDistributionManagement(project.getDistributionManagement());
        toBuild.getModel().setProfiles(project.getModel().getProfiles());
        toBuild.getProperties().put("clean.skip", "true");
        toBuild.getModel().getBuild().setDirectory(bomDir.getAbsolutePath());
        toBuild.getModel().getBuild().setOutputDirectory(new File(bomDir, "target").getAbsolutePath());
        for (String key : config.getProperties().stringPropertyNames()) {
            toBuild.getProperties().put(key, config.getProperties().getProperty(key));
        }
        return toBuild;
    }

    private List<MavenProject> getAllButCurrent() {
        LinkedList<MavenProject> result = new LinkedList<MavenProject>(this.getSession().getProjects());
        result.remove(this.getSession().getCurrentProject());
        return result;
    }

    private void build(MavenSession session, MavenProject project, List<MavenProject> allProjects, GoalSet goals) throws MojoExecutionException {
        session.setProjects(allProjects);
        ProjectIndex projectIndex = new ProjectIndex(session.getProjects());
        try {
            ReactorBuildStatus reactorBuildStatus = new ReactorBuildStatus((ProjectDependencyGraph)new BomDependencyGraph(session.getProjects()));
            ReactorContext reactorContext = new ReactorContextFactory(new MavenVersion(this.mavenVersion)).create(session.getResult(), projectIndex, Thread.currentThread().getContextClassLoader(), reactorBuildStatus, this.builder);
            List segments = this.segmentCalculator.calculateTaskSegments(session);
            for (TaskSegment segment : segments) {
                this.builder.buildProject(session, reactorContext, project, GenerateBomMojo.filterSegment(segment, goals));
            }
        }
        catch (Throwable t) {
            throw new MojoExecutionException("Error building generated bom:" + project.getArtifactId(), t);
        }
    }

    private Set<Artifact> getSessionArtifacts() {
        LinkedHashSet<Artifact> result = new LinkedHashSet<Artifact>();
        for (MavenProject p : this.getSession().getProjectDependencyGraph().getSortedProjects()) {
            result.add(p.getArtifact());
        }
        return result;
    }

    private Set<Artifact> getProjectDependencies() {
        LinkedHashSet<Artifact> result = new LinkedHashSet<Artifact>();
        for (MavenProject p : this.getSession().getProjectDependencyGraph().getSortedProjects()) {
            for (Dependency dependency : p.getDependencies()) {
                result.add(this.toArtifact(dependency));
            }
        }
        return result;
    }

    private Set<Artifact> getProjectDependencyManagement() {
        LinkedHashSet<Artifact> result = new LinkedHashSet<Artifact>();
        DependencyManagement dependencyManagement = this.getProject().getDependencyManagement();
        if (dependencyManagement != null) {
            for (Dependency dependency : dependencyManagement.getDependencies()) {
                result.add(this.toArtifact(dependency));
            }
        }
        return result;
    }

    private Set<Artifact> getProjectPluginManagement() {
        LinkedHashSet<Artifact> result = new LinkedHashSet<Artifact>();
        PluginManagement pluginManagement = this.getProject().getPluginManagement();
        if (pluginManagement != null) {
            for (Plugin plugin : pluginManagement.getPlugins()) {
                result.add(this.toArtifact(plugin));
            }
        }
        return result;
    }

    private Set<Artifact> getDependencies(Set<Artifact> projectDependencies) {
        LinkedHashSet<Artifact> result = new LinkedHashSet<Artifact>(projectDependencies);
        Set<Artifact> testDependencies = GenerateBomMojo.dependenciesWithScope(projectDependencies, "test");
        Set<Artifact> nonTestDependencies = GenerateBomMojo.allBut(projectDependencies, testDependencies);
        Set<Artifact> testTransitives = this.resolve(testDependencies);
        Set<Artifact> nonTestTransitives = this.resolve(nonTestDependencies);
        Set<Artifact> testOnlyDependencies = GenerateBomMojo.allBut(testTransitives, nonTestTransitives);
        for (Artifact testOnly : testOnlyDependencies) {
            result.add((Artifact)new DefaultArtifact(testOnly.getGroupId(), testOnly.getArtifactId(), testOnly.getVersion(), "test", testOnly.getType(), testOnly.getClassifier(), testOnly.getArtifactHandler()));
        }
        result.addAll(this.resolve(projectDependencies));
        return result;
    }

    private Set<Artifact> resolve(Set<Artifact> dependencies) {
        ArtifactResolutionRequest request = new ArtifactResolutionRequest();
        request.setArtifact(this.getProject().getArtifact());
        request.setArtifactDependencies(dependencies);
        request.setLocalRepository(this.localRepository);
        request.setRemoteRepositories(this.remoteRepositories);
        request.setManagedVersionMap(this.getProject().getManagedVersionMap());
        request.setResolveTransitively(true);
        ArtifactResolutionResult result = this.artifactResolver.resolve(request);
        return result.getArtifacts();
    }

    private Artifact toArtifact(Dependency dependency) {
        return new DefaultArtifact(dependency.getGroupId(), dependency.getArtifactId(), dependency.getVersion(), dependency.getScope(), dependency.getType(), dependency.getClassifier(), this.getArtifactHandler());
    }

    private Artifact toArtifact(Plugin plugin) {
        return new DefaultArtifact(plugin.getGroupId(), plugin.getArtifactId(), plugin.getVersion(), null, "maven-plugin", null, this.getArtifactHandler());
    }

    private static Map<Artifact, Dependency> toDependencyMap(Collection<Artifact> artifacts) {
        LinkedHashMap<Artifact, Dependency> dependencyMap = new LinkedHashMap<Artifact, Dependency>();
        if (artifacts != null) {
            for (Artifact artifact : artifacts) {
                Dependency dependency = GenerateBomMojo.toDependency(artifact);
                dependencyMap.put(artifact, dependency);
            }
        }
        return dependencyMap;
    }

    private static Dependency toDependency(Artifact artifact) {
        Dependency dependency = new Dependency();
        dependency.setGroupId(artifact.getGroupId());
        dependency.setArtifactId(artifact.getArtifactId());
        dependency.setVersion(artifact.getVersion());
        dependency.setType(artifact.getType());
        dependency.setScope("compile".equals(artifact.getScope()) ? null : artifact.getScope());
        dependency.setClassifier(artifact.getClassifier());
        dependency.setOptional(artifact.isOptional());
        return dependency;
    }

    private static Plugin toPlugin(Artifact artifact) {
        Plugin plugin = new Plugin();
        plugin.setGroupId(artifact.getGroupId());
        plugin.setArtifactId(artifact.getArtifactId());
        plugin.setVersion(artifact.getVersion());
        return plugin;
    }

    private static TaskSegment filterSegment(TaskSegment segment, GoalSet goals) {
        ArrayList filtered = new ArrayList();
        Set<String> includes = goals.getIncludes();
        Set<String> excludes = goals.getExcludes();
        for (Object obj : segment.getTasks()) {
            String name = Reflections.readAnyField(obj, "pluginGoal", "lifecyclePhase");
            if (excludes.contains(name) || !includes.contains(name) && !includes.isEmpty()) continue;
            filtered.add(obj);
        }
        return new TaskSegment(segment.isAggregating(), filtered.toArray());
    }

    private static void preProccessConfig(BomConfig config) {
        if (config.getModules().getIncludes().isEmpty()) {
            config.getModules().getIncludes().add("*:*");
        }
    }

    private static Set<Artifact> dependenciesWithScope(Set<Artifact> dependencies, String scope) {
        LinkedHashSet<Artifact> result = new LinkedHashSet<Artifact>();
        for (Artifact artifact : dependencies) {
            if (!scope.equals(artifact.getScope())) continue;
            result.add(artifact);
        }
        return result;
    }

    private static Set<Artifact> allBut(Set<Artifact> source, Set<Artifact> exclusions) {
        LinkedHashSet<Artifact> result = new LinkedHashSet<Artifact>(source);
        result.removeAll(exclusions);
        return result;
    }

    private static String dependencyKey(Dependency dependency) {
        return dependency.getGroupId() + ":" + dependency.getArtifactId() + ":" + dependency.getType() + ":" + dependency.getClassifier();
    }
}

