/*
 * Decompiled with CFR 0.152.
 */
package io.sundr.maven;

import io.sundr.adapter.api.AdapterContext;
import io.sundr.adapter.source.Project;
import io.sundr.adapter.source.analysis.ImpactAnalysisResult;
import io.sundr.adapter.source.analysis.ImpactAnalyzer;
import io.sundr.adapter.source.change.ChangeSet;
import io.sundr.adapter.source.utils.Sources;
import io.sundr.maven.AbstractSundrioMojo;
import io.sundr.model.Block;
import io.sundr.model.ClassRef;
import io.sundr.model.Method;
import io.sundr.model.Nameable;
import io.sundr.model.TypeDef;
import io.sundr.model.repo.DefinitionRepository;
import io.sundr.model.repo.MethodReference;
import io.sundr.tui.Key;
import io.sundr.tui.TermFrame;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.lang.invoke.CallSite;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.shared.invoker.DefaultInvocationRequest;
import org.apache.maven.shared.invoker.DefaultInvoker;
import org.apache.maven.shared.invoker.InvocationRequest;
import org.apache.maven.shared.invoker.InvocationResult;
import org.apache.maven.shared.invoker.MavenInvocationException;
import org.fusesource.jansi.Ansi;
import org.fusesource.jansi.AnsiConsole;

@Mojo(name="continuous-test", defaultPhase=LifecyclePhase.TEST, requiresDependencyResolution=ResolutionScope.TEST, threadSafe=false)
public class ContinuousTestingMojo
extends AbstractSundrioMojo {
    @Parameter(defaultValue="${project.build.testSourceDirectory}")
    private File testSourceDirectory;
    @Parameter(defaultValue="${project.build.sourceDirectory}")
    private File sourceDirectory;
    @Parameter(property="maven.test.skip", defaultValue="false")
    private boolean skipTests;
    @Parameter(property="test.includes", defaultValue="**/*Test.java,**/Test*.java,**/*Tests.java")
    private String testIncludes;
    @Parameter(property="test.goal", defaultValue="test")
    private String testGoal;
    private Project sourceProject;
    private ImpactAnalyzer impactAnalyzer;
    private final Map<String, Set<String>> testToSourceMapping = new ConcurrentHashMap<String, Set<String>>();
    private final Map<String, TypeDef> testTypeDefs = new ConcurrentHashMap<String, TypeDef>();
    private final Map<String, TypeDef> sourceTypeDefs = new ConcurrentHashMap<String, TypeDef>();
    private final Map<String, Map<String, String>> sourceFileMethodSnapshots = new ConcurrentHashMap<String, Map<String, String>>();
    private final Map<String, Set<String>> sourceMethodToTestMethods = new ConcurrentHashMap<String, Set<String>>();
    private final Map<String, ConcurrentLinkedQueue<FileChangeEvent>> pendingFileEvents = new ConcurrentHashMap<String, ConcurrentLinkedQueue<FileChangeEvent>>();
    private final ScheduledExecutorService debounceExecutor = Executors.newSingleThreadScheduledExecutor();
    private final AtomicBoolean running = new AtomicBoolean(true);
    private volatile ChangeSet lastChangeSet;
    private volatile ImpactAnalysisResult lastImpactAnalysis;
    private final AtomicInteger totalTests = new AtomicInteger(0);
    private final AtomicInteger passedTests = new AtomicInteger(0);
    private final AtomicInteger failedTests = new AtomicInteger(0);
    private final AtomicInteger errorTests = new AtomicInteger(0);
    private final AtomicInteger skippedTests = new AtomicInteger(0);
    private final Map<String, TestClassResult> sessionTestResults = new ConcurrentHashMap<String, TestClassResult>();
    private final AtomicInteger sessionTotalTests = new AtomicInteger(0);
    private final AtomicInteger sessionPassedTests = new AtomicInteger(0);
    private final AtomicInteger sessionFailedTests = new AtomicInteger(0);
    private final AtomicInteger sessionErrorTests = new AtomicInteger(0);
    private final AtomicInteger sessionSkippedTests = new AtomicInteger(0);
    private final Map<String, TestCaseResult> sessionTestCases = new ConcurrentHashMap<String, TestCaseResult>();
    private final Map<String, TestCaseResult> currentRunTestCases = new ConcurrentHashMap<String, TestCaseResult>();
    private final Set<String> requestedTestMethods = ConcurrentHashMap.newKeySet();
    private boolean runningSpecificMethods = false;
    private TermFrame termFrame;

    private String generateStatusHeader() {
        StringBuilder header = new StringBuilder();
        header.append(Ansi.ansi().fgBrightCyan().a("Continuous Testing").reset().a(": Tracking ").a(this.sessionTestCases.size()).a(" test methods\n"));
        return header.toString();
    }

    private String generateCommandFooter() {
        StringBuilder footer = new StringBuilder();
        Map<TestStatus, Long> testCaseStats = this.sessionTestCases.values().stream().collect(Collectors.groupingBy(tc -> tc.status, Collectors.counting()));
        long casePending = testCaseStats.getOrDefault((Object)TestStatus.PENDING, 0L);
        long casePassed = testCaseStats.getOrDefault((Object)TestStatus.PASSED, 0L);
        long caseFailed = testCaseStats.getOrDefault((Object)TestStatus.FAILED, 0L);
        long caseErrors = testCaseStats.getOrDefault((Object)TestStatus.ERROR, 0L);
        long caseSkipped = testCaseStats.getOrDefault((Object)TestStatus.SKIPPED, 0L);
        long caseTotal = this.sessionTestCases.size();
        String statusEmoji = caseFailed > 0L || caseErrors > 0L ? "\u274c" : (casePending > 0L ? "\u23f3" : (caseTotal > 0L ? "\u2705" : "\u23f3"));
        footer.append(statusEmoji).append(" Tests: ").append(caseTotal).append(" methods");
        if (casePending > 0L) {
            footer.append(", ").append(casePending).append(" \u23f3");
        }
        if (casePassed > 0L) {
            footer.append(", ").append(casePassed).append(" \u2713");
        }
        if (caseFailed > 0L) {
            footer.append(", ").append(caseFailed).append(" \u2717");
        }
        if (caseErrors > 0L) {
            footer.append(", ").append(caseErrors).append(" \u26a0");
        }
        if (caseSkipped > 0L) {
            footer.append(", ").append(caseSkipped).append(" \u2298");
        }
        if (!this.currentRunTestCases.isEmpty()) {
            Map<TestStatus, Long> currentStats = this.currentRunTestCases.values().stream().collect(Collectors.groupingBy(tc -> tc.status, Collectors.counting()));
            long currentPassed = currentStats.getOrDefault((Object)TestStatus.PASSED, 0L);
            long currentFailed = currentStats.getOrDefault((Object)TestStatus.FAILED, 0L);
            long currentErrors = currentStats.getOrDefault((Object)TestStatus.ERROR, 0L);
            long currentSkipped = currentStats.getOrDefault((Object)TestStatus.SKIPPED, 0L);
            long totalFailures = currentFailed + currentErrors;
            footer.append(" | Last run: ").append(this.currentRunTestCases.size()).append(" run");
            if (currentPassed > 0L) {
                footer.append(", ").append(currentPassed).append(" \u2713");
            }
            if (totalFailures > 0L) {
                footer.append(", ").append(totalFailures).append(" \u2717");
            }
            if (currentSkipped > 0L) {
                footer.append(", ").append(currentSkipped).append(" \u2298");
            }
        }
        footer.append("\n");
        footer.append(Ansi.ansi().fgBrightCyan().a("[Q]").reset().a("uit | ").fgBrightCyan().a("[D]").reset().a("ependency tree | ").fgBrightCyan().a("[R]").reset().a("estart | ").fgBrightCyan().a("[H]").reset().a("elp"));
        return footer.toString();
    }

    private void initializeTermFrame() throws Exception {
        this.termFrame = TermFrame.newFrame().withHeader(this::generateStatusHeader).withFooter(this::generateCommandFooter).withExitKey(Key.ESC).withHelpKey(104).withKeyBinding(113, "Quit continuous testing", tf -> {
            tf.println("Quitting continuous testing...");
            this.running.set(false);
            System.exit(0);
        }).withKeyBinding(100, "Show dependency tree", tf -> this.showDependencyTree()).withKeyBinding(114, "Re-run all tests", tf -> {
            tf.println("Re-running all tests...");
            try {
                this.runAllTests();
            }
            catch (Exception e) {
                tf.println("\u274c Error running tests: " + e.getMessage());
            }
        });
        this.termFrame.start();
    }

    private void runInitialTests() throws MavenInvocationException {
        this.termFrame.println("\ud83e\uddea Running initial test suite...");
        this.termFrame.println("");
        this.runAllTests();
    }

    private void startTermFrameEventLoop() throws Exception {
        Thread watcherThread = new Thread(() -> {
            try {
                this.sourceProject.allSources().watch(changeSet -> {
                    try {
                        this.handleChangeSetWithImpactAnalysis((ChangeSet)changeSet);
                    }
                    catch (Exception e) {
                        this.termFrame.println("\u274c Error handling file changes: " + e.getMessage());
                    }
                }).get();
            }
            catch (Exception e) {
                this.termFrame.println("\u274c File watcher error: " + e.getMessage());
            }
        });
        watcherThread.setDaemon(true);
        watcherThread.start();
        this.termFrame.run();
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.skipTests) {
            this.getLog().info((CharSequence)"Tests are skipped, continuous testing disabled");
            return;
        }
        try {
            AnsiConsole.systemInstall();
            this.initializeProject();
            this.analyzeTestFiles();
            this.analyzeSourceFiles();
            this.mapTestDependencies();
            this.createMethodSnapshots();
            this.buildMethodToTestMapping();
            this.analyzeProjectStructure();
            this.initializeTestCaseData();
            this.initializeTermFrame();
            this.runInitialTests();
            this.startTermFrameEventLoop();
        }
        catch (Exception e) {
            throw new MojoExecutionException("Error during continuous testing", e);
        }
        finally {
            if (this.termFrame != null) {
                try {
                    this.termFrame.close();
                }
                catch (Exception e) {
                    this.getLog().debug((CharSequence)"Error closing TermFrame", (Throwable)e);
                }
            }
        }
    }

    private void initializeProject() {
        this.sourceProject = Project.getProject((Path)this.getProject().getBasedir().toPath());
        this.impactAnalyzer = new ImpactAnalyzer(this.sourceProject, DefinitionRepository.getRepository());
        this.getLog().info((CharSequence)("Project initialized: " + String.valueOf(this.sourceProject.getModuleRoot())));
    }

    private void analyzeProjectStructure() {
        this.getLog().debug((CharSequence)"Analyzing project structure...");
        List testFiles = this.sourceProject.testSources().including(this.testIncludes.split(",")).list();
        List sourceFiles = this.sourceProject.sources().list();
        this.getLog().debug((CharSequence)("Found " + testFiles.size() + " test files"));
        this.getLog().debug((CharSequence)("Found " + sourceFiles.size() + " source files"));
        this.buildTestSourceMapping(testFiles, sourceFiles);
    }

    private void buildTestSourceMapping(List<Path> testFiles, List<Path> sourceFiles) {
        this.getLog().debug((CharSequence)"Building test to source mapping...");
        AdapterContext context = AdapterContext.create((DefinitionRepository)DefinitionRepository.getRepository());
        for (Path testFile : testFiles) {
            try {
                TypeDef testTypeDef;
                try (FileInputStream fis = new FileInputStream(testFile.toFile());){
                    testTypeDef = Sources.readTypeDefFromStream((InputStream)fis, (AdapterContext)context);
                    DefinitionRepository.getRepository().registerIfAbsent(testTypeDef);
                }
                HashSet referencedSources = new HashSet();
                for (Method method : testTypeDef.getMethods()) {
                    Set methodRefs = MethodReference.getMethodReferences((Method)method);
                    for (MethodReference methodRef : methodRefs) {
                        this.sourceProject.sources().find((Nameable)methodRef.getOwningType()).ifPresent(sourcePath -> referencedSources.add(sourcePath.toString()));
                    }
                }
                if (referencedSources.isEmpty()) continue;
                this.testToSourceMapping.put(testFile.toString(), referencedSources);
                this.getLog().info((CharSequence)("Test " + String.valueOf(testFile.getFileName()) + " -> " + referencedSources.size() + " sources"));
            }
            catch (Exception e) {
                this.getLog().warn((CharSequence)("Failed to analyze test file: " + String.valueOf(testFile)), (Throwable)e);
            }
        }
        this.getLog().debug((CharSequence)("Built mappings for " + this.testToSourceMapping.size() + " test files"));
    }

    private void runAllTests() throws MavenInvocationException {
        this.getLog().info((CharSequence)"Running all tests...");
        this.runningSpecificMethods = false;
        this.requestedTestMethods.clear();
        this.resetTestCounters();
        this.runMavenGoal(this.testGoal, new String[0]);
    }

    private void runSpecificTests(Set<String> testClasses) throws MavenInvocationException {
        if (testClasses.isEmpty()) {
            return;
        }
        this.runningSpecificMethods = false;
        this.requestedTestMethods.clear();
        String testClassNames = testClasses.stream().map(this::extractClassName).collect(Collectors.joining(","));
        this.resetTestCounters();
        this.runMavenGoal(this.testGoal, "-Dtest=" + testClassNames);
    }

    private void runMavenGoal(String goal, String ... additionalArgs) throws MavenInvocationException {
        DefaultInvocationRequest request = new DefaultInvocationRequest();
        request.setPomFile(this.getProject().getFile());
        request.setGoals(List.of(goal));
        request.setBatchMode(true);
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        ByteArrayOutputStream errorStream = new ByteArrayOutputStream();
        PrintStream outputPrintStream = new PrintStream(outputStream);
        PrintStream errorPrintStream = new PrintStream(errorStream);
        request.setOutputHandler(line -> {
            String trimmed;
            outputPrintStream.println(line);
            if (!(this.termFrame == null || line == null || (trimmed = line.trim()).isEmpty() || trimmed.startsWith("[INFO] Scanning for projects") || trimmed.startsWith("[INFO] Building") || trimmed.startsWith("[INFO] Skipping") || trimmed.startsWith("[INFO] --- ") && !trimmed.contains("surefire") || trimmed.equals("[INFO]"))) {
                this.termFrame.println(line);
            }
        });
        request.setErrorHandler(line -> {
            errorPrintStream.println(line);
            if (this.termFrame != null && line != null && !line.trim().isEmpty()) {
                this.termFrame.println("\u274c " + line);
            }
        });
        if (additionalArgs.length > 0) {
            Properties props = new Properties();
            props.setProperty("test", additionalArgs[0].substring(additionalArgs[0].indexOf(61) + 1));
            request.setProperties(props);
        }
        DefaultInvoker invoker = new DefaultInvoker();
        this.currentRunTestCases.clear();
        InvocationResult result = invoker.execute((InvocationRequest)request);
        String output = outputStream.toString();
        String errorOutput = errorStream.toString();
        String fullOutput = output + "\n" + errorOutput;
        this.parseIndividualTestResults(fullOutput);
        this.extractAndLogTestSummary(fullOutput);
        this.updateSessionTestCases();
        if (result.getExitCode() != 0 && this.termFrame != null) {
            this.termFrame.println("\u26a0\ufe0f Test execution failed with exit code: " + result.getExitCode());
        }
    }

    private void extractAndLogTestSummary(String mavenOutput) {
        if (mavenOutput == null || mavenOutput.trim().isEmpty()) {
            this.getLog().info((CharSequence)"\u2705 Test execution completed (no output captured)");
            return;
        }
        String[] lines = mavenOutput.split("\n");
        boolean inTestResults = false;
        boolean foundTestOutput = false;
        for (String line : lines) {
            String trimmedLine = line.trim();
            if (trimmedLine.contains("Tests run:") && trimmedLine.contains("Time elapsed:")) {
                this.getLog().info((CharSequence)trimmedLine);
                this.parseTestResults(trimmedLine);
                foundTestOutput = true;
                continue;
            }
            if (trimmedLine.contains("FAILURE") || trimmedLine.contains("ERROR")) {
                this.getLog().warn((CharSequence)("\u274c " + trimmedLine));
                this.markTestCaseAsFailed(trimmedLine);
                foundTestOutput = true;
                continue;
            }
            if (trimmedLine.startsWith("Results:")) {
                inTestResults = true;
                this.getLog().info((CharSequence)("\ud83c\udfc1 " + trimmedLine));
                foundTestOutput = true;
                continue;
            }
            if (inTestResults && (trimmedLine.startsWith("Tests run:") || trimmedLine.contains("Failed:") || trimmedLine.contains("Errors:"))) {
                this.getLog().info((CharSequence)("\ud83d\udcc8 " + trimmedLine));
                foundTestOutput = true;
                if (!trimmedLine.isEmpty()) continue;
                inTestResults = false;
                continue;
            }
            if (trimmedLine.contains("[INFO]") && trimmedLine.contains("Surefire") && trimmedLine.contains("Test")) {
                this.getLog().info((CharSequence)("\ud83e\uddea " + trimmedLine.substring(trimmedLine.indexOf("]") + 1).trim()));
                foundTestOutput = true;
                continue;
            }
            if (!trimmedLine.contains("Running ") || !trimmedLine.contains("Test")) continue;
            this.getLog().info((CharSequence)trimmedLine);
            foundTestOutput = true;
        }
        this.termFrame.println("");
    }

    private void markTestCaseAsFailed(String failureLine) {
        for (TestCaseResult testCase : this.currentRunTestCases.values()) {
            if (!failureLine.contains(testCase.testMethod) && !failureLine.contains(testCase.testClass)) continue;
            String testKey = testCase.getFullName();
            this.currentRunTestCases.put(testKey, new TestCaseResult(testCase.testClass, testCase.testMethod, TestStatus.FAILED, failureLine));
            this.getLog().debug((CharSequence)("Marked test case as failed: " + testKey));
            break;
        }
    }

    private void logCurrentRunSummary() {
        if (this.currentRunTestCases.isEmpty()) {
            return;
        }
        Map<TestStatus, Long> currentRunStats = this.currentRunTestCases.values().stream().collect(Collectors.groupingBy(tc -> tc.status, Collectors.counting()));
        long runPassed = currentRunStats.getOrDefault((Object)TestStatus.PASSED, 0L);
        long runFailed = currentRunStats.getOrDefault((Object)TestStatus.FAILED, 0L);
        long runErrors = currentRunStats.getOrDefault((Object)TestStatus.ERROR, 0L);
        long runSkipped = currentRunStats.getOrDefault((Object)TestStatus.SKIPPED, 0L);
        StringBuilder summary = new StringBuilder("\ud83d\udccb Current run: ");
        summary.append(this.currentRunTestCases.size()).append(" test cases - ");
        if (runPassed > 0L) {
            summary.append(runPassed).append(" \u2713 ");
        }
        if (runFailed > 0L) {
            summary.append(runFailed).append(" \u2717 ");
        }
        if (runErrors > 0L) {
            summary.append(runErrors).append(" \u26a0 ");
        }
        if (runSkipped > 0L) {
            summary.append(runSkipped).append(" \u2298 ");
        }
        if (runFailed > 0L || runErrors > 0L) {
            this.getLog().warn((CharSequence)summary.toString());
            this.currentRunTestCases.values().stream().filter(tc -> tc.status == TestStatus.FAILED || tc.status == TestStatus.ERROR).forEach(tc -> this.getLog().warn((CharSequence)("  \u274c " + tc.getFullName())));
        } else {
            this.getLog().info((CharSequence)summary.toString());
        }
    }

    private void analyzeTestFiles() throws IOException {
        this.getLog().debug((CharSequence)"Analyzing test files...");
        if (!this.testSourceDirectory.exists()) {
            this.getLog().warn((CharSequence)("Test source directory does not exist: " + String.valueOf(this.testSourceDirectory)));
            return;
        }
        AdapterContext context = AdapterContext.create((DefinitionRepository)DefinitionRepository.getRepository());
        this.getLog().debug((CharSequence)("Test source directory: " + String.valueOf(this.testSourceDirectory)));
        this.getLog().debug((CharSequence)("Test includes pattern: " + this.testIncludes));
        Files.walk(this.testSourceDirectory.toPath(), new FileVisitOption[0]).filter(path -> path.toString().endsWith(".java")).forEach(path -> {
            boolean isTest = this.isTestFile((Path)path);
            this.getLog().debug((CharSequence)("\ud83d\udd0d Checking file: " + String.valueOf(path) + " -> isTest: " + isTest));
            if (isTest) {
                try (FileInputStream fis = new FileInputStream(path.toFile());){
                    TypeDef typeDef = Sources.readTypeDefFromStream((InputStream)fis, (AdapterContext)context);
                    this.testTypeDefs.put(path.toString(), typeDef);
                    DefinitionRepository.getRepository().registerIfAbsent(typeDef);
                    String fqn = typeDef.getPackageName() + "." + typeDef.getName();
                    this.getLog().debug((CharSequence)("\ud83e\uddea Test: " + typeDef.getName() + " (" + fqn + ") -> " + String.valueOf(path)));
                }
                catch (Exception e) {
                    this.getLog().warn((CharSequence)("Failed to analyze test file: " + String.valueOf(path)), (Throwable)e);
                }
            }
        });
        this.getLog().debug((CharSequence)("Analyzed " + this.testTypeDefs.size() + " test files"));
    }

    private void analyzeSourceFiles() throws IOException {
        this.getLog().debug((CharSequence)"Analyzing source files...");
        if (!this.sourceDirectory.exists()) {
            this.getLog().warn((CharSequence)("Source directory does not exist: " + String.valueOf(this.sourceDirectory)));
            return;
        }
        AdapterContext context = AdapterContext.create((DefinitionRepository)DefinitionRepository.getRepository());
        Files.walk(this.sourceDirectory.toPath(), new FileVisitOption[0]).filter(path -> path.toString().endsWith(".java")).forEach(path -> {
            try (FileInputStream fis = new FileInputStream(path.toFile());){
                TypeDef typeDef = Sources.readTypeDefFromStream((InputStream)fis, (AdapterContext)context);
                this.sourceTypeDefs.put(path.toString(), typeDef);
                DefinitionRepository.getRepository().registerIfAbsent(typeDef);
                String string = typeDef.getPackageName() + "." + typeDef.getName();
            }
            catch (Exception e) {
                this.getLog().debug((CharSequence)("Failed to analyze source file: " + String.valueOf(path) + " - " + e.getMessage()));
            }
        });
    }

    private void mapTestDependencies() {
        for (Map.Entry<String, TypeDef> testEntry : this.testTypeDefs.entrySet()) {
            String testFile = testEntry.getKey();
            TypeDef testTypeDef = testEntry.getValue();
            HashSet<String> referencedSources = new HashSet<String>();
            HashSet<String> allFoundDependencies = new HashSet<String>();
            String testClassName = this.extractClassName(testFile);
            for (Method method : testTypeDef.getMethods()) {
                Set<String> methodDependencies = this.extractTypeDependencies(method);
                allFoundDependencies.addAll(methodDependencies);
                for (String dependency : methodDependencies) {
                    String sourceFile = this.findSourceFileForType(dependency);
                    if (sourceFile == null) continue;
                    referencedSources.add(sourceFile);
                }
            }
            Set<String> classDependencies = this.extractClassDependencies(testTypeDef);
            allFoundDependencies.addAll(classDependencies);
            for (String dependency : classDependencies) {
                String sourceFile = this.findSourceFileForType(dependency);
                if (sourceFile != null) {
                    referencedSources.add(sourceFile);
                    this.getLog().debug((CharSequence)("    \u2705 " + dependency + " -> " + sourceFile));
                    continue;
                }
                this.getLog().debug((CharSequence)("    \u274c " + dependency + " -> NOT FOUND in source files"));
            }
            if (referencedSources.isEmpty()) continue;
            this.testToSourceMapping.put(testFile, referencedSources);
        }
    }

    private void createMethodSnapshots() {
        for (Map.Entry<String, TypeDef> entry : this.sourceTypeDefs.entrySet()) {
            String sourceFile = entry.getKey();
            TypeDef typeDef = entry.getValue();
            HashMap<String, String> methodSnapshots = new HashMap<String, String>();
            for (Method method : typeDef.getMethods()) {
                String methodSignature = this.createMethodSignature(method);
                methodSnapshots.put(method.getName(), methodSignature);
                this.getLog().debug((CharSequence)("\ud83d\udcf8 Snapshot: " + typeDef.getName() + "." + method.getName() + " -> " + methodSignature.hashCode()));
            }
            this.sourceFileMethodSnapshots.put(sourceFile, methodSnapshots);
        }
    }

    private void buildMethodToTestMapping() {
        this.getLog().debug((CharSequence)"\ud83d\udd27 Building method-to-test mapping for fine-grained test execution...");
        for (Map.Entry<String, TypeDef> entry : this.testTypeDefs.entrySet()) {
            String testFile = entry.getKey();
            TypeDef testTypeDef = entry.getValue();
            this.getLog().debug((CharSequence)("\ud83d\udd0d Analyzing test class: " + testTypeDef.getFullyQualifiedName()));
            for (Method testMethod : testTypeDef.getMethods()) {
                String testMethodKey = testTypeDef.getFullyQualifiedName() + "." + testMethod.getName();
                this.getLog().debug((CharSequence)("  \ud83d\udccb Analyzing test method: " + testMethod.getName()));
                Set<String> methodDependencies = this.extractMethodCallDependencies(testMethod);
                this.getLog().debug((CharSequence)("    \ud83d\udd17 Method call dependencies: " + String.valueOf(methodDependencies)));
                for (String sourceMethodCall : methodDependencies) {
                    this.sourceMethodToTestMethods.computeIfAbsent(sourceMethodCall, k -> new HashSet()).add(testMethodKey);
                    this.getLog().debug((CharSequence)("    \u2705 Mapped: " + sourceMethodCall + " -> " + testMethodKey));
                }
                Set<String> classDependencies = this.extractClassDependencies(testTypeDef);
                this.getLog().debug((CharSequence)("    \ud83c\udfd7\ufe0f  Class-level dependencies: " + String.valueOf(classDependencies)));
                for (String dependency : classDependencies) {
                    for (Map.Entry<String, TypeDef> sourceEntry : this.sourceTypeDefs.entrySet()) {
                        TypeDef sourceTypeDef = sourceEntry.getValue();
                        if (!sourceTypeDef.getFullyQualifiedName().equals(dependency)) continue;
                        this.getLog().debug((CharSequence)("    \ud83c\udfaf Found source class: " + dependency + " with " + sourceTypeDef.getMethods().size() + " methods"));
                        for (Method sourceMethod : sourceTypeDef.getMethods()) {
                            String sourceMethodKey = dependency + "." + sourceMethod.getName();
                            this.sourceMethodToTestMethods.computeIfAbsent(sourceMethodKey, k -> new HashSet()).add(testMethodKey);
                            this.getLog().debug((CharSequence)("      \u2705 Mapped (class-level): " + sourceMethodKey + " -> " + testMethodKey));
                        }
                    }
                }
            }
        }
        this.getLog().debug((CharSequence)("Built method-to-test mapping with " + this.sourceMethodToTestMethods.size() + " source method entries"));
        this.getLog().debug((CharSequence)"\ud83d\uddc2\ufe0f  COMPLETE METHOD-TO-TEST MAPPING:");
        for (Map.Entry<String, Object> entry : this.sourceMethodToTestMethods.entrySet()) {
            this.getLog().debug((CharSequence)("  \ud83d\udccb " + entry.getKey() + " -> " + ((Set)entry.getValue()).size() + " test method(s): " + String.valueOf(entry.getValue())));
        }
        if (this.sourceMethodToTestMethods.isEmpty()) {
            this.getLog().warn((CharSequence)"\u26a0\ufe0f  WARNING: No method-to-test mappings were created!");
            this.getLog().info((CharSequence)"This means method-level test execution will always fall back to file-level execution.");
        }
    }

    private String createMethodSignature(Method method) {
        StringBuilder signature = new StringBuilder();
        signature.append(method.getName()).append("(");
        method.getArguments().forEach(arg -> signature.append(arg.getTypeRef()).append(","));
        signature.append("):");
        signature.append(method.getReturnType());
        if (method.getBlock() != null) {
            String blockContent = this.extractBlockContent(method.getBlock());
            signature.append("{").append(blockContent).append("}");
            this.getLog().debug((CharSequence)("      \ud83d\udd27 Method " + method.getName() + " block content: " + blockContent));
        } else {
            this.getLog().info((CharSequence)("      \u26a0\ufe0f  Method " + method.getName() + " has no block"));
        }
        String finalSignature = signature.toString();
        this.getLog().debug((CharSequence)("      \ud83d\udccb Signature for " + method.getName() + ": " + finalSignature));
        return finalSignature;
    }

    private String extractBlockContent(Block block) {
        if (block == null || block.getStatements() == null) {
            return "EMPTY_BLOCK";
        }
        StringBuilder content = new StringBuilder();
        block.getStatements().forEach(statement -> {
            if (statement != null) {
                content.append(statement.toString()).append(";");
            }
        });
        String result = content.toString();
        this.getLog().debug((CharSequence)("        \ud83d\udcc4 Extracted block content: " + result));
        return result;
    }

    private Set<String> extractTypeDependencies(Method method) {
        HashSet<String> dependencies = new HashSet<String>();
        if (method.getReturnType() instanceof ClassRef) {
            dependencies.add(((ClassRef)method.getReturnType()).getFullyQualifiedName());
        }
        method.getArguments().forEach(prop -> {
            if (prop.getTypeRef() instanceof ClassRef) {
                dependencies.add(((ClassRef)prop.getTypeRef()).getFullyQualifiedName());
            }
        });
        if (method.getBlock() != null && method.getBlock().getStatements() != null) {
            method.getBlock().getStatements().forEach(statement -> {
                String statementString = statement.toString();
                if (statementString.contains("new ")) {
                    this.extractConstructorDependencies(statementString, dependencies);
                }
                this.extractVariableDependencies(statementString, dependencies);
            });
        }
        return dependencies;
    }

    private Set<String> extractMethodCallDependencies(Method method) {
        HashSet<String> methodCalls = new HashSet<String>();
        this.getLog().debug((CharSequence)("    \ud83d\udd2c Analyzing method body for: " + method.getName()));
        if (method.getBlock() != null && method.getBlock().getStatements() != null) {
            this.getLog().debug((CharSequence)("      \ud83d\udcc4 Found " + method.getBlock().getStatements().size() + " statements"));
            method.getBlock().getStatements().forEach(statement -> {
                String statementString = statement.toString();
                this.getLog().debug((CharSequence)("      \ud83d\udcdd Statement: " + statementString));
                HashSet<String> statementCalls = new HashSet<String>();
                this.extractMethodCallsFromStatement(statementString, statementCalls);
                if (!statementCalls.isEmpty()) {
                    this.getLog().debug((CharSequence)("        \ud83d\udcde Found method calls: " + String.valueOf(statementCalls)));
                    methodCalls.addAll(statementCalls);
                } else {
                    this.getLog().debug((CharSequence)"        \u274c No method calls found in statement");
                }
            });
        } else {
            this.getLog().debug((CharSequence)"      \u26a0\ufe0f  No method block or statements found");
        }
        return methodCalls;
    }

    private void extractMethodCallsFromStatement(String statement, Set<String> methodCalls) {
        this.getLog().debug((CharSequence)("        \ud83d\udd0d Analyzing statement: '" + statement + "'"));
        Object[] parts = statement.split("\\.");
        this.getLog().debug((CharSequence)("        \ud83e\udde9 Split into " + parts.length + " parts: " + Arrays.toString(parts)));
        for (int i = 0; i < parts.length - 1; ++i) {
            String beforeDot = ((String)parts[i]).trim();
            String afterDot = ((String)parts[i + 1]).trim();
            this.getLog().debug((CharSequence)("          \ud83d\udd39 beforeDot: '" + beforeDot + "', afterDot: '" + afterDot + "'"));
            int parenIndex = afterDot.indexOf(40);
            if (parenIndex > 0) {
                String methodName = afterDot.substring(0, parenIndex).trim();
                this.getLog().debug((CharSequence)("          \ud83c\udfaf Found potential method call: '" + methodName + "'"));
                String objectReference = this.extractObjectReference(beforeDot);
                this.getLog().debug((CharSequence)("          \ud83d\udd27 Extracted object reference: '" + objectReference + "'"));
                String objectType = this.inferObjectType(objectReference);
                if (objectType != null) {
                    String methodCall = objectType + "." + methodName;
                    methodCalls.add(methodCall);
                    this.getLog().debug((CharSequence)("          \u2705 Added method call: " + methodCall));
                    continue;
                }
                this.getLog().debug((CharSequence)("          \u274c Could not infer object type for: '" + objectReference + "'"));
                continue;
            }
            this.getLog().debug((CharSequence)("          \u26a0\ufe0f  No parentheses found in: '" + afterDot + "'"));
        }
    }

    private String extractObjectReference(String beforeDot) {
        String[] words;
        int lastOpenParen;
        int lastSemicolon;
        String cleaned = beforeDot;
        int lastComma = cleaned.lastIndexOf(44);
        if (lastComma >= 0) {
            cleaned = cleaned.substring(lastComma + 1).trim();
        }
        if ((lastSemicolon = cleaned.lastIndexOf(59)) >= 0) {
            cleaned = cleaned.substring(lastSemicolon + 1).trim();
        }
        if ((lastOpenParen = cleaned.lastIndexOf(40)) >= 0) {
            cleaned = cleaned.substring(lastOpenParen + 1).trim();
        }
        if ((words = cleaned.split("\\s+")).length > 0) {
            String lastWord = words[words.length - 1];
            return lastWord.replaceAll("[^a-zA-Z_][^a-zA-Z0-9_]*$", "");
        }
        return cleaned;
    }

    private String inferObjectType(String objectReference) {
        this.getLog().debug((CharSequence)("            \ud83e\udd14 Inferring type for object reference: '" + objectReference + "'"));
        if (objectReference == null || objectReference.isEmpty()) {
            this.getLog().debug((CharSequence)"            \u274c Empty object reference");
            return null;
        }
        if (Character.isUpperCase(objectReference.charAt(0))) {
            this.getLog().debug((CharSequence)("            \ud83d\udcca Uppercase start - treating as class name: " + objectReference));
            String fqn = this.findFullyQualifiedName(objectReference);
            if (fqn != null) {
                this.getLog().debug((CharSequence)("            \u2705 Found FQN: " + fqn));
                return fqn;
            }
            this.getLog().debug((CharSequence)("            \u26a0\ufe0f  No FQN found, using class name as-is: " + objectReference));
            return objectReference;
        }
        String typeName = Character.toUpperCase(objectReference.charAt(0)) + objectReference.substring(1);
        this.getLog().debug((CharSequence)("            \ud83d\udd24 Lowercase start - inferring type name: " + objectReference + " -> " + typeName));
        String fqn = this.findFullyQualifiedName(typeName);
        if (fqn != null) {
            this.getLog().debug((CharSequence)("            \u2705 Found FQN for inferred type: " + fqn));
            return fqn;
        }
        this.getLog().debug((CharSequence)("            \u274c No FQN found for inferred type: " + typeName));
        return null;
    }

    private void extractConstructorDependencies(String statement, Set<String> dependencies) {
        String[] parts = statement.split("new ");
        for (int i = 1; i < parts.length; ++i) {
            String part = parts[i].trim();
            int parenIndex = part.indexOf(40);
            if (parenIndex <= 0) continue;
            String className = part.substring(0, parenIndex).trim();
            if (!className.contains(".") && !className.matches(".*[\\[\\]<>].*")) {
                String fqn = this.findFullyQualifiedName(className);
                if (fqn == null) continue;
                dependencies.add(fqn);
                continue;
            }
            if (!className.contains(".")) continue;
            dependencies.add(className);
        }
    }

    private void extractVariableDependencies(String statement, Set<String> dependencies) {
        String[] words = statement.trim().split("\\s+");
        for (int i = 0; i < words.length - 1; ++i) {
            String fqn;
            String word = words[i];
            String nextWord = words[i + 1];
            if (!Character.isUpperCase(word.charAt(0)) || !Character.isLowerCase(nextWord.charAt(0)) || !nextWord.matches("[a-zA-Z_][a-zA-Z0-9_]*") || (fqn = this.findFullyQualifiedName(word)) == null) continue;
            dependencies.add(fqn);
        }
    }

    private String findFullyQualifiedName(String className) {
        this.getLog().debug((CharSequence)("              \ud83d\udd0e Looking for FQN of: " + className));
        for (Map.Entry<String, TypeDef> entry : this.sourceTypeDefs.entrySet()) {
            TypeDef typeDef = entry.getValue();
            this.getLog().debug((CharSequence)("              \ud83d\udccb Checking source type: " + typeDef.getName()));
            if (!typeDef.getName().equals(className)) continue;
            String fqn = typeDef.getPackageName() + "." + typeDef.getName();
            this.getLog().debug((CharSequence)("              \u2705 Match found: " + className + " -> " + fqn));
            return fqn;
        }
        this.getLog().debug((CharSequence)("              \u274c No match found for: " + className));
        return null;
    }

    private Set<String> extractClassDependencies(TypeDef typeDef) {
        HashSet<String> dependencies = new HashSet<String>();
        typeDef.getExtendsList().forEach(ref -> dependencies.add(ref.getFullyQualifiedName()));
        typeDef.getImplementsList().forEach(ref -> dependencies.add(ref.getFullyQualifiedName()));
        typeDef.getProperties().forEach(prop -> {
            if (prop.getTypeRef() instanceof ClassRef) {
                dependencies.add(((ClassRef)prop.getTypeRef()).getFullyQualifiedName());
            }
        });
        return dependencies;
    }

    private String findSourceFileForType(String fullyQualifiedName) {
        for (Map.Entry<String, TypeDef> entry : this.sourceTypeDefs.entrySet()) {
            TypeDef typeDef = entry.getValue();
            String typeFullName = typeDef.getPackageName() + "." + typeDef.getName();
            if (!typeFullName.equals(fullyQualifiedName)) continue;
            return entry.getKey();
        }
        return null;
    }

    private boolean isTestFile(Path path) {
        String fileName = path.getFileName().toString();
        Object[] patterns = this.testIncludes.split(",");
        this.getLog().debug((CharSequence)("\ud83d\udd0d isTestFile - fileName: " + fileName + ", patterns: " + Arrays.toString(patterns)));
        for (Object pattern : patterns) {
            boolean matches = this.matchesPattern(fileName, ((String)pattern).trim());
            this.getLog().debug((CharSequence)("  Pattern '" + ((String)pattern).trim() + "' matches '" + fileName + "': " + matches));
            if (!matches) continue;
            return true;
        }
        return false;
    }

    private boolean matchesPattern(String fileName, String pattern) {
        this.getLog().debug((CharSequence)("    matchesPattern - fileName: '" + fileName + "', pattern: '" + pattern + "'"));
        String regex = pattern;
        if (regex.startsWith("**/")) {
            regex = regex.substring(3);
            this.getLog().debug((CharSequence)("    Removed **/ prefix, remaining: '" + regex + "'"));
        }
        regex = regex.replace(".", "\\.");
        regex = regex.replace("(", "\\(");
        regex = regex.replace(")", "\\)");
        regex = regex.replace("[", "\\[");
        regex = regex.replace("]", "\\]");
        regex = regex.replace("{", "\\{");
        regex = regex.replace("}", "\\}");
        regex = regex.replace("+", "\\+");
        regex = regex.replace("^", "\\^");
        regex = regex.replace("$", "\\$");
        regex = regex.replace("*", ".*");
        regex = regex.replace("?", ".");
        this.getLog().debug((CharSequence)("    Final regex: '" + regex + "'"));
        boolean result = fileName.matches(regex);
        this.getLog().debug((CharSequence)("    matches result: " + result));
        return result;
    }

    private String extractClassName(String filePath) {
        String fileName = new File(filePath).getName();
        return fileName.substring(0, fileName.lastIndexOf(".java"));
    }

    private void startSmartFileWatching() throws IOException, InterruptedException {
        this.getLog().info((CharSequence)"Starting smart file watcher with impact analysis...");
        this.getLog().info((CharSequence)"Press Ctrl+C to stop watching...");
        try {
            this.sourceProject.allSources().watch(changeSet -> {
                try {
                    this.handleChangeSetWithImpactAnalysis((ChangeSet)changeSet);
                }
                catch (Exception e) {
                    this.getLog().error((CharSequence)"Error handling change set", (Throwable)e);
                }
            }).get();
        }
        catch (ExecutionException e) {
            throw new RuntimeException("Error during file watching", e.getCause());
        }
    }

    private void handleChangeSetWithImpactAnalysis(ChangeSet changeSet) throws MavenInvocationException {
        ImpactAnalysisResult impact;
        this.getLog().info((CharSequence)"\ud83d\ude80 Processing change set with impact analysis...");
        this.lastChangeSet = changeSet;
        this.reportFileChanges(changeSet);
        this.lastImpactAnalysis = impact = this.impactAnalyzer.analyze(changeSet);
        this.getLog().info((CharSequence)impact.getSummary());
        if (!impact.hasAnyImpact()) {
            this.getLog().info((CharSequence)"No impact detected, skipping test execution");
            return;
        }
        Set<String> affectedTestMethods = this.findTestMethodsAffectedByImpact(impact);
        if (!affectedTestMethods.isEmpty()) {
            this.reportAffectedTestMethods(affectedTestMethods);
            this.runSpecificTestMethods(affectedTestMethods);
        } else {
            this.getLog().info((CharSequence)"\ud83d\udca1 No method-level dependencies found, falling back to file-level test execution");
            Set<String> testsToRun = this.findTestsAffectedByImpact(impact);
            if (!testsToRun.isEmpty()) {
                this.reportAffectedTestFiles(testsToRun);
                this.runSpecificTests(testsToRun);
            } else {
                this.getLog().info((CharSequence)"\u274c No tests affected by changes");
            }
        }
    }

    private void reportFileChanges(ChangeSet changeSet) {
        this.getLog().info((CharSequence)"\ud83d\udcc1 Changes detected:");
        if (changeSet.getOldTypeDef() == null && changeSet.getNewTypeDef() != null) {
            this.getLog().info((CharSequence)("  \u2795 Created: " + changeSet.getNewTypeDef().getFullyQualifiedName()));
        } else if (changeSet.getOldTypeDef() != null && changeSet.getNewTypeDef() == null) {
            this.getLog().info((CharSequence)("  \u274c Deleted: " + changeSet.getOldTypeDef().getFullyQualifiedName()));
        } else if (changeSet.hasChanges()) {
            this.getLog().info((CharSequence)("  \u270f\ufe0f  Modified: " + changeSet.getNewTypeDef().getFullyQualifiedName()));
            if (!changeSet.getMethodChanges().isEmpty()) {
                this.getLog().info((CharSequence)("    \ud83d\udccb Method changes: " + changeSet.getMethodChanges().size()));
            }
            if (!changeSet.getPropertyChanges().isEmpty()) {
                this.getLog().info((CharSequence)("    \ud83c\udff7\ufe0f  Property changes: " + changeSet.getPropertyChanges().size()));
            }
        }
    }

    private void reportAffectedTestMethods(Set<String> affectedTestMethods) {
        this.getLog().info((CharSequence)("\ud83c\udfaf Found " + affectedTestMethods.size() + " affected test methods:"));
        for (String testMethod : affectedTestMethods) {
            this.getLog().info((CharSequence)("  \ud83e\uddea " + testMethod));
        }
    }

    private void reportAffectedTestFiles(Set<String> affectedTestFiles) {
        this.getLog().info((CharSequence)("\ud83d\udcc2 Found " + affectedTestFiles.size() + " affected test files:"));
        for (String testFile : affectedTestFiles) {
            this.getLog().info((CharSequence)("  \ud83d\udcc4 " + testFile));
        }
    }

    private Set<String> findTestMethodsAffectedByImpact(ImpactAnalysisResult impact) {
        HashSet<String> affectedTestMethods = new HashSet<String>();
        Set affectedMethodRefs = impact.getAffectedMethodReferences();
        for (MethodReference methodRef : affectedMethodRefs) {
            String methodKey = methodRef.getOwningType().getFullyQualifiedName() + "." + methodRef.getMethod().getName();
            Set<String> dependentTests = this.sourceMethodToTestMethods.get(methodKey);
            if (dependentTests == null) continue;
            affectedTestMethods.addAll(dependentTests);
        }
        return affectedTestMethods;
    }

    private Set<String> findTestsAffectedByImpact(ImpactAnalysisResult impact) {
        HashSet<String> affectedTests = new HashSet<String>();
        for (Path affectedFile : impact.getAffectedFiles()) {
            String filePath = affectedFile.toString();
            for (Map.Entry<String, Set<String>> entry : this.testToSourceMapping.entrySet()) {
                if (!entry.getValue().contains(filePath)) continue;
                affectedTests.add(entry.getKey());
            }
        }
        for (TypeDef affectedType : impact.getAffectedTypeDefs()) {
            String typeFQN = affectedType.getFullyQualifiedName();
            this.sourceProject.sources().find(typeFQN).ifPresent(sourcePath -> {
                String sourceFile = sourcePath.toString();
                for (Map.Entry<String, Set<String>> entry : this.testToSourceMapping.entrySet()) {
                    if (!entry.getValue().contains(sourceFile)) continue;
                    affectedTests.add(entry.getKey());
                }
            });
        }
        return affectedTests;
    }

    private void startFileWatching() throws IOException, InterruptedException {
        this.getLog().info((CharSequence)"Starting file watcher...");
        WatchService watchService = FileSystems.getDefault().newWatchService();
        this.registerDirectoryRecursively(this.sourceDirectory.toPath(), watchService);
        this.registerDirectoryRecursively(this.testSourceDirectory.toPath(), watchService);
        this.getLog().info((CharSequence)"File watcher started. Press Ctrl+C to stop.");
        while (this.running.get()) {
            WatchKey key = watchService.take();
            for (WatchEvent<?> event : key.pollEvents()) {
                WatchEvent.Kind<?> kind = event.kind();
                if (kind == StandardWatchEventKinds.OVERFLOW) continue;
                WatchEvent<?> ev = event;
                Path filename = (Path)ev.context();
                Path dir = (Path)key.watchable();
                Path fullPath = dir.resolve(filename);
                if (!fullPath.toString().endsWith(".java")) continue;
                this.enqueueFileChangeEvent(fullPath, kind);
            }
            boolean valid = key.reset();
            if (valid) continue;
            break;
        }
    }

    private void registerDirectoryRecursively(Path path, WatchService watchService) throws IOException {
        if (!Files.exists(path, new LinkOption[0])) {
            return;
        }
        Files.walk(path, new FileVisitOption[0]).filter(x$0 -> Files.isDirectory(x$0, new LinkOption[0])).forEach(dir -> {
            try {
                dir.register(watchService, StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_DELETE, StandardWatchEventKinds.ENTRY_MODIFY);
            }
            catch (IOException e) {
                this.getLog().warn((CharSequence)("Failed to register directory for watching: " + String.valueOf(dir)), (Throwable)e);
            }
        });
    }

    private void enqueueFileChangeEvent(Path filePath, WatchEvent.Kind<?> kind) {
        String fileKey = filePath.toString();
        FileChangeEvent event = new FileChangeEvent(filePath, kind);
        this.pendingFileEvents.computeIfAbsent(fileKey, k -> new ConcurrentLinkedQueue()).offer(event);
        this.getLog().debug((CharSequence)("\ud83d\udcdd Enqueued " + String.valueOf(kind) + " event for: " + String.valueOf(filePath)));
        this.debounceExecutor.schedule(() -> this.processFileChangeEvents(fileKey), 500L, TimeUnit.MILLISECONDS);
    }

    private void processFileChangeEvents(String fileKey) {
        ConcurrentLinkedQueue<FileChangeEvent> events = this.pendingFileEvents.remove(fileKey);
        if (events == null || events.isEmpty()) {
            return;
        }
        try {
            ArrayList<FileChangeEvent> eventList = new ArrayList<FileChangeEvent>(events);
            eventList.sort((e1, e2) -> Long.compare(e1.timestamp, e2.timestamp));
            this.getLog().info((CharSequence)("\ud83d\udd04 Processing " + eventList.size() + " debounced event(s) for: " + fileKey));
            EffectiveChange effectiveChange = this.analyzeEventSequence(eventList);
            this.getLog().info((CharSequence)("\ud83d\udcca Effective change: " + String.valueOf((Object)effectiveChange.type) + " for " + String.valueOf(effectiveChange.filePath)));
            this.handleEffectiveFileChange(effectiveChange);
        }
        catch (Exception e) {
            this.getLog().error((CharSequence)("Error processing file change events for: " + fileKey), (Throwable)e);
        }
    }

    private EffectiveChange analyzeEventSequence(List<FileChangeEvent> events) {
        ChangeType effectiveType;
        Path filePath = events.get((int)0).filePath;
        boolean hasDelete = events.stream().anyMatch(e -> e.kind == StandardWatchEventKinds.ENTRY_DELETE);
        boolean hasCreate = events.stream().anyMatch(e -> e.kind == StandardWatchEventKinds.ENTRY_CREATE);
        boolean hasModify = events.stream().anyMatch(e -> e.kind == StandardWatchEventKinds.ENTRY_MODIFY);
        if (hasDelete && hasCreate) {
            effectiveType = ChangeType.REPLACE;
            this.getLog().info((CharSequence)("\ud83d\udd04 Detected file replacement (delete\u2192create) for: " + String.valueOf(filePath)));
        } else if (hasDelete) {
            effectiveType = ChangeType.DELETE;
            this.getLog().info((CharSequence)("\ud83d\uddd1\ufe0f Detected file deletion for: " + String.valueOf(filePath)));
        } else if (hasCreate) {
            effectiveType = ChangeType.CREATE;
            this.getLog().info((CharSequence)("\u2795 Detected file creation for: " + String.valueOf(filePath)));
        } else if (hasModify) {
            effectiveType = ChangeType.MODIFY;
            this.getLog().info((CharSequence)("\u270f\ufe0f Detected file modification for: " + String.valueOf(filePath)));
        } else {
            effectiveType = ChangeType.MODIFY;
        }
        return new EffectiveChange(filePath, effectiveType);
    }

    private void handleEffectiveFileChange(EffectiveChange change) throws MavenInvocationException {
        if (this.isSourceFile(change.filePath)) {
            this.handleEffectiveSourceFileChange(change);
        } else if (this.isTestFile(change.filePath)) {
            this.handleEffectiveTestFileChange(change);
        }
    }

    private void handleEffectiveSourceFileChange(EffectiveChange change) throws MavenInvocationException {
        String filePath = change.filePath.toString();
        switch (change.type) {
            case DELETE: {
                this.getLog().info((CharSequence)("\ud83d\uddd1\ufe0f Source file deleted: " + filePath));
                this.handleSourceFileDeleted(filePath);
                break;
            }
            case CREATE: {
                this.getLog().info((CharSequence)("\u2795 New source file created: " + filePath));
                this.handleSourceFileCreated(filePath);
                break;
            }
            case REPLACE: 
            case MODIFY: {
                this.getLog().info((CharSequence)("\ud83d\udd04 Source file changed: " + filePath));
                this.handleSourceFileModified(filePath);
            }
        }
    }

    private void handleEffectiveTestFileChange(EffectiveChange change) throws MavenInvocationException {
        Set<String> changedTest = Set.of(change.filePath.toString());
        this.runSpecificTests(changedTest);
        if (change.type == ChangeType.MODIFY || change.type == ChangeType.REPLACE) {
            this.reanalyzeTestFile(change.filePath);
        }
    }

    private boolean isSourceFile(Path path) {
        return path.startsWith(this.sourceDirectory.toPath()) && path.toString().endsWith(".java");
    }

    private void handleSourceFileChange(Path changedFile, WatchEvent.Kind<?> kind) throws MavenInvocationException {
        String changedFilePath = changedFile.toString();
        this.getLog().info((CharSequence)("\ud83d\udd0d Analyzing method-level changes in: " + String.valueOf(changedFile) + " (event: " + String.valueOf(kind) + ")"));
        if (kind == StandardWatchEventKinds.ENTRY_DELETE) {
            this.getLog().info((CharSequence)"\ud83d\uddd1\ufe0f File deleted, marking all methods as changed");
            this.handleFileDeleted(changedFilePath);
            return;
        }
        Set<String> changedMethods = this.detectChangedMethods(changedFilePath);
        if (!changedMethods.isEmpty()) {
            this.getLog().info((CharSequence)("\ud83c\udfaf Changed methods: " + String.valueOf(changedMethods)));
            HashSet<String> affectedTestMethods = new HashSet<String>();
            for (String changedMethod : changedMethods) {
                Set<String> dependentTests = this.sourceMethodToTestMethods.get(changedMethod);
                if (dependentTests == null) continue;
                affectedTestMethods.addAll(dependentTests);
            }
            if (!affectedTestMethods.isEmpty()) {
                this.getLog().info((CharSequence)("\u26a1 Method-level change affects " + affectedTestMethods.size() + " test method(s): " + String.valueOf(affectedTestMethods)));
                this.runSpecificTestMethods(affectedTestMethods);
            } else {
                this.getLog().info((CharSequence)"\ud83d\udca1 Changed methods have no direct test dependencies, falling back to file-level detection");
                this.handleSourceFileChangeFallback(changedFilePath);
            }
        } else {
            this.getLog().info((CharSequence)"\ud83d\udd04 No method changes detected, running file-level analysis");
            this.handleSourceFileChangeFallback(changedFilePath);
        }
    }

    private void handleSourceFileChangeFallback(String changedFilePath) throws MavenInvocationException {
        HashSet<String> affectedTests = new HashSet<String>();
        for (Map.Entry<String, Set<String>> entry : this.testToSourceMapping.entrySet()) {
            if (!entry.getValue().contains(changedFilePath)) continue;
            affectedTests.add(entry.getKey());
        }
        if (!affectedTests.isEmpty()) {
            this.getLog().info((CharSequence)("\ud83d\udcc2 Source file change affects " + affectedTests.size() + " test file(s)"));
            this.runSpecificTests(affectedTests);
        } else {
            this.getLog().info((CharSequence)("\u274c No tests affected by source file change: " + changedFilePath));
        }
    }

    private void handleSourceFileDeleted(String filePath) throws MavenInvocationException {
        this.handleFileDeleted(filePath);
    }

    private void handleSourceFileCreated(String filePath) throws MavenInvocationException {
        this.getLog().info((CharSequence)("\ud83c\udd95 Analyzing new source file: " + filePath));
        try {
            this.analyzeSourceFiles();
            this.mapTestDependencies();
            this.createMethodSnapshots();
            this.runAllTests();
        }
        catch (Exception e) {
            this.getLog().warn((CharSequence)("Failed to analyze new source file: " + filePath), (Throwable)e);
            this.handleSourceFileChangeFallback(filePath);
        }
    }

    private void handleSourceFileModified(String filePath) throws MavenInvocationException {
        this.getLog().info((CharSequence)("\ud83d\udd27 DETAILED ANALYSIS: Source file modified: " + filePath));
        Set<String> changedMethods = this.detectChangedMethods(filePath);
        this.getLog().info((CharSequence)("\ud83d\udd0d STEP 1: Detected " + changedMethods.size() + " changed methods: " + String.valueOf(changedMethods)));
        if (!changedMethods.isEmpty()) {
            HashSet<String> affectedTestMethods = new HashSet<String>();
            this.getLog().info((CharSequence)"\ud83d\udd0d STEP 2: Looking up test dependencies for each changed method...");
            for (String changedMethod : changedMethods) {
                Set<String> dependentTests = this.sourceMethodToTestMethods.get(changedMethod);
                this.getLog().info((CharSequence)("  \ud83d\udccb Method '" + changedMethod + "' -> " + (String)(dependentTests != null ? dependentTests.size() + " test method(s): " + String.valueOf(dependentTests) : "No Dependencies")));
                if (dependentTests == null) continue;
                affectedTestMethods.addAll(dependentTests);
            }
            this.getLog().info((CharSequence)("\ud83d\udd0d STEP 3: Total affected test methods: " + affectedTestMethods.size()));
            if (!affectedTestMethods.isEmpty()) {
                this.getLog().info((CharSequence)("  \u2705 Will run specific test methods: " + String.valueOf(affectedTestMethods)));
                this.runSpecificTestMethods(affectedTestMethods);
            } else {
                this.getLog().info((CharSequence)"  \u274c No method-level dependencies found!");
                this.getLog().info((CharSequence)"\ud83d\udd0d STEP 4: Checking available method mappings (showing first 10):");
                this.sourceMethodToTestMethods.entrySet().stream().limit(10L).forEach(entry -> this.getLog().info((CharSequence)("    " + (String)entry.getKey() + " -> " + String.valueOf(entry.getValue()))));
                this.getLog().info((CharSequence)"\ud83d\udca1 Falling back to file-level detection");
                this.handleSourceFileChangeFallback(filePath);
            }
        } else {
            this.getLog().info((CharSequence)"\ud83d\udd04 No method changes detected, running file-level analysis");
            this.handleSourceFileChangeFallback(filePath);
        }
    }

    private void handleFileDeleted(String deletedFilePath) throws MavenInvocationException {
        Map<String, String> deletedSnapshots = this.sourceFileMethodSnapshots.get(deletedFilePath);
        if (deletedSnapshots != null) {
            TypeDef deletedTypeDef = this.sourceTypeDefs.get(deletedFilePath);
            if (deletedTypeDef != null) {
                String className = deletedTypeDef.getPackageName() + "." + deletedTypeDef.getName();
                HashSet<String> affectedTestMethods = new HashSet<String>();
                for (String methodName : deletedSnapshots.keySet()) {
                    String methodKey = className + "." + methodName;
                    Set<String> dependentTests = this.sourceMethodToTestMethods.get(methodKey);
                    if (dependentTests == null) continue;
                    affectedTestMethods.addAll(dependentTests);
                }
                if (!affectedTestMethods.isEmpty()) {
                    this.getLog().info((CharSequence)("\ud83d\udd25 File deletion affects " + affectedTestMethods.size() + " test method(s): " + String.valueOf(affectedTestMethods)));
                    this.runSpecificTestMethods(affectedTestMethods);
                } else {
                    this.handleSourceFileChangeFallback(deletedFilePath);
                }
            }
        } else {
            this.handleSourceFileChangeFallback(deletedFilePath);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Set<String> detectChangedMethods(String changedFilePath) {
        HashSet<String> changedMethods = new HashSet<String>();
        File file = new File(changedFilePath);
        if (!file.exists()) {
            this.getLog().info((CharSequence)("\ud83d\udced File does not exist (yet): " + changedFilePath + ", skipping method change detection"));
            return changedMethods;
        }
        try {
            AdapterContext context = AdapterContext.create((DefinitionRepository)DefinitionRepository.getRepository());
            try (FileInputStream fis = new FileInputStream(file);){
                TypeDef newTypeDef = Sources.readTypeDefFromStream((InputStream)fis, (AdapterContext)context);
                DefinitionRepository.getRepository().registerIfAbsent(newTypeDef);
                Map<String, String> oldSnapshots = this.sourceFileMethodSnapshots.get(changedFilePath);
                if (oldSnapshots == null) {
                    this.getLog().warn((CharSequence)("\u26a0\ufe0f  No previous snapshots found for " + changedFilePath));
                    HashSet<String> hashSet = changedMethods;
                    return hashSet;
                }
                String className = newTypeDef.getPackageName() + "." + newTypeDef.getName();
                for (Method method : newTypeDef.getMethods()) {
                    String methodName = method.getName();
                    String newSignature = this.createMethodSignature(method);
                    String oldSignature = oldSnapshots.get(methodName);
                    this.getLog().info((CharSequence)("\ud83d\udd0d Comparing method: " + methodName));
                    this.getLog().info((CharSequence)("  \ud83d\udcdd New signature: " + newSignature));
                    this.getLog().info((CharSequence)("  \ud83d\udcdc Old signature: " + oldSignature));
                    if (oldSignature == null) {
                        this.getLog().info((CharSequence)("\u2795 New method detected: " + className + "." + methodName));
                        changedMethods.add(className + "." + methodName);
                    } else if (!newSignature.equals(oldSignature)) {
                        this.getLog().info((CharSequence)("\ud83d\udd04 Method changed: " + className + "." + methodName));
                        this.getLog().info((CharSequence)"  \ud83c\udd9a Signatures differ:");
                        this.getLog().info((CharSequence)("    Old: " + oldSignature));
                        this.getLog().info((CharSequence)("    New: " + newSignature));
                        changedMethods.add(className + "." + methodName);
                    } else {
                        this.getLog().info((CharSequence)("\u2705 Method unchanged: " + className + "." + methodName));
                    }
                    oldSnapshots.put(methodName, newSignature);
                }
                Set currentMethods = newTypeDef.getMethods().stream().map(Method::getName).collect(Collectors.toSet());
                for (String oldMethod : new HashSet<String>(oldSnapshots.keySet())) {
                    if (currentMethods.contains(oldMethod)) continue;
                    this.getLog().info((CharSequence)("\u2796 Method deleted: " + className + "." + oldMethod));
                    changedMethods.add(className + "." + oldMethod);
                    oldSnapshots.remove(oldMethod);
                }
                this.sourceTypeDefs.put(changedFilePath, newTypeDef);
                return changedMethods;
            }
        }
        catch (Exception e) {
            this.getLog().warn((CharSequence)("Failed to detect method changes in: " + changedFilePath), (Throwable)e);
        }
        return changedMethods;
    }

    private void runSpecificTestMethods(Set<String> testMethods) throws MavenInvocationException {
        if (testMethods.isEmpty()) {
            return;
        }
        this.runningSpecificMethods = true;
        this.requestedTestMethods.clear();
        this.requestedTestMethods.addAll(testMethods);
        HashMap<String, Set> testFileToMethods = new HashMap<String, Set>();
        for (String string : testMethods) {
            String[] stringArray = string.split("\\.");
            if (stringArray.length < 2) continue;
            String methodName = stringArray[stringArray.length - 1];
            String testFile = string.substring(0, string.lastIndexOf("."));
            testFileToMethods.computeIfAbsent(testFile, k -> new HashSet()).add(methodName);
        }
        this.getLog().info((CharSequence)"\ud83c\udfaf Running specific test methods:");
        ArrayList<CallSite> testSpecs = new ArrayList<CallSite>();
        for (Map.Entry entry : testFileToMethods.entrySet()) {
            String testClassFQN = (String)entry.getKey();
            Set methods = (Set)entry.getValue();
            String testClassName = testClassFQN.substring(testClassFQN.lastIndexOf(46) + 1);
            this.getLog().info((CharSequence)("  \ud83d\udccb " + testClassName + ": " + String.valueOf(methods)));
            for (String methodName : methods) {
                testSpecs.add((CallSite)((Object)(testClassName + "#" + methodName)));
            }
        }
        if (!testSpecs.isEmpty()) {
            String string = String.join((CharSequence)",", testSpecs);
            this.getLog().info((CharSequence)("Running test methods: " + string));
            this.resetTestCounters();
            this.runMavenGoal(this.testGoal, "-Dtest=" + string);
        }
    }

    private void reanalyzeTestFile(Path testFile) {
        try {
            AdapterContext context = AdapterContext.create((DefinitionRepository)DefinitionRepository.getRepository());
            try (FileInputStream fis = new FileInputStream(testFile.toFile());){
                TypeDef typeDef = Sources.readTypeDefFromStream((InputStream)fis, (AdapterContext)context);
                this.testTypeDefs.put(testFile.toString(), typeDef);
                DefinitionRepository.getRepository().registerIfAbsent(typeDef);
                this.remapTestDependencies(testFile.toString(), typeDef);
                this.getLog().debug((CharSequence)("Re-analyzed test file: " + String.valueOf(testFile)));
            }
        }
        catch (Exception e) {
            this.getLog().warn((CharSequence)("Failed to re-analyze test file: " + String.valueOf(testFile)), (Throwable)e);
        }
    }

    private void remapTestDependencies(String testFile, TypeDef testTypeDef) {
        HashSet<String> referencedSources = new HashSet<String>();
        for (Method method : testTypeDef.getMethods()) {
            Set<String> methodDependencies = this.extractTypeDependencies(method);
            for (String dependency : methodDependencies) {
                String sourceFile = this.findSourceFileForType(dependency);
                if (sourceFile == null) continue;
                referencedSources.add(sourceFile);
            }
        }
        Set<String> classDependencies = this.extractClassDependencies(testTypeDef);
        for (String dependency : classDependencies) {
            String sourceFile = this.findSourceFileForType(dependency);
            if (sourceFile == null) continue;
            referencedSources.add(sourceFile);
        }
        if (!referencedSources.isEmpty()) {
            this.testToSourceMapping.put(testFile, referencedSources);
        } else {
            this.testToSourceMapping.remove(testFile);
        }
    }

    private void resetTestCounters() {
        this.totalTests.set(0);
        this.passedTests.set(0);
        this.failedTests.set(0);
        this.errorTests.set(0);
        this.skippedTests.set(0);
        this.currentRunTestCases.clear();
    }

    private void parseTestResults(String testResultLine) {
        try {
            int testsRun = this.extractNumber(testResultLine, "Tests run:");
            int failures = this.extractNumber(testResultLine, "Failures:");
            int errors = this.extractNumber(testResultLine, "Errors:");
            int skipped = this.extractNumber(testResultLine, "Skipped:");
            this.totalTests.addAndGet(testsRun);
            this.failedTests.addAndGet(failures);
            this.errorTests.addAndGet(errors);
            this.skippedTests.addAndGet(skipped);
            this.passedTests.addAndGet(testsRun - failures - errors - skipped);
            this.updateSessionTestResult(testResultLine, testsRun, failures, errors, skipped);
        }
        catch (Exception e) {
            this.getLog().debug((CharSequence)("Failed to parse test results: " + testResultLine), (Throwable)e);
        }
    }

    private int extractNumber(String line, String prefix) {
        int startIndex = line.indexOf(prefix);
        if (startIndex == -1) {
            return 0;
        }
        int endIndex = line.indexOf(44, startIndex += prefix.length());
        if (endIndex == -1) {
            endIndex = line.indexOf(32, startIndex);
        }
        if (endIndex == -1) {
            return 0;
        }
        String numberStr = line.substring(startIndex, endIndex).trim();
        return Integer.parseInt(numberStr);
    }

    private void updateSessionTestResult(String testResultLine, int testsRun, int failures, int errors, int skipped) {
        String testClassName = null;
        int inIndex = testResultLine.lastIndexOf(" -- in ");
        if (inIndex > 0) {
            testClassName = testResultLine.substring(inIndex + 7).trim();
        }
        if (testClassName != null) {
            int passed = testsRun - failures - errors - skipped;
            TestClassResult newResult = new TestClassResult(testsRun, passed, failures, errors, skipped);
            this.sessionTestResults.put(testClassName, newResult);
            this.recalculateSessionTotals();
        }
    }

    private void recalculateSessionTotals() {
        int total = 0;
        int passed = 0;
        int failed = 0;
        int errors = 0;
        int skipped = 0;
        for (TestClassResult result : this.sessionTestResults.values()) {
            total += result.total;
            passed += result.passed;
            failed += result.failed;
            errors += result.errors;
            skipped += result.skipped;
        }
        this.sessionTotalTests.set(total);
        this.sessionPassedTests.set(passed);
        this.sessionFailedTests.set(failed);
        this.sessionErrorTests.set(errors);
        this.sessionSkippedTests.set(skipped);
    }

    private void parseIndividualTestResults(String mavenOutput) {
        if (mavenOutput == null || mavenOutput.trim().isEmpty()) {
            return;
        }
        String[] lines = mavenOutput.split("\n");
        String currentTestClass = null;
        for (String line : lines) {
            String trimmedLine = line.trim();
            if (trimmedLine.contains("Running ") && trimmedLine.contains("Test")) {
                String[] parts = trimmedLine.split("Running ");
                if (parts.length <= 1) continue;
                currentTestClass = parts[1].trim();
                this.getLog().debug((CharSequence)("Found test class: " + currentTestClass));
                continue;
            }
            if (currentTestClass == null || !trimmedLine.contains("Tests run:") || !trimmedLine.contains("Time elapsed:")) continue;
            this.parseTestClassResult(trimmedLine, currentTestClass);
            currentTestClass = null;
        }
    }

    private void parseTestClassResult(String testResultLine, String testClass) {
        try {
            String testKey;
            String methodName;
            List<String> testMethodsToUpdate;
            int testsRun = this.extractNumber(testResultLine, "Tests run:");
            int failures = this.extractNumber(testResultLine, "Failures:");
            int errors = this.extractNumber(testResultLine, "Errors:");
            int skipped = this.extractNumber(testResultLine, "Skipped:");
            this.getLog().debug((CharSequence)("Parsing class " + testClass + ": " + testsRun + " tests, " + failures + " failures, " + errors + " errors, " + skipped + " skipped"));
            if (this.runningSpecificMethods) {
                testMethodsToUpdate = this.requestedTestMethods.stream().filter(methodKey -> methodKey.startsWith(testClass + ".")).map(methodKey -> methodKey.substring(methodKey.lastIndexOf(46) + 1)).collect(Collectors.toList());
                this.getLog().debug((CharSequence)("Running specific methods for " + testClass + ": " + String.valueOf(testMethodsToUpdate)));
                if (testMethodsToUpdate.isEmpty()) {
                    this.getLog().debug((CharSequence)("No requested methods found for class: " + testClass));
                    return;
                }
            } else {
                testMethodsToUpdate = this.getTestMethodsForClass(testClass);
                if (testMethodsToUpdate.isEmpty()) {
                    this.getLog().debug((CharSequence)("No test methods found for class: " + testClass));
                    return;
                }
            }
            if (failures == 0 && errors == 0) {
                for (String methodName2 : testMethodsToUpdate) {
                    String testKey2 = testClass + "#" + methodName2;
                    this.currentRunTestCases.put(testKey2, new TestCaseResult(testClass, methodName2, TestStatus.PASSED, null));
                    this.getLog().debug((CharSequence)("Recorded passed test case: " + testKey2));
                }
            } else {
                int failureCount = failures + errors;
                for (int i = 0; i < testMethodsToUpdate.size(); ++i) {
                    methodName = testMethodsToUpdate.get(i);
                    testKey = testClass + "#" + methodName;
                    TestStatus status = i < failureCount ? TestStatus.FAILED : TestStatus.PASSED;
                    String errorMsg = status == TestStatus.FAILED ? "Test failed (details in Maven output)" : null;
                    this.currentRunTestCases.put(testKey, new TestCaseResult(testClass, methodName, status, errorMsg));
                    this.getLog().debug((CharSequence)("Recorded test case: " + testKey + " -> " + String.valueOf((Object)status)));
                }
            }
            if (skipped > 0) {
                ArrayList<String> methodsCopy = new ArrayList<String>(testMethodsToUpdate);
                for (int i = Math.max(0, methodsCopy.size() - skipped); i < methodsCopy.size(); ++i) {
                    methodName = (String)methodsCopy.get(i);
                    testKey = testClass + "#" + methodName;
                    this.currentRunTestCases.put(testKey, new TestCaseResult(testClass, methodName, TestStatus.SKIPPED, null));
                    this.getLog().debug((CharSequence)("Recorded skipped test case: " + testKey));
                }
            }
        }
        catch (Exception e) {
            this.getLog().warn((CharSequence)("Failed to parse test class result: " + testResultLine), (Throwable)e);
        }
    }

    private List<String> getTestMethodsForClass(String testClassName) {
        for (Map.Entry<String, TypeDef> entry : this.testTypeDefs.entrySet()) {
            TypeDef typeDef = entry.getValue();
            String fqn = typeDef.getPackageName() + "." + typeDef.getName();
            if (!fqn.equals(testClassName)) continue;
            return typeDef.getMethods().stream().filter(method -> this.isTestMethod((Method)method)).map(method -> method.getName()).collect(Collectors.toList());
        }
        String simpleClassName = testClassName.substring(testClassName.lastIndexOf(46) + 1);
        for (Map.Entry<String, TypeDef> entry : this.testTypeDefs.entrySet()) {
            TypeDef typeDef = entry.getValue();
            if (!typeDef.getName().equals(simpleClassName)) continue;
            return typeDef.getMethods().stream().filter(method -> this.isTestMethod((Method)method)).map(method -> method.getName()).collect(Collectors.toList());
        }
        this.getLog().debug((CharSequence)("Could not find test methods for class: " + testClassName));
        return new ArrayList<String>();
    }

    private void initializeTestCaseData() {
        for (Map.Entry<String, TypeDef> entry : this.testTypeDefs.entrySet()) {
            TypeDef typeDef = entry.getValue();
            String testClassName = typeDef.getPackageName() + "." + typeDef.getName();
            List testMethods = typeDef.getMethods().stream().filter(method -> method.getAnnotations().stream().anyMatch(ann -> ann.getClassRef().getName().equals("Test"))).map(method -> method.getName()).collect(Collectors.toList());
            for (String methodName : testMethods) {
                String testKey = testClassName + "#" + methodName;
                this.sessionTestCases.put(testKey, new TestCaseResult(testClassName, methodName, TestStatus.PENDING, null));
                this.getLog().debug((CharSequence)("Initialized test case: " + testKey));
            }
        }
        this.getLog().info((CharSequence)("Initialized " + this.sessionTestCases.size() + " test methods"));
    }

    private boolean isTestMethod(Method method) {
        boolean hasTestAnnotation = method.getAnnotations().stream().anyMatch(ann -> {
            String annotationName = ann.getClassRef().getName();
            return "Test".equals(annotationName) || annotationName.endsWith(".Test");
        });
        if (hasTestAnnotation) {
            return true;
        }
        if (method.getName().startsWith("test") && method.getReturnType().toString().equals("void") && method.getModifiers().isPublic() && method.getArguments().isEmpty()) {
            return true;
        }
        boolean hasOtherTestAnnotations = method.getAnnotations().stream().anyMatch(ann -> {
            String annotationName = ann.getClassRef().getName();
            return annotationName.contains("Test") || "BeforeEach".equals(annotationName) || "AfterEach".equals(annotationName) || "ParameterizedTest".equals(annotationName) || annotationName.endsWith(".ParameterizedTest");
        });
        return hasOtherTestAnnotations;
    }

    private void updateSessionTestCases() {
        for (TestCaseResult testCase : this.currentRunTestCases.values()) {
            this.sessionTestCases.put(testCase.getFullName(), testCase);
        }
    }

    private void showDependencyTree() {
        if (this.termFrame == null) {
            return;
        }
        try {
            this.termFrame.saveState();
            this.termFrame.clearContent();
            if (this.lastChangeSet == null || this.lastImpactAnalysis == null) {
                this.termFrame.println("\ud83d\udd0d No recent changes to analyze. Make a change to see the dependency tree.");
                this.termFrame.println("");
                this.termFrame.println("Press any key to return to continuous testing...");
                return;
            }
            this.termFrame.println("\ud83c\udf33 Dependency Tree - From Last Changes to Affected Tests");
            this.termFrame.println("");
            this.termFrame.println("\n\ud83d\udcc1 Changes Types:");
            if (this.lastChangeSet.getOldTypeDef() == null && this.lastChangeSet.getNewTypeDef() != null) {
                this.termFrame.println("  \u2795 Created: " + this.lastChangeSet.getNewTypeDef().getFullyQualifiedName());
            } else if (this.lastChangeSet.getOldTypeDef() != null && this.lastChangeSet.getNewTypeDef() == null) {
                this.termFrame.println("  \u274c Deleted: " + this.lastChangeSet.getOldTypeDef().getFullyQualifiedName());
            } else if (this.lastChangeSet.hasChanges()) {
                String connector;
                int i;
                this.termFrame.println("  \u270f\ufe0f  Modified: " + this.lastChangeSet.getNewTypeDef().getFullyQualifiedName());
                if (!this.lastChangeSet.getMethodChanges().isEmpty()) {
                    this.termFrame.println("    \ud83d\udccb Method changes: " + this.lastChangeSet.getMethodChanges().size());
                    Object[] methodChanges = this.lastChangeSet.getMethodChanges().toArray();
                    for (i = 0; i < methodChanges.length; ++i) {
                        Object methodChange = methodChanges[i];
                        connector = i == methodChanges.length - 1 ? "\u2514\u2500" : "\u251c\u2500";
                        String changeDesc = this.formatMethodChange(methodChange);
                        this.termFrame.println("      " + connector + " " + changeDesc);
                    }
                }
                if (!this.lastChangeSet.getPropertyChanges().isEmpty()) {
                    this.termFrame.println("    \ud83c\udff7\ufe0f  Property changes: " + this.lastChangeSet.getPropertyChanges().size());
                    Object[] propertyChanges = this.lastChangeSet.getPropertyChanges().toArray();
                    for (i = 0; i < propertyChanges.length; ++i) {
                        Object propertyChange = propertyChanges[i];
                        connector = i == propertyChanges.length - 1 ? "\u2514\u2500" : "\u251c\u2500";
                        this.termFrame.println("      " + connector + " " + propertyChange.toString());
                    }
                }
            }
            if (this.lastImpactAnalysis.hasAnyImpact()) {
                this.termFrame.println("\n\ud83c\udf33 Method Dependency Tree:");
                this.termFrame.println("");
                String treeVisualization = this.lastImpactAnalysis.getDependencyTreeVisualization();
                if (!treeVisualization.trim().isEmpty()) {
                    String[] lines = treeVisualization.split("\n");
                    for (String line : lines) {
                        this.termFrame.println("  " + line);
                    }
                } else {
                    this.termFrame.println("  (No method dependencies found)");
                }
                this.termFrame.println("");
                Set<String> affectedTestMethods = this.findTestMethodsAffectedByImpact(this.lastImpactAnalysis);
                if (!affectedTestMethods.isEmpty()) {
                    this.termFrame.println("\ud83e\uddea Affected Test Methods:");
                    String[] testMethodsArray = affectedTestMethods.toArray(new String[0]);
                    for (int i = 0; i < testMethodsArray.length; ++i) {
                        String connector = i == testMethodsArray.length - 1 ? "\u2514\u2500" : "\u251c\u2500";
                        this.termFrame.println("  " + connector + " " + testMethodsArray[i]);
                    }
                } else {
                    Set<String> affectedTestFiles = this.findTestsAffectedByImpact(this.lastImpactAnalysis);
                    if (!affectedTestFiles.isEmpty()) {
                        this.termFrame.println("\ud83d\udcc4 Affected Test Files:");
                        String[] testFilesArray = affectedTestFiles.toArray(new String[0]);
                        for (int i = 0; i < testFilesArray.length; ++i) {
                            String connector = i == testFilesArray.length - 1 ? "\u2514\u2500" : "\u251c\u2500";
                            this.termFrame.println("  " + connector + " " + testFilesArray[i]);
                        }
                    }
                }
            } else {
                this.termFrame.println("\n\u274c No test impact detected");
            }
            this.termFrame.println("");
            this.termFrame.println("");
            this.termFrame.println("Press any key to return to continuous testing...");
            this.termFrame.waitForAnyKeyPress((tf, key) -> tf.restoreState());
        }
        catch (Exception e) {
            this.getLog().error((CharSequence)"Error showing dependency tree", (Throwable)e);
        }
    }

    private String formatMethodChange(Object methodChange) {
        try {
            Class<?> changeClass = methodChange.getClass();
            java.lang.reflect.Method getChangeTypeMethod = changeClass.getMethod("getChangeType", new Class[0]);
            java.lang.reflect.Method getOldElementMethod = changeClass.getMethod("getOldElement", new Class[0]);
            java.lang.reflect.Method getNewElementMethod = changeClass.getMethod("getNewElement", new Class[0]);
            Object changeType = getChangeTypeMethod.invoke(methodChange, new Object[0]);
            Object oldElement = getOldElementMethod.invoke(methodChange, new Object[0]);
            Object newElement = getNewElementMethod.invoke(methodChange, new Object[0]);
            switch (changeType.toString()) {
                case "ADDED": {
                    return "ADDED: " + String.valueOf(newElement);
                }
                case "REMOVED": {
                    return "REMOVED: " + String.valueOf(oldElement);
                }
                case "MODIFIED": {
                    return "MODIFIED: " + String.valueOf(newElement != null ? newElement : oldElement) + " (implementation changed)";
                }
            }
            return String.valueOf(changeType) + ": " + String.valueOf(newElement != null ? newElement : oldElement);
        }
        catch (Exception e) {
            return methodChange.toString();
        }
    }

    public TestSessionSummary getTestSessionSummary() {
        Map<TestStatus, Long> statusCounts = this.sessionTestCases.values().stream().collect(Collectors.groupingBy(tc -> tc.status, Collectors.counting()));
        return new TestSessionSummary(this.sessionTestCases.size(), statusCounts.getOrDefault((Object)TestStatus.PASSED, 0L), statusCounts.getOrDefault((Object)TestStatus.FAILED, 0L), statusCounts.getOrDefault((Object)TestStatus.ERROR, 0L), statusCounts.getOrDefault((Object)TestStatus.SKIPPED, 0L), new HashMap<String, TestCaseResult>(this.sessionTestCases), this.currentRunTestCases.size());
    }

    private static enum TestStatus {
        PENDING,
        PASSED,
        FAILED,
        ERROR,
        SKIPPED;

    }

    private static class TestCaseResult {
        final String testClass;
        final String testMethod;
        final TestStatus status;
        final String errorMessage;
        final long lastRunTime;

        TestCaseResult(String testClass, String testMethod, TestStatus status, String errorMessage) {
            this.testClass = testClass;
            this.testMethod = testMethod;
            this.status = status;
            this.errorMessage = errorMessage;
            this.lastRunTime = System.currentTimeMillis();
        }

        String getFullName() {
            return this.testClass + "#" + this.testMethod;
        }
    }

    private static class FileChangeEvent {
        final Path filePath;
        final WatchEvent.Kind<?> kind;
        final long timestamp;

        FileChangeEvent(Path filePath, WatchEvent.Kind<?> kind) {
            this.filePath = filePath;
            this.kind = kind;
            this.timestamp = System.currentTimeMillis();
        }
    }

    private static class EffectiveChange {
        final Path filePath;
        final ChangeType type;

        EffectiveChange(Path filePath, ChangeType type) {
            this.filePath = filePath;
            this.type = type;
        }
    }

    private static enum ChangeType {
        CREATE,
        MODIFY,
        DELETE,
        REPLACE;

    }

    private static class TestClassResult {
        final int total;
        final int passed;
        final int failed;
        final int errors;
        final int skipped;

        TestClassResult(int total, int passed, int failed, int errors, int skipped) {
            this.total = total;
            this.passed = passed;
            this.failed = failed;
            this.errors = errors;
            this.skipped = skipped;
        }
    }

    public static class TestSessionSummary {
        public final long totalTestCases;
        public final long passedTestCases;
        public final long failedTestCases;
        public final long errorTestCases;
        public final long skippedTestCases;
        public final Map<String, TestCaseResult> allTestCases;
        public final int lastRunTestCount;

        public TestSessionSummary(long totalTestCases, long passedTestCases, long failedTestCases, long errorTestCases, long skippedTestCases, Map<String, TestCaseResult> allTestCases, int lastRunTestCount) {
            this.totalTestCases = totalTestCases;
            this.passedTestCases = passedTestCases;
            this.failedTestCases = failedTestCases;
            this.errorTestCases = errorTestCases;
            this.skippedTestCases = skippedTestCases;
            this.allTestCases = allTestCases;
            this.lastRunTestCount = lastRunTestCount;
        }

        public boolean hasFailures() {
            return this.failedTestCases > 0L || this.errorTestCases > 0L;
        }

        public List<TestCaseResult> getFailedTests() {
            return this.allTestCases.values().stream().filter(tc -> tc.status == TestStatus.FAILED || tc.status == TestStatus.ERROR).collect(Collectors.toList());
        }

        public String toString() {
            return String.format("TestSession[total=%d, passed=%d, failed=%d, errors=%d, skipped=%d, lastRun=%d]", this.totalTestCases, this.passedTestCases, this.failedTestCases, this.errorTestCases, this.skippedTestCases, this.lastRunTestCount);
        }
    }
}

