/*
 * Decompiled with CFR 0.152.
 */
package io.sundr.maven;

import io.sundr.maven.MavenVersion;
import io.sundr.maven.Reflections;
import java.lang.reflect.Constructor;
import org.apache.maven.execution.MavenExecutionResult;
import org.apache.maven.lifecycle.internal.LifecycleModuleBuilder;
import org.apache.maven.lifecycle.internal.ProjectIndex;
import org.apache.maven.lifecycle.internal.ReactorBuildStatus;
import org.apache.maven.lifecycle.internal.ReactorContext;

public class ReactorContextFactory {
    private static MavenVersion VERSION_3_0_0 = new MavenVersion(3, 0, 0);
    private static MavenVersion VERSION_3_3_0 = new MavenVersion(3, 3, 0);
    private final MavenVersion version;

    public ReactorContextFactory(MavenVersion version) {
        this.version = version;
    }

    public ReactorContext create(MavenExecutionResult result, ProjectIndex index, ClassLoader classLoader, ReactorBuildStatus status, LifecycleModuleBuilder builder) {
        if (VERSION_3_0_0.compareTo(this.version) < 0) {
            throw new UnsupportedOperationException("ReactorContext is not supported in maven version:" + this.version);
        }
        ReactorContext context = VERSION_3_3_0.compareTo(this.version) < 0 ? ReactorContextFactory.create_3_2_x(result, index, classLoader, status) : ReactorContextFactory.create_3_3_x(result, index, classLoader, status, builder);
        if (context == null) {
            throw new IllegalStateException("Unable to create ReactorContext");
        }
        return context;
    }

    private static ReactorContext create_3_2_x(MavenExecutionResult result, ProjectIndex index, ClassLoader classLoader, ReactorBuildStatus status) {
        try {
            Constructor constructor = ReactorContext.class.getDeclaredConstructor(MavenExecutionResult.class, ProjectIndex.class, ClassLoader.class, ReactorBuildStatus.class);
            return (ReactorContext)constructor.newInstance(result, index, classLoader, status);
        }
        catch (NoSuchMethodException e) {
            return null;
        }
        catch (Throwable t) {
            throw new RuntimeException("Could not create ReactorContext.", t);
        }
    }

    private static ReactorContext create_3_3_x(MavenExecutionResult result, ProjectIndex index, ClassLoader classLoader, ReactorBuildStatus status, LifecycleModuleBuilder builder) {
        try {
            Constructor<?> constructor = ReactorContext.class.getDeclaredConstructors()[0];
            return (ReactorContext)constructor.newInstance(result, index, classLoader, status, Reflections.getMemento(builder));
        }
        catch (Throwable t) {
            throw new RuntimeException("Could not create ReactorContext.", t);
        }
    }
}

