/*
 * Decompiled with CFR 0.152.
 */
package io.sundr.model;

import io.sundr.model.Expression;
import io.sundr.model.ExpressionOrStatement;
import io.sundr.model.Property;
import io.sundr.model.PropertyRef;
import io.sundr.model.ValueRef;

public class Assign
implements ExpressionOrStatement {
    private final Expression target;
    private final Expression value;

    public Assign(Expression target, Expression value) {
        this.target = target;
        this.value = value;
    }

    public Assign(Property property, Expression value) {
        this(new PropertyRef(property), value);
    }

    public Expression getTarget() {
        return this.target;
    }

    public Assign(Property property, Object value, Object ... rest) {
        this(property, (Expression)ValueRef.from(value, rest));
    }

    public Expression getValue() {
        return this.value;
    }

    @Override
    public String render() {
        return this.target.render() + " = " + this.value.render();
    }
}

