/*
 * Decompiled with CFR 0.152.
 */
package io.sundr.model;

import io.sundr.model.AttributeKey;
import io.sundr.model.Mappable;
import io.sundr.model.Nameable;
import io.sundr.model.TypeRef;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class ClassRef
extends TypeRef
implements Nameable,
Mappable<ClassRef> {
    public static final String UNKNOWN = "<unknown>";
    public static final String BRACKETS = "[]";
    public static final ClassRef OBJECT = new ClassRef("java.lang.Object", 0, Collections.emptyList(), Collections.emptyMap());
    private final String fullyQualifiedName;
    private final int dimensions;
    private final List<TypeRef> arguments;

    public ClassRef(String fullyQualifiedName, int dimensions, List<TypeRef> arguments, Map<AttributeKey, Object> attributes) {
        super(attributes);
        this.dimensions = dimensions;
        this.arguments = arguments;
        this.fullyQualifiedName = fullyQualifiedName;
    }

    public static ClassRef forName(String fullyQualifiedName) {
        return new ClassRef(fullyQualifiedName, 0, Collections.emptyList(), Collections.emptyMap());
    }

    @Override
    public String getFullyQualifiedName() {
        return this.fullyQualifiedName;
    }

    @Override
    public int getDimensions() {
        return this.dimensions;
    }

    public List<TypeRef> getArguments() {
        return this.arguments;
    }

    @Override
    public ClassRef withDimensions(int dimensions) {
        return new ClassRef(this.getFullyQualifiedName(), dimensions, this.getArguments(), this.getAttributes());
    }

    public Set<ClassRef> getReferences() {
        LinkedHashSet<ClassRef> refs = new LinkedHashSet<ClassRef>();
        for (TypeRef argument : this.arguments) {
            if (!(argument instanceof ClassRef)) continue;
            refs.addAll(((ClassRef)argument).getReferences());
        }
        refs.add(this);
        return refs;
    }

    @Override
    public String getName() {
        return Nameable.getClassName(this.fullyQualifiedName);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClassRef classRef = (ClassRef)o;
        if (this.dimensions != classRef.dimensions) {
            return false;
        }
        if (this.fullyQualifiedName != null ? !this.fullyQualifiedName.equals(classRef.getFullyQualifiedName()) : classRef.getFullyQualifiedName() != null) {
            return false;
        }
        return this.arguments != null ? this.arguments.equals(classRef.arguments) : classRef.arguments == null;
    }

    public int hashCode() {
        int result = this.fullyQualifiedName != null ? this.fullyQualifiedName.hashCode() : 0;
        result = 31 * result + this.dimensions;
        result = 31 * result + (this.arguments != null ? this.arguments.hashCode() : 0);
        return result;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.fullyQualifiedName);
        if (this.arguments.size() > 0) {
            sb.append("<");
            sb.append(this.arguments.stream().map(Object::toString).collect(Collectors.joining(",")));
            sb.append(">");
        }
        for (int i = 0; i < this.dimensions; ++i) {
            sb.append(BRACKETS);
        }
        return sb.toString();
    }

    @Override
    public String render() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.fullyQualifiedName);
        if (this.arguments.size() > 0) {
            sb.append("<");
            sb.append(this.arguments.stream().map((? super T a) -> a.render()).collect(Collectors.joining(",")));
            sb.append(">");
        }
        for (int i = 0; i < this.dimensions; ++i) {
            sb.append(BRACKETS);
        }
        return sb.toString();
    }
}

