/*
 * Decompiled with CFR 0.152.
 */
package io.sundr.model;

import io.sundr.model.Expression;
import io.sundr.model.Property;
import io.sundr.model.Statement;
import io.sundr.model.TypeRef;
import io.sundr.model.ValueRef;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

public class Declare
implements Statement {
    private final List<Property> properties;
    private final Optional<Expression> value;

    public Declare(List<Property> properties, Optional<Expression> value) {
        this.properties = properties;
        this.value = value;
    }

    public Declare(Property property, Object value, Object ... rest) {
        this(Arrays.asList(property), Optional.of(ValueRef.from(value, rest)));
    }

    public List<Property> getProperties() {
        return this.properties;
    }

    public Optional<Expression> getValue() {
        return this.value;
    }

    @Override
    public String render() {
        StringBuilder sb = new StringBuilder();
        TypeRef typeRef = this.properties.get(0).getTypeRef();
        sb.append(typeRef.render());
        sb.append(" ");
        sb.append(this.properties.stream().map(Property::getName).collect(Collectors.joining(", ")));
        sb.append(this.value.map(v -> " = " + v.render()).orElse(""));
        sb.append(";");
        return sb.toString();
    }
}

