/*
 * Decompiled with CFR 0.152.
 */
package io.sundr.model;

import io.sundr.model.Expression;
import io.sundr.model.Statement;
import java.util.Optional;

public class If
implements Statement {
    private final Expression condition;
    private final Statement statement;
    private final Optional<Statement> elseStatement;

    public If(Expression condition, Statement statement, Optional<Statement> elseStatement) {
        this.condition = condition;
        this.statement = statement;
        this.elseStatement = elseStatement;
    }

    public If(Expression condition, Statement statement, Statement elseStatement) {
        this(condition, statement, Optional.ofNullable(elseStatement));
    }

    public Expression getCondition() {
        return this.condition;
    }

    public Statement getStatement() {
        return this.statement;
    }

    public Optional<Statement> getElseStatement() {
        return this.elseStatement;
    }

    @Override
    public String render() {
        StringBuilder sb = new StringBuilder();
        sb.append("if").append(" ").append("(").append(this.condition.render()).append(")").append(" ").append("{").append("\n");
        sb.append(this.tab(this.statement.render()));
        sb.append("}");
        this.elseStatement.ifPresent(e -> {
            sb.append(" else ");
            if (e instanceof If) {
                sb.append(e.render());
            } else {
                sb.append("{");
                sb.append(this.tab(e.render()));
                sb.append("}");
            }
        });
        sb.append("\n");
        return sb.toString();
    }
}

