/*
 * Decompiled with CFR 0.152.
 */
package io.sundr.model;

import io.sundr.model.Expression;
import io.sundr.model.Renderable;
import io.sundr.model.TypeRef;
import java.util.List;
import java.util.stream.Collectors;

public class MethodCall
implements Expression {
    private final String name;
    private final Expression scope;
    private final List<TypeRef> parameters;
    private List<Expression> arguments;

    public MethodCall(String name, Expression scope, List<TypeRef> parameters, List<Expression> arguments) {
        this.name = name;
        this.scope = scope;
        this.parameters = parameters;
        this.arguments = arguments;
    }

    public String getName() {
        return this.name;
    }

    public Expression getScope() {
        return this.scope;
    }

    public List<TypeRef> getParameters() {
        return this.parameters;
    }

    public List<Expression> getArguments() {
        return this.arguments;
    }

    @Override
    public String render() {
        StringBuilder sb = new StringBuilder();
        if (this.scope != null) {
            sb.append(this.scope.render()).append(".");
            if (!this.arguments.isEmpty()) {
                sb.append("<");
                sb.append(this.parameters.stream().map(Renderable::render).collect(Collectors.joining(", ")));
                sb.append(">");
            }
        }
        sb.append(this.name).append("(");
        if (!this.arguments.isEmpty()) {
            sb.append(this.arguments.stream().map(Renderable::render).collect(Collectors.joining(", ")));
        }
        if (!this.arguments.isEmpty()) {
            sb.append(this.arguments.stream().map(Renderable::render).collect(Collectors.joining(", ")));
        }
        sb.append(")");
        return sb.toString();
    }
}

