/*
 * Decompiled with CFR 0.152.
 */
package io.sundr.model;

import io.sundr.model.ClassRef;
import io.sundr.model.Expression;
import java.util.HashSet;
import java.util.Set;

public class InstanceOf
implements Expression {
    private final Expression expression;
    private final ClassRef type;

    public InstanceOf(Expression expression, ClassRef type) {
        this.expression = expression;
        this.type = type;
    }

    public InstanceOf(Expression expression, Class type) {
        this(expression, ClassRef.forClass(type));
    }

    public Expression getExpression() {
        return this.expression;
    }

    public ClassRef getType() {
        return this.type;
    }

    @Override
    public Set<ClassRef> getReferences() {
        HashSet<ClassRef> refs = new HashSet<ClassRef>();
        if (this.expression != null) {
            refs.addAll(this.expression.getReferences());
        }
        if (this.type != null) {
            refs.addAll(this.type.getReferences());
        }
        return refs;
    }

    @Override
    public String render() {
        return this.expression.renderExpression() + " instanceof " + this.type.render();
    }
}

