/*
 * Decompiled with CFR 0.152.
 */
package io.sundr.model;

import io.sundr.model.Block;
import io.sundr.model.ClassRef;
import io.sundr.model.Declare;
import io.sundr.model.Expression;
import io.sundr.model.GreaterThan;
import io.sundr.model.GreaterThanOrEqual;
import io.sundr.model.LessThan;
import io.sundr.model.LessThanOrEqual;
import io.sundr.model.Property;
import io.sundr.model.Renderable;
import io.sundr.model.Statement;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public class For
implements Statement {
    private final List<Expression> init;
    private final Expression compare;
    private final List<Expression> update;
    private final Statement body;

    public For(List<Expression> init, Expression compare, List<Expression> update, Statement body) {
        this.init = init;
        this.compare = compare;
        this.update = update;
        this.body = body;
    }

    public For(Expression init, Expression compare, Expression update, Statement body) {
        this.init = Arrays.asList(init);
        this.compare = compare;
        this.update = Arrays.asList(update);
        this.body = body;
    }

    public List<Expression> getInit() {
        return this.init;
    }

    public Expression getCompare() {
        return this.compare;
    }

    public List<Expression> getUpdate() {
        return this.update;
    }

    public Statement getBody() {
        return this.body;
    }

    @Override
    public Set<ClassRef> getReferences() {
        HashSet<ClassRef> refs = new HashSet<ClassRef>();
        if (this.init != null) {
            for (Expression expr : this.init) {
                if (expr == null) continue;
                refs.addAll(expr.getReferences());
            }
        }
        if (this.compare != null) {
            refs.addAll(this.compare.getReferences());
        }
        if (this.update != null) {
            for (Expression expr : this.update) {
                if (expr == null) continue;
                refs.addAll(expr.getReferences());
            }
        }
        if (this.body != null) {
            refs.addAll(this.body.getReferences());
        }
        return refs;
    }

    @Override
    public String render() {
        StringBuilder sb = new StringBuilder();
        sb.append("for").append(" ").append("(");
        sb.append(this.init.stream().map(e -> e.renderExpression()).map(Renderable::noSemicolon).collect(Collectors.joining(",")));
        sb.append(";");
        sb.append(this.compare.renderExpression());
        sb.append(";");
        sb.append(this.update.stream().map(e -> e.renderExpression()).collect(Collectors.joining(",")));
        sb.append(")");
        sb.append(" ").append("{").append("\n");
        sb.append(this.tab(this.body.renderStatement()));
        sb.append("}").append("\n");
        return sb.toString();
    }

    public static DslInit init(Property prop, Object expression) {
        return new DslInit(Arrays.asList(new Declare(prop, expression, new Object[0])));
    }

    public static DslInit init(Expression ... init) {
        return new DslInit(Arrays.asList(init));
    }

    public static DslInit init(List<Expression> init) {
        return new DslInit(init);
    }

    public static class DslInit {
        private List<Expression> init;

        DslInit(List<Expression> init) {
            this.init = init;
        }

        public DslCompareStep compare(Expression compare) {
            return new DslCompareStep(this.init, compare);
        }

        public DslCompareStep eq(Expression left, Expression right) {
            return new DslCompareStep(this.init, Expression.eq(left, right));
        }

        public DslCompareStep ge(Expression left, Expression right) {
            return new DslCompareStep(this.init, new GreaterThanOrEqual(left, right));
        }

        public DslCompareStep gt(Expression left, Expression right) {
            return new DslCompareStep(this.init, new GreaterThan(left, right));
        }

        public DslCompareStep le(Expression left, Expression right) {
            return new DslCompareStep(this.init, new LessThanOrEqual(left, right));
        }

        public DslCompareStep lt(Expression left, Expression right) {
            return new DslCompareStep(this.init, new LessThan(left, right));
        }

        public DslCompareStep ne(Expression left, Expression right) {
            return new DslCompareStep(this.init, Expression.ne(left, right));
        }

        public DslCompareStep isNull(Expression expr) {
            return new DslCompareStep(this.init, Expression.isNull(expr));
        }

        public DslCompareStep notNull(Expression expr) {
            return new DslCompareStep(this.init, Expression.notNull(expr));
        }
    }

    public static class DslBodyStep {
        private List<Expression> init;
        private Expression compare;
        private List<Expression> update;

        DslBodyStep(List<Expression> init, Expression compare, List<Expression> update) {
            this.init = init;
            this.compare = compare;
            this.update = update;
        }

        public For body(Statement ... statements) {
            return new For(this.init, this.compare, this.update, Block.wrap(statements));
        }
    }

    public static class DslCompareStep {
        private List<Expression> init;
        private Expression compare;

        DslCompareStep(List<Expression> init, Expression compare) {
            this.init = init;
            this.compare = compare;
        }

        public DslBodyStep update(Expression ... update) {
            return new DslBodyStep(this.init, this.compare, Arrays.asList(update));
        }

        public DslBodyStep update(List<Expression> update) {
            return new DslBodyStep(this.init, this.compare, update);
        }
    }
}

