/*
 * Decompiled with CFR 0.152.
 */
package io.sundr.model;

import io.sundr.model.ClassRef;
import io.sundr.model.Expression;
import io.sundr.model.ExpressionOrStatement;
import io.sundr.model.Property;
import io.sundr.model.TypeRef;
import io.sundr.model.WithScope;
import java.util.HashSet;
import java.util.Set;

public class PropertyRef
extends WithScope
implements ExpressionOrStatement {
    private final Property property;

    public PropertyRef(Property property, Expression scope) {
        super(scope);
        this.property = property;
    }

    public PropertyRef(TypeRef type, String name, Expression scope) {
        super(scope);
        this.property = Property.newProperty(type, name);
    }

    public PropertyRef(String name, Expression scope) {
        super(scope);
        this.property = Property.newProperty(ClassRef.OBJECT, name);
    }

    public PropertyRef(Property property) {
        super(null);
        this.property = property;
    }

    public Property getProperty() {
        return this.property;
    }

    @Override
    public Set<ClassRef> getReferences() {
        HashSet<ClassRef> refs = new HashSet<ClassRef>();
        if (this.property != null) {
            refs.addAll(this.property.getReferences());
        }
        if (this.getScope() != null) {
            refs.addAll(this.getScope().getReferences());
        }
        return refs;
    }

    @Override
    public String render() {
        if (this.getScope() != null) {
            return this.getScope().renderExpression() + "." + this.property.getName();
        }
        return this.property.getName();
    }

    public String toString() {
        return "PropertyRef [property=" + String.valueOf(this.property) + ", scope=" + String.valueOf(this.getScope()) + "]";
    }
}

