/*
 * Decompiled with CFR 0.152.
 */
package io.sundr.model;

import io.sundr.model.Block;
import io.sundr.model.ClassRef;
import io.sundr.model.Expression;
import io.sundr.model.Statement;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class Synchronized
implements Statement {
    private final Expression lockExpression;
    private final Statement body;

    public Synchronized(Expression lockExpression, Statement body) {
        this.lockExpression = lockExpression;
        this.body = body;
    }

    public Expression getLockExpression() {
        return this.lockExpression;
    }

    public Statement getBody() {
        return this.body;
    }

    @Override
    public Set<ClassRef> getReferences() {
        HashSet<ClassRef> refs = new HashSet<ClassRef>();
        refs.addAll(this.lockExpression.getReferences());
        refs.addAll(this.body.getReferences());
        return refs;
    }

    @Override
    public String render() {
        StringBuilder sb = new StringBuilder();
        sb.append("synchronized").append(" ").append("(").append(this.lockExpression.render()).append(")").append(" ").append("{").append("\n");
        sb.append(this.tab(this.body.renderStatement()));
        sb.append("}").append("\n");
        return sb.toString();
    }

    public static DslLockStep on(Expression lockExpression) {
        return new DslLockStep(lockExpression);
    }

    public static class DslLockStep {
        private Expression lockExpression;

        DslLockStep(Expression lockExpression) {
            this.lockExpression = lockExpression;
        }

        public Synchronized body(Statement ... statements) {
            return new Synchronized(this.lockExpression, Block.wrap(statements));
        }

        public Synchronized body(List<Statement> statements) {
            return new Synchronized(this.lockExpression, Block.wrap(statements));
        }
    }
}

