/*
 * Decompiled with CFR 0.152.
 */
package io.sundr.model;

import io.sundr.model.ClassRef;
import io.sundr.model.Expression;
import io.sundr.model.TypeRef;
import io.sundr.model.ValueRef;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public class NewArray
implements Expression {
    private final TypeRef type;
    private final List<Expression> expressions;

    public NewArray(TypeRef type, List<Expression> expressions) {
        this.type = type;
        this.expressions = expressions;
    }

    public NewArray(Class<?> type, Expression ... expressions) {
        this((TypeRef)ClassRef.forClass(type), Arrays.asList(expressions));
    }

    public NewArray(TypeRef type, Expression ... expressions) {
        this(type, Arrays.asList(expressions));
    }

    public NewArray(Class<?> type, Integer ... sizes) {
        this((TypeRef)ClassRef.forClass(type), Arrays.stream(sizes).map(x$0 -> ValueRef.from(x$0, new Integer[0])).collect(Collectors.toList()));
    }

    public NewArray(TypeRef type, Integer ... sizes) {
        this(type, Arrays.stream(sizes).map(x$0 -> ValueRef.from(x$0, new Integer[0])).collect(Collectors.toList()));
    }

    public TypeRef getType() {
        return this.type;
    }

    public List<Expression> getExpressions() {
        return this.expressions;
    }

    @Override
    public Set<ClassRef> getReferences() {
        HashSet<ClassRef> refs = new HashSet<ClassRef>();
        if (this.type instanceof ClassRef) {
            refs.addAll(((ClassRef)this.type).getReferences());
        }
        if (this.expressions != null) {
            for (Expression expr : this.expressions) {
                if (expr == null) continue;
                refs.addAll(expr.getReferences());
            }
        }
        return refs;
    }

    @Override
    public String render() {
        StringBuilder sb = new StringBuilder();
        sb.append("new ").append(this.type.render());
        sb.append(this.expressions.stream().map(Expression::renderExpression).collect(Collectors.joining(", ", "[", "]")));
        return sb.toString();
    }
}

