/*
 * Decompiled with CFR 0.152.
 */
package io.sundr.model;

import io.sundr.model.ClassRef;
import io.sundr.model.Expression;
import io.sundr.model.Statement;
import io.sundr.model.ValueRef;
import java.util.HashSet;
import java.util.Set;

public class Throw
implements Statement {
    private final Expression exception;

    public Throw(Expression exception) {
        this.exception = exception;
    }

    public Expression getException() {
        return this.exception;
    }

    @Override
    public Set<ClassRef> getReferences() {
        HashSet<ClassRef> refs = new HashSet<ClassRef>();
        refs.addAll(this.exception.getReferences());
        return refs;
    }

    @Override
    public String render() {
        return "throw " + this.exception.renderExpression() + ";";
    }

    public static Throw newInstance(Class<?> exceptionClass, String message) {
        return new Throw(Expression.createNew(exceptionClass, ValueRef.from(message, new String[0])));
    }

    public static Throw newInstance(ClassRef exceptionClassRef, String message) {
        return new Throw(Expression.createNew(exceptionClassRef, ValueRef.from(message, new String[0])));
    }

    public static Throw newInstance(Class<?> exceptionClass, Expression messageExpression) {
        return new Throw(Expression.createNew(exceptionClass, messageExpression));
    }

    public static Throw newInstance(ClassRef exceptionClassRef, Expression messageExpression) {
        return new Throw(Expression.createNew(exceptionClassRef, messageExpression));
    }

    public static Throw runtimeException(String message) {
        return Throw.newInstance(RuntimeException.class, message);
    }

    public static Throw runtimeException(Expression messageExpression) {
        return Throw.newInstance(RuntimeException.class, messageExpression);
    }

    public static Throw illegalArgument(String message) {
        return Throw.newInstance(IllegalArgumentException.class, message);
    }

    public static Throw illegalArgument(Expression messageExpression) {
        return Throw.newInstance(IllegalArgumentException.class, messageExpression);
    }

    public static Throw illegalState(String message) {
        return Throw.newInstance(IllegalStateException.class, message);
    }

    public static Throw illegalState(Expression messageExpression) {
        return Throw.newInstance(IllegalStateException.class, messageExpression);
    }
}

