/*
 * Decompiled with CFR 0.152.
 */
package io.sundr.model;

import io.sundr.model.AttributeKey;
import io.sundr.model.TypeDef;
import io.sundr.model.TypeRef;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class WildcardRef
extends TypeRef {
    private final BoundKind boundKind;
    private final List<TypeRef> bounds;

    public WildcardRef() {
        this(BoundKind.EXTENDS, Collections.emptyList(), Collections.emptyMap());
    }

    public WildcardRef(BoundKind boundKind, List<TypeRef> bounds, Map<AttributeKey, Object> attributes) {
        super(attributes);
        this.boundKind = boundKind;
        this.bounds = bounds;
    }

    @Override
    public String getName() {
        return "?";
    }

    public List<TypeRef> getBounds() {
        return this.bounds;
    }

    public BoundKind getBoundKind() {
        return this.boundKind;
    }

    @Override
    public int getDimensions() {
        return 0;
    }

    @Override
    public TypeRef withDimensions(int dimensions) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String render(TypeDef enclosing) {
        StringBuilder sb = new StringBuilder();
        if (this.bounds == null || this.bounds.isEmpty()) {
            sb.append("?");
        } else {
            sb.append(String.format(this.boundKind.format, this.bounds.stream().map(b -> b.render(enclosing)).collect(Collectors.joining(","))));
        }
        return sb.toString();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.bounds == null || this.bounds.isEmpty()) {
            sb.append("?");
        } else {
            sb.append(String.format(this.boundKind.format, this.bounds.stream().map(Object::toString).collect(Collectors.joining(","))));
        }
        return sb.toString();
    }

    public static enum BoundKind {
        EXTENDS("? extends %s"),
        SUPER("? super %s");

        String format;

        private BoundKind(String format) {
            this.format = format;
        }

        String getFormat() {
            return this.format;
        }
    }
}

