/*
 * Decompiled with CFR 0.152.
 */
package io.sundr.model;

import io.sundr.model.Annotatable;
import io.sundr.model.AnnotationRef;
import io.sundr.model.AttributeKey;
import io.sundr.model.ClassRef;
import io.sundr.model.Commentable;
import io.sundr.model.ModifierSupport;
import io.sundr.model.Modifiers;
import io.sundr.model.Renderable;
import io.sundr.model.TypeDef;
import io.sundr.model.TypeParamRef;
import io.sundr.model.TypeRef;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class Property
extends ModifierSupport
implements Renderable,
Commentable,
Annotatable {
    private final List<AnnotationRef> annotations;
    private final TypeRef typeRef;
    private final String name;
    private final List<String> comments;

    public Property(List<AnnotationRef> annotations, TypeRef typeRef, String name, List<String> comments, Modifiers modifiers, Map<AttributeKey, Object> attributes) {
        super(modifiers, attributes);
        this.annotations = annotations;
        this.typeRef = typeRef;
        this.name = name;
        this.comments = comments;
    }

    public static Property newProperty(TypeRef typeRef, String name) {
        return new Property(Collections.emptyList(), typeRef, name, Collections.emptyList(), Modifiers.create(), new HashMap<AttributeKey, Object>());
    }

    @Override
    public List<AnnotationRef> getAnnotations() {
        return this.annotations;
    }

    public TypeRef getTypeRef() {
        return this.typeRef;
    }

    public String getName() {
        return this.name;
    }

    @Override
    public List<String> getComments() {
        return this.comments;
    }

    public String getNameCapitalized() {
        return Stream.of(this.name.split("[^a-zA-Z0-9]")).filter(s -> s != null && s.length() > 0).map(v -> Character.toUpperCase(v.charAt(0)) + v.substring(1)).collect(Collectors.joining());
    }

    public Set<ClassRef> getReferences() {
        LinkedHashSet<ClassRef> refs = new LinkedHashSet<ClassRef>();
        for (AnnotationRef annotationRef : this.annotations) {
            refs.addAll(annotationRef.getReferences());
        }
        if (this.typeRef instanceof ClassRef) {
            ClassRef classRef = (ClassRef)this.typeRef;
            refs.addAll(classRef.getReferences());
        }
        for (AnnotationRef a : this.getAnnotations()) {
            refs.addAll(a.getClassRef().getReferences());
        }
        if (this.getAttributes().containsKey(ALSO_IMPORT)) {
            Object obj = this.getAttributes().get(ALSO_IMPORT);
            if (obj instanceof ClassRef) {
                refs.add((ClassRef)obj);
            } else if (obj instanceof Collection) {
                refs.addAll((Collection)obj);
            }
        }
        return refs;
    }

    protected Property withoutModiers() {
        return new Property(this.annotations, this.typeRef, this.name, this.comments, Modifiers.create(), this.getAttributes());
    }

    public Property withErasure() {
        return new Property(this.annotations, this.typeRef instanceof TypeParamRef ? ((TypeParamRef)this.typeRef).withErasure() : this.typeRef, this.name, this.comments, Modifiers.create(), this.getAttributes());
    }

    protected String getDefaultValue() {
        Object value = this.getAttribute(INIT);
        if (this.getTypeRef() instanceof ClassRef && ((ClassRef)this.getTypeRef()).getFullyQualifiedName().equals("java.lang.String") && this.getTypeRef().getDimensions() == 0 && !String.valueOf(value).startsWith("\"")) {
            return "\"" + value + "\"";
        }
        return String.valueOf(value);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Property other = (Property)obj;
        if (!this.modifiers.equals(other.modifiers)) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        return !(this.typeRef == null ? other.typeRef != null : !this.typeRef.equals(other.typeRef));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.modifiers.hashCode();
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.typeRef == null ? 0 : this.typeRef.hashCode());
        return result;
    }

    @Override
    public String render(TypeDef enclosingType) {
        StringBuilder sb = new StringBuilder();
        if (this.isPublic()) {
            sb.append("public").append(" ");
        } else if (this.isProtected()) {
            sb.append("protected").append(" ");
        } else if (this.isPrivate()) {
            sb.append("private").append(" ");
        }
        if (this.isStatic()) {
            sb.append("static").append(" ");
        }
        if (this.isFinal()) {
            sb.append("final").append(" ");
        }
        sb.append(this.typeRef.render(enclosingType)).append(" ");
        sb.append(this.name);
        return sb.toString();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.isPublic()) {
            sb.append("public").append(" ");
        } else if (this.isProtected()) {
            sb.append("protected").append(" ");
        } else if (this.isPrivate()) {
            sb.append("private").append(" ");
        }
        if (this.isStatic()) {
            sb.append("static").append(" ");
        }
        if (this.isFinal()) {
            sb.append("final").append(" ");
        }
        sb.append(this.typeRef).append(" ");
        sb.append(this.name);
        return sb.toString();
    }
}

