/*
 * Decompiled with CFR 0.152.
 */
package io.sundr.model.repo;

import io.sundr.builder.Visitor;
import io.sundr.model.Block;
import io.sundr.model.ClassRef;
import io.sundr.model.Expression;
import io.sundr.model.Method;
import io.sundr.model.MethodBuilder;
import io.sundr.model.MethodCall;
import io.sundr.model.Property;
import io.sundr.model.Super;
import io.sundr.model.This;
import io.sundr.model.TypeDef;
import io.sundr.model.repo.DefinitionRepository;
import io.sundr.model.repo.MethodCallCollector;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class MethodReference {
    private static final Map<String, Set<MethodReference>> RESULTION_CACHE = new ConcurrentHashMap<String, Set<MethodReference>>();
    private final Method method;
    private final TypeDef owningType;

    public MethodReference(Method method, TypeDef owningType) {
        this.method = method;
        this.owningType = owningType;
    }

    public Method getMethod() {
        return this.method;
    }

    public TypeDef getOwningType() {
        return this.owningType;
    }

    public static Set<MethodReference> getDirectMethodReferences(Method method, DefinitionRepository repository) {
        if (method == null) {
            throw new IllegalArgumentException("Method cannot be null");
        }
        if (repository == null) {
            throw new IllegalArgumentException("Repository cannot be null");
        }
        LinkedHashSet<MethodReference> result = new LinkedHashSet<MethodReference>();
        if (method.getBlock() != null) {
            Set<MethodCall> methodCalls = MethodReference.findMethodCalls(method.getBlock());
            for (MethodCall methodCall : methodCalls) {
                Set<MethodReference> referencedMethods = MethodReference.resolveMethodCall(methodCall, repository);
                result.addAll(referencedMethods);
            }
        }
        return result;
    }

    public static Set<MethodReference> getMethodReferences(Method method, DefinitionRepository repository) {
        if (method == null) {
            throw new IllegalArgumentException("Method cannot be null");
        }
        if (repository == null) {
            throw new IllegalArgumentException("Repository cannot be null");
        }
        HashSet<Method> visited = new HashSet<Method>();
        LinkedHashSet<MethodReference> result = new LinkedHashSet<MethodReference>();
        MethodReference.collectMethodReferencesRecursively(method, repository, visited, result);
        return result;
    }

    public static Set<MethodReference> getMethodReferences(Method method) {
        if (method == null) {
            throw new IllegalArgumentException("Method cannot be null");
        }
        return MethodReference.getMethodReferences(method, DefinitionRepository.getRepository());
    }

    private static void collectMethodReferencesRecursively(Method method, DefinitionRepository repository, Set<Method> visited, Set<MethodReference> result) {
        if (method == null || visited.contains(method)) {
            return;
        }
        visited.add(method);
        Set<MethodReference> directReferences = MethodReference.getDirectMethodReferences(method, repository);
        for (MethodReference referencedMethod : directReferences) {
            if (visited.contains(referencedMethod.getMethod())) continue;
            result.add(referencedMethod);
            MethodReference.collectMethodReferencesRecursively(referencedMethod.getMethod(), repository, visited, result);
        }
    }

    private static Set<MethodCall> findMethodCalls(Block block) {
        MethodCallCollector collector = new MethodCallCollector();
        MethodBuilder methodBuilder = (MethodBuilder)new MethodBuilder().withBlock(block);
        methodBuilder.accept(new Visitor[]{collector});
        return collector.getMethodCalls();
    }

    private static Set<MethodReference> findMethodsByName(TypeDef typeDef, String methodName) {
        HashSet<MethodReference> methods = new HashSet<MethodReference>();
        for (Method method : typeDef.getMethods()) {
            if (!methodName.equals(method.getName())) continue;
            methods.add(new MethodReference(method, typeDef));
        }
        return methods;
    }

    private static Set<MethodReference> findMethodsBySignature(TypeDef typeDef, String methodName, List<Property> parameterTypes) {
        Method targetMethod = ((MethodBuilder)((MethodBuilder)new MethodBuilder().withName(methodName)).withArguments(parameterTypes != null ? parameterTypes : List.of())).build();
        String targetErasure = targetMethod.getErasure();
        HashSet<MethodReference> methods = new HashSet<MethodReference>();
        for (Method method : typeDef.getMethods()) {
            if (!targetErasure.equals(method.getErasure())) continue;
            methods.add(new MethodReference(method, typeDef));
        }
        return methods;
    }

    private static Set<MethodReference> resolveMethodCall(MethodCall methodCall, DefinitionRepository repository) {
        String cacheKey = MethodReference.createMethodCallCacheKey(methodCall, repository);
        Set<MethodReference> cachedResult = RESULTION_CACHE.get(cacheKey);
        if (cachedResult != null) {
            return new HashSet<MethodReference>(cachedResult);
        }
        HashSet<MethodReference> methods = new HashSet<MethodReference>();
        Expression scope = methodCall.getScope();
        if (scope != null) {
            if (scope instanceof This || scope instanceof Super) {
                for (TypeDef typeDef : repository.getDefinitions()) {
                    methods.addAll(MethodReference.findMethodsByName(typeDef, methodCall.getName()));
                }
            } else {
                Set scopeReferences = scope.getReferences();
                for (ClassRef classRef : scopeReferences) {
                    TypeDef typeDef = repository.getDefinition(classRef.getFullyQualifiedName());
                    if (typeDef == null) continue;
                    Set<MethodReference> foundMethods = MethodReference.findMethodsByName(typeDef, methodCall.getName());
                    methods.addAll(foundMethods);
                }
            }
        } else {
            for (TypeDef typeDef : repository.getDefinitions()) {
                Set<MethodReference> foundMethods = MethodReference.findMethodsByName(typeDef, methodCall.getName());
                methods.addAll(foundMethods);
            }
        }
        RESULTION_CACHE.put(cacheKey, new HashSet(methods));
        return methods;
    }

    private static String createMethodCallCacheKey(MethodCall methodCall, DefinitionRepository repository) {
        StringBuilder key = new StringBuilder();
        key.append(methodCall.getName());
        Expression scope = methodCall.getScope();
        if (scope != null) {
            key.append("@").append(scope.getClass().getSimpleName());
            if (!(scope instanceof This) && !(scope instanceof Super)) {
                key.append(":").append(scope.toString());
            }
        } else {
            key.append("@null");
        }
        key.append("#").append(repository.getDefinitions().stream().mapToInt(td -> td.getFullyQualifiedName().hashCode()).sum());
        return key.toString();
    }

    public static Set<MethodReference> getDirectMethodCallers(MethodReference targetMethod, DefinitionRepository repository) {
        if (targetMethod == null) {
            throw new IllegalArgumentException("Target method cannot be null");
        }
        if (repository == null) {
            throw new IllegalArgumentException("Repository cannot be null");
        }
        HashSet<MethodReference> callers = new HashSet<MethodReference>();
        int methodsChecked = 0;
        int typeDefsProcessed = 0;
        for (TypeDef typeDef : repository.getDefinitions()) {
            ++typeDefsProcessed;
            for (Method method : typeDef.getMethods()) {
                ++methodsChecked;
                try {
                    Set<MethodReference> directReferences = MethodReference.getDirectMethodReferences(method, repository);
                    if (directReferences.contains(targetMethod)) {
                        callers.add(new MethodReference(method, typeDef));
                        continue;
                    }
                    if (methodsChecked > 5) continue;
                    for (MethodReference ref : directReferences) {
                        if (!ref.getMethod().getName().equals(targetMethod.getMethod().getName())) continue;
                    }
                }
                catch (Exception exception) {
                }
            }
        }
        return callers;
    }

    public static Set<MethodReference> getMethodCallers(MethodReference targetMethod, DefinitionRepository repository) {
        if (targetMethod == null) {
            throw new IllegalArgumentException("Target method cannot be null");
        }
        if (repository == null) {
            throw new IllegalArgumentException("Repository cannot be null");
        }
        HashSet<MethodReference> allCallers = new HashSet<MethodReference>();
        HashSet<MethodReference> visited = new HashSet<MethodReference>();
        MethodReference.collectCallersRecursively(targetMethod, repository, visited, allCallers);
        return allCallers;
    }

    private static void collectCallersRecursively(MethodReference targetMethod, DefinitionRepository repository, Set<MethodReference> visited, Set<MethodReference> result) {
        if (targetMethod == null || visited.contains(targetMethod)) {
            return;
        }
        visited.add(targetMethod);
        Set<MethodReference> directCallers = MethodReference.getDirectMethodCallers(targetMethod, repository);
        for (MethodReference caller : directCallers) {
            if (visited.contains(caller)) continue;
            result.add(caller);
            MethodReference.collectCallersRecursively(caller, repository, visited, result);
        }
    }

    public static void clearCache() {
        RESULTION_CACHE.clear();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        MethodReference that = (MethodReference)obj;
        return this.method.getErasure().equals(that.method.getErasure()) && this.owningType.getFullyQualifiedName().equals(that.owningType.getFullyQualifiedName());
    }

    public int hashCode() {
        return Objects.hash(this.method.getErasure(), this.owningType.getFullyQualifiedName());
    }

    public String toString() {
        return this.owningType.getName() + "." + this.method.getName();
    }
}

