/*
 * Decompiled with CFR 0.152.
 */
package io.sundr.model.visitors.context.resolver;

import io.sundr.builder.Visitable;
import io.sundr.builder.Visitor;
import io.sundr.model.Expression;
import io.sundr.model.TypeDef;
import io.sundr.model.TypeDefBuilder;
import io.sundr.model.TypeDefFluent;
import io.sundr.model.utils.Resolvers;
import io.sundr.model.visitors.context.resolver.LocalVariableResolver;
import io.sundr.model.visitors.context.resolver.MethodArgumentsResolver;
import io.sundr.model.visitors.context.resolver.MethodCallArgumentsResolver;
import io.sundr.model.visitors.context.resolver.PropertyRefContextRefResolver;
import io.sundr.model.visitors.context.resolver.ScopeResolver;
import io.sundr.model.visitors.context.resolver.StaticMethodContextRefResolver;
import java.util.Map;

public class TypeDefContextRefResolver
implements Visitor<TypeDefFluent<?>> {
    public void visit(TypeDefFluent<?> fluent) {
        if (fluent instanceof Visitable) {
            Visitable visitable = (Visitable)fluent;
            Map<String, Expression> resolutionMap = Resolvers.createResolutionMap(fluent.buildProperties());
            visitable.accept(new Visitor[]{new LocalVariableResolver(resolutionMap)});
            visitable.accept(new Visitor[]{new MethodArgumentsResolver(resolutionMap)});
            visitable.accept(new Visitor[]{new ScopeResolver(resolutionMap)});
            visitable.accept(new Visitor[]{new MethodCallArgumentsResolver(resolutionMap)});
        }
        if (fluent instanceof TypeDefBuilder) {
            TypeDefBuilder builder = (TypeDefBuilder)fluent;
            TypeDef typeDef = builder.build();
            builder.accept(new Visitor[]{new StaticMethodContextRefResolver(typeDef.getImports(), typeDef.getPackageName())});
            builder.accept(new Visitor[]{new PropertyRefContextRefResolver(typeDef.getImports(), typeDef.getPackageName())});
        }
    }
}

