/*
 * Decompiled with CFR 0.152.
 */
package io.sundr.model.utils;

import io.sundr.SundrException;
import io.sundr.model.Method;
import io.sundr.model.MethodBuilder;
import io.sundr.model.MethodFluent;
import io.sundr.model.Property;
import io.sundr.model.Return;
import io.sundr.model.RichTypeDef;
import io.sundr.model.Statement;
import io.sundr.model.TypeDef;
import io.sundr.model.VoidRef;
import io.sundr.model.functions.Assignable;
import io.sundr.model.utils.Record;
import io.sundr.model.utils.TypeArguments;
import io.sundr.model.utils.Types;
import io.sundr.utils.Strings;
import java.util.Optional;
import java.util.stream.Collectors;

public class Getter {
    public static final String GET_PREFIX = "get";
    public static final String IS_PREFIX = "is";
    public static final String SHOULD_PREFIX = "should";
    public static final VoidRef VOID = new VoidRef();

    public static Method find(TypeDef clazz, Property property) {
        return Getter.find(clazz, property, false);
    }

    public static Optional<Method> findOptional(TypeDef clazz, Property property) {
        try {
            return Optional.of(Getter.find(clazz, property, false));
        }
        catch (SundrException e) {
            return Optional.empty();
        }
    }

    public static Method find(TypeDef clazz, Property property, boolean acceptPrefixless) {
        RichTypeDef richType = clazz instanceof RichTypeDef ? (RichTypeDef)clazz : TypeArguments.apply(clazz);
        for (Method method : richType.getAllMethods()) {
            if ((!Record.is(clazz) || !Getter.isApplicable(method, property, true, true)) && !Getter.isApplicable(method, property, true, false)) continue;
            return method;
        }
        for (Method method : richType.getAllMethods()) {
            if (!Getter.isApplicable(method, property, false, false)) continue;
            return method;
        }
        if (acceptPrefixless) {
            for (Method method : richType.getAllMethods()) {
                if (!Getter.isApplicable(method, property, false, true)) continue;
                return method;
            }
        }
        throw new SundrException("No getter found for property: [" + property.toString() + "] on class: " + clazz.getFullyQualifiedName() + ", getters found: [" + richType.getAllMethods().stream().filter(Getter::is).map(m -> String.valueOf(m.getReturnType()) + " " + m.getName()).collect(Collectors.joining(",")) + "]");
    }

    public static boolean is(Method method) {
        return Getter.is(method, false);
    }

    public static boolean is(Method method, boolean acceptPrefixless) {
        int length = method.getName().length();
        if (method.isPrivate() || method.isStatic()) {
            return false;
        }
        if (!method.getArguments().isEmpty()) {
            return false;
        }
        if (method.getReturnType().equals(VOID)) {
            return false;
        }
        if (method.getExceptions() != null && !method.getExceptions().isEmpty()) {
            return false;
        }
        if (acceptPrefixless) {
            return true;
        }
        if (method.getName().startsWith(GET_PREFIX)) {
            return length > GET_PREFIX.length();
        }
        if (method.getName().startsWith(IS_PREFIX) && Types.isBoolean(method.getReturnType())) {
            return length > IS_PREFIX.length();
        }
        if (method.getName().startsWith(SHOULD_PREFIX) && Types.isBoolean(method.getReturnType())) {
            return length > SHOULD_PREFIX.length();
        }
        return false;
    }

    private static boolean isApplicable(Method method, Property property) {
        return Getter.isApplicable(method, property, false, false);
    }

    private static boolean isApplicable(Method method, Property property, boolean strict, boolean acceptPrefixless) {
        if (!Assignable.isAssignable(method.getReturnType()).from(property.getTypeRef())) {
            return false;
        }
        String capitalized = Strings.capitalizeFirst((String)property.getName());
        if (method.getName().endsWith(GET_PREFIX + capitalized)) {
            return true;
        }
        if (method.getName().endsWith(IS_PREFIX + capitalized)) {
            return true;
        }
        if (method.getName().endsWith(SHOULD_PREFIX + capitalized)) {
            return true;
        }
        if (acceptPrefixless && method.getName().endsWith(property.getName())) {
            return true;
        }
        if (!strict) {
            if (method.getName().endsWith(GET_PREFIX + property.getNameCapitalized())) {
                return true;
            }
            if (method.getName().endsWith(IS_PREFIX + property.getNameCapitalized())) {
                return true;
            }
            if (method.getName().endsWith(GET_PREFIX + property.getName()) && !Character.isAlphabetic(property.getName().charAt(0))) {
                return true;
            }
            if (method.getName().endsWith(IS_PREFIX + property.getName()) && !Character.isAlphabetic(property.getName().charAt(0))) {
                return true;
            }
            if (method.getName().endsWith(SHOULD_PREFIX + property.getName()) && !Character.isAlphabetic(property.getName().charAt(0))) {
                return true;
            }
        }
        return false;
    }

    public static final Method forProperty(Property property) {
        return ((MethodBuilder)((MethodFluent.BlockNested)((MethodBuilder)((MethodBuilder)new MethodBuilder().withName(Getter.name(property))).withReturnType(property.getTypeRef())).withNewBlock().addToStatements(new Statement[]{Return.This().ref(property)})).endBlock()).build();
    }

    public static String name(Property property) {
        return Getter.prefix(property) + property.getNameCapitalized();
    }

    public static String propertyName(Method method) {
        if (!Getter.is(method)) {
            throw new IllegalArgumentException("Method: " + String.valueOf(method) + " is not a real getter.");
        }
        String name = method.getName();
        if (name.startsWith(GET_PREFIX)) {
            name = name.substring(GET_PREFIX.length());
        } else if (name.startsWith(IS_PREFIX)) {
            name = name.substring(IS_PREFIX.length());
        } else if (name.startsWith(SHOULD_PREFIX)) {
            name = name.substring(SHOULD_PREFIX.length());
        } else {
            throw new IllegalStateException("Method: " + String.valueOf(method) + " is a getter but couldn't find a valid prefix.");
        }
        if (name.length() == 1) {
            return name.toLowerCase();
        }
        return name.substring(0, 1).toLowerCase() + name.substring(1);
    }

    public static String propertyNameSafe(Method method) {
        String name = method.getName();
        if (name.startsWith(GET_PREFIX)) {
            name = name.substring(GET_PREFIX.length());
        } else if (name.startsWith(IS_PREFIX)) {
            name = name.substring(IS_PREFIX.length());
        } else if (name.startsWith(SHOULD_PREFIX)) {
            name = name.substring(SHOULD_PREFIX.length());
        }
        if (name.length() == 1) {
            return name.toLowerCase();
        }
        return name.substring(0, 1).toLowerCase() + name.substring(1);
    }

    public static String prefix(Property property) {
        return Types.isPrimitive(property.getTypeRef()) && Types.isBoolean(property.getTypeRef()) ? IS_PREFIX : GET_PREFIX;
    }
}

