/*
 * Decompiled with CFR 0.152.
 */
package io.sundr.model.visitors.context.resolver;

import io.sundr.builder.Visitable;
import io.sundr.builder.Visitor;
import io.sundr.model.ClassRef;
import io.sundr.model.ContextRef;
import io.sundr.model.Expression;
import io.sundr.model.MethodCallFluent;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

public class StaticMethodContextRefResolver
implements Visitor<MethodCallFluent<?>> {
    private final Set<ClassRef> imports;
    private final String currentPackage;

    public StaticMethodContextRefResolver(Set<String> imports, String currentPackage) {
        this.currentPackage = currentPackage;
        this.imports = imports.stream().map(ClassRef::forName).collect(Collectors.toSet());
    }

    public void visit(MethodCallFluent<?> fluent) {
        if (!(fluent instanceof Visitable)) {
            return;
        }
        Expression scope = fluent.buildScope();
        if (scope instanceof ContextRef) {
            ContextRef contextRef = (ContextRef)scope;
            String className = contextRef.getName();
            this.resolveClassName(className).ifPresent(resolvedClass -> fluent.withScope((Expression)resolvedClass));
        }
    }

    private Optional<ClassRef> resolveClassName(String className) {
        for (ClassRef importedClass : this.imports) {
            if (!importedClass.getName().equals(className)) continue;
            return Optional.of(importedClass);
        }
        if (this.isJavaLangClass(className)) {
            return Optional.of(ClassRef.forName((String)("java.lang." + className)));
        }
        if (Character.isUpperCase(className.charAt(0))) {
            String fullyQualifiedName = this.currentPackage != null && !this.currentPackage.isEmpty() ? this.currentPackage + "." + className : className;
            return Optional.of(ClassRef.forName((String)fullyQualifiedName));
        }
        return Optional.empty();
    }

    private boolean isJavaLangClass(String className) {
        return className.equals("System") || className.equals("String") || className.equals("Object") || className.equals("Class") || className.equals("Thread") || className.equals("Math") || className.equals("Integer") || className.equals("Long") || className.equals("Double") || className.equals("Float") || className.equals("Boolean") || className.equals("Character") || className.equals("Byte") || className.equals("Short") || className.equals("Number") || className.equals("Throwable") || className.equals("Exception") || className.equals("RuntimeException") || className.equals("Error") || className.equals("ClassLoader") || className.equals("Package") || className.equals("Process") || className.equals("ProcessBuilder") || className.equals("Runtime") || className.equals("SecurityManager") || className.equals("StringBuilder") || className.equals("StringBuffer");
    }
}

