/*
 * Decompiled with CFR 0.152.
 */
package io.sundr.model.utils;

import io.sundr.SundrException;
import io.sundr.model.ClassRef;
import io.sundr.model.Method;
import io.sundr.model.MethodBuilder;
import io.sundr.model.MethodFluent;
import io.sundr.model.Property;
import io.sundr.model.Statement;
import io.sundr.model.StringStatement;
import io.sundr.model.TypeDef;
import io.sundr.model.VoidRef;
import io.sundr.model.functions.Assignable;
import io.sundr.model.repo.DefinitionRepository;
import io.sundr.model.utils.Types;
import io.sundr.utils.Strings;

public class Getter {
    public static final String GET_PREFIX = "get";
    public static final String IS_PREFIX = "is";
    public static final String SHOULD_PREFIX = "should";
    public static final VoidRef VOID = new VoidRef();

    public static Method find(TypeDef clazz, Property property) {
        return Getter.find(clazz, property, false);
    }

    public static Method find(TypeDef clazz, Property property, boolean acceptPrefixless) {
        TypeDef current = clazz;
        while (current != null && !current.equals((Object)TypeDef.OBJECT)) {
            for (Method method : current.getMethods()) {
                if (!Getter.isApplicable(method, property, true, false)) continue;
                return method;
            }
            for (Method method : current.getMethods()) {
                if (!Getter.isApplicable(method, property, false, false)) continue;
                return method;
            }
            if (acceptPrefixless) {
                for (Method method : current.getMethods()) {
                    if (!Getter.isApplicable(method, property, false, true)) continue;
                    return method;
                }
            }
            if (!current.getExtendsList().iterator().hasNext()) break;
            String fqn = ((ClassRef)current.getExtendsList().iterator().next()).getFullyQualifiedName();
            current = DefinitionRepository.getRepository().getDefinition(fqn);
        }
        throw new SundrException("No getter found for property: " + property.getName() + " on class: " + clazz.getFullyQualifiedName());
    }

    public static boolean is(Method method) {
        return Getter.is(method, false);
    }

    public static boolean is(Method method, boolean acceptPrefixless) {
        int length = method.getName().length();
        if (method.isPrivate() || method.isStatic()) {
            return false;
        }
        if (!method.getArguments().isEmpty()) {
            return false;
        }
        if (method.getReturnType().equals(VOID)) {
            return false;
        }
        if (acceptPrefixless) {
            return true;
        }
        if (method.getName().startsWith(GET_PREFIX)) {
            return length > GET_PREFIX.length();
        }
        if (method.getName().startsWith(IS_PREFIX) && Types.isBoolean(method.getReturnType())) {
            return length > IS_PREFIX.length();
        }
        if (method.getName().startsWith(SHOULD_PREFIX) && Types.isBoolean(method.getReturnType())) {
            return length > SHOULD_PREFIX.length();
        }
        return false;
    }

    private static boolean isApplicable(Method method, Property property) {
        return Getter.isApplicable(method, property, false, false);
    }

    private static boolean isApplicable(Method method, Property property, boolean strict, boolean acceptPrefixless) {
        if (!Assignable.isAssignable(method.getReturnType()).from(property.getTypeRef())) {
            return false;
        }
        String capitalized = Strings.capitalizeFirst((String)property.getName());
        if (method.getName().endsWith(GET_PREFIX + capitalized)) {
            return true;
        }
        if (method.getName().endsWith(IS_PREFIX + capitalized)) {
            return true;
        }
        if (method.getName().endsWith(SHOULD_PREFIX + capitalized)) {
            return true;
        }
        if (acceptPrefixless && method.getName().endsWith(property.getName())) {
            return true;
        }
        if (!strict) {
            if (method.getName().endsWith(GET_PREFIX + property.getNameCapitalized())) {
                return true;
            }
            if (method.getName().endsWith(IS_PREFIX + property.getNameCapitalized())) {
                return true;
            }
            if (method.getName().endsWith(GET_PREFIX + property.getName()) && !Character.isAlphabetic(property.getName().charAt(0))) {
                return true;
            }
            if (method.getName().endsWith(IS_PREFIX + property.getName()) && !Character.isAlphabetic(property.getName().charAt(0))) {
                return true;
            }
            if (method.getName().endsWith(SHOULD_PREFIX + property.getName()) && !Character.isAlphabetic(property.getName().charAt(0))) {
                return true;
            }
        }
        return false;
    }

    public static final Method forProperty(Property property) {
        return ((MethodBuilder)((MethodFluent.BlockNested)((MethodBuilder)((MethodBuilder)new MethodBuilder().withName(Getter.name(property))).withReturnType(property.getTypeRef())).withNewBlock().addToStatements(new Statement[]{new StringStatement("return this." + property + ";")})).endBlock()).build();
    }

    public static String name(Property property) {
        return Getter.prefix(property) + property.getNameCapitalized();
    }

    public static String propertyName(Method method) {
        if (!Getter.is(method)) {
            throw new IllegalArgumentException("Method: " + method + " is not a real getter.");
        }
        String name = method.getName();
        if (name.startsWith(GET_PREFIX)) {
            return name.substring(GET_PREFIX.length());
        }
        if (name.startsWith(IS_PREFIX)) {
            return name.substring(IS_PREFIX.length());
        }
        if (!name.startsWith(SHOULD_PREFIX)) {
            throw new IllegalStateException("Method: " + method + " is a getter but couldn't find a valid prefix.");
        }
        name = name.substring(SHOULD_PREFIX.length());
        if (name.length() == 1) {
            return name.toUpperCase();
        }
        return name.substring(0, 1).toUpperCase() + name.substring(1);
    }

    public static String propertyNameSafe(Method method) {
        if (!Getter.is(method)) {
            return method.getName();
        }
        String name = method.getName();
        if (name.startsWith(GET_PREFIX)) {
            return name.substring(GET_PREFIX.length());
        }
        if (name.startsWith(IS_PREFIX)) {
            return name.substring(IS_PREFIX.length());
        }
        if (name.startsWith(SHOULD_PREFIX)) {
            name = name.substring(SHOULD_PREFIX.length());
        }
        if (name.length() == 1) {
            return name.toUpperCase();
        }
        return name.substring(0, 1).toUpperCase() + name.substring(1);
    }

    public static String prefix(Property property) {
        return Types.isPrimitive(property.getTypeRef()) && Types.isBoolean(property.getTypeRef()) ? IS_PREFIX : GET_PREFIX;
    }
}

