/*
 * Decompiled with CFR 0.152.
 */
package io.sundr.model.utils;

import io.sundr.model.ClassRef;
import io.sundr.model.ClassRefBuilder;
import io.sundr.model.PrimitiveRef;
import io.sundr.model.PrimitiveRefBuilder;
import io.sundr.model.Property;
import io.sundr.model.TypeDef;
import io.sundr.model.TypeDefBuilder;
import io.sundr.model.TypeParamDef;
import io.sundr.model.TypeParamDefBuilder;
import io.sundr.model.TypeParamRef;
import io.sundr.model.TypeParamRefBuilder;
import io.sundr.model.TypeRef;
import io.sundr.model.functions.GetDefinition;
import io.sundr.model.repo.DefinitionRepository;
import io.sundr.model.utils.Collections;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.lang.model.element.Modifier;

public final class Types {
    private static final String JAVA_LANG_OBJECT = "java.lang.Object";
    private static final String JAVA_UTIL_OPTIONAL = "java.util.Optional";
    private static final String JAVA_UTIL_OPTIONAL_INT = "java.util.OptionalInt";
    private static final String JAVA_UTIL_OPTIONAL_DOUBLE = "java.util.OptionalDouble";
    private static final String JAVA_UTIL_OPTIONAL_LONG = "java.util.OptionalLong";
    private static final String OTHER = "other";
    private static final String DOT_REGEX = "\\.";
    public static final TypeDef OBJECT = TypeDef.OBJECT;
    public static final TypeRef OBJECT_REF = OBJECT.toInternalReference();
    public static final TypeDef BOOLEAN = TypeDef.forName((String)Boolean.class.getName());
    public static final TypeRef BOOLEAN_REF = BOOLEAN.toInternalReference();
    public static final PrimitiveRef PRIMITIVE_BOOLEAN_REF = ((PrimitiveRefBuilder)new PrimitiveRefBuilder().withName("boolean")).build();
    public static final PrimitiveRef PRIMITIVE_BYTE_REF = ((PrimitiveRefBuilder)new PrimitiveRefBuilder().withName("byte")).build();
    public static final PrimitiveRef PRIMITIVE_CHAR_REF = ((PrimitiveRefBuilder)new PrimitiveRefBuilder().withName("char")).build();
    public static final PrimitiveRef PRIMITIVE_SHORT_REF = ((PrimitiveRefBuilder)new PrimitiveRefBuilder().withName("short")).build();
    public static final PrimitiveRef PRIMITIVE_INT_REF = ((PrimitiveRefBuilder)new PrimitiveRefBuilder().withName("int")).build();
    public static final PrimitiveRef PRIMITIVE_LONG_REF = ((PrimitiveRefBuilder)new PrimitiveRefBuilder().withName("long")).build();
    public static final PrimitiveRef PRIMITIVE_DOUBLE_REF = ((PrimitiveRefBuilder)new PrimitiveRefBuilder().withName("double")).build();
    public static final PrimitiveRef PRIMITIVE_FLOAT_REF = ((PrimitiveRefBuilder)new PrimitiveRefBuilder().withName("float")).build();
    public static TypeRef[] PRIMITIVE_TYPES = new TypeRef[]{PRIMITIVE_BOOLEAN_REF, PRIMITIVE_BYTE_REF, PRIMITIVE_CHAR_REF, PRIMITIVE_SHORT_REF, PRIMITIVE_INT_REF, PRIMITIVE_LONG_REF, PRIMITIVE_DOUBLE_REF, PRIMITIVE_FLOAT_REF};
    public static TypeRef[] BOXED_PRIMITIVE_TYPES = new TypeRef[]{((ClassRefBuilder)new ClassRefBuilder().withFullyQualifiedName(Boolean.class.getName())).build(), ((ClassRefBuilder)new ClassRefBuilder().withFullyQualifiedName(Byte.class.getName())).build(), ((ClassRefBuilder)new ClassRefBuilder().withFullyQualifiedName(Character.class.getName())).build(), ((ClassRefBuilder)new ClassRefBuilder().withFullyQualifiedName(Short.class.getName())).build(), ((ClassRefBuilder)new ClassRefBuilder().withFullyQualifiedName(Integer.class.getName())).build(), ((ClassRefBuilder)new ClassRefBuilder().withFullyQualifiedName(Long.class.getName())).build(), ((ClassRefBuilder)new ClassRefBuilder().withFullyQualifiedName(Double.class.getName())).build(), ((ClassRefBuilder)new ClassRefBuilder().withFullyQualifiedName(Float.class.getName())).build()};
    public static String[] BOXED_PARSE_METHOD = new String[]{"parseBoolean", "parseByte", null, "parseShort", "parseInt", "parseLong", "parseDouble", "parseFloat"};

    private Types() {
    }

    public static TypeRef box(TypeRef ref) {
        if (ref instanceof PrimitiveRef) {
            int index = 0;
            for (TypeRef primitive : PRIMITIVE_TYPES) {
                if (primitive.equals(ref)) {
                    return BOXED_PRIMITIVE_TYPES[index];
                }
                ++index;
            }
        }
        return ref;
    }

    public static boolean isInstanceOf(TypeRef type, TypeDef targetType, Function<TypeRef, Boolean> function) {
        if (type instanceof ClassRef) {
            ClassRef classRef = (ClassRef)type;
            if (classRef.getFullyQualifiedName().equals(targetType.getFullyQualifiedName())) {
                return true;
            }
            if (type.equals(TypeDef.OBJECT.toInternalReference())) {
                return false;
            }
            TypeDef definition = (TypeDef)classRef.map((Function)GetDefinition.FUNCTION);
            for (TypeRef i : definition.getImplementsList()) {
                if (!function.apply(i).booleanValue()) continue;
                return true;
            }
            for (TypeRef e : definition.getExtendsList()) {
                if (!function.apply(e).booleanValue()) continue;
                return true;
            }
        }
        return false;
    }

    public static TypeParamDef getParameterDefinition(TypeRef typeRef, Collection<TypeParamDef> parameters) {
        String name = typeRef instanceof ClassRef ? ((ClassRef)typeRef).getFullyQualifiedName() : (typeRef instanceof TypeParamRef ? ((TypeParamRef)typeRef).getName() : (typeRef instanceof PrimitiveRef ? ((PrimitiveRef)typeRef).getName() : typeRef.toString()));
        for (TypeParamDef parameter : parameters) {
            if (!parameter.getName().equals(name)) continue;
            return parameter;
        }
        return null;
    }

    public static TypeParamRef newTypeParamRef(String letter) {
        return ((TypeParamRefBuilder)new TypeParamRefBuilder().withName(letter)).build();
    }

    public static TypeParamDef newTypeParamDef(String letter) {
        return ((TypeParamDefBuilder)new TypeParamDefBuilder().withName(letter)).build();
    }

    public static TypeDef unwrapGeneric(TypeDef base) {
        return ((TypeDefBuilder)new TypeDefBuilder(base).withParameters(new TypeParamDef[0])).build();
    }

    public static TypeDef typeGenericOf(TypeDef base, TypeParamDef ... parameters) {
        return ((TypeDefBuilder)new TypeDefBuilder(base).withParameters(parameters)).build();
    }

    public static TypeDef typeExtends(TypeDef base, ClassRef superClass) {
        return ((TypeDefBuilder)new TypeDefBuilder(base).withExtendsList(new ClassRef[]{superClass})).build();
    }

    public static TypeDef typeImplements(TypeDef base, ClassRef ... superClass) {
        return ((TypeDefBuilder)new TypeDefBuilder(base).withImplementsList(superClass)).build();
    }

    public static int modifiersToInt(Modifier ... modifiers) {
        return Types.modifiersToInt(Arrays.asList(modifiers));
    }

    public static int modifiersToInt(Collection<Modifier> modifiers) {
        int result = 0;
        for (Modifier m : modifiers) {
            switch (m) {
                case ABSTRACT: {
                    result |= 0x400;
                    break;
                }
                case FINAL: {
                    result |= 0x10;
                    break;
                }
                case NATIVE: {
                    result |= 0x100;
                    break;
                }
                case PRIVATE: {
                    result |= 2;
                    break;
                }
                case PROTECTED: {
                    result |= 4;
                    break;
                }
                case PUBLIC: {
                    result |= 1;
                    break;
                }
                case STATIC: {
                    result |= 8;
                    break;
                }
                case SYNCHRONIZED: {
                    result |= 0x20;
                    break;
                }
                case TRANSIENT: {
                    result |= 0x80;
                }
            }
        }
        return result;
    }

    public static String fullyQualifiedNameDiff(String left, String right) {
        String[] lparts = left.split(DOT_REGEX);
        String[] rparts = right.split(DOT_REGEX);
        int l = lparts.length - 1;
        for (int r = rparts.length - 1; l >= 0 && r >= 0; --r, --l) {
            if (lparts[l].equals(rparts[r])) continue;
            return rparts[r];
        }
        return OTHER;
    }

    public static boolean isEnum(TypeRef typeRef) {
        if (typeRef instanceof ClassRef) {
            ClassRef classRef = (ClassRef)typeRef;
            return ((TypeDef)classRef.map((Function)GetDefinition.FUNCTION)).isEnum();
        }
        return false;
    }

    public static boolean isAbstract(TypeRef typeRef) {
        DefinitionRepository repository = DefinitionRepository.getRepository();
        TypeDef def = repository.getDefinition(typeRef);
        if (def == null && typeRef instanceof ClassRef) {
            def = (TypeDef)((ClassRef)typeRef).map((Function)GetDefinition.FUNCTION);
        }
        return def != null ? def.isAbstract() : false;
    }

    public static boolean isConcrete(TypeRef typeRef) {
        DefinitionRepository repository = DefinitionRepository.getRepository();
        TypeDef def = repository.getDefinition(typeRef);
        if (def == null && typeRef instanceof ClassRef) {
            def = (TypeDef)((ClassRef)typeRef).map((Function)GetDefinition.FUNCTION);
        }
        return def != null ? !def.isAbstract() && !def.isInterface() : false;
    }

    public static boolean isPrimitive(TypeRef type) {
        return type instanceof PrimitiveRef;
    }

    public static boolean isMap(TypeRef type) {
        return Collections.IS_MAP.apply(type);
    }

    public static boolean isList(TypeRef type) {
        return Collections.IS_LIST.apply(type);
    }

    public static boolean isSet(TypeRef type) {
        return Collections.IS_SET.apply(type);
    }

    public static boolean isCollection(TypeRef type) {
        return Collections.IS_COLLECTION.apply(type);
    }

    public static boolean isBoolean(TypeRef type) {
        if (type instanceof PrimitiveRef) {
            return PRIMITIVE_BOOLEAN_REF.getName().equals(((PrimitiveRef)type).getName());
        }
        if (!(type instanceof ClassRef)) {
            return false;
        }
        return BOOLEAN_REF.equals(type);
    }

    public static boolean isArray(TypeRef type) {
        if (type instanceof ClassRef) {
            return ((ClassRef)type).getDimensions() > 0;
        }
        if (type instanceof PrimitiveRef) {
            return ((PrimitiveRef)type).getDimensions() > 0;
        }
        if (type instanceof TypeParamRef) {
            return ((TypeParamRef)type).getDimensions() > 0;
        }
        return false;
    }

    public static boolean isOptional(TypeRef type) {
        if (!(type instanceof ClassRef)) {
            return false;
        }
        return JAVA_UTIL_OPTIONAL.equals(((TypeDef)((ClassRef)type).map((Function)GetDefinition.FUNCTION)).getFullyQualifiedName());
    }

    public static boolean isOptionalInt(TypeRef type) {
        if (!(type instanceof ClassRef)) {
            return false;
        }
        return JAVA_UTIL_OPTIONAL_INT.equals(((TypeDef)((ClassRef)type).map((Function)GetDefinition.FUNCTION)).getFullyQualifiedName());
    }

    public static boolean isOptionalDouble(TypeRef type) {
        if (!(type instanceof ClassRef)) {
            return false;
        }
        return JAVA_UTIL_OPTIONAL_DOUBLE.equals(((TypeDef)((ClassRef)type).map((Function)GetDefinition.FUNCTION)).getFullyQualifiedName());
    }

    public static boolean isOptionalLong(TypeRef type) {
        if (!(type instanceof ClassRef)) {
            return false;
        }
        return JAVA_UTIL_OPTIONAL_LONG.equals(((TypeDef)((ClassRef)type).map((Function)GetDefinition.FUNCTION)).getFullyQualifiedName());
    }

    public static boolean isJdkType(TypeRef type) {
        if (!(type instanceof ClassRef)) {
            return false;
        }
        String packageName = ((TypeDef)((ClassRef)type).map((Function)GetDefinition.FUNCTION)).getPackageName();
        if (packageName.startsWith("java.")) {
            return true;
        }
        if (packageName.startsWith("sun.")) {
            return true;
        }
        if (packageName.startsWith("com.sun.")) {
            return true;
        }
        return packageName.startsWith("com.ibm.jit.");
    }

    public static boolean hasMethod(TypeDef typeDef, String method) {
        return Types.unrollHierarchy(typeDef).stream().flatMap(h -> h.getMethods().stream()).filter(m -> method.equals(m.getName())).findAny().isPresent();
    }

    public static boolean hasProperty(TypeDef typeDef, String property) {
        return Types.unrollHierarchy(typeDef).stream().flatMap(h -> h.getProperties().stream()).filter(p -> property.equals(p.getName())).findAny().isPresent();
    }

    public static List<Property> allProperties(TypeDef typeDef) {
        return Types.unrollHierarchy(typeDef).stream().flatMap(h -> h.getProperties().stream()).collect(Collectors.toList());
    }

    public static Set<TypeDef> unrollHierarchy(TypeDef typeDef) {
        if (OBJECT.equals((Object)typeDef)) {
            return new HashSet<TypeDef>();
        }
        HashSet<TypeDef> hierarchy = new HashSet<TypeDef>();
        hierarchy.add(typeDef);
        hierarchy.addAll(typeDef.getExtendsList().stream().flatMap(s -> Types.unrollHierarchy((TypeDef)s.map((Function)GetDefinition.FUNCTION)).stream()).collect(Collectors.toSet()));
        return hierarchy;
    }

    public static String toClassName(Object o) {
        if (o instanceof String) {
            return (String)o;
        }
        if (o instanceof ClassRef) {
            return ((ClassRef)o).getFullyQualifiedName();
        }
        if (o instanceof TypeDef) {
            return ((TypeDef)o).getFullyQualifiedName();
        }
        return String.valueOf(o);
    }

    public static void visitParents(TypeDef type, List<TypeDef> types) {
        Types.visitParents(type, types, new ArrayList<TypeDef>());
    }

    public static void visitParents(TypeDef type, List<TypeDef> types, List<TypeDef> visited) {
        if (type == null || JAVA_LANG_OBJECT.equals(type.getFullyQualifiedName())) {
            return;
        }
        if (visited.contains(type)) {
            return;
        }
        visited.add(type);
        ArrayList allRefs = new ArrayList();
        allRefs.addAll(type.getImplementsList());
        allRefs.addAll(type.getExtendsList());
        for (TypeRef ref : allRefs) {
            TypeDef parent = DefinitionRepository.getRepository().getDefinition(ref);
            Types.visitParents(parent, types, visited);
        }
        types.add(type);
    }
}

