/*
 * Decompiled with CFR 0.152.
 */
package io.sundr.model.utils;

import io.sundr.SundrException;
import io.sundr.model.ClassRef;
import io.sundr.model.Method;
import io.sundr.model.Property;
import io.sundr.model.RichTypeDef;
import io.sundr.model.TypeDef;
import io.sundr.model.repo.DefinitionRepository;
import io.sundr.utils.Strings;

public class Setter {
    public static Method find(TypeDef clazz, Property property) {
        TypeDef current = clazz;
        while (current != null && !current.equals((Object)TypeDef.OBJECT)) {
            for (Method method : current.getMethods()) {
                if (!Setter.isApplicable(method, property, true)) continue;
                return method;
            }
            for (Method method : current.getMethods()) {
                if (!Setter.isApplicable(method, property, false)) continue;
                return method;
            }
            if (!current.getExtendsList().iterator().hasNext()) break;
            String fqn = ((ClassRef)current.getExtendsList().iterator().next()).getFullyQualifiedName();
            current = DefinitionRepository.getRepository().getDefinition(fqn);
        }
        throw new SundrException("No setter found for property: " + property.getName() + " on class: " + clazz.getFullyQualifiedName());
    }

    public static boolean has(TypeDef clazz, Property property) {
        for (Method method : clazz.getMethods()) {
            if (!Setter.isApplicable(method, property)) continue;
            return true;
        }
        return false;
    }

    public static boolean isApplicable(Method method, Property property) {
        return Setter.isApplicable(method, property, false);
    }

    private static boolean isApplicable(Method method, Property property, boolean strict) {
        if (method.getArguments().size() != 1) {
            return false;
        }
        if (!((Property)method.getArguments().get(0)).getTypeRef().equals(property.getTypeRef())) {
            return false;
        }
        String capitalized = Strings.capitalizeFirst((String)property.getName());
        if (method.getName().endsWith("set" + capitalized)) {
            return true;
        }
        return !strict && method.getName().endsWith("set" + property.getNameCapitalized());
    }

    public static boolean hasOrInherits(RichTypeDef clazz, Property property) {
        for (Method method : clazz.getAllMethods()) {
            if (!Setter.isApplicable(method, property)) continue;
            return true;
        }
        return false;
    }

    public static boolean hasOrInherits(TypeDef clazz, Property property) {
        TypeDef current = clazz;
        while (current != null && !current.equals((Object)TypeDef.OBJECT)) {
            for (Method method : current.getMethods()) {
                if (!Setter.isApplicable(method, property)) continue;
                return true;
            }
            if (!current.getExtendsList().isEmpty()) {
                String fqn = ((ClassRef)current.getExtendsList().iterator().next()).getFullyQualifiedName();
                current = DefinitionRepository.getRepository().getDefinition(fqn);
                continue;
            }
            current = null;
        }
        return false;
    }
}

