/*
 * Decompiled with CFR 0.152.
 */
package io.sundr.model.functions;

import io.sundr.builder.Visitor;
import io.sundr.model.ClassRef;
import io.sundr.model.ClassRefBuilder;
import io.sundr.model.TypeDef;
import io.sundr.model.TypeRef;
import io.sundr.model.WildcardRef;
import io.sundr.model.functions.GetDefinition;
import io.sundr.model.utils.TypeArguments;
import io.sundr.model.visitors.ApplyTypeParamMappingToTypeArguments;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class TypeCast
implements Function<TypeRef, Optional<ClassRef>> {
    private final ClassRef expectedType;

    private TypeCast(ClassRef expectedType) {
        this.expectedType = expectedType;
    }

    public static TypeCast to(ClassRef expectedType) {
        TypeCast.assertNoArray(expectedType);
        TypeCast.assertAllArgumentsAreWildcards(expectedType);
        return new TypeCast(expectedType);
    }

    private static void assertNoArray(ClassRef expectedType) {
        if (expectedType.getDimensions() != 0) {
            throw new IllegalArgumentException("Arrays are not supported: " + expectedType);
        }
    }

    private static void assertAllArgumentsAreWildcards(ClassRef expectedType) {
        for (TypeRef argument : expectedType.getArguments()) {
            if (argument instanceof WildcardRef && ((WildcardRef)argument).getBounds().isEmpty()) continue;
            throw new IllegalArgumentException("Argument " + argument + " is not an unbounded wildcard in " + expectedType);
        }
    }

    @Override
    public Optional<ClassRef> apply(TypeRef type) {
        if (type instanceof ClassRef) {
            Set types = this.findMatchingTypes((ClassRef)type).collect(Collectors.toSet());
            if (types.size() > 1) {
                throw new IllegalStateException("Type " + type + " extends or implements " + this.expectedType + " multiple times: " + types + ". This is not legal in Java");
            }
            return types.stream().findAny();
        }
        return Optional.empty();
    }

    private Stream<ClassRef> findMatchingTypes(ClassRef type) {
        if (type.getFullyQualifiedName().equals(this.expectedType.getFullyQualifiedName())) {
            return Stream.of(type);
        }
        TypeDef definition = GetDefinition.of(type);
        Stream supertypes = Stream.concat(definition.getImplementsList().stream(), definition.getExtendsList().stream());
        return supertypes.filter(supertype -> !type.equals(supertype)).flatMap(this::findMatchingTypes).map(supertype -> this.bindArguments(type, (ClassRef)supertype));
    }

    private ClassRef bindArguments(ClassRef type, ClassRef supertype) {
        Map<String, TypeRef> mappings = TypeArguments.getGenericArgumentsMappings(type);
        return ((ClassRefBuilder)new ClassRefBuilder(supertype).accept(new Visitor[]{new ApplyTypeParamMappingToTypeArguments(mappings)})).build();
    }
}

