/*
 * Decompiled with CFR 0.152.
 */
package io.sundr.model;

import io.sundr.builder.BaseFluent;
import io.sundr.builder.Nested;
import io.sundr.model.Declare;
import io.sundr.model.Expression;
import io.sundr.model.Property;
import io.sundr.model.PropertyBuilder;
import io.sundr.model.PropertyFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;

public class DeclareFluent<A extends DeclareFluent<A>>
extends BaseFluent<A> {
    private ArrayList<PropertyBuilder> properties = new ArrayList();
    private Optional<Expression> value = Optional.empty();

    public DeclareFluent() {
    }

    public DeclareFluent(Declare instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(Declare instance) {
        if (instance != null) {
            this.withProperties(instance.getProperties());
            this.withValue(instance.getValue());
        }
    }

    public A addToProperties(int index, Property item) {
        if (this.properties == null) {
            this.properties = new ArrayList();
        }
        PropertyBuilder builder = new PropertyBuilder(item);
        if (index < 0 || index >= this.properties.size()) {
            this._visitables.get((Object)"properties").add(builder);
            this.properties.add(builder);
        } else {
            this._visitables.get((Object)"properties").add(index, builder);
            this.properties.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToProperties(int index, Property item) {
        if (this.properties == null) {
            this.properties = new ArrayList();
        }
        PropertyBuilder builder = new PropertyBuilder(item);
        if (index < 0 || index >= this.properties.size()) {
            this._visitables.get((Object)"properties").add(builder);
            this.properties.add(builder);
        } else {
            this._visitables.get((Object)"properties").set(index, builder);
            this.properties.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToProperties(Property ... items) {
        if (this.properties == null) {
            this.properties = new ArrayList();
        }
        for (Property item : items) {
            PropertyBuilder builder = new PropertyBuilder(item);
            this._visitables.get((Object)"properties").add(builder);
            this.properties.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToProperties(Collection<Property> items) {
        if (this.properties == null) {
            this.properties = new ArrayList();
        }
        for (Property item : items) {
            PropertyBuilder builder = new PropertyBuilder(item);
            this._visitables.get((Object)"properties").add(builder);
            this.properties.add(builder);
        }
        return (A)((Object)this);
    }

    public A removeFromProperties(Property ... items) {
        if (this.properties == null) {
            return (A)((Object)this);
        }
        for (Property item : items) {
            PropertyBuilder builder = new PropertyBuilder(item);
            this._visitables.get((Object)"properties").remove((Object)builder);
            this.properties.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromProperties(Collection<Property> items) {
        if (this.properties == null) {
            return (A)((Object)this);
        }
        for (Property item : items) {
            PropertyBuilder builder = new PropertyBuilder(item);
            this._visitables.get((Object)"properties").remove((Object)builder);
            this.properties.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromProperties(Predicate<PropertyBuilder> predicate) {
        if (this.properties == null) {
            return (A)((Object)this);
        }
        Iterator<PropertyBuilder> each = this.properties.iterator();
        List visitables = this._visitables.get((Object)"properties");
        while (each.hasNext()) {
            PropertyBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public List<Property> buildProperties() {
        return this.properties != null ? DeclareFluent.build(this.properties) : null;
    }

    public Property buildProperty(int index) {
        return this.properties.get(index).build();
    }

    public Property buildFirstProperty() {
        return this.properties.get(0).build();
    }

    public Property buildLastProperty() {
        return this.properties.get(this.properties.size() - 1).build();
    }

    public Property buildMatchingProperty(Predicate<PropertyBuilder> predicate) {
        for (PropertyBuilder item : this.properties) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingProperty(Predicate<PropertyBuilder> predicate) {
        for (PropertyBuilder item : this.properties) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withProperties(List<Property> properties) {
        if (this.properties != null) {
            this._visitables.get((Object)"properties").clear();
        }
        if (properties != null) {
            this.properties = new ArrayList();
            for (Property item : properties) {
                this.addToProperties(item);
            }
        } else {
            this.properties = null;
        }
        return (A)((Object)this);
    }

    public A withProperties(Property ... properties) {
        if (this.properties != null) {
            this.properties.clear();
            this._visitables.remove((Object)"properties");
        }
        if (properties != null) {
            for (Property item : properties) {
                this.addToProperties(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasProperties() {
        return this.properties != null && !this.properties.isEmpty();
    }

    public PropertiesNested<A> addNewProperty() {
        return new PropertiesNested(-1, null);
    }

    public PropertiesNested<A> addNewPropertyLike(Property item) {
        return new PropertiesNested(-1, item);
    }

    public PropertiesNested<A> setNewPropertyLike(int index, Property item) {
        return new PropertiesNested(index, item);
    }

    public PropertiesNested<A> editProperty(int index) {
        if (this.properties.size() <= index) {
            throw new RuntimeException("Can't edit properties. Index exceeds size.");
        }
        return this.setNewPropertyLike(index, this.buildProperty(index));
    }

    public PropertiesNested<A> editFirstProperty() {
        if (this.properties.size() == 0) {
            throw new RuntimeException("Can't edit first properties. The list is empty.");
        }
        return this.setNewPropertyLike(0, this.buildProperty(0));
    }

    public PropertiesNested<A> editLastProperty() {
        int index = this.properties.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last properties. The list is empty.");
        }
        return this.setNewPropertyLike(index, this.buildProperty(index));
    }

    public PropertiesNested<A> editMatchingProperty(Predicate<PropertyBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.properties.size(); ++i) {
            if (!predicate.test(this.properties.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching properties. No match found.");
        }
        return this.setNewPropertyLike(index, this.buildProperty(index));
    }

    public A withValue(Optional<Expression> value) {
        this.value = value == null || !value.isPresent() ? Optional.empty() : value;
        return (A)((Object)this);
    }

    public A withValue(Expression value) {
        this.value = value == null ? Optional.empty() : Optional.of(value);
        return (A)((Object)this);
    }

    public Optional<Expression> getValue() {
        return this.value;
    }

    public boolean hasValue() {
        return this.value != null && this.value.isPresent();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        DeclareFluent that = (DeclareFluent)((Object)o);
        if (!Objects.equals(this.properties, that.properties)) {
            return false;
        }
        return Objects.equals(this.value, that.value);
    }

    public int hashCode() {
        return Objects.hash(this.properties, this.value, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.properties != null && !this.properties.isEmpty()) {
            sb.append("properties:");
            sb.append(this.properties + ",");
        }
        if (this.value != null) {
            sb.append("value:");
            sb.append(this.value);
        }
        sb.append("}");
        return sb.toString();
    }

    public class PropertiesNested<N>
    extends PropertyFluent<PropertiesNested<N>>
    implements Nested<N> {
        PropertyBuilder builder;
        int index;

        PropertiesNested(int index, Property item) {
            this.index = index;
            this.builder = new PropertyBuilder(this, item);
        }

        public N and() {
            return (N)DeclareFluent.this.setToProperties(this.index, this.builder.build());
        }

        public N endProperty() {
            return this.and();
        }
    }
}

