/*
 * Decompiled with CFR 0.152.
 */
package io.sundr.model;

import io.sundr.builder.BaseFluent;
import io.sundr.builder.Nested;
import io.sundr.builder.VisitableBuilder;
import io.sundr.model.Assign;
import io.sundr.model.AssignBuilder;
import io.sundr.model.AssignFluent;
import io.sundr.model.Block;
import io.sundr.model.BlockBuilder;
import io.sundr.model.BlockFluent;
import io.sundr.model.Break;
import io.sundr.model.BreakBuilder;
import io.sundr.model.BreakFluent;
import io.sundr.model.Continue;
import io.sundr.model.ContinueBuilder;
import io.sundr.model.ContinueFluent;
import io.sundr.model.Declare;
import io.sundr.model.DeclareBuilder;
import io.sundr.model.DeclareFluent;
import io.sundr.model.Do;
import io.sundr.model.DoBuilder;
import io.sundr.model.DoFluent;
import io.sundr.model.For;
import io.sundr.model.ForBuilder;
import io.sundr.model.ForFluent;
import io.sundr.model.Foreach;
import io.sundr.model.ForeachBuilder;
import io.sundr.model.ForeachFluent;
import io.sundr.model.If;
import io.sundr.model.IfBuilder;
import io.sundr.model.IfFluent;
import io.sundr.model.Lambda;
import io.sundr.model.LambdaBuilder;
import io.sundr.model.MethodCall;
import io.sundr.model.MethodCallBuilder;
import io.sundr.model.MethodCallFluent;
import io.sundr.model.Return;
import io.sundr.model.ReturnBuilder;
import io.sundr.model.ReturnFluent;
import io.sundr.model.Statement;
import io.sundr.model.StringStatement;
import io.sundr.model.StringStatementBuilder;
import io.sundr.model.StringStatementFluent;
import io.sundr.model.Switch;
import io.sundr.model.SwitchBuilder;
import io.sundr.model.SwitchFluent;
import io.sundr.model.While;
import io.sundr.model.WhileBuilder;
import io.sundr.model.WhileFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;

public class LambdaFluent<A extends LambdaFluent<A>>
extends BaseFluent<A> {
    private List<String> parameters = new ArrayList<String>();
    private VisitableBuilder<? extends Statement, ?> statement;

    public LambdaFluent() {
    }

    public LambdaFluent(Lambda instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(Lambda instance) {
        if (instance != null) {
            this.withParameters(instance.getParameters());
            this.withStatement(instance.getStatement());
        }
    }

    public A addToParameters(int index, String item) {
        if (this.parameters == null) {
            this.parameters = new ArrayList<String>();
        }
        this.parameters.add(index, item);
        return (A)((Object)this);
    }

    public A setToParameters(int index, String item) {
        if (this.parameters == null) {
            this.parameters = new ArrayList<String>();
        }
        this.parameters.set(index, item);
        return (A)((Object)this);
    }

    public A addToParameters(String ... items) {
        if (this.parameters == null) {
            this.parameters = new ArrayList<String>();
        }
        for (String item : items) {
            this.parameters.add(item);
        }
        return (A)((Object)this);
    }

    public A addAllToParameters(Collection<String> items) {
        if (this.parameters == null) {
            this.parameters = new ArrayList<String>();
        }
        for (String item : items) {
            this.parameters.add(item);
        }
        return (A)((Object)this);
    }

    public A removeFromParameters(String ... items) {
        if (this.parameters == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.parameters.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeAllFromParameters(Collection<String> items) {
        if (this.parameters == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.parameters.remove(item);
        }
        return (A)((Object)this);
    }

    public List<String> getParameters() {
        return this.parameters;
    }

    public String getParameter(int index) {
        return this.parameters.get(index);
    }

    public String getFirstParameter() {
        return this.parameters.get(0);
    }

    public String getLastParameter() {
        return this.parameters.get(this.parameters.size() - 1);
    }

    public String getMatchingParameter(Predicate<String> predicate) {
        for (String item : this.parameters) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingParameter(Predicate<String> predicate) {
        for (String item : this.parameters) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withParameters(List<String> parameters) {
        if (parameters != null) {
            this.parameters = new ArrayList<String>();
            for (String item : parameters) {
                this.addToParameters(item);
            }
        } else {
            this.parameters = null;
        }
        return (A)((Object)this);
    }

    public A withParameters(String ... parameters) {
        if (this.parameters != null) {
            this.parameters.clear();
            this._visitables.remove((Object)"parameters");
        }
        if (parameters != null) {
            for (String item : parameters) {
                this.addToParameters(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasParameters() {
        return this.parameters != null && !this.parameters.isEmpty();
    }

    public Statement buildStatement() {
        return this.statement != null ? (Statement)this.statement.build() : null;
    }

    public A withStatement(Statement statement) {
        if (statement == null) {
            this.statement = null;
            this._visitables.remove((Object)"statement");
            return (A)((Object)this);
        }
        VisitableBuilder builder = LambdaFluent.builder(statement);
        this._visitables.get((Object)"statement").clear();
        this._visitables.get((Object)"statement").add(builder);
        this.statement = builder;
        return (A)((Object)this);
    }

    public boolean hasStatement() {
        return this.statement != null;
    }

    public MethodCallStatementNested<A> withNewMethodCallStatement() {
        return new MethodCallStatementNested(null);
    }

    public MethodCallStatementNested<A> withNewMethodCallStatementLike(MethodCall item) {
        return new MethodCallStatementNested(item);
    }

    public SwitchStatementNested<A> withNewSwitchStatement() {
        return new SwitchStatementNested(null);
    }

    public SwitchStatementNested<A> withNewSwitchStatementLike(Switch item) {
        return new SwitchStatementNested(item);
    }

    public BreakStatementNested<A> withNewBreakStatement() {
        return new BreakStatementNested(null);
    }

    public BreakStatementNested<A> withNewBreakStatementLike(Break item) {
        return new BreakStatementNested(item);
    }

    public DeclareStatementNested<A> withNewDeclareStatement() {
        return new DeclareStatementNested(null);
    }

    public DeclareStatementNested<A> withNewDeclareStatementLike(Declare item) {
        return new DeclareStatementNested(item);
    }

    public A withNewDeclareStatement(Class type, String name) {
        return this.withStatement((Statement)new Declare(type, name));
    }

    public A withNewDeclareStatement(Class type, String name, Object value) {
        return this.withStatement((Statement)new Declare(type, name, value));
    }

    public WhileStatementNested<A> withNewWhileStatement() {
        return new WhileStatementNested(null);
    }

    public WhileStatementNested<A> withNewWhileStatementLike(While item) {
        return new WhileStatementNested(item);
    }

    public ContinueStatementNested<A> withNewContinueStatement() {
        return new ContinueStatementNested(null);
    }

    public ContinueStatementNested<A> withNewContinueStatementLike(Continue item) {
        return new ContinueStatementNested(item);
    }

    public StringStatementNested<A> withNewStringStatement() {
        return new StringStatementNested(null);
    }

    public StringStatementNested<A> withNewStringStatementLike(StringStatement item) {
        return new StringStatementNested(item);
    }

    public A withNewStringStatement(String data) {
        return this.withStatement((Statement)new StringStatement(data));
    }

    public A withNewStringStatement(String data, Object[] parameters) {
        return this.withStatement((Statement)new StringStatement(data, parameters));
    }

    public DoStatementNested<A> withNewDoStatement() {
        return new DoStatementNested(null);
    }

    public DoStatementNested<A> withNewDoStatementLike(Do item) {
        return new DoStatementNested(item);
    }

    public ForeachStatementNested<A> withNewForeachStatement() {
        return new ForeachStatementNested(null);
    }

    public ForeachStatementNested<A> withNewForeachStatementLike(Foreach item) {
        return new ForeachStatementNested(item);
    }

    public BlockStatementNested<A> withNewBlockStatement() {
        return new BlockStatementNested(null);
    }

    public BlockStatementNested<A> withNewBlockStatementLike(Block item) {
        return new BlockStatementNested(item);
    }

    public IfStatementNested<A> withNewIfStatement() {
        return new IfStatementNested(null);
    }

    public IfStatementNested<A> withNewIfStatementLike(If item) {
        return new IfStatementNested(item);
    }

    public LambdaStatementNested<A> withNewLambdaStatement() {
        return new LambdaStatementNested(null);
    }

    public LambdaStatementNested<A> withNewLambdaStatementLike(Lambda item) {
        return new LambdaStatementNested(item);
    }

    public ReturnStatementNested<A> withNewReturnStatement() {
        return new ReturnStatementNested(null);
    }

    public ReturnStatementNested<A> withNewReturnStatementLike(Return item) {
        return new ReturnStatementNested(item);
    }

    public A withNewReturnStatement(Object object) {
        return this.withStatement((Statement)new Return(object));
    }

    public AssignStatementNested<A> withNewAssignStatement() {
        return new AssignStatementNested(null);
    }

    public AssignStatementNested<A> withNewAssignStatementLike(Assign item) {
        return new AssignStatementNested(item);
    }

    public ForStatementNested<A> withNewForStatement() {
        return new ForStatementNested(null);
    }

    public ForStatementNested<A> withNewForStatementLike(For item) {
        return new ForStatementNested(item);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        LambdaFluent that = (LambdaFluent)((Object)o);
        if (!Objects.equals(this.parameters, that.parameters)) {
            return false;
        }
        return Objects.equals(this.statement, that.statement);
    }

    public int hashCode() {
        return Objects.hash(this.parameters, this.statement, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.parameters != null && !this.parameters.isEmpty()) {
            sb.append("parameters:");
            sb.append(this.parameters + ",");
        }
        if (this.statement != null) {
            sb.append("statement:");
            sb.append(this.statement);
        }
        sb.append("}");
        return sb.toString();
    }

    protected static <T> VisitableBuilder<T, ?> builder(Object item) {
        switch (item.getClass().getName()) {
            case "io.sundr.model.MethodCall": {
                return new MethodCallBuilder((MethodCall)item);
            }
            case "io.sundr.model.Switch": {
                return new SwitchBuilder((Switch)item);
            }
            case "io.sundr.model.Break": {
                return new BreakBuilder((Break)item);
            }
            case "io.sundr.model.Declare": {
                return new DeclareBuilder((Declare)item);
            }
            case "io.sundr.model.While": {
                return new WhileBuilder((While)item);
            }
            case "io.sundr.model.Continue": {
                return new ContinueBuilder((Continue)item);
            }
            case "io.sundr.model.StringStatement": {
                return new StringStatementBuilder((StringStatement)item);
            }
            case "io.sundr.model.Do": {
                return new DoBuilder((Do)item);
            }
            case "io.sundr.model.Foreach": {
                return new ForeachBuilder((Foreach)item);
            }
            case "io.sundr.model.Block": {
                return new BlockBuilder((Block)item);
            }
            case "io.sundr.model.If": {
                return new IfBuilder((If)item);
            }
            case "io.sundr.model.Lambda": {
                return new LambdaBuilder((Lambda)item);
            }
            case "io.sundr.model.Return": {
                return new ReturnBuilder((Return)item);
            }
            case "io.sundr.model.Assign": {
                return new AssignBuilder((Assign)item);
            }
            case "io.sundr.model.For": {
                return new ForBuilder((For)item);
            }
        }
        return LambdaFluent.builderOf((Object)item);
    }

    public class ForStatementNested<N>
    extends ForFluent<ForStatementNested<N>>
    implements Nested<N> {
        ForBuilder builder;

        ForStatementNested(For item) {
            this.builder = new ForBuilder(this, item);
        }

        public N and() {
            return (N)LambdaFluent.this.withStatement((Statement)this.builder.build());
        }

        public N endForStatement() {
            return this.and();
        }
    }

    public class AssignStatementNested<N>
    extends AssignFluent<AssignStatementNested<N>>
    implements Nested<N> {
        AssignBuilder builder;

        AssignStatementNested(Assign item) {
            this.builder = new AssignBuilder(this, item);
        }

        public N and() {
            return (N)LambdaFluent.this.withStatement((Statement)this.builder.build());
        }

        public N endAssignStatement() {
            return this.and();
        }
    }

    public class ReturnStatementNested<N>
    extends ReturnFluent<ReturnStatementNested<N>>
    implements Nested<N> {
        ReturnBuilder builder;

        ReturnStatementNested(Return item) {
            this.builder = new ReturnBuilder(this, item);
        }

        public N and() {
            return (N)LambdaFluent.this.withStatement((Statement)this.builder.build());
        }

        public N endReturnStatement() {
            return this.and();
        }
    }

    public class LambdaStatementNested<N>
    extends LambdaFluent<LambdaStatementNested<N>>
    implements Nested<N> {
        LambdaBuilder builder;

        LambdaStatementNested(Lambda item) {
            this.builder = new LambdaBuilder(this, item);
        }

        public N and() {
            return (N)LambdaFluent.this.withStatement((Statement)this.builder.build());
        }

        public N endLambdaStatement() {
            return this.and();
        }
    }

    public class IfStatementNested<N>
    extends IfFluent<IfStatementNested<N>>
    implements Nested<N> {
        IfBuilder builder;

        IfStatementNested(If item) {
            this.builder = new IfBuilder(this, item);
        }

        public N and() {
            return (N)LambdaFluent.this.withStatement((Statement)this.builder.build());
        }

        public N endIfStatement() {
            return this.and();
        }
    }

    public class BlockStatementNested<N>
    extends BlockFluent<BlockStatementNested<N>>
    implements Nested<N> {
        BlockBuilder builder;

        BlockStatementNested(Block item) {
            this.builder = new BlockBuilder(this, item);
        }

        public N and() {
            return (N)LambdaFluent.this.withStatement((Statement)this.builder.build());
        }

        public N endBlockStatement() {
            return this.and();
        }
    }

    public class ForeachStatementNested<N>
    extends ForeachFluent<ForeachStatementNested<N>>
    implements Nested<N> {
        ForeachBuilder builder;

        ForeachStatementNested(Foreach item) {
            this.builder = new ForeachBuilder(this, item);
        }

        public N and() {
            return (N)LambdaFluent.this.withStatement((Statement)this.builder.build());
        }

        public N endForeachStatement() {
            return this.and();
        }
    }

    public class DoStatementNested<N>
    extends DoFluent<DoStatementNested<N>>
    implements Nested<N> {
        DoBuilder builder;

        DoStatementNested(Do item) {
            this.builder = new DoBuilder(this, item);
        }

        public N and() {
            return (N)LambdaFluent.this.withStatement((Statement)this.builder.build());
        }

        public N endDoStatement() {
            return this.and();
        }
    }

    public class StringStatementNested<N>
    extends StringStatementFluent<StringStatementNested<N>>
    implements Nested<N> {
        StringStatementBuilder builder;

        StringStatementNested(StringStatement item) {
            this.builder = new StringStatementBuilder(this, item);
        }

        public N and() {
            return (N)LambdaFluent.this.withStatement((Statement)this.builder.build());
        }

        public N endStringStatement() {
            return this.and();
        }
    }

    public class ContinueStatementNested<N>
    extends ContinueFluent<ContinueStatementNested<N>>
    implements Nested<N> {
        ContinueBuilder builder;

        ContinueStatementNested(Continue item) {
            this.builder = new ContinueBuilder(this, item);
        }

        public N and() {
            return (N)LambdaFluent.this.withStatement((Statement)this.builder.build());
        }

        public N endContinueStatement() {
            return this.and();
        }
    }

    public class WhileStatementNested<N>
    extends WhileFluent<WhileStatementNested<N>>
    implements Nested<N> {
        WhileBuilder builder;

        WhileStatementNested(While item) {
            this.builder = new WhileBuilder(this, item);
        }

        public N and() {
            return (N)LambdaFluent.this.withStatement((Statement)this.builder.build());
        }

        public N endWhileStatement() {
            return this.and();
        }
    }

    public class DeclareStatementNested<N>
    extends DeclareFluent<DeclareStatementNested<N>>
    implements Nested<N> {
        DeclareBuilder builder;

        DeclareStatementNested(Declare item) {
            this.builder = new DeclareBuilder(this, item);
        }

        public N and() {
            return (N)LambdaFluent.this.withStatement((Statement)this.builder.build());
        }

        public N endDeclareStatement() {
            return this.and();
        }
    }

    public class BreakStatementNested<N>
    extends BreakFluent<BreakStatementNested<N>>
    implements Nested<N> {
        BreakBuilder builder;

        BreakStatementNested(Break item) {
            this.builder = new BreakBuilder(this, item);
        }

        public N and() {
            return (N)LambdaFluent.this.withStatement((Statement)this.builder.build());
        }

        public N endBreakStatement() {
            return this.and();
        }
    }

    public class SwitchStatementNested<N>
    extends SwitchFluent<SwitchStatementNested<N>>
    implements Nested<N> {
        SwitchBuilder builder;

        SwitchStatementNested(Switch item) {
            this.builder = new SwitchBuilder(this, item);
        }

        public N and() {
            return (N)LambdaFluent.this.withStatement((Statement)this.builder.build());
        }

        public N endSwitchStatement() {
            return this.and();
        }
    }

    public class MethodCallStatementNested<N>
    extends MethodCallFluent<MethodCallStatementNested<N>>
    implements Nested<N> {
        MethodCallBuilder builder;

        MethodCallStatementNested(MethodCall item) {
            this.builder = new MethodCallBuilder(this, item);
        }

        public N and() {
            return (N)LambdaFluent.this.withStatement((Statement)this.builder.build());
        }

        public N endMethodCallStatement() {
            return this.and();
        }
    }
}

