/*
 * Decompiled with CFR 0.152.
 */
package io.sundr.model;

import io.sundr.builder.Nested;
import io.sundr.model.AnnotationRef;
import io.sundr.model.AnnotationRefBuilder;
import io.sundr.model.AnnotationRefFluent;
import io.sundr.model.ClassRef;
import io.sundr.model.ClassRefBuilder;
import io.sundr.model.ClassRefFluent;
import io.sundr.model.Kind;
import io.sundr.model.Method;
import io.sundr.model.MethodBuilder;
import io.sundr.model.MethodFluent;
import io.sundr.model.ModifierSupportFluent;
import io.sundr.model.Property;
import io.sundr.model.PropertyBuilder;
import io.sundr.model.PropertyFluent;
import io.sundr.model.TypeDef;
import io.sundr.model.TypeDefBuilder;
import io.sundr.model.TypeParamDef;
import io.sundr.model.TypeParamDefBuilder;
import io.sundr.model.TypeParamDefFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;

public class TypeDefFluent<A extends TypeDefFluent<A>>
extends ModifierSupportFluent<A> {
    private Kind kind;
    private String packageName;
    private String name;
    private List<String> comments = new ArrayList<String>();
    private ArrayList<AnnotationRefBuilder> annotations = new ArrayList();
    private ArrayList<ClassRefBuilder> extendsList = new ArrayList();
    private ArrayList<ClassRefBuilder> implementsList = new ArrayList();
    private ArrayList<TypeParamDefBuilder> parameters = new ArrayList();
    private ArrayList<PropertyBuilder> properties = new ArrayList();
    private ArrayList<MethodBuilder> constructors = new ArrayList();
    private ArrayList<MethodBuilder> methods = new ArrayList();
    private String outerTypeName;
    private ArrayList<TypeDefBuilder> innerTypes = new ArrayList();

    public TypeDefFluent() {
    }

    public TypeDefFluent(TypeDef instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(TypeDef instance) {
        if (instance != null) {
            this.withKind(instance.getKind());
            this.withPackageName(instance.getPackageName());
            this.withName(instance.getName());
            this.withComments(instance.getComments());
            this.withAnnotations(instance.getAnnotations());
            this.withExtendsList(instance.getExtendsList());
            this.withImplementsList(instance.getImplementsList());
            this.withParameters(instance.getParameters());
            this.withProperties(instance.getProperties());
            this.withConstructors(instance.getConstructors());
            this.withMethods(instance.getMethods());
            this.withOuterTypeName(instance.getOuterTypeName());
            this.withInnerTypes(instance.getInnerTypes());
            this.withModifiers(instance.getModifiers());
            this.withAttributes(instance.getAttributes());
        }
    }

    public Kind getKind() {
        return this.kind;
    }

    public A withKind(Kind kind) {
        this.kind = kind;
        return (A)((Object)this);
    }

    public boolean hasKind() {
        return this.kind != null;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public A withPackageName(String packageName) {
        this.packageName = packageName;
        return (A)((Object)this);
    }

    public boolean hasPackageName() {
        return this.packageName != null;
    }

    public String getName() {
        return this.name;
    }

    public A withName(String name) {
        this.name = name;
        return (A)((Object)this);
    }

    public boolean hasName() {
        return this.name != null;
    }

    public A addToComments(int index, String item) {
        if (this.comments == null) {
            this.comments = new ArrayList<String>();
        }
        this.comments.add(index, item);
        return (A)((Object)this);
    }

    public A setToComments(int index, String item) {
        if (this.comments == null) {
            this.comments = new ArrayList<String>();
        }
        this.comments.set(index, item);
        return (A)((Object)this);
    }

    public A addToComments(String ... items) {
        if (this.comments == null) {
            this.comments = new ArrayList<String>();
        }
        for (String item : items) {
            this.comments.add(item);
        }
        return (A)((Object)this);
    }

    public A addAllToComments(Collection<String> items) {
        if (this.comments == null) {
            this.comments = new ArrayList<String>();
        }
        for (String item : items) {
            this.comments.add(item);
        }
        return (A)((Object)this);
    }

    public A removeFromComments(String ... items) {
        if (this.comments == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.comments.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeAllFromComments(Collection<String> items) {
        if (this.comments == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.comments.remove(item);
        }
        return (A)((Object)this);
    }

    public List<String> getComments() {
        return this.comments;
    }

    public String getComment(int index) {
        return this.comments.get(index);
    }

    public String getFirstComment() {
        return this.comments.get(0);
    }

    public String getLastComment() {
        return this.comments.get(this.comments.size() - 1);
    }

    public String getMatchingComment(Predicate<String> predicate) {
        for (String item : this.comments) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingComment(Predicate<String> predicate) {
        for (String item : this.comments) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withComments(List<String> comments) {
        if (comments != null) {
            this.comments = new ArrayList<String>();
            for (String item : comments) {
                this.addToComments(item);
            }
        } else {
            this.comments = null;
        }
        return (A)((Object)this);
    }

    public A withComments(String ... comments) {
        if (this.comments != null) {
            this.comments.clear();
            this._visitables.remove((Object)"comments");
        }
        if (comments != null) {
            for (String item : comments) {
                this.addToComments(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasComments() {
        return this.comments != null && !this.comments.isEmpty();
    }

    public A addToAnnotations(int index, AnnotationRef item) {
        if (this.annotations == null) {
            this.annotations = new ArrayList();
        }
        AnnotationRefBuilder builder = new AnnotationRefBuilder(item);
        if (index < 0 || index >= this.annotations.size()) {
            this._visitables.get((Object)"annotations").add(builder);
            this.annotations.add(builder);
        } else {
            this._visitables.get((Object)"annotations").add(index, builder);
            this.annotations.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToAnnotations(int index, AnnotationRef item) {
        if (this.annotations == null) {
            this.annotations = new ArrayList();
        }
        AnnotationRefBuilder builder = new AnnotationRefBuilder(item);
        if (index < 0 || index >= this.annotations.size()) {
            this._visitables.get((Object)"annotations").add(builder);
            this.annotations.add(builder);
        } else {
            this._visitables.get((Object)"annotations").set(index, builder);
            this.annotations.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToAnnotations(AnnotationRef ... items) {
        if (this.annotations == null) {
            this.annotations = new ArrayList();
        }
        for (AnnotationRef item : items) {
            AnnotationRefBuilder builder = new AnnotationRefBuilder(item);
            this._visitables.get((Object)"annotations").add(builder);
            this.annotations.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToAnnotations(Collection<AnnotationRef> items) {
        if (this.annotations == null) {
            this.annotations = new ArrayList();
        }
        for (AnnotationRef item : items) {
            AnnotationRefBuilder builder = new AnnotationRefBuilder(item);
            this._visitables.get((Object)"annotations").add(builder);
            this.annotations.add(builder);
        }
        return (A)((Object)this);
    }

    public A removeFromAnnotations(AnnotationRef ... items) {
        if (this.annotations == null) {
            return (A)((Object)this);
        }
        for (AnnotationRef item : items) {
            AnnotationRefBuilder builder = new AnnotationRefBuilder(item);
            this._visitables.get((Object)"annotations").remove((Object)builder);
            this.annotations.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromAnnotations(Collection<AnnotationRef> items) {
        if (this.annotations == null) {
            return (A)((Object)this);
        }
        for (AnnotationRef item : items) {
            AnnotationRefBuilder builder = new AnnotationRefBuilder(item);
            this._visitables.get((Object)"annotations").remove((Object)builder);
            this.annotations.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromAnnotations(Predicate<AnnotationRefBuilder> predicate) {
        if (this.annotations == null) {
            return (A)((Object)this);
        }
        Iterator<AnnotationRefBuilder> each = this.annotations.iterator();
        List visitables = this._visitables.get((Object)"annotations");
        while (each.hasNext()) {
            AnnotationRefBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public List<AnnotationRef> buildAnnotations() {
        return this.annotations != null ? TypeDefFluent.build(this.annotations) : null;
    }

    public AnnotationRef buildAnnotation(int index) {
        return this.annotations.get(index).build();
    }

    public AnnotationRef buildFirstAnnotation() {
        return this.annotations.get(0).build();
    }

    public AnnotationRef buildLastAnnotation() {
        return this.annotations.get(this.annotations.size() - 1).build();
    }

    public AnnotationRef buildMatchingAnnotation(Predicate<AnnotationRefBuilder> predicate) {
        for (AnnotationRefBuilder item : this.annotations) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingAnnotation(Predicate<AnnotationRefBuilder> predicate) {
        for (AnnotationRefBuilder item : this.annotations) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withAnnotations(List<AnnotationRef> annotations) {
        if (this.annotations != null) {
            this._visitables.get((Object)"annotations").clear();
        }
        if (annotations != null) {
            this.annotations = new ArrayList();
            for (AnnotationRef item : annotations) {
                this.addToAnnotations(item);
            }
        } else {
            this.annotations = null;
        }
        return (A)((Object)this);
    }

    public A withAnnotations(AnnotationRef ... annotations) {
        if (this.annotations != null) {
            this.annotations.clear();
            this._visitables.remove((Object)"annotations");
        }
        if (annotations != null) {
            for (AnnotationRef item : annotations) {
                this.addToAnnotations(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasAnnotations() {
        return this.annotations != null && !this.annotations.isEmpty();
    }

    public AnnotationsNested<A> addNewAnnotation() {
        return new AnnotationsNested(-1, null);
    }

    public AnnotationsNested<A> addNewAnnotationLike(AnnotationRef item) {
        return new AnnotationsNested(-1, item);
    }

    public AnnotationsNested<A> setNewAnnotationLike(int index, AnnotationRef item) {
        return new AnnotationsNested(index, item);
    }

    public AnnotationsNested<A> editAnnotation(int index) {
        if (this.annotations.size() <= index) {
            throw new RuntimeException("Can't edit annotations. Index exceeds size.");
        }
        return this.setNewAnnotationLike(index, this.buildAnnotation(index));
    }

    public AnnotationsNested<A> editFirstAnnotation() {
        if (this.annotations.size() == 0) {
            throw new RuntimeException("Can't edit first annotations. The list is empty.");
        }
        return this.setNewAnnotationLike(0, this.buildAnnotation(0));
    }

    public AnnotationsNested<A> editLastAnnotation() {
        int index = this.annotations.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last annotations. The list is empty.");
        }
        return this.setNewAnnotationLike(index, this.buildAnnotation(index));
    }

    public AnnotationsNested<A> editMatchingAnnotation(Predicate<AnnotationRefBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.annotations.size(); ++i) {
            if (!predicate.test(this.annotations.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching annotations. No match found.");
        }
        return this.setNewAnnotationLike(index, this.buildAnnotation(index));
    }

    public A addToExtendsList(int index, ClassRef item) {
        if (this.extendsList == null) {
            this.extendsList = new ArrayList();
        }
        ClassRefBuilder builder = new ClassRefBuilder(item);
        if (index < 0 || index >= this.extendsList.size()) {
            this._visitables.get((Object)"extendsList").add(builder);
            this.extendsList.add(builder);
        } else {
            this._visitables.get((Object)"extendsList").add(index, builder);
            this.extendsList.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToExtendsList(int index, ClassRef item) {
        if (this.extendsList == null) {
            this.extendsList = new ArrayList();
        }
        ClassRefBuilder builder = new ClassRefBuilder(item);
        if (index < 0 || index >= this.extendsList.size()) {
            this._visitables.get((Object)"extendsList").add(builder);
            this.extendsList.add(builder);
        } else {
            this._visitables.get((Object)"extendsList").set(index, builder);
            this.extendsList.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToExtendsList(ClassRef ... items) {
        if (this.extendsList == null) {
            this.extendsList = new ArrayList();
        }
        for (ClassRef item : items) {
            ClassRefBuilder builder = new ClassRefBuilder(item);
            this._visitables.get((Object)"extendsList").add(builder);
            this.extendsList.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToExtendsList(Collection<ClassRef> items) {
        if (this.extendsList == null) {
            this.extendsList = new ArrayList();
        }
        for (ClassRef item : items) {
            ClassRefBuilder builder = new ClassRefBuilder(item);
            this._visitables.get((Object)"extendsList").add(builder);
            this.extendsList.add(builder);
        }
        return (A)((Object)this);
    }

    public A removeFromExtendsList(ClassRef ... items) {
        if (this.extendsList == null) {
            return (A)((Object)this);
        }
        for (ClassRef item : items) {
            ClassRefBuilder builder = new ClassRefBuilder(item);
            this._visitables.get((Object)"extendsList").remove((Object)builder);
            this.extendsList.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromExtendsList(Collection<ClassRef> items) {
        if (this.extendsList == null) {
            return (A)((Object)this);
        }
        for (ClassRef item : items) {
            ClassRefBuilder builder = new ClassRefBuilder(item);
            this._visitables.get((Object)"extendsList").remove((Object)builder);
            this.extendsList.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromExtendsList(Predicate<ClassRefBuilder> predicate) {
        if (this.extendsList == null) {
            return (A)((Object)this);
        }
        Iterator<ClassRefBuilder> each = this.extendsList.iterator();
        List visitables = this._visitables.get((Object)"extendsList");
        while (each.hasNext()) {
            ClassRefBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public List<ClassRef> buildExtendsList() {
        return this.extendsList != null ? TypeDefFluent.build(this.extendsList) : null;
    }

    public ClassRef buildExtendsList(int index) {
        return this.extendsList.get(index).build();
    }

    public ClassRef buildFirstExtendsList() {
        return this.extendsList.get(0).build();
    }

    public ClassRef buildLastExtendsList() {
        return this.extendsList.get(this.extendsList.size() - 1).build();
    }

    public ClassRef buildMatchingExtendsList(Predicate<ClassRefBuilder> predicate) {
        for (ClassRefBuilder item : this.extendsList) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingExtendsList(Predicate<ClassRefBuilder> predicate) {
        for (ClassRefBuilder item : this.extendsList) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withExtendsList(List<ClassRef> extendsList) {
        if (this.extendsList != null) {
            this._visitables.get((Object)"extendsList").clear();
        }
        if (extendsList != null) {
            this.extendsList = new ArrayList();
            for (ClassRef item : extendsList) {
                this.addToExtendsList(item);
            }
        } else {
            this.extendsList = null;
        }
        return (A)((Object)this);
    }

    public A withExtendsList(ClassRef ... extendsList) {
        if (this.extendsList != null) {
            this.extendsList.clear();
            this._visitables.remove((Object)"extendsList");
        }
        if (extendsList != null) {
            for (ClassRef item : extendsList) {
                this.addToExtendsList(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasExtendsList() {
        return this.extendsList != null && !this.extendsList.isEmpty();
    }

    public ExtendsListNested<A> addNewExtendsList() {
        return new ExtendsListNested(-1, null);
    }

    public ExtendsListNested<A> addNewExtendsListLike(ClassRef item) {
        return new ExtendsListNested(-1, item);
    }

    public ExtendsListNested<A> setNewExtendsListLike(int index, ClassRef item) {
        return new ExtendsListNested(index, item);
    }

    public ExtendsListNested<A> editExtendsList(int index) {
        if (this.extendsList.size() <= index) {
            throw new RuntimeException("Can't edit extendsList. Index exceeds size.");
        }
        return this.setNewExtendsListLike(index, this.buildExtendsList(index));
    }

    public ExtendsListNested<A> editFirstExtendsList() {
        if (this.extendsList.size() == 0) {
            throw new RuntimeException("Can't edit first extendsList. The list is empty.");
        }
        return this.setNewExtendsListLike(0, this.buildExtendsList(0));
    }

    public ExtendsListNested<A> editLastExtendsList() {
        int index = this.extendsList.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last extendsList. The list is empty.");
        }
        return this.setNewExtendsListLike(index, this.buildExtendsList(index));
    }

    public ExtendsListNested<A> editMatchingExtendsList(Predicate<ClassRefBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.extendsList.size(); ++i) {
            if (!predicate.test(this.extendsList.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching extendsList. No match found.");
        }
        return this.setNewExtendsListLike(index, this.buildExtendsList(index));
    }

    public A addToImplementsList(int index, ClassRef item) {
        if (this.implementsList == null) {
            this.implementsList = new ArrayList();
        }
        ClassRefBuilder builder = new ClassRefBuilder(item);
        if (index < 0 || index >= this.implementsList.size()) {
            this._visitables.get((Object)"implementsList").add(builder);
            this.implementsList.add(builder);
        } else {
            this._visitables.get((Object)"implementsList").add(index, builder);
            this.implementsList.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToImplementsList(int index, ClassRef item) {
        if (this.implementsList == null) {
            this.implementsList = new ArrayList();
        }
        ClassRefBuilder builder = new ClassRefBuilder(item);
        if (index < 0 || index >= this.implementsList.size()) {
            this._visitables.get((Object)"implementsList").add(builder);
            this.implementsList.add(builder);
        } else {
            this._visitables.get((Object)"implementsList").set(index, builder);
            this.implementsList.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToImplementsList(ClassRef ... items) {
        if (this.implementsList == null) {
            this.implementsList = new ArrayList();
        }
        for (ClassRef item : items) {
            ClassRefBuilder builder = new ClassRefBuilder(item);
            this._visitables.get((Object)"implementsList").add(builder);
            this.implementsList.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToImplementsList(Collection<ClassRef> items) {
        if (this.implementsList == null) {
            this.implementsList = new ArrayList();
        }
        for (ClassRef item : items) {
            ClassRefBuilder builder = new ClassRefBuilder(item);
            this._visitables.get((Object)"implementsList").add(builder);
            this.implementsList.add(builder);
        }
        return (A)((Object)this);
    }

    public A removeFromImplementsList(ClassRef ... items) {
        if (this.implementsList == null) {
            return (A)((Object)this);
        }
        for (ClassRef item : items) {
            ClassRefBuilder builder = new ClassRefBuilder(item);
            this._visitables.get((Object)"implementsList").remove((Object)builder);
            this.implementsList.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromImplementsList(Collection<ClassRef> items) {
        if (this.implementsList == null) {
            return (A)((Object)this);
        }
        for (ClassRef item : items) {
            ClassRefBuilder builder = new ClassRefBuilder(item);
            this._visitables.get((Object)"implementsList").remove((Object)builder);
            this.implementsList.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromImplementsList(Predicate<ClassRefBuilder> predicate) {
        if (this.implementsList == null) {
            return (A)((Object)this);
        }
        Iterator<ClassRefBuilder> each = this.implementsList.iterator();
        List visitables = this._visitables.get((Object)"implementsList");
        while (each.hasNext()) {
            ClassRefBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public List<ClassRef> buildImplementsList() {
        return this.implementsList != null ? TypeDefFluent.build(this.implementsList) : null;
    }

    public ClassRef buildImplementsList(int index) {
        return this.implementsList.get(index).build();
    }

    public ClassRef buildFirstImplementsList() {
        return this.implementsList.get(0).build();
    }

    public ClassRef buildLastImplementsList() {
        return this.implementsList.get(this.implementsList.size() - 1).build();
    }

    public ClassRef buildMatchingImplementsList(Predicate<ClassRefBuilder> predicate) {
        for (ClassRefBuilder item : this.implementsList) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingImplementsList(Predicate<ClassRefBuilder> predicate) {
        for (ClassRefBuilder item : this.implementsList) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withImplementsList(List<ClassRef> implementsList) {
        if (this.implementsList != null) {
            this._visitables.get((Object)"implementsList").clear();
        }
        if (implementsList != null) {
            this.implementsList = new ArrayList();
            for (ClassRef item : implementsList) {
                this.addToImplementsList(item);
            }
        } else {
            this.implementsList = null;
        }
        return (A)((Object)this);
    }

    public A withImplementsList(ClassRef ... implementsList) {
        if (this.implementsList != null) {
            this.implementsList.clear();
            this._visitables.remove((Object)"implementsList");
        }
        if (implementsList != null) {
            for (ClassRef item : implementsList) {
                this.addToImplementsList(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasImplementsList() {
        return this.implementsList != null && !this.implementsList.isEmpty();
    }

    public ImplementsListNested<A> addNewImplementsList() {
        return new ImplementsListNested(-1, null);
    }

    public ImplementsListNested<A> addNewImplementsListLike(ClassRef item) {
        return new ImplementsListNested(-1, item);
    }

    public ImplementsListNested<A> setNewImplementsListLike(int index, ClassRef item) {
        return new ImplementsListNested(index, item);
    }

    public ImplementsListNested<A> editImplementsList(int index) {
        if (this.implementsList.size() <= index) {
            throw new RuntimeException("Can't edit implementsList. Index exceeds size.");
        }
        return this.setNewImplementsListLike(index, this.buildImplementsList(index));
    }

    public ImplementsListNested<A> editFirstImplementsList() {
        if (this.implementsList.size() == 0) {
            throw new RuntimeException("Can't edit first implementsList. The list is empty.");
        }
        return this.setNewImplementsListLike(0, this.buildImplementsList(0));
    }

    public ImplementsListNested<A> editLastImplementsList() {
        int index = this.implementsList.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last implementsList. The list is empty.");
        }
        return this.setNewImplementsListLike(index, this.buildImplementsList(index));
    }

    public ImplementsListNested<A> editMatchingImplementsList(Predicate<ClassRefBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.implementsList.size(); ++i) {
            if (!predicate.test(this.implementsList.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching implementsList. No match found.");
        }
        return this.setNewImplementsListLike(index, this.buildImplementsList(index));
    }

    public A addToParameters(int index, TypeParamDef item) {
        if (this.parameters == null) {
            this.parameters = new ArrayList();
        }
        TypeParamDefBuilder builder = new TypeParamDefBuilder(item);
        if (index < 0 || index >= this.parameters.size()) {
            this._visitables.get((Object)"parameters").add(builder);
            this.parameters.add(builder);
        } else {
            this._visitables.get((Object)"parameters").add(index, builder);
            this.parameters.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToParameters(int index, TypeParamDef item) {
        if (this.parameters == null) {
            this.parameters = new ArrayList();
        }
        TypeParamDefBuilder builder = new TypeParamDefBuilder(item);
        if (index < 0 || index >= this.parameters.size()) {
            this._visitables.get((Object)"parameters").add(builder);
            this.parameters.add(builder);
        } else {
            this._visitables.get((Object)"parameters").set(index, builder);
            this.parameters.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToParameters(TypeParamDef ... items) {
        if (this.parameters == null) {
            this.parameters = new ArrayList();
        }
        for (TypeParamDef item : items) {
            TypeParamDefBuilder builder = new TypeParamDefBuilder(item);
            this._visitables.get((Object)"parameters").add(builder);
            this.parameters.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToParameters(Collection<TypeParamDef> items) {
        if (this.parameters == null) {
            this.parameters = new ArrayList();
        }
        for (TypeParamDef item : items) {
            TypeParamDefBuilder builder = new TypeParamDefBuilder(item);
            this._visitables.get((Object)"parameters").add(builder);
            this.parameters.add(builder);
        }
        return (A)((Object)this);
    }

    public A removeFromParameters(TypeParamDef ... items) {
        if (this.parameters == null) {
            return (A)((Object)this);
        }
        for (TypeParamDef item : items) {
            TypeParamDefBuilder builder = new TypeParamDefBuilder(item);
            this._visitables.get((Object)"parameters").remove((Object)builder);
            this.parameters.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromParameters(Collection<TypeParamDef> items) {
        if (this.parameters == null) {
            return (A)((Object)this);
        }
        for (TypeParamDef item : items) {
            TypeParamDefBuilder builder = new TypeParamDefBuilder(item);
            this._visitables.get((Object)"parameters").remove((Object)builder);
            this.parameters.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromParameters(Predicate<TypeParamDefBuilder> predicate) {
        if (this.parameters == null) {
            return (A)((Object)this);
        }
        Iterator<TypeParamDefBuilder> each = this.parameters.iterator();
        List visitables = this._visitables.get((Object)"parameters");
        while (each.hasNext()) {
            TypeParamDefBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public List<TypeParamDef> buildParameters() {
        return this.parameters != null ? TypeDefFluent.build(this.parameters) : null;
    }

    public TypeParamDef buildParameter(int index) {
        return this.parameters.get(index).build();
    }

    public TypeParamDef buildFirstParameter() {
        return this.parameters.get(0).build();
    }

    public TypeParamDef buildLastParameter() {
        return this.parameters.get(this.parameters.size() - 1).build();
    }

    public TypeParamDef buildMatchingParameter(Predicate<TypeParamDefBuilder> predicate) {
        for (TypeParamDefBuilder item : this.parameters) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingParameter(Predicate<TypeParamDefBuilder> predicate) {
        for (TypeParamDefBuilder item : this.parameters) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withParameters(List<TypeParamDef> parameters) {
        if (this.parameters != null) {
            this._visitables.get((Object)"parameters").clear();
        }
        if (parameters != null) {
            this.parameters = new ArrayList();
            for (TypeParamDef item : parameters) {
                this.addToParameters(item);
            }
        } else {
            this.parameters = null;
        }
        return (A)((Object)this);
    }

    public A withParameters(TypeParamDef ... parameters) {
        if (this.parameters != null) {
            this.parameters.clear();
            this._visitables.remove((Object)"parameters");
        }
        if (parameters != null) {
            for (TypeParamDef item : parameters) {
                this.addToParameters(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasParameters() {
        return this.parameters != null && !this.parameters.isEmpty();
    }

    public ParametersNested<A> addNewParameter() {
        return new ParametersNested(-1, null);
    }

    public ParametersNested<A> addNewParameterLike(TypeParamDef item) {
        return new ParametersNested(-1, item);
    }

    public ParametersNested<A> setNewParameterLike(int index, TypeParamDef item) {
        return new ParametersNested(index, item);
    }

    public ParametersNested<A> editParameter(int index) {
        if (this.parameters.size() <= index) {
            throw new RuntimeException("Can't edit parameters. Index exceeds size.");
        }
        return this.setNewParameterLike(index, this.buildParameter(index));
    }

    public ParametersNested<A> editFirstParameter() {
        if (this.parameters.size() == 0) {
            throw new RuntimeException("Can't edit first parameters. The list is empty.");
        }
        return this.setNewParameterLike(0, this.buildParameter(0));
    }

    public ParametersNested<A> editLastParameter() {
        int index = this.parameters.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last parameters. The list is empty.");
        }
        return this.setNewParameterLike(index, this.buildParameter(index));
    }

    public ParametersNested<A> editMatchingParameter(Predicate<TypeParamDefBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.parameters.size(); ++i) {
            if (!predicate.test(this.parameters.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching parameters. No match found.");
        }
        return this.setNewParameterLike(index, this.buildParameter(index));
    }

    public A addToProperties(int index, Property item) {
        if (this.properties == null) {
            this.properties = new ArrayList();
        }
        PropertyBuilder builder = new PropertyBuilder(item);
        if (index < 0 || index >= this.properties.size()) {
            this._visitables.get((Object)"properties").add(builder);
            this.properties.add(builder);
        } else {
            this._visitables.get((Object)"properties").add(index, builder);
            this.properties.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToProperties(int index, Property item) {
        if (this.properties == null) {
            this.properties = new ArrayList();
        }
        PropertyBuilder builder = new PropertyBuilder(item);
        if (index < 0 || index >= this.properties.size()) {
            this._visitables.get((Object)"properties").add(builder);
            this.properties.add(builder);
        } else {
            this._visitables.get((Object)"properties").set(index, builder);
            this.properties.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToProperties(Property ... items) {
        if (this.properties == null) {
            this.properties = new ArrayList();
        }
        for (Property item : items) {
            PropertyBuilder builder = new PropertyBuilder(item);
            this._visitables.get((Object)"properties").add(builder);
            this.properties.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToProperties(Collection<Property> items) {
        if (this.properties == null) {
            this.properties = new ArrayList();
        }
        for (Property item : items) {
            PropertyBuilder builder = new PropertyBuilder(item);
            this._visitables.get((Object)"properties").add(builder);
            this.properties.add(builder);
        }
        return (A)((Object)this);
    }

    public A removeFromProperties(Property ... items) {
        if (this.properties == null) {
            return (A)((Object)this);
        }
        for (Property item : items) {
            PropertyBuilder builder = new PropertyBuilder(item);
            this._visitables.get((Object)"properties").remove((Object)builder);
            this.properties.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromProperties(Collection<Property> items) {
        if (this.properties == null) {
            return (A)((Object)this);
        }
        for (Property item : items) {
            PropertyBuilder builder = new PropertyBuilder(item);
            this._visitables.get((Object)"properties").remove((Object)builder);
            this.properties.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromProperties(Predicate<PropertyBuilder> predicate) {
        if (this.properties == null) {
            return (A)((Object)this);
        }
        Iterator<PropertyBuilder> each = this.properties.iterator();
        List visitables = this._visitables.get((Object)"properties");
        while (each.hasNext()) {
            PropertyBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public List<Property> buildProperties() {
        return this.properties != null ? TypeDefFluent.build(this.properties) : null;
    }

    public Property buildProperty(int index) {
        return this.properties.get(index).build();
    }

    public Property buildFirstProperty() {
        return this.properties.get(0).build();
    }

    public Property buildLastProperty() {
        return this.properties.get(this.properties.size() - 1).build();
    }

    public Property buildMatchingProperty(Predicate<PropertyBuilder> predicate) {
        for (PropertyBuilder item : this.properties) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingProperty(Predicate<PropertyBuilder> predicate) {
        for (PropertyBuilder item : this.properties) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withProperties(List<Property> properties) {
        if (this.properties != null) {
            this._visitables.get((Object)"properties").clear();
        }
        if (properties != null) {
            this.properties = new ArrayList();
            for (Property item : properties) {
                this.addToProperties(item);
            }
        } else {
            this.properties = null;
        }
        return (A)((Object)this);
    }

    public A withProperties(Property ... properties) {
        if (this.properties != null) {
            this.properties.clear();
            this._visitables.remove((Object)"properties");
        }
        if (properties != null) {
            for (Property item : properties) {
                this.addToProperties(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasProperties() {
        return this.properties != null && !this.properties.isEmpty();
    }

    public PropertiesNested<A> addNewProperty() {
        return new PropertiesNested(-1, null);
    }

    public PropertiesNested<A> addNewPropertyLike(Property item) {
        return new PropertiesNested(-1, item);
    }

    public PropertiesNested<A> setNewPropertyLike(int index, Property item) {
        return new PropertiesNested(index, item);
    }

    public PropertiesNested<A> editProperty(int index) {
        if (this.properties.size() <= index) {
            throw new RuntimeException("Can't edit properties. Index exceeds size.");
        }
        return this.setNewPropertyLike(index, this.buildProperty(index));
    }

    public PropertiesNested<A> editFirstProperty() {
        if (this.properties.size() == 0) {
            throw new RuntimeException("Can't edit first properties. The list is empty.");
        }
        return this.setNewPropertyLike(0, this.buildProperty(0));
    }

    public PropertiesNested<A> editLastProperty() {
        int index = this.properties.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last properties. The list is empty.");
        }
        return this.setNewPropertyLike(index, this.buildProperty(index));
    }

    public PropertiesNested<A> editMatchingProperty(Predicate<PropertyBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.properties.size(); ++i) {
            if (!predicate.test(this.properties.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching properties. No match found.");
        }
        return this.setNewPropertyLike(index, this.buildProperty(index));
    }

    public A addToConstructors(int index, Method item) {
        if (this.constructors == null) {
            this.constructors = new ArrayList();
        }
        MethodBuilder builder = new MethodBuilder(item);
        if (index < 0 || index >= this.constructors.size()) {
            this._visitables.get((Object)"constructors").add(builder);
            this.constructors.add(builder);
        } else {
            this._visitables.get((Object)"constructors").add(index, builder);
            this.constructors.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToConstructors(int index, Method item) {
        if (this.constructors == null) {
            this.constructors = new ArrayList();
        }
        MethodBuilder builder = new MethodBuilder(item);
        if (index < 0 || index >= this.constructors.size()) {
            this._visitables.get((Object)"constructors").add(builder);
            this.constructors.add(builder);
        } else {
            this._visitables.get((Object)"constructors").set(index, builder);
            this.constructors.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToConstructors(Method ... items) {
        if (this.constructors == null) {
            this.constructors = new ArrayList();
        }
        for (Method item : items) {
            MethodBuilder builder = new MethodBuilder(item);
            this._visitables.get((Object)"constructors").add(builder);
            this.constructors.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToConstructors(Collection<Method> items) {
        if (this.constructors == null) {
            this.constructors = new ArrayList();
        }
        for (Method item : items) {
            MethodBuilder builder = new MethodBuilder(item);
            this._visitables.get((Object)"constructors").add(builder);
            this.constructors.add(builder);
        }
        return (A)((Object)this);
    }

    public A removeFromConstructors(Method ... items) {
        if (this.constructors == null) {
            return (A)((Object)this);
        }
        for (Method item : items) {
            MethodBuilder builder = new MethodBuilder(item);
            this._visitables.get((Object)"constructors").remove((Object)builder);
            this.constructors.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromConstructors(Collection<Method> items) {
        if (this.constructors == null) {
            return (A)((Object)this);
        }
        for (Method item : items) {
            MethodBuilder builder = new MethodBuilder(item);
            this._visitables.get((Object)"constructors").remove((Object)builder);
            this.constructors.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromConstructors(Predicate<MethodBuilder> predicate) {
        if (this.constructors == null) {
            return (A)((Object)this);
        }
        Iterator<MethodBuilder> each = this.constructors.iterator();
        List visitables = this._visitables.get((Object)"constructors");
        while (each.hasNext()) {
            MethodBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public List<Method> buildConstructors() {
        return this.constructors != null ? TypeDefFluent.build(this.constructors) : null;
    }

    public Method buildConstructor(int index) {
        return this.constructors.get(index).build();
    }

    public Method buildFirstConstructor() {
        return this.constructors.get(0).build();
    }

    public Method buildLastConstructor() {
        return this.constructors.get(this.constructors.size() - 1).build();
    }

    public Method buildMatchingConstructor(Predicate<MethodBuilder> predicate) {
        for (MethodBuilder item : this.constructors) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingConstructor(Predicate<MethodBuilder> predicate) {
        for (MethodBuilder item : this.constructors) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withConstructors(List<Method> constructors) {
        if (this.constructors != null) {
            this._visitables.get((Object)"constructors").clear();
        }
        if (constructors != null) {
            this.constructors = new ArrayList();
            for (Method item : constructors) {
                this.addToConstructors(item);
            }
        } else {
            this.constructors = null;
        }
        return (A)((Object)this);
    }

    public A withConstructors(Method ... constructors) {
        if (this.constructors != null) {
            this.constructors.clear();
            this._visitables.remove((Object)"constructors");
        }
        if (constructors != null) {
            for (Method item : constructors) {
                this.addToConstructors(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasConstructors() {
        return this.constructors != null && !this.constructors.isEmpty();
    }

    public ConstructorsNested<A> addNewConstructor() {
        return new ConstructorsNested(-1, null);
    }

    public ConstructorsNested<A> addNewConstructorLike(Method item) {
        return new ConstructorsNested(-1, item);
    }

    public ConstructorsNested<A> setNewConstructorLike(int index, Method item) {
        return new ConstructorsNested(index, item);
    }

    public ConstructorsNested<A> editConstructor(int index) {
        if (this.constructors.size() <= index) {
            throw new RuntimeException("Can't edit constructors. Index exceeds size.");
        }
        return this.setNewConstructorLike(index, this.buildConstructor(index));
    }

    public ConstructorsNested<A> editFirstConstructor() {
        if (this.constructors.size() == 0) {
            throw new RuntimeException("Can't edit first constructors. The list is empty.");
        }
        return this.setNewConstructorLike(0, this.buildConstructor(0));
    }

    public ConstructorsNested<A> editLastConstructor() {
        int index = this.constructors.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last constructors. The list is empty.");
        }
        return this.setNewConstructorLike(index, this.buildConstructor(index));
    }

    public ConstructorsNested<A> editMatchingConstructor(Predicate<MethodBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.constructors.size(); ++i) {
            if (!predicate.test(this.constructors.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching constructors. No match found.");
        }
        return this.setNewConstructorLike(index, this.buildConstructor(index));
    }

    public A addToMethods(int index, Method item) {
        if (this.methods == null) {
            this.methods = new ArrayList();
        }
        MethodBuilder builder = new MethodBuilder(item);
        if (index < 0 || index >= this.methods.size()) {
            this._visitables.get((Object)"methods").add(builder);
            this.methods.add(builder);
        } else {
            this._visitables.get((Object)"methods").add(index, builder);
            this.methods.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToMethods(int index, Method item) {
        if (this.methods == null) {
            this.methods = new ArrayList();
        }
        MethodBuilder builder = new MethodBuilder(item);
        if (index < 0 || index >= this.methods.size()) {
            this._visitables.get((Object)"methods").add(builder);
            this.methods.add(builder);
        } else {
            this._visitables.get((Object)"methods").set(index, builder);
            this.methods.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToMethods(Method ... items) {
        if (this.methods == null) {
            this.methods = new ArrayList();
        }
        for (Method item : items) {
            MethodBuilder builder = new MethodBuilder(item);
            this._visitables.get((Object)"methods").add(builder);
            this.methods.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToMethods(Collection<Method> items) {
        if (this.methods == null) {
            this.methods = new ArrayList();
        }
        for (Method item : items) {
            MethodBuilder builder = new MethodBuilder(item);
            this._visitables.get((Object)"methods").add(builder);
            this.methods.add(builder);
        }
        return (A)((Object)this);
    }

    public A removeFromMethods(Method ... items) {
        if (this.methods == null) {
            return (A)((Object)this);
        }
        for (Method item : items) {
            MethodBuilder builder = new MethodBuilder(item);
            this._visitables.get((Object)"methods").remove((Object)builder);
            this.methods.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromMethods(Collection<Method> items) {
        if (this.methods == null) {
            return (A)((Object)this);
        }
        for (Method item : items) {
            MethodBuilder builder = new MethodBuilder(item);
            this._visitables.get((Object)"methods").remove((Object)builder);
            this.methods.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromMethods(Predicate<MethodBuilder> predicate) {
        if (this.methods == null) {
            return (A)((Object)this);
        }
        Iterator<MethodBuilder> each = this.methods.iterator();
        List visitables = this._visitables.get((Object)"methods");
        while (each.hasNext()) {
            MethodBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public List<Method> buildMethods() {
        return this.methods != null ? TypeDefFluent.build(this.methods) : null;
    }

    public Method buildMethod(int index) {
        return this.methods.get(index).build();
    }

    public Method buildFirstMethod() {
        return this.methods.get(0).build();
    }

    public Method buildLastMethod() {
        return this.methods.get(this.methods.size() - 1).build();
    }

    public Method buildMatchingMethod(Predicate<MethodBuilder> predicate) {
        for (MethodBuilder item : this.methods) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingMethod(Predicate<MethodBuilder> predicate) {
        for (MethodBuilder item : this.methods) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withMethods(List<Method> methods) {
        if (this.methods != null) {
            this._visitables.get((Object)"methods").clear();
        }
        if (methods != null) {
            this.methods = new ArrayList();
            for (Method item : methods) {
                this.addToMethods(item);
            }
        } else {
            this.methods = null;
        }
        return (A)((Object)this);
    }

    public A withMethods(Method ... methods) {
        if (this.methods != null) {
            this.methods.clear();
            this._visitables.remove((Object)"methods");
        }
        if (methods != null) {
            for (Method item : methods) {
                this.addToMethods(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasMethods() {
        return this.methods != null && !this.methods.isEmpty();
    }

    public MethodsNested<A> addNewMethod() {
        return new MethodsNested(-1, null);
    }

    public MethodsNested<A> addNewMethodLike(Method item) {
        return new MethodsNested(-1, item);
    }

    public MethodsNested<A> setNewMethodLike(int index, Method item) {
        return new MethodsNested(index, item);
    }

    public MethodsNested<A> editMethod(int index) {
        if (this.methods.size() <= index) {
            throw new RuntimeException("Can't edit methods. Index exceeds size.");
        }
        return this.setNewMethodLike(index, this.buildMethod(index));
    }

    public MethodsNested<A> editFirstMethod() {
        if (this.methods.size() == 0) {
            throw new RuntimeException("Can't edit first methods. The list is empty.");
        }
        return this.setNewMethodLike(0, this.buildMethod(0));
    }

    public MethodsNested<A> editLastMethod() {
        int index = this.methods.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last methods. The list is empty.");
        }
        return this.setNewMethodLike(index, this.buildMethod(index));
    }

    public MethodsNested<A> editMatchingMethod(Predicate<MethodBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.methods.size(); ++i) {
            if (!predicate.test(this.methods.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching methods. No match found.");
        }
        return this.setNewMethodLike(index, this.buildMethod(index));
    }

    public String getOuterTypeName() {
        return this.outerTypeName;
    }

    public A withOuterTypeName(String outerTypeName) {
        this.outerTypeName = outerTypeName;
        return (A)((Object)this);
    }

    public boolean hasOuterTypeName() {
        return this.outerTypeName != null;
    }

    public A addToInnerTypes(int index, TypeDef item) {
        if (this.innerTypes == null) {
            this.innerTypes = new ArrayList();
        }
        TypeDefBuilder builder = new TypeDefBuilder(item);
        if (index < 0 || index >= this.innerTypes.size()) {
            this._visitables.get((Object)"innerTypes").add(builder);
            this.innerTypes.add(builder);
        } else {
            this._visitables.get((Object)"innerTypes").add(index, builder);
            this.innerTypes.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToInnerTypes(int index, TypeDef item) {
        if (this.innerTypes == null) {
            this.innerTypes = new ArrayList();
        }
        TypeDefBuilder builder = new TypeDefBuilder(item);
        if (index < 0 || index >= this.innerTypes.size()) {
            this._visitables.get((Object)"innerTypes").add(builder);
            this.innerTypes.add(builder);
        } else {
            this._visitables.get((Object)"innerTypes").set(index, builder);
            this.innerTypes.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToInnerTypes(TypeDef ... items) {
        if (this.innerTypes == null) {
            this.innerTypes = new ArrayList();
        }
        for (TypeDef item : items) {
            TypeDefBuilder builder = new TypeDefBuilder(item);
            this._visitables.get((Object)"innerTypes").add(builder);
            this.innerTypes.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToInnerTypes(Collection<TypeDef> items) {
        if (this.innerTypes == null) {
            this.innerTypes = new ArrayList();
        }
        for (TypeDef item : items) {
            TypeDefBuilder builder = new TypeDefBuilder(item);
            this._visitables.get((Object)"innerTypes").add(builder);
            this.innerTypes.add(builder);
        }
        return (A)((Object)this);
    }

    public A removeFromInnerTypes(TypeDef ... items) {
        if (this.innerTypes == null) {
            return (A)((Object)this);
        }
        for (TypeDef item : items) {
            TypeDefBuilder builder = new TypeDefBuilder(item);
            this._visitables.get((Object)"innerTypes").remove((Object)builder);
            this.innerTypes.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromInnerTypes(Collection<TypeDef> items) {
        if (this.innerTypes == null) {
            return (A)((Object)this);
        }
        for (TypeDef item : items) {
            TypeDefBuilder builder = new TypeDefBuilder(item);
            this._visitables.get((Object)"innerTypes").remove((Object)builder);
            this.innerTypes.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromInnerTypes(Predicate<TypeDefBuilder> predicate) {
        if (this.innerTypes == null) {
            return (A)((Object)this);
        }
        Iterator<TypeDefBuilder> each = this.innerTypes.iterator();
        List visitables = this._visitables.get((Object)"innerTypes");
        while (each.hasNext()) {
            TypeDefBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public List<TypeDef> buildInnerTypes() {
        return this.innerTypes != null ? TypeDefFluent.build(this.innerTypes) : null;
    }

    public TypeDef buildInnerType(int index) {
        return this.innerTypes.get(index).build();
    }

    public TypeDef buildFirstInnerType() {
        return this.innerTypes.get(0).build();
    }

    public TypeDef buildLastInnerType() {
        return this.innerTypes.get(this.innerTypes.size() - 1).build();
    }

    public TypeDef buildMatchingInnerType(Predicate<TypeDefBuilder> predicate) {
        for (TypeDefBuilder item : this.innerTypes) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingInnerType(Predicate<TypeDefBuilder> predicate) {
        for (TypeDefBuilder item : this.innerTypes) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withInnerTypes(List<TypeDef> innerTypes) {
        if (this.innerTypes != null) {
            this._visitables.get((Object)"innerTypes").clear();
        }
        if (innerTypes != null) {
            this.innerTypes = new ArrayList();
            for (TypeDef item : innerTypes) {
                this.addToInnerTypes(item);
            }
        } else {
            this.innerTypes = null;
        }
        return (A)((Object)this);
    }

    public A withInnerTypes(TypeDef ... innerTypes) {
        if (this.innerTypes != null) {
            this.innerTypes.clear();
            this._visitables.remove((Object)"innerTypes");
        }
        if (innerTypes != null) {
            for (TypeDef item : innerTypes) {
                this.addToInnerTypes(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasInnerTypes() {
        return this.innerTypes != null && !this.innerTypes.isEmpty();
    }

    public A addNewInnerType(String fullyQualifiedName) {
        return this.addToInnerTypes(new TypeDef(fullyQualifiedName));
    }

    public InnerTypesNested<A> addNewInnerType() {
        return new InnerTypesNested(-1, null);
    }

    public InnerTypesNested<A> addNewInnerTypeLike(TypeDef item) {
        return new InnerTypesNested(-1, item);
    }

    public InnerTypesNested<A> setNewInnerTypeLike(int index, TypeDef item) {
        return new InnerTypesNested(index, item);
    }

    public InnerTypesNested<A> editInnerType(int index) {
        if (this.innerTypes.size() <= index) {
            throw new RuntimeException("Can't edit innerTypes. Index exceeds size.");
        }
        return this.setNewInnerTypeLike(index, this.buildInnerType(index));
    }

    public InnerTypesNested<A> editFirstInnerType() {
        if (this.innerTypes.size() == 0) {
            throw new RuntimeException("Can't edit first innerTypes. The list is empty.");
        }
        return this.setNewInnerTypeLike(0, this.buildInnerType(0));
    }

    public InnerTypesNested<A> editLastInnerType() {
        int index = this.innerTypes.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last innerTypes. The list is empty.");
        }
        return this.setNewInnerTypeLike(index, this.buildInnerType(index));
    }

    public InnerTypesNested<A> editMatchingInnerType(Predicate<TypeDefBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.innerTypes.size(); ++i) {
            if (!predicate.test(this.innerTypes.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching innerTypes. No match found.");
        }
        return this.setNewInnerTypeLike(index, this.buildInnerType(index));
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        TypeDefFluent that = (TypeDefFluent)((Object)o);
        if (!Objects.equals(this.kind, that.kind)) {
            return false;
        }
        if (!Objects.equals(this.packageName, that.packageName)) {
            return false;
        }
        if (!Objects.equals(this.name, that.name)) {
            return false;
        }
        if (!Objects.equals(this.comments, that.comments)) {
            return false;
        }
        if (!Objects.equals(this.annotations, that.annotations)) {
            return false;
        }
        if (!Objects.equals(this.extendsList, that.extendsList)) {
            return false;
        }
        if (!Objects.equals(this.implementsList, that.implementsList)) {
            return false;
        }
        if (!Objects.equals(this.parameters, that.parameters)) {
            return false;
        }
        if (!Objects.equals(this.properties, that.properties)) {
            return false;
        }
        if (!Objects.equals(this.constructors, that.constructors)) {
            return false;
        }
        if (!Objects.equals(this.methods, that.methods)) {
            return false;
        }
        if (!Objects.equals(this.outerTypeName, that.outerTypeName)) {
            return false;
        }
        return Objects.equals(this.innerTypes, that.innerTypes);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.kind, this.packageName, this.name, this.comments, this.annotations, this.extendsList, this.implementsList, this.parameters, this.properties, this.constructors, this.methods, this.outerTypeName, this.innerTypes, super.hashCode());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.kind != null) {
            sb.append("kind:");
            sb.append(String.valueOf(this.kind) + ",");
        }
        if (this.packageName != null) {
            sb.append("packageName:");
            sb.append(this.packageName + ",");
        }
        if (this.name != null) {
            sb.append("name:");
            sb.append(this.name + ",");
        }
        if (this.comments != null && !this.comments.isEmpty()) {
            sb.append("comments:");
            sb.append(String.valueOf(this.comments) + ",");
        }
        if (this.annotations != null && !this.annotations.isEmpty()) {
            sb.append("annotations:");
            sb.append(String.valueOf(this.annotations) + ",");
        }
        if (this.extendsList != null && !this.extendsList.isEmpty()) {
            sb.append("extendsList:");
            sb.append(String.valueOf(this.extendsList) + ",");
        }
        if (this.implementsList != null && !this.implementsList.isEmpty()) {
            sb.append("implementsList:");
            sb.append(String.valueOf(this.implementsList) + ",");
        }
        if (this.parameters != null && !this.parameters.isEmpty()) {
            sb.append("parameters:");
            sb.append(String.valueOf(this.parameters) + ",");
        }
        if (this.properties != null && !this.properties.isEmpty()) {
            sb.append("properties:");
            sb.append(String.valueOf(this.properties) + ",");
        }
        if (this.constructors != null && !this.constructors.isEmpty()) {
            sb.append("constructors:");
            sb.append(String.valueOf(this.constructors) + ",");
        }
        if (this.methods != null && !this.methods.isEmpty()) {
            sb.append("methods:");
            sb.append(String.valueOf(this.methods) + ",");
        }
        if (this.outerTypeName != null) {
            sb.append("outerTypeName:");
            sb.append(this.outerTypeName + ",");
        }
        if (this.innerTypes != null && !this.innerTypes.isEmpty()) {
            sb.append("innerTypes:");
            sb.append(this.innerTypes);
        }
        sb.append("}");
        return sb.toString();
    }

    public class InnerTypesNested<N>
    extends TypeDefFluent<InnerTypesNested<N>>
    implements Nested<N> {
        TypeDefBuilder builder;
        int index;

        InnerTypesNested(int index, TypeDef item) {
            this.index = index;
            this.builder = new TypeDefBuilder(this, item);
        }

        public N and() {
            return (N)TypeDefFluent.this.setToInnerTypes(this.index, this.builder.build());
        }

        public N endInnerType() {
            return this.and();
        }
    }

    public class MethodsNested<N>
    extends MethodFluent<MethodsNested<N>>
    implements Nested<N> {
        MethodBuilder builder;
        int index;

        MethodsNested(int index, Method item) {
            this.index = index;
            this.builder = new MethodBuilder(this, item);
        }

        public N and() {
            return (N)TypeDefFluent.this.setToMethods(this.index, this.builder.build());
        }

        public N endMethod() {
            return this.and();
        }
    }

    public class ConstructorsNested<N>
    extends MethodFluent<ConstructorsNested<N>>
    implements Nested<N> {
        MethodBuilder builder;
        int index;

        ConstructorsNested(int index, Method item) {
            this.index = index;
            this.builder = new MethodBuilder(this, item);
        }

        public N and() {
            return (N)TypeDefFluent.this.setToConstructors(this.index, this.builder.build());
        }

        public N endConstructor() {
            return this.and();
        }
    }

    public class PropertiesNested<N>
    extends PropertyFluent<PropertiesNested<N>>
    implements Nested<N> {
        PropertyBuilder builder;
        int index;

        PropertiesNested(int index, Property item) {
            this.index = index;
            this.builder = new PropertyBuilder(this, item);
        }

        public N and() {
            return (N)TypeDefFluent.this.setToProperties(this.index, this.builder.build());
        }

        public N endProperty() {
            return this.and();
        }
    }

    public class ParametersNested<N>
    extends TypeParamDefFluent<ParametersNested<N>>
    implements Nested<N> {
        TypeParamDefBuilder builder;
        int index;

        ParametersNested(int index, TypeParamDef item) {
            this.index = index;
            this.builder = new TypeParamDefBuilder(this, item);
        }

        public N and() {
            return (N)TypeDefFluent.this.setToParameters(this.index, this.builder.build());
        }

        public N endParameter() {
            return this.and();
        }
    }

    public class ImplementsListNested<N>
    extends ClassRefFluent<ImplementsListNested<N>>
    implements Nested<N> {
        ClassRefBuilder builder;
        int index;

        ImplementsListNested(int index, ClassRef item) {
            this.index = index;
            this.builder = new ClassRefBuilder(this, item);
        }

        public N and() {
            return (N)TypeDefFluent.this.setToImplementsList(this.index, this.builder.build());
        }

        public N endImplementsList() {
            return this.and();
        }
    }

    public class ExtendsListNested<N>
    extends ClassRefFluent<ExtendsListNested<N>>
    implements Nested<N> {
        ClassRefBuilder builder;
        int index;

        ExtendsListNested(int index, ClassRef item) {
            this.index = index;
            this.builder = new ClassRefBuilder(this, item);
        }

        public N and() {
            return (N)TypeDefFluent.this.setToExtendsList(this.index, this.builder.build());
        }

        public N endExtendsList() {
            return this.and();
        }
    }

    public class AnnotationsNested<N>
    extends AnnotationRefFluent<AnnotationsNested<N>>
    implements Nested<N> {
        AnnotationRefBuilder builder;
        int index;

        AnnotationsNested(int index, AnnotationRef item) {
            this.index = index;
            this.builder = new AnnotationRefBuilder(this, item);
        }

        public N and() {
            return (N)TypeDefFluent.this.setToAnnotations(this.index, this.builder.build());
        }

        public N endAnnotation() {
            return this.and();
        }
    }
}

