/*
 * Decompiled with CFR 0.152.
 */
package io.sundr.model;

import io.sundr.builder.Nested;
import io.sundr.builder.VisitableBuilder;
import io.sundr.model.AnnotationRef;
import io.sundr.model.AnnotationRefBuilder;
import io.sundr.model.AnnotationRefFluent;
import io.sundr.model.Block;
import io.sundr.model.BlockBuilder;
import io.sundr.model.BlockFluent;
import io.sundr.model.ClassRef;
import io.sundr.model.ClassRefBuilder;
import io.sundr.model.ClassRefFluent;
import io.sundr.model.Method;
import io.sundr.model.ModifierSupportFluent;
import io.sundr.model.PrimitiveRef;
import io.sundr.model.PrimitiveRefBuilder;
import io.sundr.model.PrimitiveRefFluent;
import io.sundr.model.Property;
import io.sundr.model.PropertyBuilder;
import io.sundr.model.PropertyFluent;
import io.sundr.model.TypeParamDef;
import io.sundr.model.TypeParamDefBuilder;
import io.sundr.model.TypeParamDefFluent;
import io.sundr.model.TypeParamRef;
import io.sundr.model.TypeParamRefBuilder;
import io.sundr.model.TypeParamRefFluent;
import io.sundr.model.TypeRef;
import io.sundr.model.VoidRef;
import io.sundr.model.VoidRefBuilder;
import io.sundr.model.VoidRefFluent;
import io.sundr.model.WildcardRef;
import io.sundr.model.WildcardRefBuilder;
import io.sundr.model.WildcardRefFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;

public class MethodFluent<A extends MethodFluent<A>>
extends ModifierSupportFluent<A> {
    private List<String> comments = new ArrayList<String>();
    private ArrayList<AnnotationRefBuilder> annotations = new ArrayList();
    private ArrayList<TypeParamDefBuilder> parameters = new ArrayList();
    private String name;
    private VisitableBuilder<? extends TypeRef, ?> returnType;
    private ArrayList<PropertyBuilder> arguments = new ArrayList();
    private boolean varArgPreferred;
    private ArrayList<ClassRefBuilder> exceptions = new ArrayList();
    private boolean defaultMethod;
    private BlockBuilder block;

    public MethodFluent() {
    }

    public MethodFluent(Method instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(Method instance) {
        if (instance != null) {
            this.withComments(instance.getComments());
            this.withAnnotations(instance.getAnnotations());
            this.withParameters(instance.getParameters());
            this.withName(instance.getName());
            this.withReturnType(instance.getReturnType());
            this.withArguments(instance.getArguments());
            this.withVarArgPreferred(instance.isVarArgPreferred());
            this.withExceptions(instance.getExceptions());
            this.withDefaultMethod(instance.isDefaultMethod());
            this.withBlock(instance.getBlock());
            this.withModifiers(instance.getModifiers());
            this.withAttributes(instance.getAttributes());
        }
    }

    public A addToComments(int index, String item) {
        if (this.comments == null) {
            this.comments = new ArrayList<String>();
        }
        this.comments.add(index, item);
        return (A)((Object)this);
    }

    public A setToComments(int index, String item) {
        if (this.comments == null) {
            this.comments = new ArrayList<String>();
        }
        this.comments.set(index, item);
        return (A)((Object)this);
    }

    public A addToComments(String ... items) {
        if (this.comments == null) {
            this.comments = new ArrayList<String>();
        }
        for (String item : items) {
            this.comments.add(item);
        }
        return (A)((Object)this);
    }

    public A addAllToComments(Collection<String> items) {
        if (this.comments == null) {
            this.comments = new ArrayList<String>();
        }
        for (String item : items) {
            this.comments.add(item);
        }
        return (A)((Object)this);
    }

    public A removeFromComments(String ... items) {
        if (this.comments == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.comments.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeAllFromComments(Collection<String> items) {
        if (this.comments == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.comments.remove(item);
        }
        return (A)((Object)this);
    }

    public List<String> getComments() {
        return this.comments;
    }

    public String getComment(int index) {
        return this.comments.get(index);
    }

    public String getFirstComment() {
        return this.comments.get(0);
    }

    public String getLastComment() {
        return this.comments.get(this.comments.size() - 1);
    }

    public String getMatchingComment(Predicate<String> predicate) {
        for (String item : this.comments) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingComment(Predicate<String> predicate) {
        for (String item : this.comments) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withComments(List<String> comments) {
        if (comments != null) {
            this.comments = new ArrayList<String>();
            for (String item : comments) {
                this.addToComments(item);
            }
        } else {
            this.comments = null;
        }
        return (A)((Object)this);
    }

    public A withComments(String ... comments) {
        if (this.comments != null) {
            this.comments.clear();
            this._visitables.remove((Object)"comments");
        }
        if (comments != null) {
            for (String item : comments) {
                this.addToComments(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasComments() {
        return this.comments != null && !this.comments.isEmpty();
    }

    public A addToAnnotations(int index, AnnotationRef item) {
        if (this.annotations == null) {
            this.annotations = new ArrayList();
        }
        AnnotationRefBuilder builder = new AnnotationRefBuilder(item);
        if (index < 0 || index >= this.annotations.size()) {
            this._visitables.get((Object)"annotations").add(builder);
            this.annotations.add(builder);
        } else {
            this._visitables.get((Object)"annotations").add(index, builder);
            this.annotations.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToAnnotations(int index, AnnotationRef item) {
        if (this.annotations == null) {
            this.annotations = new ArrayList();
        }
        AnnotationRefBuilder builder = new AnnotationRefBuilder(item);
        if (index < 0 || index >= this.annotations.size()) {
            this._visitables.get((Object)"annotations").add(builder);
            this.annotations.add(builder);
        } else {
            this._visitables.get((Object)"annotations").set(index, builder);
            this.annotations.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToAnnotations(AnnotationRef ... items) {
        if (this.annotations == null) {
            this.annotations = new ArrayList();
        }
        for (AnnotationRef item : items) {
            AnnotationRefBuilder builder = new AnnotationRefBuilder(item);
            this._visitables.get((Object)"annotations").add(builder);
            this.annotations.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToAnnotations(Collection<AnnotationRef> items) {
        if (this.annotations == null) {
            this.annotations = new ArrayList();
        }
        for (AnnotationRef item : items) {
            AnnotationRefBuilder builder = new AnnotationRefBuilder(item);
            this._visitables.get((Object)"annotations").add(builder);
            this.annotations.add(builder);
        }
        return (A)((Object)this);
    }

    public A removeFromAnnotations(AnnotationRef ... items) {
        if (this.annotations == null) {
            return (A)((Object)this);
        }
        for (AnnotationRef item : items) {
            AnnotationRefBuilder builder = new AnnotationRefBuilder(item);
            this._visitables.get((Object)"annotations").remove((Object)builder);
            this.annotations.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromAnnotations(Collection<AnnotationRef> items) {
        if (this.annotations == null) {
            return (A)((Object)this);
        }
        for (AnnotationRef item : items) {
            AnnotationRefBuilder builder = new AnnotationRefBuilder(item);
            this._visitables.get((Object)"annotations").remove((Object)builder);
            this.annotations.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromAnnotations(Predicate<AnnotationRefBuilder> predicate) {
        if (this.annotations == null) {
            return (A)((Object)this);
        }
        Iterator<AnnotationRefBuilder> each = this.annotations.iterator();
        List visitables = this._visitables.get((Object)"annotations");
        while (each.hasNext()) {
            AnnotationRefBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public List<AnnotationRef> buildAnnotations() {
        return this.annotations != null ? MethodFluent.build(this.annotations) : null;
    }

    public AnnotationRef buildAnnotation(int index) {
        return this.annotations.get(index).build();
    }

    public AnnotationRef buildFirstAnnotation() {
        return this.annotations.get(0).build();
    }

    public AnnotationRef buildLastAnnotation() {
        return this.annotations.get(this.annotations.size() - 1).build();
    }

    public AnnotationRef buildMatchingAnnotation(Predicate<AnnotationRefBuilder> predicate) {
        for (AnnotationRefBuilder item : this.annotations) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingAnnotation(Predicate<AnnotationRefBuilder> predicate) {
        for (AnnotationRefBuilder item : this.annotations) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withAnnotations(List<AnnotationRef> annotations) {
        if (this.annotations != null) {
            this._visitables.get((Object)"annotations").clear();
        }
        if (annotations != null) {
            this.annotations = new ArrayList();
            for (AnnotationRef item : annotations) {
                this.addToAnnotations(item);
            }
        } else {
            this.annotations = null;
        }
        return (A)((Object)this);
    }

    public A withAnnotations(AnnotationRef ... annotations) {
        if (this.annotations != null) {
            this.annotations.clear();
            this._visitables.remove((Object)"annotations");
        }
        if (annotations != null) {
            for (AnnotationRef item : annotations) {
                this.addToAnnotations(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasAnnotations() {
        return this.annotations != null && !this.annotations.isEmpty();
    }

    public AnnotationsNested<A> addNewAnnotation() {
        return new AnnotationsNested(-1, null);
    }

    public AnnotationsNested<A> addNewAnnotationLike(AnnotationRef item) {
        return new AnnotationsNested(-1, item);
    }

    public AnnotationsNested<A> setNewAnnotationLike(int index, AnnotationRef item) {
        return new AnnotationsNested(index, item);
    }

    public AnnotationsNested<A> editAnnotation(int index) {
        if (this.annotations.size() <= index) {
            throw new RuntimeException("Can't edit annotations. Index exceeds size.");
        }
        return this.setNewAnnotationLike(index, this.buildAnnotation(index));
    }

    public AnnotationsNested<A> editFirstAnnotation() {
        if (this.annotations.size() == 0) {
            throw new RuntimeException("Can't edit first annotations. The list is empty.");
        }
        return this.setNewAnnotationLike(0, this.buildAnnotation(0));
    }

    public AnnotationsNested<A> editLastAnnotation() {
        int index = this.annotations.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last annotations. The list is empty.");
        }
        return this.setNewAnnotationLike(index, this.buildAnnotation(index));
    }

    public AnnotationsNested<A> editMatchingAnnotation(Predicate<AnnotationRefBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.annotations.size(); ++i) {
            if (!predicate.test(this.annotations.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching annotations. No match found.");
        }
        return this.setNewAnnotationLike(index, this.buildAnnotation(index));
    }

    public A addToParameters(int index, TypeParamDef item) {
        if (this.parameters == null) {
            this.parameters = new ArrayList();
        }
        TypeParamDefBuilder builder = new TypeParamDefBuilder(item);
        if (index < 0 || index >= this.parameters.size()) {
            this._visitables.get((Object)"parameters").add(builder);
            this.parameters.add(builder);
        } else {
            this._visitables.get((Object)"parameters").add(index, builder);
            this.parameters.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToParameters(int index, TypeParamDef item) {
        if (this.parameters == null) {
            this.parameters = new ArrayList();
        }
        TypeParamDefBuilder builder = new TypeParamDefBuilder(item);
        if (index < 0 || index >= this.parameters.size()) {
            this._visitables.get((Object)"parameters").add(builder);
            this.parameters.add(builder);
        } else {
            this._visitables.get((Object)"parameters").set(index, builder);
            this.parameters.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToParameters(TypeParamDef ... items) {
        if (this.parameters == null) {
            this.parameters = new ArrayList();
        }
        for (TypeParamDef item : items) {
            TypeParamDefBuilder builder = new TypeParamDefBuilder(item);
            this._visitables.get((Object)"parameters").add(builder);
            this.parameters.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToParameters(Collection<TypeParamDef> items) {
        if (this.parameters == null) {
            this.parameters = new ArrayList();
        }
        for (TypeParamDef item : items) {
            TypeParamDefBuilder builder = new TypeParamDefBuilder(item);
            this._visitables.get((Object)"parameters").add(builder);
            this.parameters.add(builder);
        }
        return (A)((Object)this);
    }

    public A removeFromParameters(TypeParamDef ... items) {
        if (this.parameters == null) {
            return (A)((Object)this);
        }
        for (TypeParamDef item : items) {
            TypeParamDefBuilder builder = new TypeParamDefBuilder(item);
            this._visitables.get((Object)"parameters").remove((Object)builder);
            this.parameters.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromParameters(Collection<TypeParamDef> items) {
        if (this.parameters == null) {
            return (A)((Object)this);
        }
        for (TypeParamDef item : items) {
            TypeParamDefBuilder builder = new TypeParamDefBuilder(item);
            this._visitables.get((Object)"parameters").remove((Object)builder);
            this.parameters.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromParameters(Predicate<TypeParamDefBuilder> predicate) {
        if (this.parameters == null) {
            return (A)((Object)this);
        }
        Iterator<TypeParamDefBuilder> each = this.parameters.iterator();
        List visitables = this._visitables.get((Object)"parameters");
        while (each.hasNext()) {
            TypeParamDefBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public List<TypeParamDef> buildParameters() {
        return this.parameters != null ? MethodFluent.build(this.parameters) : null;
    }

    public TypeParamDef buildParameter(int index) {
        return this.parameters.get(index).build();
    }

    public TypeParamDef buildFirstParameter() {
        return this.parameters.get(0).build();
    }

    public TypeParamDef buildLastParameter() {
        return this.parameters.get(this.parameters.size() - 1).build();
    }

    public TypeParamDef buildMatchingParameter(Predicate<TypeParamDefBuilder> predicate) {
        for (TypeParamDefBuilder item : this.parameters) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingParameter(Predicate<TypeParamDefBuilder> predicate) {
        for (TypeParamDefBuilder item : this.parameters) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withParameters(List<TypeParamDef> parameters) {
        if (this.parameters != null) {
            this._visitables.get((Object)"parameters").clear();
        }
        if (parameters != null) {
            this.parameters = new ArrayList();
            for (TypeParamDef item : parameters) {
                this.addToParameters(item);
            }
        } else {
            this.parameters = null;
        }
        return (A)((Object)this);
    }

    public A withParameters(TypeParamDef ... parameters) {
        if (this.parameters != null) {
            this.parameters.clear();
            this._visitables.remove((Object)"parameters");
        }
        if (parameters != null) {
            for (TypeParamDef item : parameters) {
                this.addToParameters(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasParameters() {
        return this.parameters != null && !this.parameters.isEmpty();
    }

    public ParametersNested<A> addNewParameter() {
        return new ParametersNested(-1, null);
    }

    public ParametersNested<A> addNewParameterLike(TypeParamDef item) {
        return new ParametersNested(-1, item);
    }

    public ParametersNested<A> setNewParameterLike(int index, TypeParamDef item) {
        return new ParametersNested(index, item);
    }

    public ParametersNested<A> editParameter(int index) {
        if (this.parameters.size() <= index) {
            throw new RuntimeException("Can't edit parameters. Index exceeds size.");
        }
        return this.setNewParameterLike(index, this.buildParameter(index));
    }

    public ParametersNested<A> editFirstParameter() {
        if (this.parameters.size() == 0) {
            throw new RuntimeException("Can't edit first parameters. The list is empty.");
        }
        return this.setNewParameterLike(0, this.buildParameter(0));
    }

    public ParametersNested<A> editLastParameter() {
        int index = this.parameters.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last parameters. The list is empty.");
        }
        return this.setNewParameterLike(index, this.buildParameter(index));
    }

    public ParametersNested<A> editMatchingParameter(Predicate<TypeParamDefBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.parameters.size(); ++i) {
            if (!predicate.test(this.parameters.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching parameters. No match found.");
        }
        return this.setNewParameterLike(index, this.buildParameter(index));
    }

    public String getName() {
        return this.name;
    }

    public A withName(String name) {
        this.name = name;
        return (A)((Object)this);
    }

    public boolean hasName() {
        return this.name != null;
    }

    public TypeRef buildReturnType() {
        return this.returnType != null ? (TypeRef)this.returnType.build() : null;
    }

    public A withReturnType(TypeRef returnType) {
        if (returnType == null) {
            this.returnType = null;
            this._visitables.remove((Object)"returnType");
            return (A)((Object)this);
        }
        VisitableBuilder builder = MethodFluent.builder(returnType);
        this._visitables.get((Object)"returnType").clear();
        this._visitables.get((Object)"returnType").add(builder);
        this.returnType = builder;
        return (A)((Object)this);
    }

    public boolean hasReturnType() {
        return this.returnType != null;
    }

    public ClassRefReturnTypeNested<A> withNewClassRefReturnType() {
        return new ClassRefReturnTypeNested(null);
    }

    public ClassRefReturnTypeNested<A> withNewClassRefReturnTypeLike(ClassRef item) {
        return new ClassRefReturnTypeNested(item);
    }

    public PrimitiveRefReturnTypeNested<A> withNewPrimitiveRefReturnType() {
        return new PrimitiveRefReturnTypeNested(null);
    }

    public PrimitiveRefReturnTypeNested<A> withNewPrimitiveRefReturnTypeLike(PrimitiveRef item) {
        return new PrimitiveRefReturnTypeNested(item);
    }

    public VoidRefReturnTypeNested<A> withNewVoidRefReturnType() {
        return new VoidRefReturnTypeNested(null);
    }

    public VoidRefReturnTypeNested<A> withNewVoidRefReturnTypeLike(VoidRef item) {
        return new VoidRefReturnTypeNested(item);
    }

    public TypeParamRefReturnTypeNested<A> withNewTypeParamRefReturnType() {
        return new TypeParamRefReturnTypeNested(null);
    }

    public TypeParamRefReturnTypeNested<A> withNewTypeParamRefReturnTypeLike(TypeParamRef item) {
        return new TypeParamRefReturnTypeNested(item);
    }

    public WildcardRefReturnTypeNested<A> withNewWildcardRefReturnType() {
        return new WildcardRefReturnTypeNested(null);
    }

    public WildcardRefReturnTypeNested<A> withNewWildcardRefReturnTypeLike(WildcardRef item) {
        return new WildcardRefReturnTypeNested(item);
    }

    public A addToArguments(int index, Property item) {
        if (this.arguments == null) {
            this.arguments = new ArrayList();
        }
        PropertyBuilder builder = new PropertyBuilder(item);
        if (index < 0 || index >= this.arguments.size()) {
            this._visitables.get((Object)"arguments").add(builder);
            this.arguments.add(builder);
        } else {
            this._visitables.get((Object)"arguments").add(index, builder);
            this.arguments.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToArguments(int index, Property item) {
        if (this.arguments == null) {
            this.arguments = new ArrayList();
        }
        PropertyBuilder builder = new PropertyBuilder(item);
        if (index < 0 || index >= this.arguments.size()) {
            this._visitables.get((Object)"arguments").add(builder);
            this.arguments.add(builder);
        } else {
            this._visitables.get((Object)"arguments").set(index, builder);
            this.arguments.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToArguments(Property ... items) {
        if (this.arguments == null) {
            this.arguments = new ArrayList();
        }
        for (Property item : items) {
            PropertyBuilder builder = new PropertyBuilder(item);
            this._visitables.get((Object)"arguments").add(builder);
            this.arguments.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToArguments(Collection<Property> items) {
        if (this.arguments == null) {
            this.arguments = new ArrayList();
        }
        for (Property item : items) {
            PropertyBuilder builder = new PropertyBuilder(item);
            this._visitables.get((Object)"arguments").add(builder);
            this.arguments.add(builder);
        }
        return (A)((Object)this);
    }

    public A removeFromArguments(Property ... items) {
        if (this.arguments == null) {
            return (A)((Object)this);
        }
        for (Property item : items) {
            PropertyBuilder builder = new PropertyBuilder(item);
            this._visitables.get((Object)"arguments").remove((Object)builder);
            this.arguments.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromArguments(Collection<Property> items) {
        if (this.arguments == null) {
            return (A)((Object)this);
        }
        for (Property item : items) {
            PropertyBuilder builder = new PropertyBuilder(item);
            this._visitables.get((Object)"arguments").remove((Object)builder);
            this.arguments.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromArguments(Predicate<PropertyBuilder> predicate) {
        if (this.arguments == null) {
            return (A)((Object)this);
        }
        Iterator<PropertyBuilder> each = this.arguments.iterator();
        List visitables = this._visitables.get((Object)"arguments");
        while (each.hasNext()) {
            PropertyBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public List<Property> buildArguments() {
        return this.arguments != null ? MethodFluent.build(this.arguments) : null;
    }

    public Property buildArgument(int index) {
        return this.arguments.get(index).build();
    }

    public Property buildFirstArgument() {
        return this.arguments.get(0).build();
    }

    public Property buildLastArgument() {
        return this.arguments.get(this.arguments.size() - 1).build();
    }

    public Property buildMatchingArgument(Predicate<PropertyBuilder> predicate) {
        for (PropertyBuilder item : this.arguments) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingArgument(Predicate<PropertyBuilder> predicate) {
        for (PropertyBuilder item : this.arguments) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withArguments(List<Property> arguments) {
        if (this.arguments != null) {
            this._visitables.get((Object)"arguments").clear();
        }
        if (arguments != null) {
            this.arguments = new ArrayList();
            for (Property item : arguments) {
                this.addToArguments(item);
            }
        } else {
            this.arguments = null;
        }
        return (A)((Object)this);
    }

    public A withArguments(Property ... arguments) {
        if (this.arguments != null) {
            this.arguments.clear();
            this._visitables.remove((Object)"arguments");
        }
        if (arguments != null) {
            for (Property item : arguments) {
                this.addToArguments(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasArguments() {
        return this.arguments != null && !this.arguments.isEmpty();
    }

    public ArgumentsNested<A> addNewArgument() {
        return new ArgumentsNested(-1, null);
    }

    public ArgumentsNested<A> addNewArgumentLike(Property item) {
        return new ArgumentsNested(-1, item);
    }

    public ArgumentsNested<A> setNewArgumentLike(int index, Property item) {
        return new ArgumentsNested(index, item);
    }

    public ArgumentsNested<A> editArgument(int index) {
        if (this.arguments.size() <= index) {
            throw new RuntimeException("Can't edit arguments. Index exceeds size.");
        }
        return this.setNewArgumentLike(index, this.buildArgument(index));
    }

    public ArgumentsNested<A> editFirstArgument() {
        if (this.arguments.size() == 0) {
            throw new RuntimeException("Can't edit first arguments. The list is empty.");
        }
        return this.setNewArgumentLike(0, this.buildArgument(0));
    }

    public ArgumentsNested<A> editLastArgument() {
        int index = this.arguments.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last arguments. The list is empty.");
        }
        return this.setNewArgumentLike(index, this.buildArgument(index));
    }

    public ArgumentsNested<A> editMatchingArgument(Predicate<PropertyBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.arguments.size(); ++i) {
            if (!predicate.test(this.arguments.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching arguments. No match found.");
        }
        return this.setNewArgumentLike(index, this.buildArgument(index));
    }

    public boolean isVarArgPreferred() {
        return this.varArgPreferred;
    }

    public A withVarArgPreferred(boolean varArgPreferred) {
        this.varArgPreferred = varArgPreferred;
        return (A)((Object)this);
    }

    public boolean hasVarArgPreferred() {
        return true;
    }

    public A addToExceptions(int index, ClassRef item) {
        if (this.exceptions == null) {
            this.exceptions = new ArrayList();
        }
        ClassRefBuilder builder = new ClassRefBuilder(item);
        if (index < 0 || index >= this.exceptions.size()) {
            this._visitables.get((Object)"exceptions").add(builder);
            this.exceptions.add(builder);
        } else {
            this._visitables.get((Object)"exceptions").add(index, builder);
            this.exceptions.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToExceptions(int index, ClassRef item) {
        if (this.exceptions == null) {
            this.exceptions = new ArrayList();
        }
        ClassRefBuilder builder = new ClassRefBuilder(item);
        if (index < 0 || index >= this.exceptions.size()) {
            this._visitables.get((Object)"exceptions").add(builder);
            this.exceptions.add(builder);
        } else {
            this._visitables.get((Object)"exceptions").set(index, builder);
            this.exceptions.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToExceptions(ClassRef ... items) {
        if (this.exceptions == null) {
            this.exceptions = new ArrayList();
        }
        for (ClassRef item : items) {
            ClassRefBuilder builder = new ClassRefBuilder(item);
            this._visitables.get((Object)"exceptions").add(builder);
            this.exceptions.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToExceptions(Collection<ClassRef> items) {
        if (this.exceptions == null) {
            this.exceptions = new ArrayList();
        }
        for (ClassRef item : items) {
            ClassRefBuilder builder = new ClassRefBuilder(item);
            this._visitables.get((Object)"exceptions").add(builder);
            this.exceptions.add(builder);
        }
        return (A)((Object)this);
    }

    public A removeFromExceptions(ClassRef ... items) {
        if (this.exceptions == null) {
            return (A)((Object)this);
        }
        for (ClassRef item : items) {
            ClassRefBuilder builder = new ClassRefBuilder(item);
            this._visitables.get((Object)"exceptions").remove((Object)builder);
            this.exceptions.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromExceptions(Collection<ClassRef> items) {
        if (this.exceptions == null) {
            return (A)((Object)this);
        }
        for (ClassRef item : items) {
            ClassRefBuilder builder = new ClassRefBuilder(item);
            this._visitables.get((Object)"exceptions").remove((Object)builder);
            this.exceptions.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromExceptions(Predicate<ClassRefBuilder> predicate) {
        if (this.exceptions == null) {
            return (A)((Object)this);
        }
        Iterator<ClassRefBuilder> each = this.exceptions.iterator();
        List visitables = this._visitables.get((Object)"exceptions");
        while (each.hasNext()) {
            ClassRefBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public List<ClassRef> buildExceptions() {
        return this.exceptions != null ? MethodFluent.build(this.exceptions) : null;
    }

    public ClassRef buildException(int index) {
        return this.exceptions.get(index).build();
    }

    public ClassRef buildFirstException() {
        return this.exceptions.get(0).build();
    }

    public ClassRef buildLastException() {
        return this.exceptions.get(this.exceptions.size() - 1).build();
    }

    public ClassRef buildMatchingException(Predicate<ClassRefBuilder> predicate) {
        for (ClassRefBuilder item : this.exceptions) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingException(Predicate<ClassRefBuilder> predicate) {
        for (ClassRefBuilder item : this.exceptions) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withExceptions(List<ClassRef> exceptions) {
        if (this.exceptions != null) {
            this._visitables.get((Object)"exceptions").clear();
        }
        if (exceptions != null) {
            this.exceptions = new ArrayList();
            for (ClassRef item : exceptions) {
                this.addToExceptions(item);
            }
        } else {
            this.exceptions = null;
        }
        return (A)((Object)this);
    }

    public A withExceptions(ClassRef ... exceptions) {
        if (this.exceptions != null) {
            this.exceptions.clear();
            this._visitables.remove((Object)"exceptions");
        }
        if (exceptions != null) {
            for (ClassRef item : exceptions) {
                this.addToExceptions(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasExceptions() {
        return this.exceptions != null && !this.exceptions.isEmpty();
    }

    public ExceptionsNested<A> addNewException() {
        return new ExceptionsNested(-1, null);
    }

    public ExceptionsNested<A> addNewExceptionLike(ClassRef item) {
        return new ExceptionsNested(-1, item);
    }

    public ExceptionsNested<A> setNewExceptionLike(int index, ClassRef item) {
        return new ExceptionsNested(index, item);
    }

    public ExceptionsNested<A> editException(int index) {
        if (this.exceptions.size() <= index) {
            throw new RuntimeException("Can't edit exceptions. Index exceeds size.");
        }
        return this.setNewExceptionLike(index, this.buildException(index));
    }

    public ExceptionsNested<A> editFirstException() {
        if (this.exceptions.size() == 0) {
            throw new RuntimeException("Can't edit first exceptions. The list is empty.");
        }
        return this.setNewExceptionLike(0, this.buildException(0));
    }

    public ExceptionsNested<A> editLastException() {
        int index = this.exceptions.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last exceptions. The list is empty.");
        }
        return this.setNewExceptionLike(index, this.buildException(index));
    }

    public ExceptionsNested<A> editMatchingException(Predicate<ClassRefBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.exceptions.size(); ++i) {
            if (!predicate.test(this.exceptions.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching exceptions. No match found.");
        }
        return this.setNewExceptionLike(index, this.buildException(index));
    }

    public boolean isDefaultMethod() {
        return this.defaultMethod;
    }

    public A withDefaultMethod(boolean defaultMethod) {
        this.defaultMethod = defaultMethod;
        return (A)((Object)this);
    }

    public boolean hasDefaultMethod() {
        return true;
    }

    public Block buildBlock() {
        return this.block != null ? this.block.build() : null;
    }

    public A withBlock(Block block) {
        this._visitables.get((Object)"block").remove((Object)this.block);
        if (block != null) {
            this.block = new BlockBuilder(block);
            this._visitables.get((Object)"block").add(this.block);
        } else {
            this.block = null;
            this._visitables.get((Object)"block").remove((Object)this.block);
        }
        return (A)((Object)this);
    }

    public boolean hasBlock() {
        return this.block != null;
    }

    public BlockNested<A> withNewBlock() {
        return new BlockNested(null);
    }

    public BlockNested<A> withNewBlockLike(Block item) {
        return new BlockNested(item);
    }

    public BlockNested<A> editBlock() {
        return this.withNewBlockLike(Optional.ofNullable(this.buildBlock()).orElse(null));
    }

    public BlockNested<A> editOrNewBlock() {
        return this.withNewBlockLike(Optional.ofNullable(this.buildBlock()).orElse(new BlockBuilder().build()));
    }

    public BlockNested<A> editOrNewBlockLike(Block item) {
        return this.withNewBlockLike(Optional.ofNullable(this.buildBlock()).orElse(item));
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        MethodFluent that = (MethodFluent)((Object)o);
        if (!Objects.equals(this.comments, that.comments)) {
            return false;
        }
        if (!Objects.equals(this.annotations, that.annotations)) {
            return false;
        }
        if (!Objects.equals(this.parameters, that.parameters)) {
            return false;
        }
        if (!Objects.equals(this.name, that.name)) {
            return false;
        }
        if (!Objects.equals(this.returnType, that.returnType)) {
            return false;
        }
        if (!Objects.equals(this.arguments, that.arguments)) {
            return false;
        }
        if (this.varArgPreferred != that.varArgPreferred) {
            return false;
        }
        if (!Objects.equals(this.exceptions, that.exceptions)) {
            return false;
        }
        if (this.defaultMethod != that.defaultMethod) {
            return false;
        }
        return Objects.equals((Object)this.block, (Object)that.block);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{this.comments, this.annotations, this.parameters, this.name, this.returnType, this.arguments, this.varArgPreferred, this.exceptions, this.defaultMethod, this.block, super.hashCode()});
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.comments != null && !this.comments.isEmpty()) {
            sb.append("comments:");
            sb.append(String.valueOf(this.comments) + ",");
        }
        if (this.annotations != null && !this.annotations.isEmpty()) {
            sb.append("annotations:");
            sb.append(String.valueOf(this.annotations) + ",");
        }
        if (this.parameters != null && !this.parameters.isEmpty()) {
            sb.append("parameters:");
            sb.append(String.valueOf(this.parameters) + ",");
        }
        if (this.name != null) {
            sb.append("name:");
            sb.append(this.name + ",");
        }
        if (this.returnType != null) {
            sb.append("returnType:");
            sb.append(String.valueOf(this.returnType) + ",");
        }
        if (this.arguments != null && !this.arguments.isEmpty()) {
            sb.append("arguments:");
            sb.append(String.valueOf(this.arguments) + ",");
        }
        sb.append("varArgPreferred:");
        sb.append(this.varArgPreferred + ",");
        if (this.exceptions != null && !this.exceptions.isEmpty()) {
            sb.append("exceptions:");
            sb.append(String.valueOf(this.exceptions) + ",");
        }
        sb.append("defaultMethod:");
        sb.append(this.defaultMethod + ",");
        if (this.block != null) {
            sb.append("block:");
            sb.append((Object)this.block);
        }
        sb.append("}");
        return sb.toString();
    }

    protected static <T> VisitableBuilder<T, ?> builder(Object item) {
        switch (item.getClass().getName()) {
            case "io.sundr.model.ClassRef": {
                return new ClassRefBuilder((ClassRef)item);
            }
            case "io.sundr.model.PrimitiveRef": {
                return new PrimitiveRefBuilder((PrimitiveRef)item);
            }
            case "io.sundr.model.VoidRef": {
                return new VoidRefBuilder((VoidRef)item);
            }
            case "io.sundr.model.TypeParamRef": {
                return new TypeParamRefBuilder((TypeParamRef)item);
            }
            case "io.sundr.model.WildcardRef": {
                return new WildcardRefBuilder((WildcardRef)item);
            }
        }
        return MethodFluent.builderOf((Object)item);
    }

    public A withVarArgPreferred() {
        return this.withVarArgPreferred(true);
    }

    public A withDefaultMethod() {
        return this.withDefaultMethod(true);
    }

    public class AnnotationsNested<N>
    extends AnnotationRefFluent<AnnotationsNested<N>>
    implements Nested<N> {
        AnnotationRefBuilder builder;
        int index;

        AnnotationsNested(int index, AnnotationRef item) {
            this.index = index;
            this.builder = new AnnotationRefBuilder(this, item);
        }

        public N and() {
            return (N)MethodFluent.this.setToAnnotations(this.index, this.builder.build());
        }

        public N endAnnotation() {
            return this.and();
        }
    }

    public class ParametersNested<N>
    extends TypeParamDefFluent<ParametersNested<N>>
    implements Nested<N> {
        TypeParamDefBuilder builder;
        int index;

        ParametersNested(int index, TypeParamDef item) {
            this.index = index;
            this.builder = new TypeParamDefBuilder(this, item);
        }

        public N and() {
            return (N)MethodFluent.this.setToParameters(this.index, this.builder.build());
        }

        public N endParameter() {
            return this.and();
        }
    }

    public class ClassRefReturnTypeNested<N>
    extends ClassRefFluent<ClassRefReturnTypeNested<N>>
    implements Nested<N> {
        ClassRefBuilder builder;

        ClassRefReturnTypeNested(ClassRef item) {
            this.builder = new ClassRefBuilder(this, item);
        }

        public N and() {
            return (N)MethodFluent.this.withReturnType((TypeRef)this.builder.build());
        }

        public N endClassRefReturnType() {
            return this.and();
        }
    }

    public class PrimitiveRefReturnTypeNested<N>
    extends PrimitiveRefFluent<PrimitiveRefReturnTypeNested<N>>
    implements Nested<N> {
        PrimitiveRefBuilder builder;

        PrimitiveRefReturnTypeNested(PrimitiveRef item) {
            this.builder = new PrimitiveRefBuilder(this, item);
        }

        public N and() {
            return (N)MethodFluent.this.withReturnType((TypeRef)this.builder.build());
        }

        public N endPrimitiveRefReturnType() {
            return this.and();
        }
    }

    public class VoidRefReturnTypeNested<N>
    extends VoidRefFluent<VoidRefReturnTypeNested<N>>
    implements Nested<N> {
        VoidRefBuilder builder;

        VoidRefReturnTypeNested(VoidRef item) {
            this.builder = new VoidRefBuilder(this, item);
        }

        public N and() {
            return (N)MethodFluent.this.withReturnType((TypeRef)this.builder.build());
        }

        public N endVoidRefReturnType() {
            return this.and();
        }
    }

    public class TypeParamRefReturnTypeNested<N>
    extends TypeParamRefFluent<TypeParamRefReturnTypeNested<N>>
    implements Nested<N> {
        TypeParamRefBuilder builder;

        TypeParamRefReturnTypeNested(TypeParamRef item) {
            this.builder = new TypeParamRefBuilder(this, item);
        }

        public N and() {
            return (N)MethodFluent.this.withReturnType((TypeRef)this.builder.build());
        }

        public N endTypeParamRefReturnType() {
            return this.and();
        }
    }

    public class WildcardRefReturnTypeNested<N>
    extends WildcardRefFluent<WildcardRefReturnTypeNested<N>>
    implements Nested<N> {
        WildcardRefBuilder builder;

        WildcardRefReturnTypeNested(WildcardRef item) {
            this.builder = new WildcardRefBuilder(this, item);
        }

        public N and() {
            return (N)MethodFluent.this.withReturnType((TypeRef)this.builder.build());
        }

        public N endWildcardRefReturnType() {
            return this.and();
        }
    }

    public class ArgumentsNested<N>
    extends PropertyFluent<ArgumentsNested<N>>
    implements Nested<N> {
        PropertyBuilder builder;
        int index;

        ArgumentsNested(int index, Property item) {
            this.index = index;
            this.builder = new PropertyBuilder(this, item);
        }

        public N and() {
            return (N)MethodFluent.this.setToArguments(this.index, this.builder.build());
        }

        public N endArgument() {
            return this.and();
        }
    }

    public class ExceptionsNested<N>
    extends ClassRefFluent<ExceptionsNested<N>>
    implements Nested<N> {
        ClassRefBuilder builder;
        int index;

        ExceptionsNested(int index, ClassRef item) {
            this.index = index;
            this.builder = new ClassRefBuilder(this, item);
        }

        public N and() {
            return (N)MethodFluent.this.setToExceptions(this.index, this.builder.build());
        }

        public N endException() {
            return this.and();
        }
    }

    public class BlockNested<N>
    extends BlockFluent<BlockNested<N>>
    implements Nested<N> {
        BlockBuilder builder;

        BlockNested(Block item) {
            this.builder = new BlockBuilder(this, item);
        }

        public N and() {
            return (N)MethodFluent.this.withBlock(this.builder.build());
        }

        public N endBlock() {
            return this.and();
        }
    }
}

