/*
 * Decompiled with CFR 0.152.
 */
package io.sundr.model;

import io.sundr.builder.BaseFluent;
import io.sundr.builder.Nested;
import io.sundr.model.Block;
import io.sundr.model.BlockBuilder;
import io.sundr.model.BlockFluent;
import io.sundr.model.Try;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;

public class TryFluent<A extends TryFluent<A>>
extends BaseFluent<A> {
    private List<Try.Catch> catchBlocks = new ArrayList<Try.Catch>();
    private Optional<BlockBuilder> finallyBlock = Optional.empty();
    private BlockBuilder tryBlock;

    public TryFluent() {
    }

    public TryFluent(Try instance) {
        this.copyInstance(instance);
    }

    public A addAllToCatchBlocks(Collection<Try.Catch> items) {
        if (this.catchBlocks == null) {
            this.catchBlocks = new ArrayList<Try.Catch>();
        }
        for (Try.Catch item : items) {
            this.catchBlocks.add(item);
        }
        return (A)((Object)this);
    }

    public A addToCatchBlocks(Try.Catch ... items) {
        if (this.catchBlocks == null) {
            this.catchBlocks = new ArrayList<Try.Catch>();
        }
        for (Try.Catch item : items) {
            this.catchBlocks.add(item);
        }
        return (A)((Object)this);
    }

    public A addToCatchBlocks(int index, Try.Catch item) {
        if (this.catchBlocks == null) {
            this.catchBlocks = new ArrayList<Try.Catch>();
        }
        this.catchBlocks.add(index, item);
        return (A)((Object)this);
    }

    public Optional<Block> buildFinallyBlock() {
        return this.finallyBlock != null ? this.finallyBlock.map(v -> v.build()) : Optional.empty();
    }

    public Block buildTryBlock() {
        return this.tryBlock != null ? this.tryBlock.build() : null;
    }

    protected void copyInstance(Try instance) {
        if (instance != null) {
            this.withTryBlock(instance.getTryBlock());
            this.withCatchBlocks(instance.getCatchBlocks());
            this.withFinallyBlock(instance.getFinallyBlock());
        }
    }

    public FinallyBlockNested<A> editFinallyBlock() {
        return this.withNewFinallyBlockLike(Optional.ofNullable(this.buildFinallyBlock()).flatMap(Function.identity()).orElse(null));
    }

    public <T> FinallyBlockNested<?> editOrNewFinallyBlock() {
        return this.withNewFinallyBlockLike(Optional.ofNullable(this.buildFinallyBlock()).flatMap(Function.identity()).orElse(new BlockBuilder().build()));
    }

    public FinallyBlockNested<A> editOrNewFinallyBlockLike(Block item) {
        return this.withNewFinallyBlockLike(Optional.ofNullable(this.buildFinallyBlock()).flatMap(Function.identity()).orElse(item));
    }

    public TryBlockNested<A> editOrNewTryBlock() {
        return this.withNewTryBlockLike(Optional.ofNullable(this.buildTryBlock()).orElse(new BlockBuilder().build()));
    }

    public TryBlockNested<A> editOrNewTryBlockLike(Block item) {
        return this.withNewTryBlockLike(Optional.ofNullable(this.buildTryBlock()).orElse(item));
    }

    public TryBlockNested<A> editTryBlock() {
        return this.withNewTryBlockLike(Optional.ofNullable(this.buildTryBlock()).orElse(null));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        TryFluent that = (TryFluent)((Object)o);
        if (!Objects.equals((Object)this.tryBlock, (Object)that.tryBlock)) {
            return false;
        }
        if (!Objects.equals(this.catchBlocks, that.catchBlocks)) {
            return false;
        }
        return Objects.equals(this.finallyBlock, that.finallyBlock);
    }

    public Try.Catch getCatchBlock(int index) {
        return this.catchBlocks.get(index);
    }

    public List<Try.Catch> getCatchBlocks() {
        return this.catchBlocks;
    }

    public Try.Catch getFirstCatchBlock() {
        return this.catchBlocks.get(0);
    }

    public Try.Catch getLastCatchBlock() {
        return this.catchBlocks.get(this.catchBlocks.size() - 1);
    }

    public Try.Catch getMatchingCatchBlock(Predicate<Try.Catch> predicate) {
        for (Try.Catch item : this.catchBlocks) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasCatchBlocks() {
        return this.catchBlocks != null && !this.catchBlocks.isEmpty();
    }

    public boolean hasFinallyBlock() {
        return this.finallyBlock != null && this.finallyBlock.isPresent();
    }

    public boolean hasMatchingCatchBlock(Predicate<Try.Catch> predicate) {
        for (Try.Catch item : this.catchBlocks) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public boolean hasTryBlock() {
        return this.tryBlock != null;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.tryBlock, this.catchBlocks, this.finallyBlock});
    }

    public A removeAllFromCatchBlocks(Collection<Try.Catch> items) {
        if (this.catchBlocks == null) {
            return (A)((Object)this);
        }
        for (Try.Catch item : items) {
            this.catchBlocks.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeFromCatchBlocks(Try.Catch ... items) {
        if (this.catchBlocks == null) {
            return (A)((Object)this);
        }
        for (Try.Catch item : items) {
            this.catchBlocks.remove(item);
        }
        return (A)((Object)this);
    }

    public A setToCatchBlocks(int index, Try.Catch item) {
        if (this.catchBlocks == null) {
            this.catchBlocks = new ArrayList<Try.Catch>();
        }
        this.catchBlocks.set(index, item);
        return (A)((Object)this);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.tryBlock != null) {
            sb.append("tryBlock:");
            sb.append((Object)this.tryBlock);
            sb.append(",");
        }
        if (this.catchBlocks != null && !this.catchBlocks.isEmpty()) {
            sb.append("catchBlocks:");
            sb.append(this.catchBlocks);
            sb.append(",");
        }
        if (this.finallyBlock != null) {
            sb.append("finallyBlock:");
            sb.append(this.finallyBlock);
        }
        sb.append("}");
        return sb.toString();
    }

    public A withCatchBlocks(List<Try.Catch> catchBlocks) {
        if (catchBlocks != null) {
            this.catchBlocks = new ArrayList<Try.Catch>();
            for (Try.Catch item : catchBlocks) {
                this.addToCatchBlocks(item);
            }
        } else {
            this.catchBlocks = null;
        }
        return (A)((Object)this);
    }

    public A withCatchBlocks(Try.Catch ... catchBlocks) {
        if (this.catchBlocks != null) {
            this.catchBlocks.clear();
            this._visitables.remove((Object)"catchBlocks");
        }
        if (catchBlocks != null) {
            for (Try.Catch item : catchBlocks) {
                this.addToCatchBlocks(item);
            }
        }
        return (A)((Object)this);
    }

    public A withFinallyBlock(Optional<Block> finallyBlock) {
        if (finallyBlock == null || !finallyBlock.isPresent()) {
            this.finallyBlock = Optional.empty();
        } else {
            BlockBuilder b = new BlockBuilder(finallyBlock.get());
            this._visitables.get((Object)"finallyBlock").add(b);
            this.finallyBlock = Optional.of(b);
        }
        return (A)((Object)this);
    }

    public A withFinallyBlock(Block finallyBlock) {
        if (finallyBlock == null) {
            this.finallyBlock = Optional.empty();
        } else {
            BlockBuilder b = new BlockBuilder(finallyBlock);
            this._visitables.get((Object)"finallyBlock").add(b);
            this.finallyBlock = Optional.of(b);
        }
        return (A)((Object)this);
    }

    public FinallyBlockNested<A> withNewFinallyBlock() {
        return new FinallyBlockNested(null);
    }

    public FinallyBlockNested<A> withNewFinallyBlockLike(Block item) {
        return new FinallyBlockNested(item);
    }

    public TryBlockNested<A> withNewTryBlock() {
        return new TryBlockNested(null);
    }

    public TryBlockNested<A> withNewTryBlockLike(Block item) {
        return new TryBlockNested(item);
    }

    public A withTryBlock(Block tryBlock) {
        this._visitables.remove((Object)"tryBlock");
        if (tryBlock != null) {
            this.tryBlock = new BlockBuilder(tryBlock);
            this._visitables.get((Object)"tryBlock").add(this.tryBlock);
        } else {
            this.tryBlock = null;
            this._visitables.get((Object)"tryBlock").remove((Object)this.tryBlock);
        }
        return (A)((Object)this);
    }

    public class FinallyBlockNested<N>
    extends BlockFluent<FinallyBlockNested<N>>
    implements Nested<N> {
        BlockBuilder builder;

        FinallyBlockNested(Block item) {
            this.builder = new BlockBuilder(this, item);
        }

        public N and() {
            return (N)TryFluent.this.withFinallyBlock(this.builder.build());
        }

        public N endFinallyBlock() {
            return this.and();
        }
    }

    public class TryBlockNested<N>
    extends BlockFluent<TryBlockNested<N>>
    implements Nested<N> {
        BlockBuilder builder;

        TryBlockNested(Block item) {
            this.builder = new BlockBuilder(this, item);
        }

        public N and() {
            return (N)TryFluent.this.withTryBlock(this.builder.build());
        }

        public N endTryBlock() {
            return this.and();
        }
    }
}

