/*
 * Decompiled with CFR 0.152.
 */
package io.sundr.model;

import io.sundr.builder.VisitableBuilder;
import io.sundr.model.Block;
import io.sundr.model.BlockFluent;
import io.sundr.model.BlockFluentImpl;
import java.util.Objects;

public class BlockBuilder
extends BlockFluentImpl<BlockBuilder>
implements VisitableBuilder<Block, BlockBuilder> {
    BlockFluent<?> fluent;
    Boolean validationEnabled;

    public BlockBuilder() {
        this(true);
    }

    public BlockBuilder(Boolean validationEnabled) {
        this.fluent = this;
        this.validationEnabled = validationEnabled;
    }

    public BlockBuilder(BlockFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public BlockBuilder(BlockFluent<?> fluent, Boolean validationEnabled) {
        this.fluent = fluent;
        this.validationEnabled = validationEnabled;
    }

    public BlockBuilder(BlockFluent<?> fluent, Block instance) {
        this(fluent, instance, true);
    }

    public BlockBuilder(BlockFluent<?> fluent, Block instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withStatements(instance.getStatements());
        this.validationEnabled = validationEnabled;
    }

    public BlockBuilder(Block instance) {
        this(instance, (Boolean)true);
    }

    public BlockBuilder(Block instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withStatements(instance.getStatements());
        this.validationEnabled = validationEnabled;
    }

    public Block build() {
        Block buildable = new Block(this.fluent.getStatements());
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        BlockBuilder that = (BlockBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.fluent, this.validationEnabled, super.hashCode());
    }
}

