/*
 * Decompiled with CFR 0.152.
 */
package io.sundr.model;

import io.sundr.builder.VisitableBuilder;
import io.sundr.model.Property;
import io.sundr.model.PropertyFluent;
import io.sundr.model.PropertyFluentImpl;
import java.util.Objects;

public class PropertyBuilder
extends PropertyFluentImpl<PropertyBuilder>
implements VisitableBuilder<Property, PropertyBuilder> {
    PropertyFluent<?> fluent;
    Boolean validationEnabled;

    public PropertyBuilder() {
        this(true);
    }

    public PropertyBuilder(Boolean validationEnabled) {
        this.fluent = this;
        this.validationEnabled = validationEnabled;
    }

    public PropertyBuilder(PropertyFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public PropertyBuilder(PropertyFluent<?> fluent, Boolean validationEnabled) {
        this.fluent = fluent;
        this.validationEnabled = validationEnabled;
    }

    public PropertyBuilder(PropertyFluent<?> fluent, Property instance) {
        this(fluent, instance, true);
    }

    public PropertyBuilder(PropertyFluent<?> fluent, Property instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withAnnotations(instance.getAnnotations());
        fluent.withTypeRef(instance.getTypeRef());
        fluent.withName(instance.getName());
        fluent.withComments(instance.getComments());
        fluent.withModifiers(instance.getModifiers());
        fluent.withAttributes(instance.getAttributes());
        this.validationEnabled = validationEnabled;
    }

    public PropertyBuilder(Property instance) {
        this(instance, (Boolean)true);
    }

    public PropertyBuilder(Property instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withAnnotations(instance.getAnnotations());
        this.withTypeRef(instance.getTypeRef());
        this.withName(instance.getName());
        this.withComments(instance.getComments());
        this.withModifiers(instance.getModifiers());
        this.withAttributes(instance.getAttributes());
        this.validationEnabled = validationEnabled;
    }

    public Property build() {
        Property buildable = new Property(this.fluent.getAnnotations(), this.fluent.getTypeRef(), this.fluent.getName(), this.fluent.getComments(), this.fluent.getModifiers(), this.fluent.getAttributes());
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        PropertyBuilder that = (PropertyBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.fluent, this.validationEnabled, super.hashCode());
    }
}

