/*
 * Decompiled with CFR 0.152.
 */
package io.sundr.model;

import io.sundr.builder.Nested;
import io.sundr.builder.VisitableBuilder;
import io.sundr.model.AnnotationRef;
import io.sundr.model.AnnotationRefBuilder;
import io.sundr.model.AnnotationRefFluentImpl;
import io.sundr.model.Block;
import io.sundr.model.BlockBuilder;
import io.sundr.model.BlockFluentImpl;
import io.sundr.model.ClassRef;
import io.sundr.model.ClassRefBuilder;
import io.sundr.model.ClassRefFluentImpl;
import io.sundr.model.Method;
import io.sundr.model.MethodFluent;
import io.sundr.model.ModifierSupportFluentImpl;
import io.sundr.model.PrimitiveRef;
import io.sundr.model.PrimitiveRefBuilder;
import io.sundr.model.PrimitiveRefFluentImpl;
import io.sundr.model.Property;
import io.sundr.model.PropertyBuilder;
import io.sundr.model.PropertyFluentImpl;
import io.sundr.model.TypeParamDef;
import io.sundr.model.TypeParamDefBuilder;
import io.sundr.model.TypeParamDefFluentImpl;
import io.sundr.model.TypeParamRef;
import io.sundr.model.TypeParamRefBuilder;
import io.sundr.model.TypeParamRefFluentImpl;
import io.sundr.model.TypeRef;
import io.sundr.model.VoidRef;
import io.sundr.model.VoidRefBuilder;
import io.sundr.model.VoidRefFluentImpl;
import io.sundr.model.WildcardRef;
import io.sundr.model.WildcardRefBuilder;
import io.sundr.model.WildcardRefFluentImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;

public class MethodFluentImpl<A extends MethodFluent<A>>
extends ModifierSupportFluentImpl<A>
implements MethodFluent<A> {
    private List<String> comments = new ArrayList<String>();
    private ArrayList<AnnotationRefBuilder> annotations = new ArrayList();
    private ArrayList<TypeParamDefBuilder> parameters = new ArrayList();
    private String name;
    private VisitableBuilder<? extends TypeRef, ?> returnType;
    private ArrayList<PropertyBuilder> arguments = new ArrayList();
    private boolean varArgPreferred;
    private ArrayList<ClassRefBuilder> exceptions = new ArrayList();
    private boolean defaultMethod;
    private BlockBuilder block;

    public MethodFluentImpl() {
    }

    public MethodFluentImpl(Method instance) {
        this.withComments(instance.getComments());
        this.withAnnotations(instance.getAnnotations());
        this.withParameters(instance.getParameters());
        this.withName(instance.getName());
        this.withReturnType(instance.getReturnType());
        this.withArguments(instance.getArguments());
        this.withVarArgPreferred(instance.isVarArgPreferred());
        this.withExceptions(instance.getExceptions());
        this.withDefaultMethod(instance.isDefaultMethod());
        this.withBlock(instance.getBlock());
        this.withModifiers(instance.getModifiers());
        this.withAttributes(instance.getAttributes());
    }

    @Override
    public A addToComments(Integer index, String item) {
        if (this.comments == null) {
            this.comments = new ArrayList<String>();
        }
        this.comments.add(index, item);
        return (A)this;
    }

    @Override
    public A setToComments(Integer index, String item) {
        if (this.comments == null) {
            this.comments = new ArrayList<String>();
        }
        this.comments.set(index, item);
        return (A)this;
    }

    @Override
    public A addToComments(String ... items) {
        if (this.comments == null) {
            this.comments = new ArrayList<String>();
        }
        for (String item : items) {
            this.comments.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToComments(Collection<String> items) {
        if (this.comments == null) {
            this.comments = new ArrayList<String>();
        }
        for (String item : items) {
            this.comments.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromComments(String ... items) {
        for (String item : items) {
            if (this.comments == null) continue;
            this.comments.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromComments(Collection<String> items) {
        for (String item : items) {
            if (this.comments == null) continue;
            this.comments.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getComments() {
        return this.comments;
    }

    @Override
    public String getComment(Integer index) {
        return this.comments.get(index);
    }

    @Override
    public String getFirstComment() {
        return this.comments.get(0);
    }

    @Override
    public String getLastComment() {
        return this.comments.get(this.comments.size() - 1);
    }

    @Override
    public String getMatchingComment(Predicate<String> predicate) {
        for (String item : this.comments) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingComment(Predicate<String> predicate) {
        for (String item : this.comments) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withComments(List<String> comments) {
        if (comments != null) {
            this.comments = new ArrayList<String>();
            for (String item : comments) {
                this.addToComments(item);
            }
        } else {
            this.comments = null;
        }
        return (A)this;
    }

    @Override
    public A withComments(String ... comments) {
        if (this.comments != null) {
            this.comments.clear();
        }
        if (comments != null) {
            for (String item : comments) {
                this.addToComments(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasComments() {
        return this.comments != null && !this.comments.isEmpty();
    }

    @Override
    public A addToAnnotations(Integer index, AnnotationRef item) {
        if (this.annotations == null) {
            this.annotations = new ArrayList();
        }
        AnnotationRefBuilder builder = new AnnotationRefBuilder(item);
        this._visitables.get((Object)"annotations").add(index >= 0 ? index.intValue() : this._visitables.get((Object)"annotations").size(), builder);
        this.annotations.add(index >= 0 ? index.intValue() : this.annotations.size(), builder);
        return (A)this;
    }

    @Override
    public A setToAnnotations(Integer index, AnnotationRef item) {
        if (this.annotations == null) {
            this.annotations = new ArrayList();
        }
        AnnotationRefBuilder builder = new AnnotationRefBuilder(item);
        if (index < 0 || index >= this._visitables.get((Object)"annotations").size()) {
            this._visitables.get((Object)"annotations").add(builder);
        } else {
            this._visitables.get((Object)"annotations").set(index, builder);
        }
        if (index < 0 || index >= this.annotations.size()) {
            this.annotations.add(builder);
        } else {
            this.annotations.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToAnnotations(AnnotationRef ... items) {
        if (this.annotations == null) {
            this.annotations = new ArrayList();
        }
        for (AnnotationRef item : items) {
            AnnotationRefBuilder builder = new AnnotationRefBuilder(item);
            this._visitables.get((Object)"annotations").add(builder);
            this.annotations.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToAnnotations(Collection<AnnotationRef> items) {
        if (this.annotations == null) {
            this.annotations = new ArrayList();
        }
        for (AnnotationRef item : items) {
            AnnotationRefBuilder builder = new AnnotationRefBuilder(item);
            this._visitables.get((Object)"annotations").add(builder);
            this.annotations.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromAnnotations(AnnotationRef ... items) {
        for (AnnotationRef item : items) {
            AnnotationRefBuilder builder = new AnnotationRefBuilder(item);
            this._visitables.get((Object)"annotations").remove(builder);
            if (this.annotations == null) continue;
            this.annotations.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromAnnotations(Collection<AnnotationRef> items) {
        for (AnnotationRef item : items) {
            AnnotationRefBuilder builder = new AnnotationRefBuilder(item);
            this._visitables.get((Object)"annotations").remove(builder);
            if (this.annotations == null) continue;
            this.annotations.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromAnnotations(Predicate<AnnotationRefBuilder> predicate) {
        if (this.annotations == null) {
            return (A)this;
        }
        Iterator<AnnotationRefBuilder> each = this.annotations.iterator();
        List visitables = this._visitables.get((Object)"annotations");
        while (each.hasNext()) {
            AnnotationRefBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<AnnotationRef> getAnnotations() {
        return this.annotations != null ? MethodFluentImpl.build(this.annotations) : null;
    }

    @Override
    public List<AnnotationRef> buildAnnotations() {
        return this.annotations != null ? MethodFluentImpl.build(this.annotations) : null;
    }

    @Override
    public AnnotationRef buildAnnotation(Integer index) {
        return this.annotations.get(index).build();
    }

    @Override
    public AnnotationRef buildFirstAnnotation() {
        return this.annotations.get(0).build();
    }

    @Override
    public AnnotationRef buildLastAnnotation() {
        return this.annotations.get(this.annotations.size() - 1).build();
    }

    @Override
    public AnnotationRef buildMatchingAnnotation(Predicate<AnnotationRefBuilder> predicate) {
        for (AnnotationRefBuilder item : this.annotations) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingAnnotation(Predicate<AnnotationRefBuilder> predicate) {
        for (AnnotationRefBuilder item : this.annotations) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withAnnotations(List<AnnotationRef> annotations) {
        if (this.annotations != null) {
            this._visitables.get((Object)"annotations").removeAll(this.annotations);
        }
        if (annotations != null) {
            this.annotations = new ArrayList();
            for (AnnotationRef item : annotations) {
                this.addToAnnotations(item);
            }
        } else {
            this.annotations = null;
        }
        return (A)this;
    }

    @Override
    public A withAnnotations(AnnotationRef ... annotations) {
        if (this.annotations != null) {
            this.annotations.clear();
        }
        if (annotations != null) {
            for (AnnotationRef item : annotations) {
                this.addToAnnotations(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasAnnotations() {
        return this.annotations != null && !this.annotations.isEmpty();
    }

    @Override
    public MethodFluent.AnnotationsNested<A> addNewAnnotation() {
        return new AnnotationsNestedImpl();
    }

    @Override
    public MethodFluent.AnnotationsNested<A> addNewAnnotationLike(AnnotationRef item) {
        return new AnnotationsNestedImpl(-1, item);
    }

    @Override
    public MethodFluent.AnnotationsNested<A> setNewAnnotationLike(Integer index, AnnotationRef item) {
        return new AnnotationsNestedImpl(index, item);
    }

    @Override
    public MethodFluent.AnnotationsNested<A> editAnnotation(Integer index) {
        if (this.annotations.size() <= index) {
            throw new RuntimeException("Can't edit annotations. Index exceeds size.");
        }
        return this.setNewAnnotationLike(index, this.buildAnnotation(index));
    }

    @Override
    public MethodFluent.AnnotationsNested<A> editFirstAnnotation() {
        if (this.annotations.size() == 0) {
            throw new RuntimeException("Can't edit first annotations. The list is empty.");
        }
        return this.setNewAnnotationLike(0, this.buildAnnotation(0));
    }

    @Override
    public MethodFluent.AnnotationsNested<A> editLastAnnotation() {
        int index = this.annotations.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last annotations. The list is empty.");
        }
        return this.setNewAnnotationLike(index, this.buildAnnotation(index));
    }

    @Override
    public MethodFluent.AnnotationsNested<A> editMatchingAnnotation(Predicate<AnnotationRefBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.annotations.size(); ++i) {
            if (!predicate.test(this.annotations.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching annotations. No match found.");
        }
        return this.setNewAnnotationLike(index, this.buildAnnotation(index));
    }

    @Override
    public A addToParameters(Integer index, TypeParamDef item) {
        if (this.parameters == null) {
            this.parameters = new ArrayList();
        }
        TypeParamDefBuilder builder = new TypeParamDefBuilder(item);
        this._visitables.get((Object)"parameters").add(index >= 0 ? index.intValue() : this._visitables.get((Object)"parameters").size(), builder);
        this.parameters.add(index >= 0 ? index.intValue() : this.parameters.size(), builder);
        return (A)this;
    }

    @Override
    public A setToParameters(Integer index, TypeParamDef item) {
        if (this.parameters == null) {
            this.parameters = new ArrayList();
        }
        TypeParamDefBuilder builder = new TypeParamDefBuilder(item);
        if (index < 0 || index >= this._visitables.get((Object)"parameters").size()) {
            this._visitables.get((Object)"parameters").add(builder);
        } else {
            this._visitables.get((Object)"parameters").set(index, builder);
        }
        if (index < 0 || index >= this.parameters.size()) {
            this.parameters.add(builder);
        } else {
            this.parameters.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToParameters(TypeParamDef ... items) {
        if (this.parameters == null) {
            this.parameters = new ArrayList();
        }
        for (TypeParamDef item : items) {
            TypeParamDefBuilder builder = new TypeParamDefBuilder(item);
            this._visitables.get((Object)"parameters").add(builder);
            this.parameters.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToParameters(Collection<TypeParamDef> items) {
        if (this.parameters == null) {
            this.parameters = new ArrayList();
        }
        for (TypeParamDef item : items) {
            TypeParamDefBuilder builder = new TypeParamDefBuilder(item);
            this._visitables.get((Object)"parameters").add(builder);
            this.parameters.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromParameters(TypeParamDef ... items) {
        for (TypeParamDef item : items) {
            TypeParamDefBuilder builder = new TypeParamDefBuilder(item);
            this._visitables.get((Object)"parameters").remove(builder);
            if (this.parameters == null) continue;
            this.parameters.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromParameters(Collection<TypeParamDef> items) {
        for (TypeParamDef item : items) {
            TypeParamDefBuilder builder = new TypeParamDefBuilder(item);
            this._visitables.get((Object)"parameters").remove(builder);
            if (this.parameters == null) continue;
            this.parameters.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromParameters(Predicate<TypeParamDefBuilder> predicate) {
        if (this.parameters == null) {
            return (A)this;
        }
        Iterator<TypeParamDefBuilder> each = this.parameters.iterator();
        List visitables = this._visitables.get((Object)"parameters");
        while (each.hasNext()) {
            TypeParamDefBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<TypeParamDef> getParameters() {
        return this.parameters != null ? MethodFluentImpl.build(this.parameters) : null;
    }

    @Override
    public List<TypeParamDef> buildParameters() {
        return this.parameters != null ? MethodFluentImpl.build(this.parameters) : null;
    }

    @Override
    public TypeParamDef buildParameter(Integer index) {
        return this.parameters.get(index).build();
    }

    @Override
    public TypeParamDef buildFirstParameter() {
        return this.parameters.get(0).build();
    }

    @Override
    public TypeParamDef buildLastParameter() {
        return this.parameters.get(this.parameters.size() - 1).build();
    }

    @Override
    public TypeParamDef buildMatchingParameter(Predicate<TypeParamDefBuilder> predicate) {
        for (TypeParamDefBuilder item : this.parameters) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingParameter(Predicate<TypeParamDefBuilder> predicate) {
        for (TypeParamDefBuilder item : this.parameters) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withParameters(List<TypeParamDef> parameters) {
        if (this.parameters != null) {
            this._visitables.get((Object)"parameters").removeAll(this.parameters);
        }
        if (parameters != null) {
            this.parameters = new ArrayList();
            for (TypeParamDef item : parameters) {
                this.addToParameters(item);
            }
        } else {
            this.parameters = null;
        }
        return (A)this;
    }

    @Override
    public A withParameters(TypeParamDef ... parameters) {
        if (this.parameters != null) {
            this.parameters.clear();
        }
        if (parameters != null) {
            for (TypeParamDef item : parameters) {
                this.addToParameters(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasParameters() {
        return this.parameters != null && !this.parameters.isEmpty();
    }

    @Override
    public MethodFluent.ParametersNested<A> addNewParameter() {
        return new ParametersNestedImpl();
    }

    @Override
    public MethodFluent.ParametersNested<A> addNewParameterLike(TypeParamDef item) {
        return new ParametersNestedImpl(-1, item);
    }

    @Override
    public MethodFluent.ParametersNested<A> setNewParameterLike(Integer index, TypeParamDef item) {
        return new ParametersNestedImpl(index, item);
    }

    @Override
    public MethodFluent.ParametersNested<A> editParameter(Integer index) {
        if (this.parameters.size() <= index) {
            throw new RuntimeException("Can't edit parameters. Index exceeds size.");
        }
        return this.setNewParameterLike(index, this.buildParameter(index));
    }

    @Override
    public MethodFluent.ParametersNested<A> editFirstParameter() {
        if (this.parameters.size() == 0) {
            throw new RuntimeException("Can't edit first parameters. The list is empty.");
        }
        return this.setNewParameterLike(0, this.buildParameter(0));
    }

    @Override
    public MethodFluent.ParametersNested<A> editLastParameter() {
        int index = this.parameters.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last parameters. The list is empty.");
        }
        return this.setNewParameterLike(index, this.buildParameter(index));
    }

    @Override
    public MethodFluent.ParametersNested<A> editMatchingParameter(Predicate<TypeParamDefBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.parameters.size(); ++i) {
            if (!predicate.test(this.parameters.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching parameters. No match found.");
        }
        return this.setNewParameterLike(index, this.buildParameter(index));
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public A withName(String name) {
        this.name = name;
        return (A)this;
    }

    @Override
    public Boolean hasName() {
        return this.name != null;
    }

    @Override
    @Deprecated
    public TypeRef getReturnType() {
        return this.returnType != null ? (TypeRef)this.returnType.build() : null;
    }

    @Override
    public TypeRef buildReturnType() {
        return this.returnType != null ? (TypeRef)this.returnType.build() : null;
    }

    @Override
    public A withReturnType(TypeRef returnType) {
        if (returnType instanceof TypeParamRef) {
            this.returnType = new TypeParamRefBuilder((TypeParamRef)returnType);
            this._visitables.get((Object)"returnType").add(this.returnType);
        }
        if (returnType instanceof WildcardRef) {
            this.returnType = new WildcardRefBuilder((WildcardRef)returnType);
            this._visitables.get((Object)"returnType").add(this.returnType);
        }
        if (returnType instanceof ClassRef) {
            this.returnType = new ClassRefBuilder((ClassRef)returnType);
            this._visitables.get((Object)"returnType").add(this.returnType);
        }
        if (returnType instanceof PrimitiveRef) {
            this.returnType = new PrimitiveRefBuilder((PrimitiveRef)returnType);
            this._visitables.get((Object)"returnType").add(this.returnType);
        }
        if (returnType instanceof VoidRef) {
            this.returnType = new VoidRefBuilder((VoidRef)returnType);
            this._visitables.get((Object)"returnType").add(this.returnType);
        }
        return (A)this;
    }

    @Override
    public Boolean hasReturnType() {
        return this.returnType != null;
    }

    @Override
    public A withTypeParamRefReturnType(TypeParamRef typeParamRefReturnType) {
        this._visitables.get((Object)"returnType").remove(this.returnType);
        if (typeParamRefReturnType != null) {
            this.returnType = new TypeParamRefBuilder(typeParamRefReturnType);
            this._visitables.get((Object)"returnType").add(this.returnType);
        }
        return (A)this;
    }

    @Override
    public MethodFluent.TypeParamRefReturnTypeNested<A> withNewTypeParamRefReturnType() {
        return new TypeParamRefReturnTypeNestedImpl();
    }

    @Override
    public MethodFluent.TypeParamRefReturnTypeNested<A> withNewTypeParamRefReturnTypeLike(TypeParamRef item) {
        return new TypeParamRefReturnTypeNestedImpl(item);
    }

    @Override
    public A withWildcardRefReturnType(WildcardRef wildcardRefReturnType) {
        this._visitables.get((Object)"returnType").remove(this.returnType);
        if (wildcardRefReturnType != null) {
            this.returnType = new WildcardRefBuilder(wildcardRefReturnType);
            this._visitables.get((Object)"returnType").add(this.returnType);
        }
        return (A)this;
    }

    @Override
    public MethodFluent.WildcardRefReturnTypeNested<A> withNewWildcardRefReturnType() {
        return new WildcardRefReturnTypeNestedImpl();
    }

    @Override
    public MethodFluent.WildcardRefReturnTypeNested<A> withNewWildcardRefReturnTypeLike(WildcardRef item) {
        return new WildcardRefReturnTypeNestedImpl(item);
    }

    @Override
    public A withClassRefReturnType(ClassRef classRefReturnType) {
        this._visitables.get((Object)"returnType").remove(this.returnType);
        if (classRefReturnType != null) {
            this.returnType = new ClassRefBuilder(classRefReturnType);
            this._visitables.get((Object)"returnType").add(this.returnType);
        }
        return (A)this;
    }

    @Override
    public MethodFluent.ClassRefReturnTypeNested<A> withNewClassRefReturnType() {
        return new ClassRefReturnTypeNestedImpl();
    }

    @Override
    public MethodFluent.ClassRefReturnTypeNested<A> withNewClassRefReturnTypeLike(ClassRef item) {
        return new ClassRefReturnTypeNestedImpl(item);
    }

    @Override
    public A withPrimitiveRefReturnType(PrimitiveRef primitiveRefReturnType) {
        this._visitables.get((Object)"returnType").remove(this.returnType);
        if (primitiveRefReturnType != null) {
            this.returnType = new PrimitiveRefBuilder(primitiveRefReturnType);
            this._visitables.get((Object)"returnType").add(this.returnType);
        }
        return (A)this;
    }

    @Override
    public MethodFluent.PrimitiveRefReturnTypeNested<A> withNewPrimitiveRefReturnType() {
        return new PrimitiveRefReturnTypeNestedImpl();
    }

    @Override
    public MethodFluent.PrimitiveRefReturnTypeNested<A> withNewPrimitiveRefReturnTypeLike(PrimitiveRef item) {
        return new PrimitiveRefReturnTypeNestedImpl(item);
    }

    @Override
    public A withVoidRefReturnType(VoidRef voidRefReturnType) {
        this._visitables.get((Object)"returnType").remove(this.returnType);
        if (voidRefReturnType != null) {
            this.returnType = new VoidRefBuilder(voidRefReturnType);
            this._visitables.get((Object)"returnType").add(this.returnType);
        }
        return (A)this;
    }

    @Override
    public MethodFluent.VoidRefReturnTypeNested<A> withNewVoidRefReturnType() {
        return new VoidRefReturnTypeNestedImpl();
    }

    @Override
    public MethodFluent.VoidRefReturnTypeNested<A> withNewVoidRefReturnTypeLike(VoidRef item) {
        return new VoidRefReturnTypeNestedImpl(item);
    }

    @Override
    public A addToArguments(Integer index, Property item) {
        if (this.arguments == null) {
            this.arguments = new ArrayList();
        }
        PropertyBuilder builder = new PropertyBuilder(item);
        this._visitables.get((Object)"arguments").add(index >= 0 ? index.intValue() : this._visitables.get((Object)"arguments").size(), builder);
        this.arguments.add(index >= 0 ? index.intValue() : this.arguments.size(), builder);
        return (A)this;
    }

    @Override
    public A setToArguments(Integer index, Property item) {
        if (this.arguments == null) {
            this.arguments = new ArrayList();
        }
        PropertyBuilder builder = new PropertyBuilder(item);
        if (index < 0 || index >= this._visitables.get((Object)"arguments").size()) {
            this._visitables.get((Object)"arguments").add(builder);
        } else {
            this._visitables.get((Object)"arguments").set(index, builder);
        }
        if (index < 0 || index >= this.arguments.size()) {
            this.arguments.add(builder);
        } else {
            this.arguments.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToArguments(Property ... items) {
        if (this.arguments == null) {
            this.arguments = new ArrayList();
        }
        for (Property item : items) {
            PropertyBuilder builder = new PropertyBuilder(item);
            this._visitables.get((Object)"arguments").add(builder);
            this.arguments.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToArguments(Collection<Property> items) {
        if (this.arguments == null) {
            this.arguments = new ArrayList();
        }
        for (Property item : items) {
            PropertyBuilder builder = new PropertyBuilder(item);
            this._visitables.get((Object)"arguments").add(builder);
            this.arguments.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromArguments(Property ... items) {
        for (Property item : items) {
            PropertyBuilder builder = new PropertyBuilder(item);
            this._visitables.get((Object)"arguments").remove(builder);
            if (this.arguments == null) continue;
            this.arguments.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromArguments(Collection<Property> items) {
        for (Property item : items) {
            PropertyBuilder builder = new PropertyBuilder(item);
            this._visitables.get((Object)"arguments").remove(builder);
            if (this.arguments == null) continue;
            this.arguments.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromArguments(Predicate<PropertyBuilder> predicate) {
        if (this.arguments == null) {
            return (A)this;
        }
        Iterator<PropertyBuilder> each = this.arguments.iterator();
        List visitables = this._visitables.get((Object)"arguments");
        while (each.hasNext()) {
            PropertyBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<Property> getArguments() {
        return this.arguments != null ? MethodFluentImpl.build(this.arguments) : null;
    }

    @Override
    public List<Property> buildArguments() {
        return this.arguments != null ? MethodFluentImpl.build(this.arguments) : null;
    }

    @Override
    public Property buildArgument(Integer index) {
        return this.arguments.get(index).build();
    }

    @Override
    public Property buildFirstArgument() {
        return this.arguments.get(0).build();
    }

    @Override
    public Property buildLastArgument() {
        return this.arguments.get(this.arguments.size() - 1).build();
    }

    @Override
    public Property buildMatchingArgument(Predicate<PropertyBuilder> predicate) {
        for (PropertyBuilder item : this.arguments) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingArgument(Predicate<PropertyBuilder> predicate) {
        for (PropertyBuilder item : this.arguments) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withArguments(List<Property> arguments) {
        if (this.arguments != null) {
            this._visitables.get((Object)"arguments").removeAll(this.arguments);
        }
        if (arguments != null) {
            this.arguments = new ArrayList();
            for (Property item : arguments) {
                this.addToArguments(item);
            }
        } else {
            this.arguments = null;
        }
        return (A)this;
    }

    @Override
    public A withArguments(Property ... arguments) {
        if (this.arguments != null) {
            this.arguments.clear();
        }
        if (arguments != null) {
            for (Property item : arguments) {
                this.addToArguments(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasArguments() {
        return this.arguments != null && !this.arguments.isEmpty();
    }

    @Override
    public MethodFluent.ArgumentsNested<A> addNewArgument() {
        return new ArgumentsNestedImpl();
    }

    @Override
    public MethodFluent.ArgumentsNested<A> addNewArgumentLike(Property item) {
        return new ArgumentsNestedImpl(-1, item);
    }

    @Override
    public MethodFluent.ArgumentsNested<A> setNewArgumentLike(Integer index, Property item) {
        return new ArgumentsNestedImpl(index, item);
    }

    @Override
    public MethodFluent.ArgumentsNested<A> editArgument(Integer index) {
        if (this.arguments.size() <= index) {
            throw new RuntimeException("Can't edit arguments. Index exceeds size.");
        }
        return this.setNewArgumentLike(index, this.buildArgument(index));
    }

    @Override
    public MethodFluent.ArgumentsNested<A> editFirstArgument() {
        if (this.arguments.size() == 0) {
            throw new RuntimeException("Can't edit first arguments. The list is empty.");
        }
        return this.setNewArgumentLike(0, this.buildArgument(0));
    }

    @Override
    public MethodFluent.ArgumentsNested<A> editLastArgument() {
        int index = this.arguments.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last arguments. The list is empty.");
        }
        return this.setNewArgumentLike(index, this.buildArgument(index));
    }

    @Override
    public MethodFluent.ArgumentsNested<A> editMatchingArgument(Predicate<PropertyBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.arguments.size(); ++i) {
            if (!predicate.test(this.arguments.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching arguments. No match found.");
        }
        return this.setNewArgumentLike(index, this.buildArgument(index));
    }

    @Override
    public boolean isVarArgPreferred() {
        return this.varArgPreferred;
    }

    @Override
    public A withVarArgPreferred(boolean varArgPreferred) {
        this.varArgPreferred = varArgPreferred;
        return (A)this;
    }

    @Override
    public Boolean hasVarArgPreferred() {
        return true;
    }

    @Override
    public A addToExceptions(Integer index, ClassRef item) {
        if (this.exceptions == null) {
            this.exceptions = new ArrayList();
        }
        ClassRefBuilder builder = new ClassRefBuilder(item);
        this._visitables.get((Object)"exceptions").add(index >= 0 ? index.intValue() : this._visitables.get((Object)"exceptions").size(), builder);
        this.exceptions.add(index >= 0 ? index.intValue() : this.exceptions.size(), builder);
        return (A)this;
    }

    @Override
    public A setToExceptions(Integer index, ClassRef item) {
        if (this.exceptions == null) {
            this.exceptions = new ArrayList();
        }
        ClassRefBuilder builder = new ClassRefBuilder(item);
        if (index < 0 || index >= this._visitables.get((Object)"exceptions").size()) {
            this._visitables.get((Object)"exceptions").add(builder);
        } else {
            this._visitables.get((Object)"exceptions").set(index, builder);
        }
        if (index < 0 || index >= this.exceptions.size()) {
            this.exceptions.add(builder);
        } else {
            this.exceptions.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToExceptions(ClassRef ... items) {
        if (this.exceptions == null) {
            this.exceptions = new ArrayList();
        }
        for (ClassRef item : items) {
            ClassRefBuilder builder = new ClassRefBuilder(item);
            this._visitables.get((Object)"exceptions").add(builder);
            this.exceptions.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToExceptions(Collection<ClassRef> items) {
        if (this.exceptions == null) {
            this.exceptions = new ArrayList();
        }
        for (ClassRef item : items) {
            ClassRefBuilder builder = new ClassRefBuilder(item);
            this._visitables.get((Object)"exceptions").add(builder);
            this.exceptions.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromExceptions(ClassRef ... items) {
        for (ClassRef item : items) {
            ClassRefBuilder builder = new ClassRefBuilder(item);
            this._visitables.get((Object)"exceptions").remove(builder);
            if (this.exceptions == null) continue;
            this.exceptions.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromExceptions(Collection<ClassRef> items) {
        for (ClassRef item : items) {
            ClassRefBuilder builder = new ClassRefBuilder(item);
            this._visitables.get((Object)"exceptions").remove(builder);
            if (this.exceptions == null) continue;
            this.exceptions.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromExceptions(Predicate<ClassRefBuilder> predicate) {
        if (this.exceptions == null) {
            return (A)this;
        }
        Iterator<ClassRefBuilder> each = this.exceptions.iterator();
        List visitables = this._visitables.get((Object)"exceptions");
        while (each.hasNext()) {
            ClassRefBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<ClassRef> getExceptions() {
        return this.exceptions != null ? MethodFluentImpl.build(this.exceptions) : null;
    }

    @Override
    public List<ClassRef> buildExceptions() {
        return this.exceptions != null ? MethodFluentImpl.build(this.exceptions) : null;
    }

    @Override
    public ClassRef buildException(Integer index) {
        return this.exceptions.get(index).build();
    }

    @Override
    public ClassRef buildFirstException() {
        return this.exceptions.get(0).build();
    }

    @Override
    public ClassRef buildLastException() {
        return this.exceptions.get(this.exceptions.size() - 1).build();
    }

    @Override
    public ClassRef buildMatchingException(Predicate<ClassRefBuilder> predicate) {
        for (ClassRefBuilder item : this.exceptions) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingException(Predicate<ClassRefBuilder> predicate) {
        for (ClassRefBuilder item : this.exceptions) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withExceptions(List<ClassRef> exceptions) {
        if (this.exceptions != null) {
            this._visitables.get((Object)"exceptions").removeAll(this.exceptions);
        }
        if (exceptions != null) {
            this.exceptions = new ArrayList();
            for (ClassRef item : exceptions) {
                this.addToExceptions(item);
            }
        } else {
            this.exceptions = null;
        }
        return (A)this;
    }

    @Override
    public A withExceptions(ClassRef ... exceptions) {
        if (this.exceptions != null) {
            this.exceptions.clear();
        }
        if (exceptions != null) {
            for (ClassRef item : exceptions) {
                this.addToExceptions(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasExceptions() {
        return this.exceptions != null && !this.exceptions.isEmpty();
    }

    @Override
    public MethodFluent.ExceptionsNested<A> addNewException() {
        return new ExceptionsNestedImpl();
    }

    @Override
    public MethodFluent.ExceptionsNested<A> addNewExceptionLike(ClassRef item) {
        return new ExceptionsNestedImpl(-1, item);
    }

    @Override
    public MethodFluent.ExceptionsNested<A> setNewExceptionLike(Integer index, ClassRef item) {
        return new ExceptionsNestedImpl(index, item);
    }

    @Override
    public MethodFluent.ExceptionsNested<A> editException(Integer index) {
        if (this.exceptions.size() <= index) {
            throw new RuntimeException("Can't edit exceptions. Index exceeds size.");
        }
        return this.setNewExceptionLike(index, this.buildException(index));
    }

    @Override
    public MethodFluent.ExceptionsNested<A> editFirstException() {
        if (this.exceptions.size() == 0) {
            throw new RuntimeException("Can't edit first exceptions. The list is empty.");
        }
        return this.setNewExceptionLike(0, this.buildException(0));
    }

    @Override
    public MethodFluent.ExceptionsNested<A> editLastException() {
        int index = this.exceptions.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last exceptions. The list is empty.");
        }
        return this.setNewExceptionLike(index, this.buildException(index));
    }

    @Override
    public MethodFluent.ExceptionsNested<A> editMatchingException(Predicate<ClassRefBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.exceptions.size(); ++i) {
            if (!predicate.test(this.exceptions.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching exceptions. No match found.");
        }
        return this.setNewExceptionLike(index, this.buildException(index));
    }

    @Override
    public boolean isDefaultMethod() {
        return this.defaultMethod;
    }

    @Override
    public A withDefaultMethod(boolean defaultMethod) {
        this.defaultMethod = defaultMethod;
        return (A)this;
    }

    @Override
    public Boolean hasDefaultMethod() {
        return true;
    }

    @Override
    @Deprecated
    public Block getBlock() {
        return this.block != null ? this.block.build() : null;
    }

    @Override
    public Block buildBlock() {
        return this.block != null ? this.block.build() : null;
    }

    @Override
    public A withBlock(Block block) {
        this._visitables.get((Object)"block").remove(this.block);
        if (block != null) {
            this.block = new BlockBuilder(block);
            this._visitables.get((Object)"block").add(this.block);
        }
        return (A)this;
    }

    @Override
    public Boolean hasBlock() {
        return this.block != null;
    }

    @Override
    public MethodFluent.BlockNested<A> withNewBlock() {
        return new BlockNestedImpl();
    }

    @Override
    public MethodFluent.BlockNested<A> withNewBlockLike(Block item) {
        return new BlockNestedImpl(item);
    }

    @Override
    public MethodFluent.BlockNested<A> editBlock() {
        return this.withNewBlockLike(this.getBlock());
    }

    @Override
    public MethodFluent.BlockNested<A> editOrNewBlock() {
        return this.withNewBlockLike(this.getBlock() != null ? this.getBlock() : new BlockBuilder().build());
    }

    @Override
    public MethodFluent.BlockNested<A> editOrNewBlockLike(Block item) {
        return this.withNewBlockLike(this.getBlock() != null ? this.getBlock() : item);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        MethodFluentImpl that = (MethodFluentImpl)o;
        if (this.comments != null ? !this.comments.equals(that.comments) : that.comments != null) {
            return false;
        }
        if (this.annotations != null ? !this.annotations.equals(that.annotations) : that.annotations != null) {
            return false;
        }
        if (this.parameters != null ? !this.parameters.equals(that.parameters) : that.parameters != null) {
            return false;
        }
        if (this.name != null ? !this.name.equals(that.name) : that.name != null) {
            return false;
        }
        if (this.returnType != null ? !this.returnType.equals(that.returnType) : that.returnType != null) {
            return false;
        }
        if (this.arguments != null ? !this.arguments.equals(that.arguments) : that.arguments != null) {
            return false;
        }
        if (this.varArgPreferred != that.varArgPreferred) {
            return false;
        }
        if (this.exceptions != null ? !this.exceptions.equals(that.exceptions) : that.exceptions != null) {
            return false;
        }
        if (this.defaultMethod != that.defaultMethod) {
            return false;
        }
        return !(this.block != null ? !this.block.equals(that.block) : that.block != null);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.comments, this.annotations, this.parameters, this.name, this.returnType, this.arguments, this.varArgPreferred, this.exceptions, this.defaultMethod, this.block, super.hashCode());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.comments != null && !this.comments.isEmpty()) {
            sb.append("comments:");
            sb.append(this.comments + ",");
        }
        if (this.annotations != null && !this.annotations.isEmpty()) {
            sb.append("annotations:");
            sb.append(this.annotations + ",");
        }
        if (this.parameters != null && !this.parameters.isEmpty()) {
            sb.append("parameters:");
            sb.append(this.parameters + ",");
        }
        if (this.name != null) {
            sb.append("name:");
            sb.append(this.name + ",");
        }
        if (this.returnType != null) {
            sb.append("returnType:");
            sb.append(this.returnType + ",");
        }
        if (this.arguments != null && !this.arguments.isEmpty()) {
            sb.append("arguments:");
            sb.append(this.arguments + ",");
        }
        sb.append("varArgPreferred:");
        sb.append(this.varArgPreferred + ",");
        if (this.exceptions != null && !this.exceptions.isEmpty()) {
            sb.append("exceptions:");
            sb.append(this.exceptions + ",");
        }
        sb.append("defaultMethod:");
        sb.append(this.defaultMethod + ",");
        if (this.block != null) {
            sb.append("block:");
            sb.append(this.block);
        }
        sb.append("}");
        return sb.toString();
    }

    class BlockNestedImpl<N>
    extends BlockFluentImpl<MethodFluent.BlockNested<N>>
    implements MethodFluent.BlockNested<N>,
    Nested<N> {
        BlockBuilder builder;

        BlockNestedImpl(Block item) {
            this.builder = new BlockBuilder(this, item);
        }

        BlockNestedImpl() {
            this.builder = new BlockBuilder(this);
        }

        @Override
        public N and() {
            return (N)MethodFluentImpl.this.withBlock(this.builder.build());
        }

        @Override
        public N endBlock() {
            return this.and();
        }
    }

    class ExceptionsNestedImpl<N>
    extends ClassRefFluentImpl<MethodFluent.ExceptionsNested<N>>
    implements MethodFluent.ExceptionsNested<N>,
    Nested<N> {
        ClassRefBuilder builder;
        Integer index;

        ExceptionsNestedImpl(Integer index, ClassRef item) {
            this.index = index;
            this.builder = new ClassRefBuilder(this, item);
        }

        ExceptionsNestedImpl() {
            this.index = -1;
            this.builder = new ClassRefBuilder(this);
        }

        @Override
        public N and() {
            return (N)MethodFluentImpl.this.setToExceptions(this.index, this.builder.build());
        }

        @Override
        public N endException() {
            return this.and();
        }
    }

    class ArgumentsNestedImpl<N>
    extends PropertyFluentImpl<MethodFluent.ArgumentsNested<N>>
    implements MethodFluent.ArgumentsNested<N>,
    Nested<N> {
        PropertyBuilder builder;
        Integer index;

        ArgumentsNestedImpl(Integer index, Property item) {
            this.index = index;
            this.builder = new PropertyBuilder(this, item);
        }

        ArgumentsNestedImpl() {
            this.index = -1;
            this.builder = new PropertyBuilder(this);
        }

        @Override
        public N and() {
            return (N)MethodFluentImpl.this.setToArguments(this.index, this.builder.build());
        }

        @Override
        public N endArgument() {
            return this.and();
        }
    }

    class VoidRefReturnTypeNestedImpl<N>
    extends VoidRefFluentImpl<MethodFluent.VoidRefReturnTypeNested<N>>
    implements MethodFluent.VoidRefReturnTypeNested<N>,
    Nested<N> {
        VoidRefBuilder builder;

        VoidRefReturnTypeNestedImpl(VoidRef item) {
            this.builder = new VoidRefBuilder(this, item);
        }

        VoidRefReturnTypeNestedImpl() {
            this.builder = new VoidRefBuilder(this);
        }

        @Override
        public N and() {
            return (N)MethodFluentImpl.this.withReturnType((TypeRef)this.builder.build());
        }

        @Override
        public N endVoidRefReturnType() {
            return this.and();
        }
    }

    class PrimitiveRefReturnTypeNestedImpl<N>
    extends PrimitiveRefFluentImpl<MethodFluent.PrimitiveRefReturnTypeNested<N>>
    implements MethodFluent.PrimitiveRefReturnTypeNested<N>,
    Nested<N> {
        PrimitiveRefBuilder builder;

        PrimitiveRefReturnTypeNestedImpl(PrimitiveRef item) {
            this.builder = new PrimitiveRefBuilder(this, item);
        }

        PrimitiveRefReturnTypeNestedImpl() {
            this.builder = new PrimitiveRefBuilder(this);
        }

        @Override
        public N and() {
            return (N)MethodFluentImpl.this.withReturnType((TypeRef)this.builder.build());
        }

        @Override
        public N endPrimitiveRefReturnType() {
            return this.and();
        }
    }

    class ClassRefReturnTypeNestedImpl<N>
    extends ClassRefFluentImpl<MethodFluent.ClassRefReturnTypeNested<N>>
    implements MethodFluent.ClassRefReturnTypeNested<N>,
    Nested<N> {
        ClassRefBuilder builder;

        ClassRefReturnTypeNestedImpl(ClassRef item) {
            this.builder = new ClassRefBuilder(this, item);
        }

        ClassRefReturnTypeNestedImpl() {
            this.builder = new ClassRefBuilder(this);
        }

        @Override
        public N and() {
            return (N)MethodFluentImpl.this.withReturnType((TypeRef)this.builder.build());
        }

        @Override
        public N endClassRefReturnType() {
            return this.and();
        }
    }

    class WildcardRefReturnTypeNestedImpl<N>
    extends WildcardRefFluentImpl<MethodFluent.WildcardRefReturnTypeNested<N>>
    implements MethodFluent.WildcardRefReturnTypeNested<N>,
    Nested<N> {
        WildcardRefBuilder builder;

        WildcardRefReturnTypeNestedImpl(WildcardRef item) {
            this.builder = new WildcardRefBuilder(this, item);
        }

        WildcardRefReturnTypeNestedImpl() {
            this.builder = new WildcardRefBuilder(this);
        }

        @Override
        public N and() {
            return (N)MethodFluentImpl.this.withReturnType((TypeRef)this.builder.build());
        }

        @Override
        public N endWildcardRefReturnType() {
            return this.and();
        }
    }

    class TypeParamRefReturnTypeNestedImpl<N>
    extends TypeParamRefFluentImpl<MethodFluent.TypeParamRefReturnTypeNested<N>>
    implements MethodFluent.TypeParamRefReturnTypeNested<N>,
    Nested<N> {
        TypeParamRefBuilder builder;

        TypeParamRefReturnTypeNestedImpl(TypeParamRef item) {
            this.builder = new TypeParamRefBuilder(this, item);
        }

        TypeParamRefReturnTypeNestedImpl() {
            this.builder = new TypeParamRefBuilder(this);
        }

        @Override
        public N and() {
            return (N)MethodFluentImpl.this.withReturnType((TypeRef)this.builder.build());
        }

        @Override
        public N endTypeParamRefReturnType() {
            return this.and();
        }
    }

    class ParametersNestedImpl<N>
    extends TypeParamDefFluentImpl<MethodFluent.ParametersNested<N>>
    implements MethodFluent.ParametersNested<N>,
    Nested<N> {
        TypeParamDefBuilder builder;
        Integer index;

        ParametersNestedImpl(Integer index, TypeParamDef item) {
            this.index = index;
            this.builder = new TypeParamDefBuilder(this, item);
        }

        ParametersNestedImpl() {
            this.index = -1;
            this.builder = new TypeParamDefBuilder(this);
        }

        @Override
        public N and() {
            return (N)MethodFluentImpl.this.setToParameters(this.index, this.builder.build());
        }

        @Override
        public N endParameter() {
            return this.and();
        }
    }

    class AnnotationsNestedImpl<N>
    extends AnnotationRefFluentImpl<MethodFluent.AnnotationsNested<N>>
    implements MethodFluent.AnnotationsNested<N>,
    Nested<N> {
        AnnotationRefBuilder builder;
        Integer index;

        AnnotationsNestedImpl(Integer index, AnnotationRef item) {
            this.index = index;
            this.builder = new AnnotationRefBuilder(this, item);
        }

        AnnotationsNestedImpl() {
            this.index = -1;
            this.builder = new AnnotationRefBuilder(this);
        }

        @Override
        public N and() {
            return (N)MethodFluentImpl.this.setToAnnotations(this.index, this.builder.build());
        }

        @Override
        public N endAnnotation() {
            return this.and();
        }
    }
}

