/*
 * Decompiled with CFR 0.152.
 */
package io.sundr.model;

import io.sundr.builder.Nested;
import io.sundr.builder.VisitableBuilder;
import io.sundr.model.AnnotationRef;
import io.sundr.model.AnnotationRefBuilder;
import io.sundr.model.AnnotationRefFluentImpl;
import io.sundr.model.ClassRef;
import io.sundr.model.ClassRefBuilder;
import io.sundr.model.ClassRefFluentImpl;
import io.sundr.model.ModifierSupportFluentImpl;
import io.sundr.model.PrimitiveRef;
import io.sundr.model.PrimitiveRefBuilder;
import io.sundr.model.PrimitiveRefFluentImpl;
import io.sundr.model.Property;
import io.sundr.model.PropertyFluent;
import io.sundr.model.TypeParamRef;
import io.sundr.model.TypeParamRefBuilder;
import io.sundr.model.TypeParamRefFluentImpl;
import io.sundr.model.TypeRef;
import io.sundr.model.VoidRef;
import io.sundr.model.VoidRefBuilder;
import io.sundr.model.VoidRefFluentImpl;
import io.sundr.model.WildcardRef;
import io.sundr.model.WildcardRefBuilder;
import io.sundr.model.WildcardRefFluentImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;

public class PropertyFluentImpl<A extends PropertyFluent<A>>
extends ModifierSupportFluentImpl<A>
implements PropertyFluent<A> {
    private ArrayList<AnnotationRefBuilder> annotations = new ArrayList();
    private VisitableBuilder<? extends TypeRef, ?> typeRef;
    private String name;
    private List<String> comments = new ArrayList<String>();

    public PropertyFluentImpl() {
    }

    public PropertyFluentImpl(Property instance) {
        this.withAnnotations(instance.getAnnotations());
        this.withTypeRef(instance.getTypeRef());
        this.withName(instance.getName());
        this.withComments(instance.getComments());
        this.withModifiers(instance.getModifiers());
        this.withAttributes(instance.getAttributes());
    }

    @Override
    public A addToAnnotations(Integer index, AnnotationRef item) {
        if (this.annotations == null) {
            this.annotations = new ArrayList();
        }
        AnnotationRefBuilder builder = new AnnotationRefBuilder(item);
        this._visitables.get((Object)"annotations").add(index >= 0 ? index.intValue() : this._visitables.get((Object)"annotations").size(), builder);
        this.annotations.add(index >= 0 ? index.intValue() : this.annotations.size(), builder);
        return (A)this;
    }

    @Override
    public A setToAnnotations(Integer index, AnnotationRef item) {
        if (this.annotations == null) {
            this.annotations = new ArrayList();
        }
        AnnotationRefBuilder builder = new AnnotationRefBuilder(item);
        if (index < 0 || index >= this._visitables.get((Object)"annotations").size()) {
            this._visitables.get((Object)"annotations").add(builder);
        } else {
            this._visitables.get((Object)"annotations").set(index, builder);
        }
        if (index < 0 || index >= this.annotations.size()) {
            this.annotations.add(builder);
        } else {
            this.annotations.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToAnnotations(AnnotationRef ... items) {
        if (this.annotations == null) {
            this.annotations = new ArrayList();
        }
        for (AnnotationRef item : items) {
            AnnotationRefBuilder builder = new AnnotationRefBuilder(item);
            this._visitables.get((Object)"annotations").add(builder);
            this.annotations.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToAnnotations(Collection<AnnotationRef> items) {
        if (this.annotations == null) {
            this.annotations = new ArrayList();
        }
        for (AnnotationRef item : items) {
            AnnotationRefBuilder builder = new AnnotationRefBuilder(item);
            this._visitables.get((Object)"annotations").add(builder);
            this.annotations.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromAnnotations(AnnotationRef ... items) {
        for (AnnotationRef item : items) {
            AnnotationRefBuilder builder = new AnnotationRefBuilder(item);
            this._visitables.get((Object)"annotations").remove(builder);
            if (this.annotations == null) continue;
            this.annotations.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromAnnotations(Collection<AnnotationRef> items) {
        for (AnnotationRef item : items) {
            AnnotationRefBuilder builder = new AnnotationRefBuilder(item);
            this._visitables.get((Object)"annotations").remove(builder);
            if (this.annotations == null) continue;
            this.annotations.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromAnnotations(Predicate<AnnotationRefBuilder> predicate) {
        if (this.annotations == null) {
            return (A)this;
        }
        Iterator<AnnotationRefBuilder> each = this.annotations.iterator();
        List visitables = this._visitables.get((Object)"annotations");
        while (each.hasNext()) {
            AnnotationRefBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<AnnotationRef> getAnnotations() {
        return this.annotations != null ? PropertyFluentImpl.build(this.annotations) : null;
    }

    @Override
    public List<AnnotationRef> buildAnnotations() {
        return this.annotations != null ? PropertyFluentImpl.build(this.annotations) : null;
    }

    @Override
    public AnnotationRef buildAnnotation(Integer index) {
        return this.annotations.get(index).build();
    }

    @Override
    public AnnotationRef buildFirstAnnotation() {
        return this.annotations.get(0).build();
    }

    @Override
    public AnnotationRef buildLastAnnotation() {
        return this.annotations.get(this.annotations.size() - 1).build();
    }

    @Override
    public AnnotationRef buildMatchingAnnotation(Predicate<AnnotationRefBuilder> predicate) {
        for (AnnotationRefBuilder item : this.annotations) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingAnnotation(Predicate<AnnotationRefBuilder> predicate) {
        for (AnnotationRefBuilder item : this.annotations) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withAnnotations(List<AnnotationRef> annotations) {
        if (this.annotations != null) {
            this._visitables.get((Object)"annotations").removeAll(this.annotations);
        }
        if (annotations != null) {
            this.annotations = new ArrayList();
            for (AnnotationRef item : annotations) {
                this.addToAnnotations(item);
            }
        } else {
            this.annotations = null;
        }
        return (A)this;
    }

    @Override
    public A withAnnotations(AnnotationRef ... annotations) {
        if (this.annotations != null) {
            this.annotations.clear();
        }
        if (annotations != null) {
            for (AnnotationRef item : annotations) {
                this.addToAnnotations(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasAnnotations() {
        return this.annotations != null && !this.annotations.isEmpty();
    }

    @Override
    public PropertyFluent.AnnotationsNested<A> addNewAnnotation() {
        return new AnnotationsNestedImpl();
    }

    @Override
    public PropertyFluent.AnnotationsNested<A> addNewAnnotationLike(AnnotationRef item) {
        return new AnnotationsNestedImpl(-1, item);
    }

    @Override
    public PropertyFluent.AnnotationsNested<A> setNewAnnotationLike(Integer index, AnnotationRef item) {
        return new AnnotationsNestedImpl(index, item);
    }

    @Override
    public PropertyFluent.AnnotationsNested<A> editAnnotation(Integer index) {
        if (this.annotations.size() <= index) {
            throw new RuntimeException("Can't edit annotations. Index exceeds size.");
        }
        return this.setNewAnnotationLike(index, this.buildAnnotation(index));
    }

    @Override
    public PropertyFluent.AnnotationsNested<A> editFirstAnnotation() {
        if (this.annotations.size() == 0) {
            throw new RuntimeException("Can't edit first annotations. The list is empty.");
        }
        return this.setNewAnnotationLike(0, this.buildAnnotation(0));
    }

    @Override
    public PropertyFluent.AnnotationsNested<A> editLastAnnotation() {
        int index = this.annotations.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last annotations. The list is empty.");
        }
        return this.setNewAnnotationLike(index, this.buildAnnotation(index));
    }

    @Override
    public PropertyFluent.AnnotationsNested<A> editMatchingAnnotation(Predicate<AnnotationRefBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.annotations.size(); ++i) {
            if (!predicate.test(this.annotations.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching annotations. No match found.");
        }
        return this.setNewAnnotationLike(index, this.buildAnnotation(index));
    }

    @Override
    @Deprecated
    public TypeRef getTypeRef() {
        return this.typeRef != null ? (TypeRef)this.typeRef.build() : null;
    }

    @Override
    public TypeRef buildTypeRef() {
        return this.typeRef != null ? (TypeRef)this.typeRef.build() : null;
    }

    @Override
    public A withTypeRef(TypeRef typeRef) {
        if (typeRef instanceof TypeParamRef) {
            this.typeRef = new TypeParamRefBuilder((TypeParamRef)typeRef);
            this._visitables.get((Object)"typeRef").add(this.typeRef);
        }
        if (typeRef instanceof WildcardRef) {
            this.typeRef = new WildcardRefBuilder((WildcardRef)typeRef);
            this._visitables.get((Object)"typeRef").add(this.typeRef);
        }
        if (typeRef instanceof ClassRef) {
            this.typeRef = new ClassRefBuilder((ClassRef)typeRef);
            this._visitables.get((Object)"typeRef").add(this.typeRef);
        }
        if (typeRef instanceof PrimitiveRef) {
            this.typeRef = new PrimitiveRefBuilder((PrimitiveRef)typeRef);
            this._visitables.get((Object)"typeRef").add(this.typeRef);
        }
        if (typeRef instanceof VoidRef) {
            this.typeRef = new VoidRefBuilder((VoidRef)typeRef);
            this._visitables.get((Object)"typeRef").add(this.typeRef);
        }
        return (A)this;
    }

    @Override
    public Boolean hasTypeRef() {
        return this.typeRef != null;
    }

    @Override
    public A withTypeParamRefType(TypeParamRef typeParamRefType) {
        this._visitables.get((Object)"typeRef").remove(this.typeRef);
        if (typeParamRefType != null) {
            this.typeRef = new TypeParamRefBuilder(typeParamRefType);
            this._visitables.get((Object)"typeRef").add(this.typeRef);
        } else {
            this.typeRef = null;
            this._visitables.get((Object)"typeRef").remove(this.typeRef);
        }
        return (A)this;
    }

    @Override
    public PropertyFluent.TypeParamRefTypeNested<A> withNewTypeParamRefType() {
        return new TypeParamRefTypeNestedImpl();
    }

    @Override
    public PropertyFluent.TypeParamRefTypeNested<A> withNewTypeParamRefTypeLike(TypeParamRef item) {
        return new TypeParamRefTypeNestedImpl(item);
    }

    @Override
    public A withWildcardRefType(WildcardRef wildcardRefType) {
        this._visitables.get((Object)"typeRef").remove(this.typeRef);
        if (wildcardRefType != null) {
            this.typeRef = new WildcardRefBuilder(wildcardRefType);
            this._visitables.get((Object)"typeRef").add(this.typeRef);
        } else {
            this.typeRef = null;
            this._visitables.get((Object)"typeRef").remove(this.typeRef);
        }
        return (A)this;
    }

    @Override
    public PropertyFluent.WildcardRefTypeNested<A> withNewWildcardRefType() {
        return new WildcardRefTypeNestedImpl();
    }

    @Override
    public PropertyFluent.WildcardRefTypeNested<A> withNewWildcardRefTypeLike(WildcardRef item) {
        return new WildcardRefTypeNestedImpl(item);
    }

    @Override
    public A withClassRefType(ClassRef classRefType) {
        this._visitables.get((Object)"typeRef").remove(this.typeRef);
        if (classRefType != null) {
            this.typeRef = new ClassRefBuilder(classRefType);
            this._visitables.get((Object)"typeRef").add(this.typeRef);
        } else {
            this.typeRef = null;
            this._visitables.get((Object)"typeRef").remove(this.typeRef);
        }
        return (A)this;
    }

    @Override
    public PropertyFluent.ClassRefTypeNested<A> withNewClassRefType() {
        return new ClassRefTypeNestedImpl();
    }

    @Override
    public PropertyFluent.ClassRefTypeNested<A> withNewClassRefTypeLike(ClassRef item) {
        return new ClassRefTypeNestedImpl(item);
    }

    @Override
    public A withPrimitiveRefType(PrimitiveRef primitiveRefType) {
        this._visitables.get((Object)"typeRef").remove(this.typeRef);
        if (primitiveRefType != null) {
            this.typeRef = new PrimitiveRefBuilder(primitiveRefType);
            this._visitables.get((Object)"typeRef").add(this.typeRef);
        } else {
            this.typeRef = null;
            this._visitables.get((Object)"typeRef").remove(this.typeRef);
        }
        return (A)this;
    }

    @Override
    public PropertyFluent.PrimitiveRefTypeNested<A> withNewPrimitiveRefType() {
        return new PrimitiveRefTypeNestedImpl();
    }

    @Override
    public PropertyFluent.PrimitiveRefTypeNested<A> withNewPrimitiveRefTypeLike(PrimitiveRef item) {
        return new PrimitiveRefTypeNestedImpl(item);
    }

    @Override
    public A withVoidRefType(VoidRef voidRefType) {
        this._visitables.get((Object)"typeRef").remove(this.typeRef);
        if (voidRefType != null) {
            this.typeRef = new VoidRefBuilder(voidRefType);
            this._visitables.get((Object)"typeRef").add(this.typeRef);
        } else {
            this.typeRef = null;
            this._visitables.get((Object)"typeRef").remove(this.typeRef);
        }
        return (A)this;
    }

    @Override
    public PropertyFluent.VoidRefTypeNested<A> withNewVoidRefType() {
        return new VoidRefTypeNestedImpl();
    }

    @Override
    public PropertyFluent.VoidRefTypeNested<A> withNewVoidRefTypeLike(VoidRef item) {
        return new VoidRefTypeNestedImpl(item);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public A withName(String name) {
        this.name = name;
        return (A)this;
    }

    @Override
    public Boolean hasName() {
        return this.name != null;
    }

    @Override
    public A addToComments(Integer index, String item) {
        if (this.comments == null) {
            this.comments = new ArrayList<String>();
        }
        this.comments.add(index, item);
        return (A)this;
    }

    @Override
    public A setToComments(Integer index, String item) {
        if (this.comments == null) {
            this.comments = new ArrayList<String>();
        }
        this.comments.set(index, item);
        return (A)this;
    }

    @Override
    public A addToComments(String ... items) {
        if (this.comments == null) {
            this.comments = new ArrayList<String>();
        }
        for (String item : items) {
            this.comments.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToComments(Collection<String> items) {
        if (this.comments == null) {
            this.comments = new ArrayList<String>();
        }
        for (String item : items) {
            this.comments.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromComments(String ... items) {
        for (String item : items) {
            if (this.comments == null) continue;
            this.comments.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromComments(Collection<String> items) {
        for (String item : items) {
            if (this.comments == null) continue;
            this.comments.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getComments() {
        return this.comments;
    }

    @Override
    public String getComment(Integer index) {
        return this.comments.get(index);
    }

    @Override
    public String getFirstComment() {
        return this.comments.get(0);
    }

    @Override
    public String getLastComment() {
        return this.comments.get(this.comments.size() - 1);
    }

    @Override
    public String getMatchingComment(Predicate<String> predicate) {
        for (String item : this.comments) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingComment(Predicate<String> predicate) {
        for (String item : this.comments) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withComments(List<String> comments) {
        if (comments != null) {
            this.comments = new ArrayList<String>();
            for (String item : comments) {
                this.addToComments(item);
            }
        } else {
            this.comments = null;
        }
        return (A)this;
    }

    @Override
    public A withComments(String ... comments) {
        if (this.comments != null) {
            this.comments.clear();
        }
        if (comments != null) {
            for (String item : comments) {
                this.addToComments(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasComments() {
        return this.comments != null && !this.comments.isEmpty();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        PropertyFluentImpl that = (PropertyFluentImpl)o;
        if (this.annotations != null ? !this.annotations.equals(that.annotations) : that.annotations != null) {
            return false;
        }
        if (this.typeRef != null ? !this.typeRef.equals(that.typeRef) : that.typeRef != null) {
            return false;
        }
        if (this.name != null ? !this.name.equals(that.name) : that.name != null) {
            return false;
        }
        return !(this.comments != null ? !this.comments.equals(that.comments) : that.comments != null);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.annotations, this.typeRef, this.name, this.comments, super.hashCode());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.annotations != null && !this.annotations.isEmpty()) {
            sb.append("annotations:");
            sb.append(this.annotations + ",");
        }
        if (this.typeRef != null) {
            sb.append("typeRef:");
            sb.append(this.typeRef + ",");
        }
        if (this.name != null) {
            sb.append("name:");
            sb.append(this.name + ",");
        }
        if (this.comments != null && !this.comments.isEmpty()) {
            sb.append("comments:");
            sb.append(this.comments);
        }
        sb.append("}");
        return sb.toString();
    }

    class VoidRefTypeNestedImpl<N>
    extends VoidRefFluentImpl<PropertyFluent.VoidRefTypeNested<N>>
    implements PropertyFluent.VoidRefTypeNested<N>,
    Nested<N> {
        VoidRefBuilder builder;

        VoidRefTypeNestedImpl(VoidRef item) {
            this.builder = new VoidRefBuilder(this, item);
        }

        VoidRefTypeNestedImpl() {
            this.builder = new VoidRefBuilder(this);
        }

        @Override
        public N and() {
            return (N)PropertyFluentImpl.this.withTypeRef((TypeRef)this.builder.build());
        }

        @Override
        public N endVoidRefType() {
            return this.and();
        }
    }

    class PrimitiveRefTypeNestedImpl<N>
    extends PrimitiveRefFluentImpl<PropertyFluent.PrimitiveRefTypeNested<N>>
    implements PropertyFluent.PrimitiveRefTypeNested<N>,
    Nested<N> {
        PrimitiveRefBuilder builder;

        PrimitiveRefTypeNestedImpl(PrimitiveRef item) {
            this.builder = new PrimitiveRefBuilder(this, item);
        }

        PrimitiveRefTypeNestedImpl() {
            this.builder = new PrimitiveRefBuilder(this);
        }

        @Override
        public N and() {
            return (N)PropertyFluentImpl.this.withTypeRef((TypeRef)this.builder.build());
        }

        @Override
        public N endPrimitiveRefType() {
            return this.and();
        }
    }

    class ClassRefTypeNestedImpl<N>
    extends ClassRefFluentImpl<PropertyFluent.ClassRefTypeNested<N>>
    implements PropertyFluent.ClassRefTypeNested<N>,
    Nested<N> {
        ClassRefBuilder builder;

        ClassRefTypeNestedImpl(ClassRef item) {
            this.builder = new ClassRefBuilder(this, item);
        }

        ClassRefTypeNestedImpl() {
            this.builder = new ClassRefBuilder(this);
        }

        @Override
        public N and() {
            return (N)PropertyFluentImpl.this.withTypeRef((TypeRef)this.builder.build());
        }

        @Override
        public N endClassRefType() {
            return this.and();
        }
    }

    class WildcardRefTypeNestedImpl<N>
    extends WildcardRefFluentImpl<PropertyFluent.WildcardRefTypeNested<N>>
    implements PropertyFluent.WildcardRefTypeNested<N>,
    Nested<N> {
        WildcardRefBuilder builder;

        WildcardRefTypeNestedImpl(WildcardRef item) {
            this.builder = new WildcardRefBuilder(this, item);
        }

        WildcardRefTypeNestedImpl() {
            this.builder = new WildcardRefBuilder(this);
        }

        @Override
        public N and() {
            return (N)PropertyFluentImpl.this.withTypeRef((TypeRef)this.builder.build());
        }

        @Override
        public N endWildcardRefType() {
            return this.and();
        }
    }

    class TypeParamRefTypeNestedImpl<N>
    extends TypeParamRefFluentImpl<PropertyFluent.TypeParamRefTypeNested<N>>
    implements PropertyFluent.TypeParamRefTypeNested<N>,
    Nested<N> {
        TypeParamRefBuilder builder;

        TypeParamRefTypeNestedImpl(TypeParamRef item) {
            this.builder = new TypeParamRefBuilder(this, item);
        }

        TypeParamRefTypeNestedImpl() {
            this.builder = new TypeParamRefBuilder(this);
        }

        @Override
        public N and() {
            return (N)PropertyFluentImpl.this.withTypeRef((TypeRef)this.builder.build());
        }

        @Override
        public N endTypeParamRefType() {
            return this.and();
        }
    }

    class AnnotationsNestedImpl<N>
    extends AnnotationRefFluentImpl<PropertyFluent.AnnotationsNested<N>>
    implements PropertyFluent.AnnotationsNested<N>,
    Nested<N> {
        AnnotationRefBuilder builder;
        Integer index;

        AnnotationsNestedImpl(Integer index, AnnotationRef item) {
            this.index = index;
            this.builder = new AnnotationRefBuilder(this, item);
        }

        AnnotationsNestedImpl() {
            this.index = -1;
            this.builder = new AnnotationRefBuilder(this);
        }

        @Override
        public N and() {
            return (N)PropertyFluentImpl.this.setToAnnotations(this.index, this.builder.build());
        }

        @Override
        public N endAnnotation() {
            return this.and();
        }
    }
}

