/*
 * Decompiled with CFR 0.152.
 */
package io.sundr.tui;

import io.sundr.tui.TermInput;
import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class SystemTermInput
implements TermInput {
    private final InputStream inputStream = System.in;
    private volatile boolean closed = false;
    private volatile Process sttyProcess = null;

    @Override
    public AutoCloseable enterRawMode() {
        if (this.closed) {
            throw new IllegalStateException("TermInput is closed");
        }
        try {
            if (this.isUnixLike()) {
                this.sttyProcess = new ProcessBuilder("stty", "-icanon", "-echo", "min", "1").inheritIO().start();
                this.sttyProcess.waitFor();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return () -> {
            if (!this.closed) {
                try {
                    if (this.isUnixLike()) {
                        Process restoreProcess = new ProcessBuilder("stty", "icanon", "echo").inheritIO().start();
                        restoreProcess.waitFor();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        };
    }

    @Override
    public int readKey() {
        if (this.closed) {
            return -1;
        }
        try {
            return this.inputStream.read();
        }
        catch (IOException e) {
            return -1;
        }
    }

    @Override
    public int readKey(long timeoutMillis) {
        if (this.closed) {
            return -1;
        }
        CompletableFuture<Integer> readFuture = CompletableFuture.supplyAsync(() -> {
            try {
                return this.inputStream.read();
            }
            catch (IOException e) {
                return -1;
            }
        });
        try {
            return readFuture.get(timeoutMillis, TimeUnit.MILLISECONDS);
        }
        catch (TimeoutException e) {
            readFuture.cancel(true);
            return -2;
        }
        catch (Exception e) {
            return -1;
        }
    }

    @Override
    public boolean isInteractive() {
        if (this.closed) {
            return false;
        }
        String term = System.getenv("TERM");
        if (term == null || "dumb".equals(term)) {
            return false;
        }
        if (this.isUnixLike()) {
            try {
                Process ttyProcess = new ProcessBuilder("tty").start();
                ttyProcess.waitFor();
                return ttyProcess.exitValue() == 0;
            }
            catch (Exception ttyProcess) {
                // empty catch block
            }
        }
        try {
            return System.console() != null;
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public void close() throws Exception {
        this.closed = true;
        if (this.sttyProcess != null && this.sttyProcess.isAlive()) {
            this.sttyProcess.destroyForcibly();
        }
    }

    private boolean isUnixLike() {
        String os = System.getProperty("os.name", "").toLowerCase();
        return os.contains("nix") || os.contains("nux") || os.contains("mac") || os.contains("darwin");
    }
}

