/*
 * Decompiled with CFR 0.152.
 */
package boopickle;

import boopickle.BufferPool$;
import java.nio.ByteBuffer;
import java.util.concurrent.atomic.AtomicInteger;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Some$;

public final class BufferPool {
    public static int allocMiss() {
        return BufferPool$.MODULE$.allocMiss();
    }

    public static int allocOk() {
        return BufferPool$.MODULE$.allocOk();
    }

    public static Option<ByteBuffer> allocate(int n) {
        return BufferPool$.MODULE$.allocate(n);
    }

    public static Option<ByteBuffer> allocateDirect(int n) {
        return BufferPool$.MODULE$.allocateDirect(n);
    }

    public static Pool directPool() {
        return BufferPool$.MODULE$.directPool();
    }

    public static void disable() {
        BufferPool$.MODULE$.disable();
    }

    public static void enable() {
        BufferPool$.MODULE$.enable();
    }

    public static Pool heapPool() {
        return BufferPool$.MODULE$.heapPool();
    }

    public static boolean isDisabled() {
        return BufferPool$.MODULE$.isDisabled();
    }

    public static void release(ByteBuffer byteBuffer) {
        BufferPool$.MODULE$.release(byteBuffer);
    }

    public static final class Pool {
        private final ByteBuffer[] pool0 = new ByteBuffer[1024];
        private final ByteBuffer[] pool1 = new ByteBuffer[1024];
        private final AtomicInteger allocIdx0 = new AtomicInteger(0);
        private final AtomicInteger allocIdx1 = new AtomicInteger(0);
        private final AtomicInteger releaseIdx0 = new AtomicInteger(0);
        private final AtomicInteger releaseIdx1 = new AtomicInteger(0);
        private int allocOk = 0;
        private int allocMiss = 0;

        public int allocOk() {
            return this.allocOk;
        }

        public void allocOk_$eq(int x$1) {
            this.allocOk = x$1;
        }

        public int allocMiss() {
            return this.allocMiss;
        }

        public void allocMiss_$eq(int x$1) {
            this.allocMiss = x$1;
        }

        public Option<ByteBuffer> allocate(int minSize) {
            None$ none$;
            if (BufferPool$.boopickle$BufferPool$$$disablePool) {
                none$ = None$.MODULE$;
            } else if (minSize > 4112) {
                this.allocMiss_$eq(this.allocMiss() + 1);
                none$ = None$.MODULE$;
            } else if (minSize > 512 || this.allocIdx0.get() == this.releaseIdx0.get()) {
                int aIdx = this.allocIdx1.get();
                int rIdx = this.releaseIdx1.get();
                int aNext = (aIdx + 1) % 1024;
                if (aIdx != rIdx) {
                    Some result = Some$.MODULE$.apply((Object)this.pool1[aNext]);
                    if (this.allocIdx1.compareAndSet(aIdx, aNext)) {
                        this.allocOk_$eq(this.allocOk() + 1);
                        none$ = result;
                    } else {
                        this.allocMiss_$eq(this.allocMiss() + 1);
                        none$ = None$.MODULE$;
                    }
                } else {
                    this.allocMiss_$eq(this.allocMiss() + 1);
                    none$ = None$.MODULE$;
                }
            } else {
                int aIdx = this.allocIdx0.get();
                int rIdx = this.releaseIdx0.get();
                int aNext = (aIdx + 1) % 1024;
                if (aIdx != rIdx) {
                    Some result = Some$.MODULE$.apply((Object)this.pool0[aNext]);
                    if (this.allocIdx0.compareAndSet(aIdx, aNext)) {
                        this.allocOk_$eq(this.allocOk() + 1);
                        none$ = result;
                    } else {
                        this.allocMiss_$eq(this.allocMiss() + 1);
                        none$ = None$.MODULE$;
                    }
                } else {
                    this.allocMiss_$eq(this.allocMiss() + 1);
                    none$ = None$.MODULE$;
                }
            }
            return none$;
        }

        public void release(ByteBuffer bb) {
            int bufSize;
            if (!BufferPool$.boopickle$BufferPool$$$disablePool && (bufSize = bb.capacity()) < 8224 && bufSize >= 512) {
                if (bufSize >= 4112) {
                    int aIdx = this.allocIdx1.get();
                    int rIdx = this.releaseIdx1.get();
                    int rNext = (rIdx + 1) % 1024;
                    if (rNext != aIdx) {
                        bb.clear();
                        this.pool1[rNext] = bb;
                        this.releaseIdx1.compareAndSet(rIdx, rNext);
                    }
                } else {
                    int aIdx = this.allocIdx0.get();
                    int rIdx = this.releaseIdx0.get();
                    int rNext = (rIdx + 1) % 1024;
                    if (rNext != aIdx) {
                        bb.clear();
                        this.pool0[rNext] = bb;
                        this.releaseIdx0.compareAndSet(rIdx, rNext);
                    }
                }
            }
        }
    }
}

