/*
 * Decompiled with CFR 0.152.
 */
package boopickle;

import boopickle.Decoder;
import boopickle.StringCodec$;
import boopickle.StringCodecBase;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.CharacterCodingException;
import scala.MatchError;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

public class DecoderSize
implements Decoder {
    private final ByteBuffer buf;
    private final StringCodecBase stringCodec;

    public DecoderSize(ByteBuffer buf) {
        this.buf = buf;
        this.stringCodec = StringCodec$.MODULE$;
    }

    public ByteBuffer buf() {
        return this.buf;
    }

    public StringCodecBase stringCodec() {
        return this.stringCodec;
    }

    @Override
    public byte readByte() {
        return this.buf().get();
    }

    @Override
    public char readChar() {
        char c;
        int b0 = this.buf().get() & 0xFF;
        if (b0 < 128) {
            c = (char)b0;
        } else if ((b0 & 0xE0) == 192) {
            int b1 = this.buf().get() & 0x3F;
            c = (char)((b0 & 0x1F) << 6 | b1);
        } else if ((b0 & 0xF0) == 224) {
            int s0 = this.buf().get() & 0x3F;
            int s1 = this.buf().get() & 0x3F;
            c = (char)((b0 & 0xF) << 12 | s0 << 6 | s1);
        } else {
            throw new CharacterCodingException();
        }
        return c;
    }

    @Override
    public short readShort() {
        return this.buf().getShort();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int readInt() {
        int n;
        int b = this.buf().get() & 0xFF;
        if ((b & 0x80) != 0) {
            int sign = (b & 0x10) == 0 ? 1 : -1;
            int b0 = b & 0xF;
            int n2 = b >> 4;
            switch (n2) {
                case 8: 
                case 9: {
                    int b1 = this.buf().get() & 0xFF;
                    n = sign * (b0 << 8 | b1);
                    break;
                }
                case 10: 
                case 11: {
                    int b1 = this.buf().get() & 0xFF;
                    int b2 = this.buf().get() & 0xFF;
                    n = sign * (b0 << 16 | b1 << 8 | b2);
                    break;
                }
                case 12: 
                case 13: {
                    int b1 = this.buf().get() & 0xFF;
                    int b2 = this.buf().get() & 0xFF;
                    int b3 = this.buf().get() & 0xFF;
                    n = sign * (b0 << 24 | b1 << 16 | b2 << 8 | b3);
                    break;
                }
                default: {
                    if (14 == n2 && b == 224) {
                        n = sign * this.readRawInt();
                        break;
                    }
                    throw new IllegalArgumentException("Unknown integer coding");
                }
            }
        } else {
            void var1_1;
            n = var1_1;
        }
        return n;
    }

    @Override
    public int readRawInt() {
        return this.buf().getInt();
    }

    @Override
    public long readLong() {
        long l;
        int b = this.buf().get() & 0xFF;
        if (b != 225) {
            this.buf().position(this.buf().position() - 1);
            l = this.readInt();
        } else {
            l = this.readRawLong();
        }
        return l;
    }

    @Override
    public long readRawLong() {
        return this.buf().getLong();
    }

    @Override
    public Either<Object, Object> readIntCode() {
        Right right;
        int b = this.buf().get() & 0xFF;
        if ((b & 0x80) != 0) {
            int sign = (b & 0x10) == 0 ? 1 : -1;
            int b0 = b & 0xF;
            int n = b >> 4;
            switch (n) {
                case 8: 
                case 9: {
                    int b1 = this.buf().get() & 0xFF;
                    right = package$.MODULE$.Right().apply((Object)BoxesRunTime.boxToInteger((int)(sign * (b0 << 8 | b1))));
                    break;
                }
                case 10: 
                case 11: {
                    int b1 = this.buf().get() & 0xFF;
                    int b2 = this.buf().get() & 0xFF;
                    right = package$.MODULE$.Right().apply((Object)BoxesRunTime.boxToInteger((int)(sign * (b0 << 16 | b1 << 8 | b2))));
                    break;
                }
                case 12: 
                case 13: {
                    int b1 = this.buf().get() & 0xFF;
                    int b2 = this.buf().get() & 0xFF;
                    int b3 = this.buf().get() & 0xFF;
                    right = package$.MODULE$.Right().apply((Object)BoxesRunTime.boxToInteger((int)(sign * (b0 << 24 | b1 << 16 | b2 << 8 | b3))));
                    break;
                }
                default: {
                    if (14 == n && b == 224) {
                        right = package$.MODULE$.Right().apply((Object)BoxesRunTime.boxToInteger((int)(sign * this.readRawInt())));
                        break;
                    }
                    right = package$.MODULE$.Left().apply((Object)BoxesRunTime.boxToByte((byte)((byte)(b & 0xF))));
                    break;
                }
            }
        } else {
            right = package$.MODULE$.Right().apply((Object)BoxesRunTime.boxToInteger((int)b));
        }
        return right;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Either<Object, Object> readLongCode() {
        Right right;
        int b = this.buf().get() & 0xFF;
        if (b != 225) {
            this.buf().position(this.buf().position() - 1);
            Either<Object, Object> either = this.readIntCode();
            if (either instanceof Left) {
                byte x = BoxesRunTime.unboxToByte((Object)((Left)either).value());
                right = package$.MODULE$.Left().apply((Object)BoxesRunTime.boxToByte((byte)((byte)(x & 0xF))));
                return right;
            } else {
                if (!(either instanceof Right)) throw new MatchError(either);
                int x = BoxesRunTime.unboxToInt((Object)((Right)either).value());
                right = package$.MODULE$.Right().apply((Object)BoxesRunTime.boxToLong((long)x));
            }
            return right;
        } else {
            right = package$.MODULE$.Right().apply((Object)BoxesRunTime.boxToLong((long)this.readRawLong()));
        }
        return right;
    }

    @Override
    public float readFloat() {
        return this.buf().getFloat();
    }

    @Override
    public double readDouble() {
        return this.buf().getDouble();
    }

    @Override
    public String readString() {
        int len = this.readInt();
        return this.stringCodec().decodeFast(len, this.buf());
    }

    @Override
    public String readString(int len) {
        return this.stringCodec().decodeFast(len, this.buf());
    }

    @Override
    public ByteBuffer readByteBuffer() {
        int sizeBO = this.readInt();
        if (sizeBO < 0) {
            throw new IllegalArgumentException("Invalid size " + sizeBO + " for ByteBuffer");
        }
        int size = sizeBO >> 1;
        ByteOrder byteOrder = (sizeBO & 1) == 1 ? ByteOrder.BIG_ENDIAN : ByteOrder.LITTLE_ENDIAN;
        ByteBuffer b = this.buf().slice().order(byteOrder);
        this.buf().position(this.buf().position() + size);
        b.limit(b.position() + size);
        return b;
    }

    @Override
    public byte[] readByteArray() {
        return this.readByteArray(this.readRawInt());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public byte[] readByteArray(int len) {
        void var2_2;
        byte[] array = new byte[len];
        this.buf().get(array);
        return var2_2;
    }

    @Override
    public int[] readIntArray() {
        return this.readIntArray(this.readRawInt());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int[] readIntArray(int len) {
        void var2_2;
        int[] array = new int[len];
        for (int i = 0; i < len; ++i) {
            array[i] = this.readInt();
        }
        return var2_2;
    }

    @Override
    public float[] readFloatArray() {
        return this.readFloatArray(this.readRawInt());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public float[] readFloatArray(int len) {
        void var2_2;
        float[] array = new float[len];
        this.buf().asFloatBuffer().get(array);
        this.buf().position(this.buf().position() + len * 4);
        return var2_2;
    }

    @Override
    public double[] readDoubleArray() {
        int len = this.readRawInt();
        this.readRawInt();
        return this.readDoubleArray(len);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public double[] readDoubleArray(int len) {
        void var2_2;
        double[] array = new double[len];
        this.buf().asDoubleBuffer().get(array);
        this.buf().position(this.buf().position() + len * 8);
        return var2_2;
    }
}

