/*
 * Decompiled with CFR 0.152.
 */
package boopickle;

import boopickle.Decoder;
import boopickle.StringCodec$;
import boopickle.StringCodecBase;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.util.Either;

public class DecoderSpeed
implements Decoder {
    private final ByteBuffer buf;
    private final StringCodecBase stringCodec;

    public DecoderSpeed(ByteBuffer buf) {
        this.buf = buf;
        this.stringCodec = StringCodec$.MODULE$;
    }

    public ByteBuffer buf() {
        return this.buf;
    }

    public StringCodecBase stringCodec() {
        return this.stringCodec;
    }

    @Override
    public byte readByte() {
        return this.buf().get();
    }

    @Override
    public char readChar() {
        return this.buf().getChar();
    }

    @Override
    public short readShort() {
        return this.buf().getShort();
    }

    @Override
    public int readInt() {
        return this.buf().getInt();
    }

    @Override
    public int readRawInt() {
        return this.buf().getInt();
    }

    @Override
    public long readLong() {
        return this.buf().getLong();
    }

    @Override
    public long readRawLong() {
        return this.buf().getLong();
    }

    @Override
    public Either<Object, Object> readIntCode() {
        int b = this.buf().get() & 0xFF;
        return (b & 0x80) != 0 ? package$.MODULE$.Left().apply((Object)BoxesRunTime.boxToByte((byte)((byte)(b & 0xF)))) : package$.MODULE$.Right().apply((Object)BoxesRunTime.boxToInteger((int)this.buf().getInt()));
    }

    @Override
    public Either<Object, Object> readLongCode() {
        int b = this.buf().get() & 0xFF;
        return (b & 0x80) != 0 ? package$.MODULE$.Left().apply((Object)BoxesRunTime.boxToByte((byte)((byte)(b & 0xF)))) : package$.MODULE$.Right().apply((Object)BoxesRunTime.boxToLong((long)this.buf().getLong()));
    }

    @Override
    public float readFloat() {
        return this.buf().getFloat();
    }

    @Override
    public double readDouble() {
        return this.buf().getDouble();
    }

    @Override
    public String readString() {
        return this.readString(this.readInt());
    }

    @Override
    public String readString(int len) {
        return this.stringCodec().decodeFast(len, this.buf());
    }

    @Override
    public ByteBuffer readByteBuffer() {
        int sizeBO = this.readInt();
        if (sizeBO < 0) {
            throw new IllegalArgumentException("Invalid size " + sizeBO + " for ByteBuffer");
        }
        int size = sizeBO >> 1;
        ByteOrder byteOrder = (sizeBO & 1) == 1 ? ByteOrder.BIG_ENDIAN : ByteOrder.LITTLE_ENDIAN;
        ByteBuffer b = this.buf().slice().order(byteOrder);
        this.buf().position(this.buf().position() + size);
        b.limit(b.position() + size);
        return b;
    }

    @Override
    public byte[] readByteArray() {
        return this.readByteArray(this.readRawInt());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public byte[] readByteArray(int len) {
        void var2_2;
        byte[] array = new byte[len];
        this.buf().get(array);
        return var2_2;
    }

    @Override
    public int[] readIntArray() {
        return this.readIntArray(this.readRawInt());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int[] readIntArray(int len) {
        void var2_2;
        int[] array = new int[len];
        this.buf().asIntBuffer().get(array);
        this.buf().position(this.buf().position() + len * 4);
        return var2_2;
    }

    @Override
    public float[] readFloatArray() {
        return this.readFloatArray(this.readRawInt());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public float[] readFloatArray(int len) {
        void var2_2;
        float[] array = new float[len];
        this.buf().asFloatBuffer().get(array);
        this.buf().position(this.buf().position() + len * 4);
        return var2_2;
    }

    @Override
    public double[] readDoubleArray() {
        int len = this.readRawInt();
        this.readRawInt();
        return this.readDoubleArray(len);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public double[] readDoubleArray(int len) {
        void var2_2;
        double[] array = new double[len];
        this.buf().asDoubleBuffer().get(array);
        this.buf().position(this.buf().position() + len * 8);
        return var2_2;
    }
}

