/*
 * Decompiled with CFR 0.152.
 */
package boopickle;

import boopickle.BufferProvider;
import boopickle.Encoder;
import boopickle.EncoderSize$;
import boopickle.StringCodec$;
import boopickle.StringCodecBase;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.collection.ArrayOps$;
import scala.collection.Iterable;
import scala.runtime.BoxesRunTime;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

public class EncoderSize
implements Encoder {
    private final BufferProvider bufferProvider;
    private final StringCodecBase stringCodec;

    public static BufferProvider $lessinit$greater$default$1() {
        return EncoderSize$.MODULE$.$lessinit$greater$default$1();
    }

    public EncoderSize(BufferProvider bufferProvider) {
        this.bufferProvider = bufferProvider;
        this.stringCodec = StringCodec$.MODULE$;
    }

    public StringCodecBase stringCodec() {
        return this.stringCodec;
    }

    private ByteBuffer alloc(int size) {
        return this.bufferProvider.alloc(size);
    }

    @Override
    public Encoder writeByte(byte b) {
        this.alloc(1).put(b);
        return this;
    }

    @Override
    public Encoder writeChar(char c) {
        ByteBuffer byteBuffer = c < '\u0080' ? this.alloc(1).put((byte)c) : (c < '\u0800' ? this.alloc(2).put((byte)(0xC0 | c >>> 6 & 0x3F)).put((byte)(0x80 | c & 0x3F)) : this.alloc(3).put((byte)(0xE0 | c >>> 12)).put((byte)(0x80 | c >>> 6 & 0x3F)).put((byte)(0x80 | c & 0x3F)));
        return this;
    }

    @Override
    public Encoder writeShort(short s) {
        this.alloc(2).putShort(s);
        return this;
    }

    @Override
    public Encoder writeInt(int i) {
        ByteBuffer byteBuffer;
        if (i >= 0 && i < 128) {
            byteBuffer = this.alloc(1).put((byte)i);
        } else if (i > -268435456 && i < 0x10000000) {
            int mask = i >>> 31 << 4;
            int a = Math.abs(i);
            byteBuffer = a < 4096 ? this.alloc(2).put((byte)(mask | 0x80 | a >> 8)).put((byte)(a & 0xFF)) : (a < 0x100000 ? this.alloc(3).put((byte)(mask | 0xA0 | a >> 16)).put((byte)(a >> 8 & 0xFF)).put((byte)(a & 0xFF)) : this.alloc(4).put((byte)(mask | 0xC0 | a >> 24)).put((byte)(a >> 16 & 0xFF)).put((byte)(a >> 8 & 0xFF)).put((byte)(a & 0xFF)));
        } else {
            byteBuffer = this.alloc(5).put((byte)224).putInt(i);
        }
        return this;
    }

    @Override
    public Encoder writeRawInt(int i) {
        this.alloc(4).putInt(i);
        return this;
    }

    @Override
    public Encoder writeLong(long l) {
        Object object = l <= Integer.MAX_VALUE && l >= Integer.MIN_VALUE ? this.writeInt((int)l) : this.alloc(9).put((byte)225).putLong(l);
        return this;
    }

    @Override
    public Encoder writeRawLong(long l) {
        this.alloc(8).putLong(l);
        return this;
    }

    @Override
    public Encoder writeIntCode(Either<Object, Object> intCode) {
        Object object;
        Either<Object, Object> either = intCode;
        if (either instanceof Left) {
            byte code = BoxesRunTime.unboxToByte((Object)((Left)either).value());
            object = this.alloc(1).put((byte)(code | 0xF0));
        } else if (either instanceof Right) {
            int i = BoxesRunTime.unboxToInt((Object)((Right)either).value());
            object = this.writeInt(i);
        } else {
            throw new MatchError(either);
        }
        return this;
    }

    @Override
    public Encoder writeLongCode(Either<Object, Object> longCode) {
        Object object;
        Either<Object, Object> either = longCode;
        if (either instanceof Left) {
            byte code = BoxesRunTime.unboxToByte((Object)((Left)either).value());
            object = this.alloc(1).put((byte)(code | 0xF0));
        } else if (either instanceof Right) {
            long l = BoxesRunTime.unboxToLong((Object)((Right)either).value());
            object = this.writeLong(l);
        } else {
            throw new MatchError(either);
        }
        return this;
    }

    @Override
    public Encoder writeString(String s) {
        this.writeInt(s.length());
        ByteBuffer bb = this.alloc(s.length() * 3);
        this.stringCodec().encodeFast(s, bb);
        return this;
    }

    @Override
    public Encoder writeFloat(float f) {
        this.alloc(4).putFloat(f);
        return this;
    }

    @Override
    public Encoder writeDouble(double d) {
        this.alloc(8).putDouble(d);
        return this;
    }

    @Override
    public Encoder writeByteBuffer(ByteBuffer bb) {
        bb.mark();
        ByteOrder byteOrder = bb.order();
        ByteOrder byteOrder2 = ByteOrder.BIG_ENDIAN;
        int byteOrder3 = !(byteOrder != null ? !byteOrder.equals(byteOrder2) : byteOrder2 != null) ? 1 : 0;
        this.writeInt(bb.remaining() * 2 | byteOrder3);
        this.alloc(bb.remaining()).put(bb);
        bb.reset();
        return this;
    }

    @Override
    public Encoder writeByteArray(byte[] ba) {
        this.writeRawInt(ba.length);
        this.alloc(ba.length).put(ba);
        return this;
    }

    @Override
    public Encoder writeIntArray(int[] ia) {
        this.writeRawInt(ia.length);
        Object object = Predef$.MODULE$.intArrayOps(ia);
        ArrayOps$.MODULE$.foreach$extension(object, (Function1 & Serializable)i -> this.writeIntArray$$anonfun$1(BoxesRunTime.unboxToInt((Object)i)));
        return this;
    }

    @Override
    public Encoder writeFloatArray(float[] fa) {
        this.writeRawInt(fa.length);
        ByteBuffer bb = this.alloc(fa.length * 4);
        bb.asFloatBuffer().put(fa);
        bb.position(bb.position() + fa.length * 4);
        return this;
    }

    @Override
    public Encoder writeDoubleArray(double[] da) {
        this.writeRawInt(da.length);
        this.writeRawInt(0);
        ByteBuffer bb = this.alloc(da.length * 8);
        bb.asDoubleBuffer().put(da);
        bb.position(bb.position() + da.length * 8);
        return this;
    }

    @Override
    public ByteBuffer asByteBuffer() {
        return this.bufferProvider.asByteBuffer();
    }

    @Override
    public Iterable<ByteBuffer> asByteBuffers() {
        return this.bufferProvider.asByteBuffers();
    }

    private final /* synthetic */ Encoder writeIntArray$$anonfun$1(int i) {
        return this.writeInt(i);
    }
}

