/*
 * Decompiled with CFR 0.152.
 */
package boopickle;

import boopickle.BufferProvider;
import boopickle.Encoder;
import boopickle.EncoderSpeed$;
import boopickle.StringCodec$;
import boopickle.StringCodecBase;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import scala.MatchError;
import scala.collection.Iterable;
import scala.runtime.BoxesRunTime;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

public class EncoderSpeed
implements Encoder {
    private final BufferProvider bufferProvider;
    private final StringCodecBase stringCodec;

    public static BufferProvider $lessinit$greater$default$1() {
        return EncoderSpeed$.MODULE$.$lessinit$greater$default$1();
    }

    public EncoderSpeed(BufferProvider bufferProvider) {
        this.bufferProvider = bufferProvider;
        this.stringCodec = StringCodec$.MODULE$;
    }

    public StringCodecBase stringCodec() {
        return this.stringCodec;
    }

    private ByteBuffer alloc(int size) {
        return this.bufferProvider.alloc(size);
    }

    @Override
    public Encoder writeByte(byte b) {
        this.alloc(1).put(b);
        return this;
    }

    @Override
    public Encoder writeChar(char c) {
        this.alloc(2).putChar(c);
        return this;
    }

    @Override
    public Encoder writeShort(short s) {
        this.alloc(2).putShort(s);
        return this;
    }

    @Override
    public Encoder writeInt(int i) {
        this.alloc(4).putInt(i);
        return this;
    }

    @Override
    public Encoder writeRawInt(int i) {
        this.alloc(4).putInt(i);
        return this;
    }

    @Override
    public Encoder writeLong(long l) {
        this.alloc(8).putLong(l);
        return this;
    }

    @Override
    public Encoder writeRawLong(long l) {
        this.alloc(8).putLong(l);
        return this;
    }

    @Override
    public Encoder writeIntCode(Either<Object, Object> intCode) {
        ByteBuffer byteBuffer;
        Either<Object, Object> either = intCode;
        if (either instanceof Left) {
            byte code = BoxesRunTime.unboxToByte((Object)((Left)either).value());
            byteBuffer = this.alloc(1).put((byte)(code | 0x80));
        } else if (either instanceof Right) {
            int i = BoxesRunTime.unboxToInt((Object)((Right)either).value());
            byteBuffer = this.alloc(5).put((byte)0).putInt(i);
        } else {
            throw new MatchError(either);
        }
        return this;
    }

    @Override
    public Encoder writeLongCode(Either<Object, Object> longCode) {
        ByteBuffer byteBuffer;
        Either<Object, Object> either = longCode;
        if (either instanceof Left) {
            byte code = BoxesRunTime.unboxToByte((Object)((Left)either).value());
            byteBuffer = this.alloc(1).put((byte)(code | 0x80));
        } else if (either instanceof Right) {
            long l = BoxesRunTime.unboxToLong((Object)((Right)either).value());
            byteBuffer = this.alloc(9).put((byte)0).putLong(l);
        } else {
            throw new MatchError(either);
        }
        return this;
    }

    @Override
    public Encoder writeString(String s) {
        this.writeInt(s.length());
        ByteBuffer bb = this.alloc(s.length() * 3);
        this.stringCodec().encodeFast(s, bb);
        return this;
    }

    @Override
    public Encoder writeFloat(float f) {
        this.alloc(4).putFloat(f);
        return this;
    }

    @Override
    public Encoder writeDouble(double d) {
        this.alloc(8).putDouble(d);
        return this;
    }

    @Override
    public Encoder writeByteBuffer(ByteBuffer bb) {
        bb.mark();
        ByteOrder byteOrder = bb.order();
        ByteOrder byteOrder2 = ByteOrder.BIG_ENDIAN;
        int byteOrder3 = !(byteOrder != null ? !byteOrder.equals(byteOrder2) : byteOrder2 != null) ? 1 : 0;
        this.writeInt(bb.remaining() * 2 | byteOrder3);
        this.alloc(bb.remaining()).put(bb);
        bb.reset();
        return this;
    }

    @Override
    public Encoder writeByteArray(byte[] ba) {
        this.writeRawInt(ba.length);
        this.alloc(ba.length).put(ba);
        return this;
    }

    @Override
    public Encoder writeIntArray(int[] ia) {
        this.writeRawInt(ia.length);
        ByteBuffer bb = this.alloc(ia.length * 4);
        bb.asIntBuffer().put(ia);
        bb.position(bb.position() + ia.length * 4);
        return this;
    }

    @Override
    public Encoder writeFloatArray(float[] fa) {
        this.writeRawInt(fa.length);
        ByteBuffer bb = this.alloc(fa.length * 4);
        bb.asFloatBuffer().put(fa);
        bb.position(bb.position() + fa.length * 4);
        return this;
    }

    @Override
    public Encoder writeDoubleArray(double[] da) {
        this.writeRawInt(da.length);
        this.writeRawInt(0);
        ByteBuffer bb = this.alloc(da.length * 8);
        bb.asDoubleBuffer().put(da);
        bb.position(bb.position() + da.length * 8);
        return this;
    }

    @Override
    public ByteBuffer asByteBuffer() {
        return this.bufferProvider.asByteBuffer();
    }

    @Override
    public Iterable<ByteBuffer> asByteBuffers() {
        return this.bufferProvider.asByteBuffers();
    }
}

